#include "acl0.c"
#include "stdlibs.c"

ASTATIC void aErrExit(const char *f, ...)
{
    va_list ap;
    va_start(ap, f);
	#if (!defined(ANOUSE_ATERRMSG))
		if (aAtErrExitMsg != 0)
		    fprintf(stderr, "\n%s\n", aAtErrExitMsg);
	#endif
    vfprintf(stderr, f, ap);
    fprintf(stderr, "\n");
    va_end(ap);
    aExitInt(1);
}

ASTATIC void *aErrExitP0(void *p, const char *f, ...)
{
	if (p != 0)
		return p;
    va_list ap;
    va_start(ap, f);
	#if (!defined(ANOUSE_ATERRMSG))
		if (aAtErrExitMsg != 0)
		    fprintf(stderr, "\n%s\n", aAtErrExitMsg);
	#endif
    vfprintf(stderr, f, ap);
    fprintf(stderr, "\n");
    va_end(ap);
    aExitInt(1);
}

#include "malloc.c"
#include "misc.c"

#define aDbgErrExit(...)


#if (!defined(AMAXWINDOWS))
	#define AMAXWINDOWS	16
#endif

#if (!defined(AKEYBUFSIZ))
	#define AKEYBUFSIZ		1024
#endif

#if (!defined(ANOUSE_GRAPHICS))
	#include "sdl2.c"
	#include "chr.c"
	#include "graphics.c"
#endif

int main(int argc, char **argv)
{
	#if (!defined(ANOUSE_ARG))
		aArgc = argc;
		aArgv = argv;
	#else
		(void) argc;
		(void) argv;
	#endif
	AMemAlc1 ma1[1], ma1s[1];
	AComArg ca0[1];  ca0 ->ta = ma1;  ca0 ->na = ma1;
	AComArg ca0s[1]; ca0s->ta = ma1s; ca0s->na = ma1s;
	ca0->s   = ca0s->s   = ca0s;
	ca0->d   = ca0s->d   = 0;
	ca0->dbg = ca0s->dbg = 0;
	AMemAlc1_init(ca0,  ma1,  0);
	AMemAlc1_init(ca0s, ma1s, 0);
	AClean c0 [1]; AClean_init(ca0,  c0,  0); ca0 ->tc = c0;
	AClean c0s[1]; AClean_init(ca0s, c0s, 0); ca0s->tc = c0s;
	#if (ADBGLV >= 1)
		AMemAlc1 ma1d[1];
		AComArg ca0d[1]; ca0d->ta = ma1d; ca0d->na = ma1d;
		ca0->d = ca0s->d = ca0d->d = ca0d;
		ca0d->s = ca0s;
		ca0d->dbg = 0;
		AMemAlc1_init(ca0d, ma1d, 0);
		AClean c0d[1]; AClean_init(ca0d, c0d, 0); ca0d->tc = c0d;
		#if (ADBGLV >= 2)
			AActObj act[1];
			AActObj_init(ca0d, act, 1, 0);
			AComArg_Dbg cad[1];
			cad->act = act;
			ca0->dbg = ca0s->dbg = ca0d->dbg = cad;
			aDbgActObj_noChk(ca0d, act, sizeof (AActObj));
			aDbgActObj_noChk(ca0d, ma1d, sizeof (AMemAlc1));

//			ASP_addInt2(ca0d, &act->noChk, (AInt) act, sizeof (AActObj));
//			ASP_addInt2(ca0d, &act->noChk, (AInt) ma1d, sizeof (AMemAlc1));
		#endif
	#endif
	#if (ADBGLV >= 2)
		AInt i;
		for (i = 0; i < 28; i++) {
			AMemAlc0_initDbg(ca0, tbl28[i], 0, 0);
		}
	#endif
//	AMemAlc0 *tbl28[29]; AMemAlc1_makeTable28(ca0, ma1, tbl28, 0);
	#if (defined(AUSE_SDL2))
		#if (!defined(ANOUSE_GRAPHICS))
	 	   if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_EVENTS) < 0)
				aErrExit("SDL2 init error");
		#endif
	#endif
	#if (!defined(ANOUSE_XORSHIFT32))
		aXorShift32_seed((unsigned int) time(0));
	#endif
	aMain(ca0);
	#if (!defined(ANOUSE_CLEAN))
		AClean_out(ca0,  c0);
		AClean_out(ca0s, c0s);
	#endif
	return 0;
}
