AINLINESTATIC AInt32 aRgb8_nd(AInt32 r, AInt32 g, AInt32 b) { return r << 16 | g << 8 | b; }

#if (ADBGLV >= 1)

#if (!defined(ADBGMAXWINDOWS))
	#define ADBGMAXWINDOWS	(AMAXWINDOWS + 4)
#endif
AWindow *aDbgWinTable[ADBGMAXWINDOWS + 1];

ASTATIC void aDbg_testWin(AWindow *w, const char *msg)
{
	int i;
	for (i = 0; i < ADBGMAXWINDOWS; i++) {
		if (aDbgWinTable[i] == w) return;
	}
	aErrExit("%s: invalid window handle", msg);
}

ASTATIC void aDbg_testCol(AInt32 c, const char *msg)
{
	if (c < 0 || 0xffffff < c)
		aErrExit("%s: invalid color code : 0x%x (%d)", msg, (int) c, (int) c);
}

#else

#define aDbg_testWin(w, msg)
#define aDbg_testCol(c, msg)

#endif

#if (ADBGLV <= 1)

AINLINESTATIC void aSetPix0(AWindow *w, AInt16 x, AInt16 y, AInt32 c) { w->buf[x + y * w->xsiz] = c; }
AINLINESTATIC AInt32 aRgb8(AInt32 r, AInt32 g, AInt32 b) { return r << 16 | g << 8 | b; }
AINLINESTATIC void aSetMode(AWindow *w, int m) { w->mode = m; }

#else

ASTATIC void aSetPix0(AWindow *w, AInt16 x, AInt16 y, AInt32 c)
{
	aDbg_testWin(w, "aSetPix0");
	aDbg_testCol(c, "aSetPix0");
	#if (defined(ADEBUG))
		if (x < 0 || w->xsiz <= x || y < 0 || w->ysiz <= y)
			aErrExit("aSetPix0 : out of range");
	#endif
	w->buf[x + y * w->xsiz] = c;
}

ASTATIC AInt32 aRgb8(AInt32 r, AInt32 g, AInt32 b)
{
	#if (defined(ADEBUG))
		if (r < 0 || 255 < r) aErrExit("aRgb8 : out of range : r=%d", r);
		if (g < 0 || 255 < g) aErrExit("aRgb8 : out of range : g=%d", g);
		if (b < 0 || 255 < b) aErrExit("aRgb8 : out of range : b=%d", b);
	#endif
	return r << 16 | g << 8 | b;
}

ASTATIC void aSetMode(AWindow *w, int m)
{
	aDbg_testWin(w, "aSetMode");
	w->mode = m;
}

#endif

ASTATIC int aAliveWindows()
{
	int i, c = 0;
	for (i = 0; i < AMAXWINDOWS; i++) {
		AWindow *w = aWinTable_w[i];
		if (w != 0 && w->phase <= 1)
			c++;
	}
	return c;
}

ASTATIC void aInitWin0(ACA, AWindow *w, int xsiz, int ysiz, const char *title, int autoClose)
{
	strncpy(w->title, title, 63);
	w->title[63] = '\0';
	w->xsiz = xsiz;
	w->ysiz = ysiz;
	w->buf = aMalloc(ca0, xsiz * ysiz * aSizeof (AInt32), 0);
	memset(w->buf, 0, xsiz * ysiz * aSizeof (AInt32));
	#if (AKEYBUFSIZ > 0)
		w->kbw = w->kbr = 0;
	#endif
	#if (!defined(ANOUSE_LEAPFLUSH))
		if (CLOCKS_PER_SEC != 1000)
			w->lastFlush = clock() * 1000 / CLOCKS_PER_SEC;
		else
			w->lastFlush = clock();
	#endif
	w->phase = 0;
	w->mode = 0;
	w->autoClose = autoClose;
	w->reqClose = 0;
	w->keyLv = 1;
	w->mosLv = 0;
	int i;
	for (i = 0; aWinTable_w[i] != 0; i++);
	#if (defined(ADEBUG))
		if (i >= AMAXWINDOWS)
			aErrExit("aInitWin0: too many windows");
	#endif
	w->table_i = i;
	aWinTable_w[i] = w;
	aWinTable_h[i] = 0;
	w->win = 0;
	w->optDef = 7;
	w->cbxs = w->cbys = 0;
	w->cb = 0;
	w->savBuf = 0;
	#if (defined(ADEBUG))
		for (i = 0; aDbgWinTable[i] != 0; i++);
		if (i >= ADBGMAXWINDOWS)
			aErrExit("aInitWin0: too many windows (DEBUG)");
		aDbgWinTable[i] = w;
	#endif
}

ASTATIC void aWait(AInt32 ms)
{
	aFlushAll(0);
	aWait0(ms);
}

ASTATIC void aSetPixOpt0(AWindow *w, AInt32 x, AInt32 y, AInt32 c)
{
	aDbg_testWin(w, "aSetPix");
	aDbg_testCol(c, "aSetPix");
	if (c >= 0 && 0 <= x && x < w->xsiz && 0 <= y && y < w->ysiz) {
		if (w->mode == AMODE_SET) w->buf[y * w->xsiz + x] =  c;
		if (w->mode == AMODE_OR)  w->buf[y * w->xsiz + x] |= c;
		if (w->mode == AMODE_AND) w->buf[y * w->xsiz + x] &= c;
		if (w->mode == AMODE_XOR) w->buf[y * w->xsiz + x] ^= c;
	}
}

ASTATIC void aSetPixOpt(AWindow *w, AInt8 opt, AInt32 x, AInt32 y, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	aSetPixOpt0(w, x, y, c);
}

ASTATIC AInt32 aGetPixOpt0(AWindow *w, AInt16 x, AInt16 y)
{
	aDbg_testWin(w, "aGetPix");
	#if (defined(ADEBUG))
		if (x < 0 || w->xsiz < x || y < 0 || w->ysiz < y)
			aErrExit("aGetPix : out of range");
	#endif
	return w->buf[y * w->xsiz + x];
}

ASTATIC void aFillRect0(AWindow *w, AInt16 sx, AInt16 sy, AInt16 x0, AInt16 y0, AInt32 c)
{
	aDbg_testWin(w, "aFillRect0");
	aDbg_testCol(c, "aFillRect0");
	#if (defined(ADEBUG))
		if (x0 < 0 || w->xsiz < sx + x0 || y0 < 0 || w->ysiz < sy + y0)
			aErrExit("aFillRect0 : out of range");
	#endif
	int i, j;
	AInt32a *b = w->buf + x0 + y0 * w->xsiz;
	for (j = 0; j < sy; j++) {
		for (i = 0; i < sx; i++)
			b[i] = c;
		b += w->xsiz;
	}
}

ASTATIC void aFillRectOpt0(AWindow *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	AInt32 i, j;
	aDbg_testWin(w, "aFillRect");
	aDbg_testCol(c, "aFillRect");
	if (w->mode == AMODE_SET && x0 >= 0 && y0 >= 0 && x0 + sx <= w->xsiz && y0 + sy <= w->ysiz) {
		aFillRect0(w, sx, sy, x0, y0, c);
		return;
	}
	for (j = 0; j < sy; j++) {
		for (i = 0; i < sx; i++) {
			aSetPixOpt0(w, x0 + i, y0 + j, c);
		}
	}
}

ASTATIC void aDrawRectOpt0(AWindow *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	aDbg_testWin(w, "aDrawRect");
	aDbg_testCol(c, "aDrawRect");
	if (sx <= 1 || sy <= 1)
		aFillRectOpt0(w, sx, sy, x0, y0, c);
	else {
		aFillRectOpt0(w, sx, 1,      x0,          y0,          c);
		aFillRectOpt0(w, sx, 1,      x0,          y0 + sy - 1, c);
		aFillRectOpt0(w, 1,  sy - 2, x0,          y0 + 1,      c);
		aFillRectOpt0(w, 1,  sy - 2, x0 + sx - 1, y0 + 1,      c);
	}
}

ASTATIC void aDrawRectOpt(AWindow *w, AInt8 opt, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { sx <<= 4; sy <<= 4; x0 <<= 4; y0 <<= 4; }
	aDrawRectOpt0(w, sx, sy, x0, y0, c);
}

ASTATIC void aDrawLineOpt0(AWindow *w, AInt32 x0, AInt32 y0, AInt32 x1, AInt32 y1, AInt32 c)
{
	AInt32 x, y, dx, dy, sx, sy, err, e2;
	aDbg_testWin(w, "aDrawLine");
	aDbg_testCol(c, "aDrawLine");
	dx = x1 - x0;
	dy = y1 - y0;
	sx = sy = 1;
	if (dx < 0) { dx *= -1; sx = -1; }
	if (dy < 0) { dy *= -1; sy = -1; }
	err = dx - dy;
	x = x0;
	y = y0;
	for (;;) {
		aSetPixOpt0(w, x, y, c);
		if (x == x1 && y == y1) break;
		e2 = err * 2;
		if (e2 > - dy) {
			err -= dy;
			x += sx;
		}
		if (e2 <   dx) {
			err += dx;
			y += sy;
		}
	}
}

ASTATIC void aDrawLineOpt(AWindow *w, AInt opt, AInt32 x0, AInt32 y0, AInt32 x1, AInt32 y1, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x0 <<= 4; y0 <<= 4; x1 <<= 4; y1 <<= 4; }
	aDrawLineOpt0(w, x0, y0, x1, y1, c);
}

ASTATIC void aFillOval0(AWindow *w, AInt16 sx, AInt16 sy, AInt16 x0, AInt16 y0, AInt16 c)
{
	double dcx, dcy, dcxy, dtx, dty;
	AInt16 x, y;
	aDbg_testWin(w, "aFillOval0");
	aDbg_testCol(c, "aFillOval0");
	#if (defined(ADEBUG))
		if (x0 < 0 || w->xsiz < sx + x0 || y0 < 0 || w->ysiz < sy + y0)
			aErrExit("aFillOval0 : out of range");
	#endif
	dcx = 0.5 * (sx - 1);
	dcy = 0.5 * (sy - 1);
	dcxy = (dcx + 0.5) * (dcy + 0.5) - 0.1;
	dcxy *= dcxy;
	for (y = 0; y < sy; y++) {
		dty = (y - dcy) * dcx;
		for (x = 0; x < sx; x++) {
			dtx = (x - dcx) * dcy;
			if (dtx * dtx + dty * dty > dcxy) continue;
				aSetPix0(w, x + x0, y + y0, c);
		}
	}
}

ASTATIC void aFillOvalOpt0(AWindow *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	double dcx, dcy, dcxy, dtx, dty;
	AInt32 x, y;
	if (w->mode == AMODE_SET && x0 >= 0 && y0 >= 0 && x0 + sx < w->xsiz && y0 + sy < w->ysiz) {
		aFillOval0(w, sx, sy, x0, y0, c);
		return;
	}
	aDbg_testWin(w, "aFillOval");
	aDbg_testCol(c, "aFillOval");
	dcx = 0.5 * (sx - 1);
	dcy = 0.5 * (sy - 1);
	dcxy = (dcx + 0.5) * (dcy + 0.5) - 0.1;
	dcxy *= dcxy;
	for (y = 0; y < sy; y++) {
		dty = (y - dcy) * dcx;
		for (x = 0; x < sx; x++) {
			dtx = (x - dcx) * dcy;
			if (dtx * dtx + dty * dty > dcxy) continue;
				aSetPixOpt0(w, x + x0, y + y0, c);
		}
	}
}

ASTATIC void aFillOvalOpt(AWindow *w, AInt opt, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { sx <<=4; sy <<= 4; x0 <<= 4; y0 <<= 4; }
	aFillOvalOpt0(w, sx, sy, x0, y0, c);
}

#define DRAWOVALPARAM	1

ASTATIC void aDrawOvalOpt0(AWindow *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	double dcx, dcy, dcxy, dtx, dty, dcx1, dcy1, dcxy1, dtx1, dty1;
	int x, y;
	aDbg_testWin(w, "aDrawOval");
	aDbg_testCol(c, "aDrawOval");
	dcx = 0.5 * (sx - 1);
	dcy = 0.5 * (sy - 1);
	dcxy = (dcx + 0.5) * (dcy + 0.5) - 0.1;
	dcxy *= dcxy;
	dcx1 = 0.5 * (sx - (1 + DRAWOVALPARAM * 2));
	dcy1 = 0.5 * (sy - (1 + DRAWOVALPARAM * 2));
	dcxy1 = (dcx1 + 0.5) * (dcy1 + 0.5) - 0.1;
	dcxy1 *= dcxy1;
	for (y = 0; y < sy; y++) {
		dty  = (y - dcy) * dcx;
		dty1 = (y - dcy) * dcx1;
		for (x = 0; x < sx; x++) {
			dtx = (x - dcx) * dcy;
			dtx1 = (x - dcx) * dcy1;
			if (dtx * dtx + dty * dty > dcxy) continue;
			if (DRAWOVALPARAM <= x && x < sx - DRAWOVALPARAM && DRAWOVALPARAM <= y && y < sy - DRAWOVALPARAM) {
				if (dtx1 * dtx1 + dty1 * dty1 < dcxy1) continue;
			}
			aSetPixOpt0(w, x + x0, y + y0, c);
		}
	}
}

ASTATIC void aDrawOvalOpt(AWindow *w, AInt opt, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { sx <<=4; sy <<= 4; x0 <<= 4; y0 <<= 4; }
	aDrawOvalOpt0(w, sx, sy, x0, y0, c);
}

typedef struct APoint_ {
	int x, y;
} APoint;

ASTATIC void aFillOpt0(ACA, AWindow *w, AInt32 x, AInt32 y, AInt32 c)
{
	int b, sp, sx = w->xsiz, sy = w->ysiz, u, v, *q = w->buf;
	APoint *p;
	if (x < 0 || x >= sx || y < 0 || y >= sy || c < 0) return;
	b = q[x + y * sx];
	if (b == c) return;
	p = aMallocTmp(ca0->s, sx * sy * aSizeof (APoint), 0);
	sp = 0; p[sp].x = x; p[sp].y = y; q[x + y * sx] = c;
	do {
		x = p[sp].x;
		y = p[sp].y;
		sp--;
		u = x;     v = y + 1; if (v < sy && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
		u = x;     v = y - 1; if (v >= 0 && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
		u = x + 1; v = y;     if (u < sx && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
		u = x - 1; v = y;     if (u >= 0 && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
	} while (sp >= 0);
	aFreeTmp(ca0->s, p, sx * sy * aSizeof (APoint));
}

ASTATIC void aFillOpt(ACA, AWindow *w, AInt8 opt, AInt32 x, AInt32 y, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	aFillOpt0(ca0, w, x, y, c);
}

#if (AKEYBUFSIZ > 0)

ASTATIC void aPutKeybuf(AWindow *w, AInt32 c)
{
	if (((w->kbw + 1) & (AKEYBUFSIZ - 1)) != w->kbr) {
		w->keybuf[w->kbw] = c;
		w->kbw = (w->kbw + 1) & (AKEYBUFSIZ - 1);
	}
}

ASTATIC AInt aGetSpcKeybuf(AWindow *w)
{
	if (w->kbr <= w->kbw)
		return AKEYBUFSIZ - (w->kbw - w->kbr);
	return w->kbr - w->kbw - 1;
}

AINLINESTATIC AInt32 aInkeySub1(AWindow *w, AInt i) { return w->keybuf[(w->kbr + i) & (AKEYBUFSIZ - 1)]; }

ASTATIC AInt aInkeySub0(AWindow *w)
{
	AInt32 i, j;
	if (w->kbr == w->kbw) return 0;
	i = w->keybuf[w->kbr];
	w->inkeyPrm[0] = i;
	if ((i & 0xc000) == 0) return 1;
	if ((i & 0xc000) == 0x4000) {
		j = w->keybuf[(w->kbr + 1) & (AKEYBUFSIZ - 1)];
		w->inkeyPrm[1] = j & 0xffff;
		if ((w->inkeyPrm[1] & 0x8000) != 0) {
			w->inkeyPrm[1] -= 0x10000;
			if (w->inkeyPrm[1] == -0x8000)
				w->inkeyPrm[1] = ~(AInt) 0x7fffffff; // (AInt) (-1) << 31;
		}
		w->inkeyPrm[2] = (j >> 16) & 0xffff;
		if ((w->inkeyPrm[2] & 0x8000) != 0)
			w->inkeyPrm[2] -= 0x10000;
		return 2;
	}
	aDbgErrExit("aInkeySub0: internal error: i=0x%x", i);
	return 0; // dummy
}

ASTATIC AInt32 aInkey(AWindow *w, AInt flg)
{
	aDbg_testWin(w, "aInkey");
	aWait0(0);
	AInt i = aInkeySub0(w);
	if (i == 0) return 0;
	if ((flg & 1) != 0)
		w->kbr = (w->kbr + i) & (AKEYBUFSIZ - 1);
	i = w->inkeyPrm[0];
	if ((flg & 2) == 0) i &= 0xffff;
	return i;
}

#endif

#if (!defined(ANOUSE_DRAWSTR))

ASTATIC AUInt8a aFontData[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x00, 0x00,
	0x10, 0x3a, 0x56, 0x92, 0x92, 0x90, 0x50, 0x38, 0x14, 0x12, 0x92, 0x92, 0xd4, 0xb8, 0x10, 0x10,
	0x62, 0x92, 0x94, 0x94, 0x68, 0x08, 0x10, 0x10, 0x20, 0x2c, 0x52, 0x52, 0x92, 0x8c, 0x00, 0x00,
	0x00, 0x70, 0x88, 0x88, 0x88, 0x90, 0x60, 0x47, 0xa2, 0x92, 0x8a, 0x84, 0x46, 0x39, 0x00, 0x00,
	0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x00,
	0x80, 0x40, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x40, 0x80, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x08, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x80, 0x80,
	0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x02, 0x04, 0x08, 0x10, 0x20, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x02, 0x02, 0x04, 0x18, 0x04, 0x02, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x0c, 0x0c, 0x0c, 0x14, 0x14, 0x14, 0x24, 0x24, 0x44, 0x7e, 0x04, 0x04, 0x1e, 0x00, 0x00,
	0x00, 0x7c, 0x40, 0x40, 0x40, 0x58, 0x64, 0x02, 0x02, 0x02, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x7e, 0x42, 0x42, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x26, 0x1a, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x08, 0x10,
	0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x04, 0x08, 0x10, 0x10, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x9c, 0x80, 0x46, 0x38, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x18, 0x18, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xf0, 0x48, 0x44, 0x44, 0x44, 0x48, 0x78, 0x44, 0x42, 0x42, 0x42, 0x44, 0xf8, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x42, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x42, 0x44, 0x38, 0x00, 0x00,
	0x00, 0xf8, 0x44, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x44, 0xf8, 0x00, 0x00,
	0x00, 0xfe, 0x42, 0x42, 0x40, 0x40, 0x44, 0x7c, 0x44, 0x40, 0x40, 0x42, 0x42, 0xfe, 0x00, 0x00,
	0x00, 0xfe, 0x42, 0x42, 0x40, 0x40, 0x44, 0x7c, 0x44, 0x44, 0x40, 0x40, 0x40, 0xf0, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x42, 0x82, 0x80, 0x80, 0x9e, 0x82, 0x82, 0x82, 0x42, 0x46, 0x38, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x48, 0x30, 0x00,
	0x00, 0xe7, 0x42, 0x44, 0x48, 0x50, 0x50, 0x60, 0x50, 0x50, 0x48, 0x44, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xf0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0xfe, 0x00, 0x00,
	0x00, 0xc3, 0x42, 0x66, 0x66, 0x66, 0x5a, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xc7, 0x42, 0x62, 0x62, 0x52, 0x52, 0x52, 0x4a, 0x4a, 0x4a, 0x46, 0x46, 0xe2, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x00, 0xf8, 0x44, 0x42, 0x42, 0x42, 0x44, 0x78, 0x40, 0x40, 0x40, 0x40, 0x40, 0xf0, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0x8a, 0x44, 0x3a, 0x00, 0x00,
	0x00, 0xfc, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x82, 0x82, 0x80, 0x40, 0x38, 0x04, 0x02, 0x82, 0x82, 0xc4, 0xb8, 0x00, 0x00,
	0x00, 0xfe, 0x92, 0x92, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x3c, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x24, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x5a, 0x5a, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x24, 0x24, 0x24, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xee, 0x44, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0xfe, 0x84, 0x84, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x42, 0x82, 0xfe, 0x00, 0x00,
	0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00,
	0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x04, 0x02, 0x02,
	0x00, 0x7c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00,
	0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00,
	0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x04, 0x3c, 0x44, 0x84, 0x84, 0x8c, 0x76, 0x00, 0x00,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4c, 0x84, 0x84, 0x80, 0x80, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x0c, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x36, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0xfc, 0x80, 0x82, 0x42, 0x3c, 0x00, 0x00,
	0x0e, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x34, 0x04, 0x04, 0x78,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe3, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x30,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x4e, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0xe6, 0x00, 0x00,
	0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0xdb, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe3, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0xe0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x34, 0x04, 0x0e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x62, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x86, 0x82, 0xc0, 0x38, 0x06, 0x82, 0xc2, 0xbc, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x5a, 0x5a, 0x5a, 0x24, 0x24, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x44, 0x28, 0x28, 0x10, 0x28, 0x28, 0x44, 0xc6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x10, 0x10, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x84, 0x08, 0x10, 0x20, 0x42, 0x82, 0xfe, 0x00, 0x00,
	0x00, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x60, 0x10, 0x10, 0x10, 0x10, 0x08, 0x06, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x60, 0x10, 0x08, 0x08, 0x08, 0x08, 0x06, 0x08, 0x08, 0x08, 0x08, 0x10, 0x60, 0x00, 0x00,
	0x00, 0x72, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0xfe, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00
};

ASTATIC void aDrawStr0(AWindow *w, AInt16 x, AInt16 y, AInt32 c, AInt32 b, const char *s)
{
	AInt i, j, ch;
	AInt16 k, pt;
	aDbg_testWin(w, "aDrawStr0");
	aDbg_testCol(c, "aDrawStr0");
	for (i = 0; s[i] != '\0'; i++) {
		#if (defined(ADEBUG))
			if (x < 0 || w->xsiz < 8 + x || y < 0 || w->ysiz < 16 + y)
				aErrExit("aDrawStr0 : out of range");
		#endif
		ch = s[i];
		if (ch < ' ' || ch > 0x7f) ch = ' ';
		ch = (ch - ' ') * 16;
		for (j = 0; j < 16; j++) {
			pt = aFontData[ch + j];
			for (k = 0; k < 8; k++) {
				if ((pt & 0x80) != 0) {
					aSetPix0(w, x + k, y + j, c);
				} else {
					aSetPix0(w, x + k, y + j, b);
				}
				pt <<= 1;
			}
		}
		x += 8;
	}
}

ASTATIC void aDrawStrOpt0(AWindow *w, AInt32 x, AInt32 y, AInt32 c, AInt32 b, const char *s)
{
	AInt i, j, ch;
	AInt16 k, pt;
	aDbg_testWin(w, "aDrawStr");
	aDbg_testCol(c, "aDrawStr");
	for (i = 0; s[i] != '\0'; i++) {
		ch = s[i];
		if (ch < ' ' || ch > 0x7f) ch = ' ';
		ch = (ch - ' ') * 16;
		for (j = 0; j < 16; j++) {
			pt = aFontData[ch + j];
			for (k = 0; k < 8; k++) {
				if ((pt & 0x80) != 0) {
					if (c >= 0)
						aSetPixOpt0(w, x + k, y + j, c);
				} else {
					if (b >= 0)
						aSetPixOpt0(w, x + k, y + j, b);
				}
				pt <<= 1;
			}
		}
		x += 8;
	}
}

ASTATIC void aDrawStrOpt(AWindow *w, AInt8 opt, AInt32 x, AInt32 y, AInt32 c, AInt32 b, const char *s)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c& 15]; if (b >= 0) c = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	aDrawStrOpt0(w, x, y, c, b, s);
}


#endif

#if (AKEYBUFSIZ > 0)

#if (!defined(ADEBUG))

AINLINESTATIC void aClrKeybuf(AWindow *w) { w->kbw = w->kbr = 0; }

#else

ASTATIC void aClrKeybuf(AWindow *w)
{
	aDbg_testWin(w, "aClrKeybuf");
	w->kbw = w->kbr = 0;
}

#endif

ASTATIC void aSetInkey(AWindow *w, AInt8 mod)
{
	aDbg_testWin(w, "aSetInkey");
	w->keyLv =  mod       & 0xf;
	w->mosLv = (mod >> 4) & 0xf;
	aClrKeybuf(w);
}

ASTATIC AInt32 aInkeyWait(AWindow *w, AInt flg)
{
	aDbg_testWin(w, "aInkeyWait");
	if (w->kbr != w->kbw)
		return aInkey(w, flg);
	aFlushAll(0);
	while (w->kbr == w->kbw)
		aWait0(32);
	return aInkey(w, flg);
}

#endif

static AInt32 aColTbl[16] = {
	0x000000, 0x0000ff, 0x00ff00, 0x00ffff, 0xff0000, 0xff00ff, 0xffff00, 0xffffff,
	0x555555, 0x0000aa, 0x00aa00, 0x00aaaa, 0xaa0000, 0xaa00aa, 0xaaaa00, 0xaaaaaa
};

ASTATIC AWindow *aOpenWinExOpt(ACA, AInt8 opt, AInt16 xs, AInt16 ys, const char *t, AInt8 mod)
{
	if ((opt & 2) == 0) { xs <<= 4; ys <<= 4; }
	AWindow *w = aOpenWin(ca0, xs, ys, t, mod);
	w->cbxs = xs >> 4;
	w->cbys = ys >> 4;
	w->cb = aMalloc(ca0, w->cbxs * w->cbys * (3 * sizeof (AInt32a)), 0);
	memset(w->cb, 0, w->cbxs * w->cbys * (3 * sizeof (AInt32a)));
	w->savBuf = aMalloc(ca0, 256 * 16 * sizeof (AInt32a), 0);
	AInt i;
	for (i = 0; i < 16; i++)
		w->savXy[i * 2 + 0] = 0x7fffffff;
	memcpy(w->pal, aColTbl, sizeof aColTbl);
	w->optDef = 0;
	return w;
}

ASTATIC AInt32 aGetPal(AWindow *w, AInt32 c)
{
	return w->pal[c & 15];
}

ASTATIC void aEchOpt0(AWindow *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	AInt16 ecx = x >> 4, ecy = y >> 4;
	if ((opt & 4) == 0 && 0 <= ecx && ecx < w->cbxs && 0 <= ecy && ecy < w->cbys) {
		AInt xy = (ecx + ecy * w->cbxs) * 3;
		w->cb[xy + 0] = ch;
		w->cb[xy + 1] = c;
		w->cb[xy + 2] = b;
	}
	AInt xsiz = w->xsiz;
	AInt32 xx, yy, *q = &w->buf[x + y * xsiz], t;
	const char *p = &aChrFontEx[ch * 256];
	for (yy = 0; yy < 16; yy++) {
		if (0 <= y + yy && y + yy < w->ysiz) {
			for (xx = 0; xx < 16; xx++) {
				if (0 <= x + xx && x + xx < xsiz) {
					t = b;
					if (p[xx + yy * 16] == '*')
						t = c;
					if (t >= 0)
						q[xx + yy * xsiz] = t;
				}
			}
		}
	}
}

ASTATIC void aEchOpt(AWindow *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	aEchOpt0(w, opt, x, y, ch, c, b);
}

ASTATIC void aClsOpt(AWindow *w, AInt8 opt, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	aFillRectOpt0(w, w->xsiz, w->ysiz, 0, 0, c);
	AInt i;
	for (i = 0; i < 16; i++)
		w->savXy[i * 2 + 0] = 0x7fffffff;
	if ((opt & 4) == 0)
		memset(w->cb, 0, w->cbxs * w->cbys * (3 * sizeof (AInt32a)));
}

ASTATIC AInt aGetEchOpt(AWindow *w, AInt8 opt, AInt16 x, AInt16 y, AInt8 ofs)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 2) != 0) { x >>= 4; y >>= 4; }
	return w->cb[(x + y * w->cbxs) * 3 + ofs];
}

ASTATIC void aEchBoxOpt0(AWindow *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	AInt xx, yy;
	for (yy = 0; yy < ys; yy += 16) {
		for (xx = 0; xx < xs; xx += 16)
			aEchOpt0(w, opt, x + xx, y + yy, ch, c, b);
	}
}

ASTATIC void aEchBoxOpt(AWindow *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; xs <<= 4; ys <<= 4; }
	aEchBoxOpt0(w, opt, xs, ys, x, y, ch, c, b);
}

ASTATIC AInt32 aGetEchBoxOpt(AWindow *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt8 ofs)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 2) != 0) { x >>= 4; y >>= 4; xs >>= 4; ys >>= 4; }
	AInt32 c = -1, cc;
	AInt16 xx, yy;
	for (yy = 0; yy < ys; yy++) {
		for (xx = 0; xx < xs; xx++) {
			if (0 <= x + xx && x + xx < w->cbxs && 0 <= y + yy && y + yy < w->cbys) {
				cc = w->cb[((x + xx) + (y + yy) * w->cbxs) * 3 + ofs];
				if (c == -1) c = cc;
				if (c != cc) return -1;
			}
		}
	}
	return c;
}

ASTATIC AInt aSaturateInt(AInt i, AInt i0, AInt i1)
{
	if (i < i0) i = i0;
	if (i > i1) i = i1;
	return i;
}

ASTATIC void aWaitKey(AWindow *w, AInt32 k)
{
	for (;;) {
		aWait(100);
		for (;;) {
			AInt32 i = aInkey(w, 1);
			if (i == k) return;
			if (i == 0) break;
		}
	}
}

ASTATIC AInt aMoveDx(AInt32 k)
{
	AInt dx = 0;
	if (k == AKEY_LEFT)  dx = -1;
	if (k == AKEY_RIGHT) dx = +1;
	return dx;
}

ASTATIC AInt aMoveDy(AInt32 k)
{
	AInt dy = 0;
	if (k == AKEY_UP)   dy = -1;
	if (k == AKEY_DOWN) dy = +1;
	return dy;
}

ASTATIC void aEchSav0(AWindow *w, AInt16 x, AInt16 y)
{
	AInt i, xx, yy;
	for (i = 0; i < 16; i++) {
		if (w->savXy[i * 2 + 0] == 0x7fffffff) goto skip;
	}
	goto fin;
skip:
	w->savXy[i * 2 + 0] = x;
	w->savXy[i * 2 + 1] = y;
	AInt xsiz = w->xsiz;
	AInt32a *p = &w->buf[x + y * xsiz];
	for (yy = 0; yy < 16; yy++) {
		if (0 <= y + yy && y + yy < w->ysiz) {
			for (xx = 0; xx < 16; xx++) {
				if (0 <= x + xx && x + xx < xsiz) {
					w->savBuf[i * 256 + yy * 16 + xx] = p[xx + yy * xsiz];
				}
			}
		}
	}
fin:	;
}

ASTATIC void aEchSavOpt(AWindow *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	aEchSav0(w, x, y);
	aEchOpt0(w, 4, x, y, ch, c, b);
}

ASTATIC void aEchRst(AWindow *w)
{
	AInt i, x, y, xx, yy;
	AInt xsiz = w->xsiz;
	AInt32 *p = w->buf;
	for (i = 15; i >= 0; i--) {
		x = w->savXy[i * 2 + 0];
		if (x == 0x7fffffff) continue;
		y = w->savXy[i * 2 + 1];
		w->savXy[i * 2 + 0] = 0x7fffffff;
		for (yy = 0; yy < 16; yy++) {
			if (0 <= y + yy && y + yy < w->ysiz) {
				for (xx = 0; xx < 16; xx++) {
					if (0 <= x + xx && x + xx < xsiz) {
						p[(x + xx) + (y + yy) * xsiz] = w->savBuf[i * 256 + yy * 16 + xx];
					}
				}
			}
		}
	}
}

ASTATIC AInt aInkey_waitRC(AWindow *w, AInt32 msec)
{
	aClrKeybuf(w);
	aWait(msec);
	AInt k = aInkey(w, 1);
	aEchRst(w);
	return k;
}

ASTATIC AInt aInkey_waitR(AWindow *w, AInt32 msec)
{
	aWait(msec);
	AInt k = aInkey(w, 1);
	aEchRst(w);
	return k;
}

ASTATIC void aScrollOpt(AWindow *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt16 dx, AInt16 dy, AInt16 mod, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	AInt32 xsiz = w->xsiz, ysiz = w->ysiz, *p = w->buf, yy;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; xs <<= 4; ys <<= 4; dx <<= 4; dy <<= 4; }
	if (xs > 0 && ys > 0 && 0 <= x && x + xs <= xsiz && 0 <= y && y + ys <= ysiz && 0 <= x + dx && x + dx + xs <= xsiz && 0 <= y + dy && y + dy + ys <= ysiz) {
		if (dy <= 0) {
			for (yy = 0; yy < ys; yy++) {
				memmove(&p[(x + dx) + (y + dy + yy) * xsiz], &p[x + (y + yy) * xsiz], xs * sizeof (AInt32a));
			}
			if ((opt & 4) == 0) {
				for (yy = 0; yy < ys; yy += 16) {
					memmove(&w->cb[(((x + dx) + (y + dy + yy) * w->cbxs) >> 4) * 3], &w->cb[((x + (y + yy) * w->cbxs) >> 4) * 3], (xs >> 4) * 3 * sizeof (AInt32a));
				}
			}
		} else {
			for (yy = ys - 1; yy >= 0; yy--) {
				memmove(&p[(x + dx) + (y + dy + yy) * xsiz], &p[x + (y + yy) * xsiz], xs * sizeof (AInt32a));
			}
			if ((opt & 4) == 0) {
				for (yy = ys - 16; yy >= 0; yy -= 16) {
					memmove(&w->cb[(((x + dx) + (y + dy + yy) * w->cbxs) >> 4) * 3], &w->cb[((x + (y + yy) * w->cbxs) >> 4) * 3], (xs >> 4) * 3 * sizeof (AInt32a));
				}
			}
		}
		if (mod == 1) {
			if (dx <  0 && dy == 0) aEchBoxOpt0(w, opt & ~3, - dx, ys, x + xs + dx, y, ch, c, b);
			if (dx >  0 && dy == 0) aEchBoxOpt0(w, opt & ~3,   dx, ys, x,           y, ch, c, b);
			if (dx == 0 && dy <  0) aEchBoxOpt0(w, opt & ~3, xs, - dy, x, y + ys + dy, ch, c, b);
			if (dx == 0 && dy >  0) aEchBoxOpt0(w, opt & ~3, xs,   dy, x, y,           ch, c, b);
		}
	}
}

ASTATIC void aGrPrintfOpt(AWindow *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 c, AInt32 b, const char *f,...)
{
	char s[1024];
    va_list ap;
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
    va_start(ap, f);
    vsprintf(s, f, ap);
	aDrawStrOpt0(w, x, y, c, b, s);
}

ASTATIC void aGrPrintf(AWindow *w, AInt16 x, AInt16 y, AInt32 c, AInt32 b, const char *f,...)
{
	char s[1024];
    va_list ap;
	AInt8 opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
    va_start(ap, f);
    vsprintf(s, f, ap);
	aDrawStrOpt0(w, x, y, c, b, s);
}

ASTATIC void aFillOvalCentOpt(AWindow *w, AInt8 opt, AInt16 x, AInt16 y, AInt16 a, AInt16 b, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; a <<= 4; b <<= 4; }
	aFillOvalOpt0(w, a * 2, b * 2, x - a, y - b, c);
}

ASTATIC void aDrawOvalCentOpt(AWindow *w, AInt8 opt, AInt16 x, AInt16 y, AInt16 a, AInt16 b, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; a <<= 4; b <<= 4; }
	aDrawOvalOpt0(w, a * 2, b * 2, x - a, y - b, c);
}

ASTATIC void aFillRectOpt(AWindow *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; xs <<= 4; ys <<= 4; }
	aFillRectOpt0(w, xs, ys, x, y, c);
}

ASTATIC AInt aGetPixOpt(AWindow *w, AInt8 opt, AInt16 x, AInt16 y)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	if (x < 0 || w->xsiz <= x || y < 0 || w->ysiz <= y) return -1;
	return aGetPixOpt0(w, x, y);
}

ASTATIC void aBitBlt(AWindow *w, AInt sx, AInt sy, AInt x, AInt y, AInt32a *p)
{
	AInt32a *q = &w->buf[x + y * w->xsiz];
	AInt i, j;
	for (j = 0; j < sy; j++) {
		for (i = 0; i < sx; i++) {
			q[i] = p[i];
		}
		p += sx;
		q += w->xsiz;
	}
}

#define aOpenWinEx(xs, ys, t, mod)		aOpenWinExOpt(0, xs, ys, t, mod)
#define aEch(w, x, y, ch, c, b)			aEchOpt(w, -1, x, y, ch, c, b)
#define aEchBox(w, xs, ys, x, y, ch, c, b)	aEchBoxOpt(w, -1, xs, ys, x, y, ch, c, b)
#define aCls(w, c)						aClsOpt(w, -1, c)
#define aScroll(w, xs, ys, x, y, dx, dy, mod, ch, c, b)		aScrollOpt(w, -1, xs, ys, x, y, dx, dy, mod, ch, c, b)
#define aEchSav(w, x, y, ch, c, b)		aEchSavOpt(w, -1, x, y, ch, c, b)
#define aGetPix(w, x, y)				aGetPixOpt(w, -1, x, y)
#define aGetEch(w, x, y)				aGetEchOpt(w, -1, x, y, 0)
#define aGetEchCol(w, x, y)				aGetEchOpt(w, -1, x, y, 1)
#define aGetEchBak(w, x, y)				aGetEchOpt(w, -1, x, y, 2)
#define aGetEchBox(w, xs, ys, x, y)		aGetEchBoxOpt(w, -1, xs, ys, x, y, 0)
#define aGetEchBoxCol(w, xs, ys, x, y)	aGetEchBoxOpt(w, -1, xs, ys, x, y, 1)
#define aGetEchBoxBak(w, xs, ys, x, y)	aGetEchBoxOpt(w, -1, xs, ys, x, y, 2)
#define aFillRect(w, xs, ys, x, y, c)	aFillRectOpt(w, -1, xs, ys, x, y, c)
#define aDrawRect(w, xs, ys, x, y, c)	aDrawRectOpt(w, -1, xs, ys, x, y, c)
#define aFillOval(w, xs, ys, x, y, c)	aFillOvalOpt(w, -1, xs, ys, x, y, c)
#define aDrawOval(w, xs, ys, x, y, c)	aDrawOvalOpt(w, -1, xs, ys, x, y, c)
#define aDrawLine(w, x0, y0, x1, y1, c)	aDrawLineOpt(w, -1, x0, y0, x1, y1, c)
#define aSetPix(w, x, y, c)				aSetPixOpt(w, -1, x, y, c)
#define aGetPix(w, x, y)				aGetPixOpt(w, -1, x, y)
#define aDrawStr(w, x, y, c, b, s)		aDrawStrOpt(w, -1, x, y, c, b, s)
#define aFillOvalCent(w, x, y, a, b, c)	aFillOvalCentOpt(w, -1, x, y, a, b, c)
#define aDrawOvalCent(w, x, y, a, b, c)	aDrawOvalCentOpt(w, -1, x, y, a, b, c)

#define AOPT_Cf		1
#define AOPT_Rf		2
#define AOPT_RfCf	3
#define AOPT_Gn		4
#define AOPT_GnCf	5
#define AOPT_GnRf	6
#define AOPT_GnRfCf	7

