#if (!defined(ASTATIC))
	#define ASTATIC static
#endif

#if (!defined(AINLINESTATIC))
	#define AINLINESTATIC inline static
#endif

#if (!defined(ADBGLV))
	#define ADBGLV	0
#endif

#define ADefCls0(clsNam)		typedef struct clsNam ## _ clsNam; struct clsNam ## _
#if (ADBGLV >= 1)
	#define ADefCls(clsNam)		ASTATIC const char *clsNam ## _nam = #clsNam ; ADefCls0(clsNam)
#else
	#define ADefCls(clsNam)		ADefCls0(clsNam)
#endif

#if (defined(AARCH_X86))
	#define AINTBIT		32
	#define AINT_MAX	0x7fffffff
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt32 AInt;
	typedef AUInt32 AUInt;
	typedef unsigned char AUInt8a;
#elif (defined(AARCH_X64))
	#define AINTBIT		64
	#define AINT_MAX	0x7fffffffffffffffLL
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt64 AInt;
	typedef AUInt64 AUInt;
	typedef unsigned char AUInt8a;
#elif (defined(AARCH_ARM32))
	#define AINTBIT		32
	#define AINT_MAX	0x7fffffff
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt32 AInt;
	typedef AUInt32 AUInt;
	typedef unsigned char AUInt8a;
#elif (defined(AARCH_AARCH64))
	#define AINTBIT		64
	#define AINT_MAX	0x7fffffffffffffffLL
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt64 AInt;
	typedef AUInt64 AUInt;
	typedef unsigned char AUInt8a;
#endif

#define aSizeof		(AInt) sizeof

#define ASTRINGIFY(n) #n
#define ATOSTRING(n) ASTRINGIFY(n)
#define ASRCPOS __FILE__ ":" ATOSTRING(__LINE__) ": "

// SetDbgSrcPosComma
#if (defined(ADEBUG))
	#define ASDSPC	aDbgSrcPos = ASRCPOS,
#else
	#define ASDSPC
#endif

#if (!defined(ANOUSE_ARG))
	ASTATIC int aArgc;
	ASTATIC char **aArgv;
#endif

#if (!defined(ANOUSE_ATERRMSG))
	static char *aAtErrExitMsg;
#endif

ASTATIC void aErrExit(const char *f, ...);
ASTATIC void *aErrExitP0(void *p, const char *f, ...);

#define AMODE_SET		0
#define AMODE_OR		1
#define AMODE_AND		2
#define AMODE_XOR		3

#define AKEY_ENTER		10
#define AKEY_ESC		27
#define AKEY_BACKSPACE	8
#define AKEY_TAB		9
#define AKEY_PAGEUP		0x1020
#define AKEY_PAGEDWN		0x1021
#define	AKEY_END		0x1022
#define	AKEY_HOME		0x1023
#define AKEY_LEFT		0x1024
#define AKEY_RIGHT		0x1025
#define AKEY_UP		0x1026
#define AKEY_DOWN		0x1027
#define AKEY_INS		0x1028
#define AKEY_DEL		0x1029

#define AKEY_LOCKS		0x00f00000

#define AKEY_LV0		0x00
#define AKEY_LV1		0x01
#define AMOS_LV0		0x00
#define AMOS_LV1		0x10	// NbN̂.
#define AMOS_LV2		0x20	// MOVEׂ.
#define AMOS_LV3		0x30	// zC[.

ADefCls(ASP) {	// size and pointer, simple.
	AInt s1, s;
	char *p;
	struct AMemAlc1_ *ma1;
};

ADefCls(AClean) {
	ASP sp;
	AInt lnk;
	struct AClean_ *pr, *ch;
	void *ext;
};

ADefCls0(AComArg) {
	AClean *tc;
	struct AMemAlc1_ *ta, *na;
	struct AComArg_ *d, *s;
	struct AComArg_Dbg_ *dbg;
	void *ext;
};

#define ACA		AComArg *ca0

ASTATIC void *aMalloc(ACA, AInt sz, AClean *c);
ASTATIC void aFree(ACA, void *p, AInt sz);
ASTATIC void *aMallocTmp(ACA, AInt sz, AClean *c);
ASTATIC void aFreeTmp(ACA, void *p, AInt sz);

void aMain(ACA);

