#define AMemAlc0LogSz	256

ADefCls0(AMemAlc0Log) {	// 256 * sizeof (AInt).
	void *p[AMemAlc0LogSz - 2], *nxt;
	AInt i;
};

ADefCls0(AMemAlc00) {
	void *(*alc)(void *, void *, void *);
	void (*fre)(void *, void *, void *);
	AInt sz;
};

ADefCls(AMemAlc0) {
	AMemAlc00 hed, *alc0, *alcLog;
	void *p;
	AMemAlc0Log *log;
	AInt sz0, c, logLen, n;
	void *cFre0[2], *cFre1[2];
	struct AMemAlc0_Dbg_ *dbg;
};

ADefCls(AMemAlc1) {
	AMemAlc0 alc[28]; // 8`1G.
};


ADefCls(AActObj) {
	ASP sp, noChk;
	char dbg;
};

ADefCls0(AComArg_Dbg) {
	AActObj *act;
};

ASTATIC void AClean_set(ACA, AClean *w, void *f, void *p);

ASTATIC void *AMemAlc1_alc0(ACA, AMemAlc1 *w, AInt sz, AClean *c);
ASTATIC void *AMemAlc1_alc1(ACA, AMemAlc1 *w, AInt sz, AClean *c);
ASTATIC AMemAlc0 *AMemAlc1_getAlc(ACA, AMemAlc1 *w, AInt sz);

ASTATIC void ASP_resize0(ACA, ASP *w, AInt s1);
ASTATIC void ASP_resize1(ACA, ASP *w, AInt s1);
ASTATIC void ASP_addInt2(ACA, ASP *w, AInt i0, AInt i1);

ASTATIC void aDbgActObj_ins0(ACA, void *p, const char *nam, AInt sz);
ASTATIC void aDbgActObj_chk0(ACA, void *p, const char *nam);
ASTATIC void aDbgActObj_del0(ACA, void *p, const char *nam);
ASTATIC void aDbgActObj_dmp0(ACA, char mod);
ASTATIC void aDbgActObj_noChk0(ACA, void *p, AInt sz);

#if (ADBGLV >= 1)
	#define ASP_resize		ASP_resize1
	#define ASPND_resize	ASPND_resize1
	#define AMemAlc0_alc	AMemAlc0_alc1
	#define AMemAlc0_fre	AMemAlc0_fre1
	#define AMemAlc0_rsz	AMemAlc0_rsz1
	#define AMemAlc1_alc	AMemAlc1_alc1
	#define AMemAlc1_fre	AMemAlc1_fre1
#else
	#define ASP_resize		ASP_resize0
	#define ASP_resize		ASP_resize0
	#define AMemAlc0_alc	AMemAlc0_alc0
	#define AMemAlc0_fre	AMemAlc0_fre0
	#define AMemAlc0_rsz(...)
	#define AMemAlc1_alc	AMemAlc1_alc0
	#define AMemAlc1_fre	AMemAlc1_fre0
#endif

#if (ADBGLV >= 2)
	#define aDbgActObj_del	aDbgActObj_del0
	#define aDbgActObj_ins	aDbgActObj_ins0
	#define aDbgActObj_chk	aDbgActObj_chk0
	#define aDbgActObj_dmp	aDbgActObj_dmp0
	#define aDbgActObj_noChk	aDbgActObj_noChk0
#else
	#define aDbgActObj_del(...)
	#define aDbgActObj_ins(...)
	#define aDbgActObj_chk(...)
	#define aDbgActObj_dmp(...)
	#define aDbgActObj_noChk(...)
#endif

#if (!defined(ANOUSE_FASTMALLOC))

ASTATIC void AMemAlc0_fill(ACA, AMemAlc0 *w)
{
	AMemAlc0Log *log = w->log;
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	if (log == 0 || log->i == AMemAlc0LogSz - 2) {
		AMemAlc0Log *nxtLog = (w->alcLog->alc)(ca0, w->alcLog, 0);
		nxtLog->nxt = log;
		nxtLog->i = 0;
		log = w->log = nxtLog;
		w->logLen++;
	}
	AInt i = log->i;
	char *p = (w->alc0->alc)(ca0, w->alc0, 0);
	log->p[i++] = p;
	log->i = i;
	AInt s = w->hed.sz * w->n;
	p += s;
	do {
		p -= w->hed.sz;
		*((void **) p) = w->p;
		w->p = (void *) p;
		s -= w->hed.sz;
	} while (s > 0);
}

ASTATIC AInt AMemAlc0_test0(ACA, AMemAlc0 *w, void *p, AInt *ofs)
// |C^p̈ԍofsɕ.
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	AMemAlc0Log *log = w->log;
	AInt ll = w->logLen;
	for (; log != 0; log = log->nxt) {
		AInt i;
		ll--;
		for (i = 0; i < log->i; i++) {
			char *p0 = log->p[i], *p1 = p0 + w->sz0;
			if (p0 == 0) continue;
			if (p0 <= (char *) p && (char *) p < p1) {
				AInt j = ((char *) p) - p0;
				*ofs = j % w->hed.sz;
				return w->n * ll + j / w->hed.sz;
			}
		}
	}
	return -1; // not-found.
}

ASTATIC AInt AMemAlc0_test1(ACA, AMemAlc0 *w, void *p)
// |C^p|C^X^bN̒ɂ-1ԂAȂ0Ԃidouble-freeopj.
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	void *r = w->p;
	for (; r != 0; r = *((void **) r)) {
		if (r == p) return -1; // exist.
	}
	return 0; // not-exist.
}

ASTATIC void *AMemAlc0_test2(ACA, AMemAlc0 *w, AInt i)
// ̈ԍA|C^Ԃ.
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	AMemAlc0Log *log = w->log;
	AInt ll = w->logLen, ii = i / ((AMemAlc0LogSz - 2) * w->n);
	i %= (AMemAlc0LogSz - 2) * w->n;
	for (; log != 0; log = log->nxt) {
		ll--;
		if (ll == ii)
			return ((char *) log->p[i / w->n]) + w->hed.sz * (i % w->n);
	}
	return 0;	// ܂Ȃ.
}

ASTATIC AInt AMemAlc0_test3(ACA, AMemAlc0 **w0, AMemAlc0 **w1, void *p, AInt *ofs, AInt *alc0)
// AMemAlc0̈ꗗ̈ԍT.
{
	AMemAlc0 **w;
	for (w = w0; w < w1; w++) {
		aDbgActObj_chk(ca0, *w, AMemAlc0_nam);
		AInt i = AMemAlc0_test0(ca0, *w, p, ofs);
		if (i >= 0) {
			*alc0 = w - w0;
			return i;
		}
	}
	return -1;
}

ASTATIC void AMemAlc0_fre0(ACA, AMemAlc0 *w, void *p)
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	#if (ADBGLV >= 2)
		AInt ofs;
		if (AMemAlc0_test0(ca0, w, p, &ofs) < 0)
			aErrExit("AMemAlc0_fre: invalid pointer #0: sz=%d", w->hed.sz);
		if (ofs != 0)
			aErrExit("AMemAlc0_fre: invalid pointer #1: sz=%d", w->hed.sz);
		if (AMemAlc0_test1(ca0, w, p) != 0)
			aErrExit("AMemAlc0_fre: double-free: sz=%d", w->hed.sz);
	#else
		(void) ca0;
	#endif
	*((void **) p) = w->p;
	w->p = (void *) p;
	w->c--;
}

ASTATIC void AMemAlc0_cFre0(ACA, void *p, void **cFre0)
{
	aDbgActObj_chk(ca0, cFre0[1], AMemAlc0_nam);
	AMemAlc0_fre0(ca0, cFre0[1], p);
}

ASTATIC void AMemAlc0_fre1(ACA, AMemAlc0 *w, void *p);

ASTATIC void AMemAlc0_cFre1(ACA, void *p, void **cFre1)
{
	aDbgActObj_chk(ca0, cFre1[1], AMemAlc0_nam);
	AMemAlc0_fre1(ca0, cFre1[1], p);
}

ASTATIC void *AMemAlc0_alc0(ACA, AMemAlc0 *w, AClean *c, AInt sz)
{
	(void) sz;
	void *p = w->p;
	if (p == 0) {
		AMemAlc0_fill(ca0, w);
		p = w->p;
	}
	w->p = *((void **) p);
	w->c++;
	AClean_set(ca0, c, w->cFre0, p);
	return p;
}

ASTATIC void AMemAlc0_deinit(ACA, AMemAlc0 *w)
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	#if (ADBGLV >= 1)
		if (w->c != 0) aErrExit("AMemAlc0_deinit(sz=%d): c=%d", w->hed.sz, w->c);
	#endif
	AMemAlc0Log *log = w->log;
	AInt i;
	while (log != 0) {
		for (i = log->i - 1; i >= 0; i--) {
			if (log->p[i] != 0)
				(w->alc0->fre)(ca0, w->alc0, log->p[i]);
		}
		void *log0 = log;
		log = log->nxt;
		(w->alcLog->fre)(ca0, w->alcLog, log0);
	};
	w->log = 0;
	w->logLen = 0;
	aDbgActObj_del(ca0, w, AMemAlc0_nam);
}

ASTATIC void AMemAlc0_init(ACA, AMemAlc0 *w, AInt sz, AMemAlc00 *alc0, AMemAlc00 *alcLog, AClean *c)
{
	static void *cDeinit[1] = { AMemAlc0_deinit };
	sz = (sz + 7) & -8;
	w->alc0 = alc0;
	w->alcLog = alcLog;
//	AMemAlc0Log *log = 0; w->log = (w->alcLog->alc)(w->alcLog, 0);
//	log->nxt = 0;
//	log->i = 0;
	w->log = 0;
	w->logLen = 0; // 1;
	w->p = 0;
	w->sz0 = alc0->sz;
	w->n = alc0->sz / sz;
	#if (ADBGLV >= 1)
		if (w->n <= 0)
			aErrExit("AMemAlc0_init: size error: sz=%d sz0=%d", sz, alc0->sz);
	#endif
	w->c = 0;
	w->hed.alc = (void *) AMemAlc0_alc0;
	w->hed.fre = (void *) AMemAlc0_fre0;
	w->hed.sz = sz;
	w->cFre0[0] = AMemAlc0_cFre0;
	w->cFre0[1] = w;
	w->cFre1[0] = AMemAlc0_cFre1;
	w->cFre1[1] = w;
	AClean_set(ca0, c, cDeinit, w);
	#if (ADBGLV >= 1)
		w->dbg = 0;
	#endif
	aDbgActObj_ins(ca0, w, AMemAlc0_nam, sizeof (AMemAlc0));
}

ADefCls0(AMemAlc0_Dbg) {
	ASP sp;
};

ASTATIC void *AMemAlc0_alc1(ACA, AMemAlc0 *w, AClean *c, AInt sz)
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	void *p = AMemAlc0_alc0(ca0, w, 0, 0);
	AClean_set(ca0, c, w->cFre1, p);
	if (w->dbg != 0) {
//		AMemAlc0_Dbg *d = w->dbg;
		ASP_addInt2(ca0, &w->dbg->sp, (AInt) p, sz);
#if 0
		d->sz += 2 * sizeof (AInt);
		ASP_resize(ca0, &d->sp, d->sz);
		AInt *q = (AInt *) (d->sp.p + d->sz);
		q[-2] = (AInt) p;
		q[-1] = sz;
#endif
	}
	return p;
}

ASTATIC void AMemAlc0_rsz1(ACA, AMemAlc0 *w, void *p, AInt sz)
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	if (w->dbg != 0) {
		AInt *q  = (AInt *) w->dbg->sp.p;
		AInt *q1 = (AInt *) (w->dbg->sp.p + w->dbg->sp.s);
		for (; q < q1; q += 2) {
			if (q[0] == (AInt) p)
				break;
		}
		if (q >= q1)
			aErrExit("AMemAlc0_rsz1: not found");
		q[1] = sz;
	}
}

ASTATIC void AMemAlc0_fre1(ACA, AMemAlc0 *w, void *p)
{
	aDbgActObj_chk(ca0, w, AMemAlc0_nam);
	if (w->dbg != 0) {
		AInt *q  = (AInt *) w->dbg->sp.p;
		AInt *q1 = (AInt *) (w->dbg->sp.p + w->dbg->sp.s);
		for (; q < q1; q += 2) {
			if (q[0] == (AInt) p)
				break;
		}
		if (q >= q1)
			aErrExit("AMemAlc0_fre1: not found");
		q[0] = q1[-2];
		q[1] = q1[-1];
		w->dbg->sp.s -= 2 * sizeof (AInt);
	}
	AMemAlc0_fre0(ca0, w, p);
}

////////////////////////////////////////////////////////////////

ADefCls0(AMemAlcSys) {
	AMemAlc00 hed;
};

ASTATIC void *AMemSlcSys_alc(ACA, AMemAlcSys *w)
{
	(void) ca0;
	void *p = malloc(w->hed.sz);
	if (p == 0)
		aErrExit("AMemSlcSys_alc: out of memory");
	return p;
}

ASTATIC void AMemSlcSys_fre(ACA, AMemAlcSys *w, void *p)
{
	(void) ca0;
	(void) w;
	free(p);
}

ASTATIC void AMemAlcSys_init(ACA, AMemAlcSys *w, AInt sz)
{
	(void) ca0;
	w->hed.alc = (void *) AMemSlcSys_alc;
	w->hed.fre = (void *) AMemSlcSys_fre;
	w->hed.sz = sz;
}

ASTATIC void AMemAlcSys_deinit(ACA, AMemAlcSys *w) { }

////////////////////////////////////////////////////////////////

enum {	AMemAlcSys_log, AMemAlcSys_16k, AMemAlcSys_64k, AMemAlcSys_256k,
		AMemAlcSys_1m,  AMemAlcSys_4m,  AMemAlcSys_16m, AMemAlcSys_64m,
		AMemAlcSys_128m, AMemAlcSys_256m, AMemAlcSys_512m, AMemAlcSys_1g
};

ASTATIC AMemAlcSys aMemAlcSys_a[12];

ASTATIC AInt aMemAlcSys_sz[12] = {
	sizeof (AMemAlc0Log), 16 << 10, 64 << 10, 256 << 10, 1 << 20,
	4 << 20, 16 << 20, 64 << 20, 128 << 20, 256 << 20, 512 << 20, 1 << 30
};

ASTATIC char AMemAlcSys_allReady = 0;

ASTATIC void AMemAlcSys_initAll(ACA)
{
	if (AMemAlcSys_allReady == 0) {
		AInt i;
		for (i = 0; i < 12; i++)
			AMemAlcSys_init(ca0, &aMemAlcSys_a[i], aMemAlcSys_sz[i]);
		AMemAlcSys_allReady = 1;
	}
}

ASTATIC void AMemAlc1_deinit(ACA, AMemAlc1 *w)
{
	AInt i;
	aDbgActObj_chk(ca0, w, AMemAlc1_nam);
	for (i = 0; i < 28; i++)
		AMemAlc0_deinit(ca0, &w->alc[i]);
	aDbgActObj_del(ca0, w, AMemAlc1_nam);
}

ASTATIC void AMemAlc1_init(ACA, AMemAlc1 *w, AClean *c)
{
	static void *cDeinit[1] = { AMemAlc1_deinit };
	static char t[28] = {
		AMemAlcSys_16k,  AMemAlcSys_16k,  AMemAlcSys_16k,  AMemAlcSys_16k, // 8,16,32,64
		AMemAlcSys_16k,  AMemAlcSys_16k,  AMemAlcSys_64k,  AMemAlcSys_64k, // 128,256,512,1k
		AMemAlcSys_256k, AMemAlcSys_256k, AMemAlcSys_1m,   AMemAlcSys_1m,  // 2k,4k,8k,16k
		AMemAlcSys_1m,   AMemAlcSys_1m,   AMemAlcSys_4m,   AMemAlcSys_4m,  // 32k,64k,128k,256k
		AMemAlcSys_4m,   AMemAlcSys_4m,   AMemAlcSys_16m,  AMemAlcSys_16m, // 512k,1m,2m,4m
		AMemAlcSys_16m,  AMemAlcSys_16m,  AMemAlcSys_64m,  AMemAlcSys_64m, // 8m,16m,32m,64m
		AMemAlcSys_128m, AMemAlcSys_256m, AMemAlcSys_512m, AMemAlcSys_1g  // 128m,256m,512m,1g
	};
	#if (ADBGLV >= 1)
		if (w == 0)
			aErrExit("AMemAlc1_init: error: w==0");
	#endif
	AMemAlcSys_initAll(ca0);
	AInt i;
	for (i = 0; i < 28; i++)
		AMemAlc0_init(ca0, &w->alc[i], 8 << i, &aMemAlcSys_a[(AInt) t[i]].hed, &aMemAlcSys_a[AMemAlcSys_log].hed, 0);
	AClean_set(ca0, c, cDeinit, w);
	aDbgActObj_ins(ca0, w, AMemAlc1_nam, sizeof (AMemAlc1));
}

ASTATIC AMemAlc0 **AMemAlc1_makeTable28(ACA, AMemAlc1 *w, AMemAlc0 **t, AClean *c)
{
	aDbgActObj_chk(ca0, w, AMemAlc1_nam);
	if (t == 0)
		t = AMemAlc1_alc(ca0, w, 28 * sizeof (AMemAlc0 *), c);
	AInt i;
	for (i = 0; i < 28; i++)
		t[i] = &w->alc[i];
	return t;
}

ASTATIC AInt AMemAlc1_idx(AInt sz)
{
	#if (ADBGLV >= 1)
		if (sz > 1 << 30)
			aErrExit("AMemAlc1_idx: error: too large size: sz=%d", sz);
	#endif
	static AInt csz = 0, cidx = 0;
	if (sz == csz) return cidx;
	if (sz > 0) {
		csz = sz;
//		cidx = sz = aPopCount32(aMsbEx32(((sz + 7) >> 3) - 1));
		sz = ((sz + 7) >> 3) - 1;
		sz |= sz >> 1;
		sz |= sz >> 2;
		sz |= sz >> 4;
		sz |= sz >> 8;
		sz |= sz >> 16;
		sz -= sz >> 1 & 0x55555555U;
		sz = (sz & 0x33333333U) + (sz >> 2 & 0x33333333U);
		sz = (sz + (sz >> 4)) & 0x0f0f0f0fU;
		cidx = sz = (sz * 0x01010101U) >> 24;
	}
	return sz;
}

ASTATIC AMemAlc0 *AMemAlc1_getAlc(ACA, AMemAlc1 *w, AInt sz)
{
	aDbgActObj_chk(ca0, w, AMemAlc1_nam);
	return &w->alc[AMemAlc1_idx(sz)];
}

ASTATIC void *AMemAlc1_alc0(ACA, AMemAlc1 *w, AInt sz, AClean *c)
{
	return AMemAlc0_alc0(ca0, &w->alc[AMemAlc1_idx(sz)], c, 0);
}

ASTATIC void *AMemAlc1_alc1(ACA, AMemAlc1 *w, AInt sz, AClean *c)
{
	aDbgActObj_chk(ca0, w, AMemAlc1_nam);
	return AMemAlc0_alc1(ca0, &w->alc[AMemAlc1_idx(sz)], c, sz);
}

ASTATIC void AMemAlc1_fre0(ACA, AMemAlc1 *w, void *p, AInt sz)
{
	AMemAlc0_fre0(ca0, &w->alc[AMemAlc1_idx(sz)], p);
}

ASTATIC void AMemAlc1_fre1(ACA, AMemAlc1 *w, void *p, AInt sz)
{
	aDbgActObj_chk(ca0, w, AMemAlc1_nam);
	AMemAlc0_fre1(ca0, &w->alc[AMemAlc1_idx(sz)], p);
}

ASTATIC void AMemAlc0_report0(ACA, AMemAlc0 **w, AMemAlc0 **w1, FILE *fp)
{
	(void) ca0;
	AInt n = 0, sz = 0;
	for (; w < w1; w++) {
		if (*w == 0) continue;
		aDbgActObj_chk(ca0, *w, AMemAlc0_nam);
		n  += (*w)->c;
		sz += (*w)->hed.sz * (*w)->c;
	}
	fprintf(fp, "AMemAlc0_report0: n=%d total=%d\n", n, sz);
}

ASTATIC void AMemAlc0_report1(ACA, AMemAlc0 **w, AMemAlc0 **w1, FILE *fp)
{
	(void) ca0;
	#if (ADBGLV >= 1)
		AInt n = 0, sz = 0;
		for (; w < w1; w++) {
			if (*w == 0) continue;
			aDbgActObj_chk(ca0, *w, AMemAlc0_nam);
			AMemAlc0_Dbg *d = (*w)->dbg;
			if (d == 0) continue;
			n += d->sp.s / (2 * sizeof (AInt));
			AInt *q  = (AInt *) d->sp.p;
			AInt *q1 = (AInt *) (d->sp.p + d->sp.s);
			for (; q < q1; q += 2)
				sz += q[1];
		}
		fprintf(fp, "AMemAlc0_report1: n=%d total=%d\n", n, sz);
	#else
		(void) w;
		fprintf(fp, "AMemAlc0_report1: ADBGLV=%d\n", ADBGLV);
	#endif
}

ASTATIC void AMemAlc0_report2(ACA, AMemAlc0 **w, AMemAlc0 **w1, FILE *fp)
{
	(void) ca0;
	#if (ADBGLV >= 1)
		AInt n = 0, sz = 0;
		for (; w < w1; w++) {
			if (*w == 0) continue;
			aDbgActObj_chk(ca0, *w, AMemAlc0_nam);
			AMemAlc0_Dbg *d = (*w)->dbg;
			if (d == 0) continue;
			n += d->sp.s / (2 * sizeof (AInt));
			AInt *q  = (AInt *) d->sp.p;
			AInt *q1 = (AInt *) (d->sp.p + d->sp.s);
			for (; q < q1; q += 2) {
				sz += q[1];
				printf("%d/%d ", q[1], (*w)->hed.sz);
			}
		}
		fprintf(fp, "AMemAlc0_report1: n=%d total=%d\n", n, sz);
	#else
		(void) w;
		fprintf(fp, "AMemAlc0_report1: ADBGLV=%d\n", ADBGLV);
	#endif
}

ASTATIC AMemAlc0 *AMemAlc0_init1(ACA, AMemAlc0 *w, AInt sz, AMemAlc1 *ma1, AInt sz0, AClean *c)
{
	if (w == 0)
		w = AMemAlc1_alc(ca0, ma1, sizeof (AMemAlc0), c);
	AMemAlc0_init(ca0, w, sz, &AMemAlc1_getAlc(ca0, ma1, sz0)->hed, &AMemAlc1_getAlc(ca0, ma1, sizeof (AMemAlc0Log))->hed, c);
	return w;
}

////////////////////////////////////////////////////////////////

ASTATIC void *aMalloc(ACA, AInt sz, AClean *c)
{
	return AMemAlc0_alc(ca0, &ca0->na->alc[AMemAlc1_idx(sz)], c, sz);
}

ASTATIC void aFree(ACA, void *p, AInt sz)
{
	AMemAlc0_fre(ca0, &ca0->na->alc[AMemAlc1_idx(sz)], p);
}

ASTATIC void *aMallocTmp(ACA, AInt sz, AClean *c)
{
	return AMemAlc0_alc(ca0, &ca0->ta->alc[AMemAlc1_idx(sz)], c, sz);
}

ASTATIC void aFreeTmp(ACA, void *p, AInt sz)
{
	AMemAlc0_fre(ca0, &ca0->ta->alc[AMemAlc1_idx(sz)], p);
}

#else

ADefCls0(AMemAlc0_Dbg) {
	ASP sp;
};

ASTATIC void AMemAlc0_cleanSub(ACA, void *p) { (void) ca0; free(p); }
ASTATIC void *AMemAlc0_cleanSubW[1] = { AMemAlc0_cleanSub };
ASTATIC void AMemAlc0_fre0(ACA, AMemAlc0 *w, void *p) { (void) ca0; (void) w; free(p); }
ASTATIC void AMemAlc0_fre1(ACA, AMemAlc0 *w, void *p) { (void) ca0; (void) w; free(p); }
ASTATIC void *AMemAlc0_alc0(ACA, AMemAlc0 *w, AClean *c, AInt sz) { (void) sz; void *p = malloc(w->hed.sz); AClean_set(ca0, c, AMemAlc0_cleanSubW, p); return p; }
ASTATIC void *AMemAlc0_alc1(ACA, AMemAlc0 *w, AClean *c, AInt sz) { (void) sz; void *p = malloc(w->hed.sz); AClean_set(ca0, c, AMemAlc0_cleanSubW, p); return p; }
ASTATIC void AMemAlc0_deinit(ACA, AMemAlc0 *w) { (void) ca0; (void) w; }
ASTATIC void AMemAlc0_init(ACA, AMemAlc0 *w, AInt sz, AMemAlc00 *alc0, AMemAlc00 *alcLog, AClean *c) { (void) ca0; (void) alc0; (void) alcLog; (void) c; w->hed.sz = sz; }
ASTATIC void AMemAlc0_rsz1(ACA, AMemAlc0 *w, void *p, AInt sz) { (void) ca0; (void) w; (void) p; (void) sz; }
ASTATIC void AMemAlc1_deinit(ACA, AMemAlc1 *w) { (void) ca0; (void) w; }

ASTATIC void AMemAlc1_init(ACA, AMemAlc1 *w, AClean *c)
{
	(void) c;
	AInt i;
	for (i = 0; i < 28; i++)
		AMemAlc0_init(ca0, &w->alc[i], 8 << i, 0, 0, 0);
}

ASTATIC AMemAlc0 **AMemAlc1_makeTable28(ACA, AMemAlc1 *w, AMemAlc0 **t, AClean *c)
{
	if (t == 0)
		t = AMemAlc1_alc(ca0, w, 28 * sizeof (AMemAlc0 *), c);
	AInt i;
	for (i = 0; i < 28; i++)
		t[i] = &w->alc[i];
	return t;
}

ASTATIC AInt AMemAlc1_idx(AInt sz)
{
	#if (ADBGLV >= 1)
		if (sz > 1 << 30)
			aErrExit("AMemAlc1_idx: error: too large size: sz=%d", sz);
	#endif
	static AInt csz = 0, cidx = 0;
	if (sz == csz) return cidx;
	if (sz > 0) {
		csz = sz;
//		cidx = sz = aPopCount32(aMsbEx32(((sz + 7) >> 3) - 1));
		sz = ((sz + 7) >> 3) - 1;
		sz |= sz >> 1;
		sz |= sz >> 2;
		sz |= sz >> 4;
		sz |= sz >> 8;
		sz |= sz >> 16;
		sz -= sz >> 1 & 0x55555555U;
		sz = (sz & 0x33333333U) + (sz >> 2 & 0x33333333U);
		sz = (sz + (sz >> 4)) & 0x0f0f0f0fU;
		cidx = sz = (sz * 0x01010101U) >> 24;
	}
	return sz;
}

ASTATIC AMemAlc0 *AMemAlc1_getAlc(ACA, AMemAlc1 *w, AInt sz) { (void) ca0; return &w->alc[AMemAlc1_idx(sz)]; }
ASTATIC void *AMemAlc1_alc0(ACA, AMemAlc1 *w, AInt sz, AClean *c) { (void) w; void *p = malloc(sz); AClean_set(ca0, c, AMemAlc0_cleanSubW, p); return p; }
ASTATIC void *AMemAlc1_alc1(ACA, AMemAlc1 *w, AInt sz, AClean *c) { (void) w; void *p = malloc(sz); AClean_set(ca0, c, AMemAlc0_cleanSubW, p); return p; }
ASTATIC void AMemAlc1_fre0(ACA, AMemAlc1 *w, void *p, AInt sz) { (void) ca0; (void) w; (void) sz; free(p); }
ASTATIC void AMemAlc1_fre1(ACA, AMemAlc1 *w, void *p, AInt sz) { (void) ca0; (void) w; (void) sz; free(p); }
ASTATIC void AMemAlc0_report0(ACA, AMemAlc0 **w, AMemAlc0 **w1, FILE *fp) { (void) ca0; (void) w; (void) w1; fprintf(fp, "AMemAlc0_report0: ANOUSE_FASTMALLOC\n"); }
ASTATIC void AMemAlc0_report1(ACA, AMemAlc0 **w, AMemAlc0 **w1, FILE *fp) { (void) ca0; (void) w; (void) w1; fprintf(fp, "AMemAlc0_report1: ANOUSE_FASTMALLOC\n"); }
ASTATIC AMemAlc0 *AMemAlc0_init1(ACA, AMemAlc0 *w, AInt sz, AMemAlc1 *ma1, AInt sz0, AClean *c) { (void) ca0; (void) sz; (void) ma1; (void) sz0; (void) c; return w; }
ASTATIC void *aMalloc(ACA, AInt sz, AClean *c) { (void) ca0; return AMemAlc1_alc(ca0, 0, sz, c); }
ASTATIC void aFree(ACA, void *p, AInt sz) { (void) ca0; (void) sz; free(p); }
ASTATIC void *aMallocTmp(ACA, AInt sz, AClean *c) { return AMemAlc1_alc(ca0, 0, sz, c); }
ASTATIC void aFreeTmp(ACA, void *p, AInt sz) { (void) ca0; (void) sz; free(p); }

#endif

ADefCls(AM) {
	void *w, *a, *f, *r, *d;
	AInt s1;
};

ASTATIC void *AM_a(ACA, AM *w, AInt sz, AClean *c)
{
	return ((void *(*)(AComArg *, void *, AInt, AClean *)) w->a)(ca0, w->w, sz, c);
}

ASTATIC void AM_f(ACA, AM *w, void *p, AInt sz)
{
	((void (*)(AComArg *, void *, void *, AInt)) w->f)(ca0, w->w, p, sz);
}

ASTATIC void AM_r(ACA, AM *w, void *p, AInt sz)
{
	((void (*)(AComArg *, void *, void *, AInt)) w->r)(ca0, w->w, p, sz);
}

ASTATIC void AM_d(ACA, AM *w)
{
	((void (*)(AComArg *, void *)) w->d)(ca0, w->w);
}


////////////////////////////////////////////////////////////////

ASTATIC void ASP_deinit(ACA, ASP *w)
{
	aDbgActObj_chk(ca0, w, ASP_nam);
	if (w->p != 0)
		AMemAlc1_fre(ca0, w->ma1, w->p, w->s1);
	#if (ADBGLV >= 1)
		w->s1 = 0;
		w->p = 0;
		w->s = 0;
	#endif
	aDbgActObj_del(ca0, w, ASP_nam);
}

ASTATIC ASP *ASP_init(ACA, ASP *w, AInt s1, AClean *c)
{
	static void *deinit[1] = { ASP_deinit };
	if (w == 0)
		w = aMalloc(ca0, sizeof (ASP), c);
	AMemAlc1 *ma1 = ca0->na;
	w->ma1 = ma1;
	w->p = 0;
	w->s1 = 0;
	w->s = 0;
	if (s1 > 0) {
		AInt i = AMemAlc1_idx(s1);
		w->p = AMemAlc0_alc(ca0, &ma1->alc[i], 0, s1);
		w->s1 = 8 << i;
	}
	AClean_set(ca0, c, deinit, w);
	aDbgActObj_ins(ca0, w, ASP_nam, sizeof (ASP));
	return w;
}

ASTATIC void ASP_resize0(ACA, ASP *w, AInt s1)
// ̂߂ AMemAlc0_rsz Ă΂Ȃ.
{
	if (s1 > w->s1) {
		AInt i0 = -1;
		if (w->s1 > 0)
			i0 = AMemAlc1_idx(w->s1);
		AInt i1 = AMemAlc1_idx(s1);
		if (i0 < i1) {
			void *p = AMemAlc0_alc(ca0, &w->ma1->alc[i1], 0, s1);
			if (w->p != 0) {
				memcpy(p, w->p, w->s1);
				AMemAlc0_fre(ca0, &w->ma1->alc[i0], w->p);
			}
			w->p = p;
			w->s1 = 8 << i1;
		}
	}
}

ASTATIC void ASP_resize1(ACA, ASP *w, AInt s1)
{
	aDbgActObj_chk(ca0, w, ASP_nam);
	AInt i0 = -1;
	if (w->s1 > 0)
		i0 = AMemAlc1_idx(w->s1);
	if (s1 <= w->s1 && i0 >= 0)
		AMemAlc0_rsz(ca0, &w->ma1->alc[i0], w->p, s1);
	else {
		AInt i1 = AMemAlc1_idx(s1);
		if (i0 == i1)
			AMemAlc0_rsz(ca0, &w->ma1->alc[i0], w->p, s1);
		else
			ASP_resize0(ca0, w, s1);
	}
}

ASTATIC void ASP_addInt(ACA, ASP *w, AInt i)
{
	aDbgActObj_chk(ca0, w, ASP_nam);
	w->s += sizeof (AInt);
	ASP_resize(ca0, w, w->s);
	AInt *p = (AInt *) (w->p + w->s);
	p[-1] = i;
}

ASTATIC void ASP_addInt2(ACA, ASP *w, AInt i0, AInt i1)
{
	aDbgActObj_chk(ca0, w, ASP_nam);
	w->s += 2 * sizeof (AInt);
	ASP_resize(ca0, w, w->s);
	AInt *p = (AInt *) (w->p + w->s);
	p[-2] = i0;
	p[-1] = i1;
}

ASTATIC void ASP_addInt3(ACA, ASP *w, AInt i0, AInt i1, AInt i2)
{
	aDbgActObj_chk(ca0, w, ASP_nam);
	w->s += 3 * sizeof (AInt);
	ASP_resize(ca0, w, w->s);
	AInt *p = (AInt *) (w->p + w->s);
	p[-3] = i0;
	p[-2] = i1;
	p[-1] = i2;
}

ASTATIC void ASP_addInt4(ACA, ASP *w, AInt i0, AInt i1, AInt i2, AInt i3)
{
	aDbgActObj_chk(ca0, w, ASP_nam);
	w->s += 4 * sizeof (AInt);
	ASP_resize(ca0, w, w->s);
	AInt *p = (AInt *) (w->p + w->s);
	p[-4] = i0;
	p[-3] = i1;
	p[-2] = i2;
	p[-1] = i3;
}

////////////////////////////////////////////////////////////////

#if (!defined(ANOUSE_CLEAN))

ASTATIC void AClean_set(ACA, AClean *w, void *f, void *p)
{
	if (w == 0) return;
	aDbgActObj_chk(ca0, w, AClean_nam);
	#if (ADBGLV >= 1)
		if (w->sp.s < 0)
			aErrExit("AClean_set: AClean is not inited");
	#endif
	void **d = (void **) (w->sp.p + w->sp.s);
	if (w->sp.s > 0 && (((AInt) d[-1]) & 1) != 0 && d[-2] == f) {
		w->sp.s += sizeof (void *);
		ASP_resize(ca0, &w->sp, w->sp.s);
		d = (void **) (w->sp.p + w->sp.s);
		d[-1] = d[-2] + 8;
		d[-2] = f;
		d[-3] = p;
	} else {
		w->sp.s += 2 * sizeof (void *);
		ASP_resize(ca0, &w->sp, w->sp.s);
		d = (void **) (w->sp.p + w->sp.s);
		d[-1] = p;
		d[-2] = f;
#if 1
		if (w->sp.s > 2 * aSizeof (void *) && (((AInt) d[-3]) & 1) == 0 && d[-4] == f) {
			d[-4] = d[-3];
			d[-3] = p;
			d[-2] = f;
			d[-1] = (void *) (AInt) 17;
		}
#endif
	}
}

ASTATIC void AClean_out0(ACA, AClean *w, char f)
{
	void (*fn)(AComArg *, void *, void *, char);
	void **fw;
	aDbgActObj_chk(ca0, w, AClean_nam);
	#if (ADBGLV >= 1)
		if (w->ch != 0) {
			if (f == 0)
				aErrExit("AClean_out0: child is not clean");
			AClean_out0(ca0, w->ch, f);
		}
	#endif
	void **d = (void **) (w->sp.p + w->sp.s), **d0 = (void **) w->sp.p;
	for (; d > d0;) {
		if ((((AInt) d[-1]) & 1) == 0) {
			fw = d[-2];
			if (fw != 0 && d[-1] != 0) {
				fn = *fw;
				fn(ca0, d[-1], fw, f);
			}
			d -= 2;
		} else {
			AInt i = ((AInt) d[-1]) >> 3;
			fw = d[-2];
			d -= 2;
			for (; i > 0; i--) {
				if (fw != 0 && d[-1] != 0) {
					fn = *fw;
					fn(ca0, d[-1], fw, f);
				}
				d--;
			}
		}
	}
	ASP_deinit(ca0, &w->sp);
	#if (ADBGLV >= 1)
		w->sp.s = -1;
	#endif
	if (w->pr != 0 && w->pr->ch == w)
		w->pr->ch = 0;
	aDbgActObj_del(ca0, w, AClean_nam);
}

ASTATIC void AClean_unlink(ACA, AClean *w)
{
	aDbgActObj_chk(ca0, w, AClean_nam);
	w->lnk--;
	if (w->lnk == 0)
		AClean_out0(ca0, w, 0);
}

ASTATIC void AClean_link(ACA, AClean *w, AClean *p)
{
	static void *cUnlink[1] = { AClean_unlink };
	aDbgActObj_chk(ca0, w, AClean_nam);
	w->lnk++;
	AClean_set(ca0, p, cUnlink, w);
}

ASTATIC void AClean_deinit(ACA, AClean *w, void *dmy, char f)
{
	(void) dmy;
	#if (ADBGLV >= 1)
		if (f == 0 && w->sp.s >= 0)
			aErrExit("AClean_deinit0: no-clean_out error  sz=%d", w->sp.s);
	#endif
	if (f != 0)
		AClean_out0(ca0, w, 1);
}

ASTATIC AClean *AClean_init(ACA, AClean *w, AClean *p)
// nł͂Ȃq(JɗȂ).
{
	static void *cDeinit[1] = { AClean_deinit };
	if (w == 0)
		w = AMemAlc1_alc(ca0, ca0->na, sizeof (AClean), p);
	ASP_init(ca0, &w->sp, 0, 0);
	w->pr = p;
	w->ch = 0;
	w->lnk = 0;
	w->ext = 0;
//	#if (ADBGLV >= 1)
		AClean_set(ca0, p, cDeinit, w);	// G[op({͒nȊO̎qǂ𒼐ڎׂł͂Ȃ).
		// AIȎĴȂAdeinitł͂ȂāAouto^ׂ.
//	#endif
	// ADBGLVɂăC̃ʂς̂Ȃ̂ŁARpC߂.
	aDbgActObj_ins(ca0, w, AClean_nam, sizeof (AClean));
	return w;
}

ASTATIC void AClean_out(ACA, AClean *w)
{
	AClean_out0(ca0, w, 0);
}

ASTATIC void AClean_force(ACA, AClean *w)
{
	AClean_out0(ca0, w, 1);
}

ASTATIC AClean *AClean_begin(AComArg *ca1, AClean *c1, ACA)
// n̎q.
{
	AClean *c0 = ca0->tc;
	#if (ADBGLV >= 1)
		if (c0->ch != 0)
			aErrExit("AClean_begin: child already exists.");
	#endif
	if (c1 == 0)
		c1 = aMalloc(ca0, sizeof (AClean), c0);
	ASP_init(ca0, &c1->sp, 0, 0);
	c1->pr = c0;
	c1->lnk = 0;
	c1->ext = c0->ext;
	c1->ch = 0;
	c0->ch = c1;
	*ca1 = *ca0;
	ca1->tc = c1;
	aDbgActObj_ins(ca0, c1, AClean_nam, sizeof (AClean));
	return c1;
}

#define ABegin(ca1, c1, ca0)	AComArg ca1[1]; AClean c1[1]; AClean_begin(ca1, c1, ca0);

#else

ASTATIC void AClean_set(ACA, AClean *w, void *f, void *p) { (void) ca0; (void) w; (void) f; (void) p; }
ASTATIC void AClean_unlink(ACA, AClean *w) { (void) ca0; (void) w; aErrExit("AClean_unlink: ANOUSE_CLEAN"); }
ASTATIC void AClean_link(ACA, AClean *w, AClean *p) { (void) ca0; (void) w; (void) p; }
ASTATIC void AClean_deinit(ACA, AClean *w, void *dmy, char f) { (void) ca0; (void) w; (void) dmy; (void) f; }
ASTATIC AClean *AClean_init(ACA, AClean *w, AClean *p) { (void) ca0; (void) w; (void) p; return w; }
ASTATIC void AClean_out(ACA, AClean *w){ (void) ca0; (void) w; aErrExit("AClean_out: ANOUSE_CLEAN"); }
ASTATIC void AClean_force(ACA, AClean *w) { (void) ca0; (void) w; aErrExit("AClean_force: ANOUSE_CLEAN"); }
ASTATIC AClean *AClean_begin(AComArg *ca1, AClean *c1, ACA) { (void) ca1; (void) ca0; return c1; }

#endif

////////////////////////////////////////////////////////////////

typedef struct AActObjSub_ {
	ASP sp;
	AInt objSz;
	const char *nam;
} AActObjSub;

// TCYꍇAɒ`̂ʂƂ݂Ȃ.
// TCYĂɒ`̂ʂƂ݂Ȃ.

ASTATIC void AActObj_deinit(ACA, AActObj *w)
{
	aDbgActObj_chk(ca0, w, AActObj_nam);
	AInt i;
	AActObjSub *sb;
	for (i = 0; i < w->sp.s; i += sizeof (AActObjSub *)) {
		sb = *((AActObjSub **) (w->sp.p + i));
		ASP_deinit(ca0, &sb->sp);
	}
	ASP_deinit(ca0, &w->sp);
	aDbgActObj_del(ca0, w, AActObj_nam);
}

ASTATIC AActObj *AActObj_init(ACA, AActObj *w, char dbg, AClean *c)
{
	static void *cDeinit[1] = { AActObj_deinit };
	if (w == 0)
		w = AMemAlc1_alc(ca0, ca0->na, sizeof (AActObj), c);
	AClean_set(ca0, c, cDeinit, w);
	ASP_init(ca0, &w->sp, 0, 0);
//	w->sp.ma1 = ma1;
	ASP_init(ca0, &w->noChk, 0, 0);
//	w->noChk.ma1 = ma1;
	w->dbg = dbg;
	aDbgActObj_ins(ca0, w, AActObj_nam, sizeof (AActObj));
	return w;
}

ASTATIC AInt AActObj_noChk(ACA, AActObj *w, void *p)
{
	(void) ca0;
	AInt i;
	char *pp = p;
	for (i = 0; i < w->noChk.s; i += 2 * sizeof (AInt)) {
		char *q  = *((char **) (w->noChk.p + i));
		char *q1 = q + *((AInt *) (w->noChk.p + i + sizeof (AInt)));
		if (q <= pp && pp < q1) return 1;
	}
	return 0;
}

ASTATIC AInt AActObj_getClsId(ACA, AActObj *w, const char *nam, AInt sz)
{
	AInt i;
	AActObjSub *sb;
	aDbgActObj_chk(ca0, w, AActObj_nam);
	for (i = 0; i < w->sp.s; i += sizeof (AActObjSub *)) {
		sb = *((AActObjSub **) (w->sp.p + i));
		if (sb->nam == nam) goto fin;
	}
	sb = AMemAlc1_alc(ca0, w->sp.ma1, sizeof (AActObjSub), 0);
	ASP_addInt(ca0, &w->sp, (AInt) sb);
	if (w->dbg != 0)
		ASP_addInt2(ca0, &w->noChk, (AInt) sb, sizeof (AActObjSub)); // ɂĂ͎noChk֒ǉ.
	ASP_init(ca0, &sb->sp, 0, 0);
	sb->sp.ma1 = w->sp.ma1;
	sb->objSz = sz;
	sb->nam = nam;
fin:
	return i / sizeof (AActObjSub *);
}

ASTATIC void AActObj_ins(ACA, AActObj *w, void *p, const char *nam, AInt sz)
{
	if (AActObj_noChk(ca0, w, p) != 0) return;
	aDbgActObj_chk(ca0, w, AActObj_nam);
	AInt i = AActObj_getClsId(ca0, w, nam, sz);
	AActObjSub *sb = ((AActObjSub **) w->sp.p)[i];
	#if (ADGBLV >= 2)
		AInt j;
		for (j = 0; j < sb->sp.s; j += sizeof (void *)) {
			if (p == *((void **) (sb->sp.p + j)))
				aErrExit("AActObj_ins: already exits");
		}
	#endif
	ASP_addInt(ca0, &sb->sp, (AInt) p);
}

ASTATIC void AActObj_del(ACA, AActObj *w, void *p, const char *nam)
{
	if (AActObj_noChk(ca0, w, p) != 0) return;
	aDbgActObj_chk(ca0, w, AActObj_nam);
	AInt i = AActObj_getClsId(ca0, w, nam, 0);
	AActObjSub *sb = ((AActObjSub **) w->sp.p)[i];
	AInt j;
	for (j = 0; j < sb->sp.s; j += sizeof (void *)) {
		if (p == *((void **) (sb->sp.p + j))) goto skip;
	}
	#if (ADBGLV >= 1)
		aErrExit("AActObj_del: not found");
	#endif
skip:
	sb->sp.s -= sizeof (void *);
	*((void **) (sb->sp.p + j)) = *((void **) (sb->sp.p + sb->sp.s));
	ASP_resize(ca0, &sb->sp, sb->sp.s);
}

ASTATIC AInt AActObj_chk(ACA, AActObj *w, void *p, const char *nam)
{
	if (AActObj_noChk(ca0, w, p) != 0) return 0;
	aDbgActObj_chk(ca0, w, AActObj_nam);
	AInt i = AActObj_getClsId(ca0, w, nam, 0);
	AActObjSub *sb = ((AActObjSub **) w->sp.p)[i];
	AInt j;
	for (j = 0; j < sb->sp.s; j += sizeof (void *)) {
		if (p == *((void **) (sb->sp.p + j))) return 0;
	}
	return 1;
}

ASTATIC int AActObj_cmp(const void *a, const void *b)
{
	AInt *aa = (AInt *) a, *bb = (AInt *) b;
	if (aa[0] < bb[0]) return -1;
	if (aa[0] > bb[0]) return +1;
	if (aa[1] < bb[1]) return +1;
	return -1;
}

ASTATIC void AActObj_dmp(ACA, AActObj *w, char mod)
{
	AInt i, j, k, n = 0;
	AActObjSub *sb;
	aDbgActObj_chk(ca0, w, AActObj_nam);
	for (i = 0; i < w->sp.s; i += sizeof (AActObjSub *)) {
		sb = *((AActObjSub **) (w->sp.p + i));
		n += sb->sp.s;
	}
	n /= sizeof (void *);
	void **p = AMemAlc1_alc(ca0, ca0->ta, n * 2 * sizeof (void *), 0);
	k = 0;
	for (i = 0; i < w->sp.s; i += sizeof (AActObjSub *)) {
		sb = *((AActObjSub **) (w->sp.p + i));
		for (j = 0; j < sb->sp.s; j += sizeof (void *)) {
			p[k + 0] = *((void **) (sb->sp.p + j));
			p[k + 1] = (void *) i;
			k += 2;
		}
	}
	qsort(p, n, 2 * sizeof (void *), AActObj_cmp);
	if (mod == 1) {
		for (k = 0; k < n * 2; k += 2) {
			sb = *((AActObjSub **) (w->sp.p + (AInt) p[k + 1]));
			printf("0x%08x: %s\n", (int) (AInt) p[k + 0], sb->nam);
		}
	} else {
		char *cp = 0;
		for (k = 0; k < n * 2; k += 2) {
			if (cp <= (char *) p[k + 0]) {
				sb = *((AActObjSub **) (w->sp.p + (AInt) p[k + 1]));
				printf("0x%08x: %s\n", (int) (AInt) p[k + 0], sb->nam);
				cp = p[k + 0];
				cp += sb->objSz;
			}
		}
	}
	AMemAlc1_fre(ca0, ca0->ta, p, n * 2 * sizeof (char *));
}

ASTATIC void aDbgActObj_ins0(ACA, void *p, const char *nam, AInt sz)
{
	if (ca0 != 0 && ca0->dbg != 0 && ca0->dbg->act != 0)
		AActObj_ins(ca0->d, ca0->dbg->act, p, nam, sz);
}

ASTATIC void aDbgActObj_chk0(ACA, void *p, const char *nam)
{
	if (ca0 != 0 && ca0->dbg != 0 && ca0->dbg->act != 0) {
		if (AActObj_chk(ca0->d, ca0->dbg->act, p, nam) != 0)
			aErrExit("aDbgActObj_chk: invalid obj: %s: p=0x%x\n", nam, (int) (AInt) p);
	}
}

ASTATIC void aDbgActObj_del0(ACA, void *p, const char *nam)
{
	if (ca0 != 0 && ca0->dbg != 0 && ca0->dbg->act != 0)
		AActObj_del(ca0->d, ca0->dbg->act, p, nam);
}

ASTATIC void aDbgActObj_dmp0(ACA, char mod)
{
	if (ca0->dbg != 0 && ca0->dbg->act != 0)
		AActObj_dmp(ca0->d, ca0->dbg->act, mod);
}

ASTATIC void aDbgActObj_noChk0(ACA, void *p, AInt sz)
{
	if (ca0 != 0 && ca0->dbg != 0 && ca0->dbg->act != 0)
		ASP_addInt2(ca0->d, &ca0->dbg->act->noChk, (AInt) p, sz);
}

////////////////

ASTATIC void AMemAlc0_deinitDbg(ACA, AMemAlc0 *w)
{
	ASP_deinit(ca0, &w->dbg->sp);
}

ASTATIC void AMemAlc0_initDbg(ACA, AMemAlc0 *w, AMemAlc0_Dbg *d, AClean *c)
{
	static void *deinit[1] = { AMemAlc0_deinitDbg };
	if (d == 0)
		d = AMemAlc1_alc(ca0->d, ca0->d->na, sizeof (AMemAlc0_Dbg), c);
	aDbgActObj_noChk(ca0, d, sizeof (AMemAlc0_Dbg));
	ASP_init(ca0->d, &d->sp, 0, 0);
	w->dbg = d;
	AClean_set(ca0, c, deinit, w);
}
