#if (!defined(ANOUSE_XORSHIFT32))

static AUInt32 aXorShift32_i = 2463534242U;

ASTATIC void aXorShift32_seed(AUInt32 s)
{
	aXorShift32_i = 2463534242U ^ s;
}

ASTATIC AUInt32 aXorShift32()
{
	AUInt32 i = aXorShift32_i;
	i = i ^ (i << 13);
	i = i ^ (i >> 17);
	i = i ^ (i <<  5);
	aXorShift32_i = i;
	return i;
}

#endif

AInt aRepC;
#define ARep(n) for (aRepC = 0; aRepC < n; aRepC++)
#define ARep0(n, i)	for (i = 0; i < n; i++)

ASTATIC AInt aRnd(AInt32 n)
{
	return aXorShift32() % n;
}

ASTATIC void aArySetInt(AInt *a, AInt i0, AInt i1, AInt v)
{
	for (; i0 < i1; i0++)
		a[i0] = v;
}

ASTATIC void aAryMovInt(AInt *a, AInt i1, AInt i0, AInt n)
{
	AInt i;
	if (i1 < i0) {
		for (i = 0; i < n; i++)
			a[i1 + i] = a[i0 + i];
	} else if (i0 < i1) {
		for (i = n - 1; i >= 0; i--)
			a[i1 + i] = a[i0 + i];
	}
}

ASTATIC AInt aMaxInt(AInt i0, AInt i1)
{
	if (i0 <= i1) return i1;
	return i0;
}

ASTATIC AInt aMinInt(AInt i0, AInt i1)
{
	if (i0 >= i1) return i1;
	return i0;
}

ASTATIC AInt aUppercase(AInt i)
{
	if ('a' <= i && i <= 'z') i -= 32;
	return i;
}

ASTATIC AInt aLowercase(AInt i)
{
	if ('A' <= i && i <= 'Z') i += 32;
	return i;
}

ASTATIC AInt aArgMaxRndInt(ACA, AInt *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	char *b = aMalloc(ca0, i1 - i0, 0);
	AInt max = a[i0], i, i00 = i0, s = 0;
	memset(b, 0, i1 - i0);
	for (i = i0; i < i1; i++) {
		if (max < a[i]) {
			max = a[i];
			i00 = i;
		}
		b[i - i0] = (a[i] == max);
	}
	for (i = i00; i < i1; i++)
		s += b[i - i0];
	s = aRnd(s);
	for (i = i00; i < i1; i++) {
		if (b[i - i0] == 0) continue;
		if (s == 0) break;
		s--;
	}
	aFree(ca0, b, i1 - i0);
	return i;
}

AINLINESTATIC AInt aMul64Shr(AInt i, AInt j, AInt k)
{
	return ((long long) i) * ((long long) j) >> k;
}

AINLINESTATIC void aPrintTime()
{
	printf("time: %.3f[sec]\n", clock() / (double) CLOCKS_PER_SEC);
}

AINLINESTATIC AInt aFf16Sin(AInt x)
{
	return (AInt) (sin(x * (2 * 3.14159265358979323 / 65536)) * 65536);
}

AINLINESTATIC AInt aFf16Cos(AInt x)
{
	return (AInt) (cos(x * (2 * 3.14159265358979323 / 65536)) * 65536);
}

