#include <windows.h>

ASTATIC AInt8 aAutoQuit = -1;
ASTATIC AInt32 aWait_exitCode = 0;

typedef struct AWindow_ {
	char title[64];
	AInt16 xsiz, ysiz;
	AInt32a *buf;
	int table_i;
	#if (AKEYBUFSIZ > 0)
		AInt32a keybuf[AKEYBUFSIZ];
		AInt kbw, kbr;
		AInt32 inkeyPrm[4];
	#endif
	#if (!defined(ANOUSE_LEAPFLUSH))
		AInt32 lastFlush;
	#endif
	AInt8 phase, mode, autoClose, reqClose, keyLv, mosLv;

	AInt16 cbxs, cbys, savXy[2 * 16];
	AInt32a *cb, *savBuf;
	AInt32 pal[16];
	AInt8 optDef;

	HWND win;
	HINSTANCE hInst;
	BITMAPINFO bmi;
} AWindow;

HWND aWinTable_h[AMAXWINDOWS];
AWindow *aWinTable_w[AMAXWINDOWS + 1];

ASTATIC void aInitWin0(ACA, AWindow *w, int xsiz, int ysiz, const char *title, int autoClose);

#if (defined(ADEBUG) || ADBGLV >= 1)

ASTATIC void aDbg_testWin(AWindow *w, const char *msg);

#else

#define	aDbg_testWin(w, msg)

#endif

ASTATIC void aWait0(AInt32 msec);	// IɌĂяoȂ΂Ȃ.

static LRESULT CALLBACK aWndProc(HWND hw, unsigned int msg, WPARAM wp, LPARAM lp);

static int aWinthread(AWindow *w)
{
	WNDCLASSEX wc;
	RECT r;
	int i, x, y;
	MSG msg;

	x = w->xsiz;
	y = w->ysiz;

	wc.cbSize = sizeof (WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = aWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = w->hInst;
	wc.hIcon = (HICON) LoadImage(NULL, MAKEINTRESOURCE(IDI_APPLICATION),
		IMAGE_ICON, 0, 0, LR_DEFAULTSIZE | LR_SHARED);
	wc.hIconSm = wc.hIcon;
	wc.hCursor = (HCURSOR)LoadImage(NULL, MAKEINTRESOURCE(IDC_ARROW),
		IMAGE_CURSOR, 0, 0, LR_DEFAULTSIZE | LR_SHARED);
	wc.hbrBackground = (HBRUSH) COLOR_APPWORKSPACE;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = w->title;
	if (RegisterClassEx(&wc) == 0)
		return 1;
	r.left = 0;
	r.top = 0;
	r.right = x;
	r.bottom = y;
	AdjustWindowRect(&r, WS_OVERLAPPEDWINDOW, FALSE);
	x = r.right - r.left;
	y = r.bottom - r.top;

	w->win = CreateWindowA(wc.lpszClassName, w->title, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, x, y, NULL, NULL,	w->hInst, NULL);
	if (w->win == NULL)
		return 1;
	aWinTable_h[w->table_i] = w->win;
	ShowWindow(w->win, SW_SHOW);
	UpdateWindow(w->win);

	for (;;) {
		i = GetMessage(&msg, NULL, 0, 0);
		if (i == 0 || i == -1)	/* G[͏IbZ[W */
			break;
		/* ̂ق͂Ƃ肠ftHg */
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	// ̃^C~OfreeĂ͂Ȃ.
	UnregisterClass(w->title, w->hInst);
	w->phase = 2;
	return 0;
}

ASTATIC void aWait0(AInt32 msec);	// IɌĂяoȂ΂Ȃ.

ASTATIC AWindow *aOpenWin(ACA, AInt16 x, AInt16 y, const char *t, AInt8 autoClose)
{
	if (aAutoQuit == -1)
		aAutoQuit = 1;
	AWindow *w = aMalloc(ca0->s, aSizeof (AWindow), 0);
	aInitWin0(ca0, w, x, y, t, autoClose);
	w->bmi.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
	w->bmi.bmiHeader.biWidth = x;
	w->bmi.bmiHeader.biHeight = - y;
	w->bmi.bmiHeader.biPlanes = 1;
	w->bmi.bmiHeader.biBitCount = 32;
	w->bmi.bmiHeader.biCompression = BI_RGB;
	int i;
	CreateThread(NULL, 0, (void *) &aWinthread, (void *) w, 0, (void *) &i);
	aWinTable_h[w->table_i] = w->win;
	aWait0(100);
	return w;
}

ASTATIC void aFlushAll0(AWindow *w)
{
	aDbg_testWin(w, "aFlushAll0");
	if (w->phase <= 1 && w->win != 0) {
		InvalidateRect(w->win, NULL, FALSE);
		UpdateWindow(w->win);
	}
	#if (!defined(ANOUSE_LEAPFLUSH))
		if (CLOCKS_PER_SEC != 1000)
			w->lastFlush = clock() * 1000 / CLOCKS_PER_SEC;
		else
			w->lastFlush = clock();
	#endif
}

ASTATIC void aFlushAll(AWindow *w)
{
	aWait0(0);
	if (w != 0 && w->win != 0) {
		aFlushAll0(w);
	} else {
		int i;
		for (i = 0; i < AMAXWINDOWS; i++) {
			if (aWinTable_w[i] != 0 && aWinTable_h[i] != 0)
				aFlushAll0(aWinTable_w[i]);
		}
	}
}

#if (!defined(ANOUSE_LEAPFLUSH))

ASTATIC void aLeapFlushAll0(AWindow *w, AInt32 ms)
{
	AInt32 t;
	if (CLOCKS_PER_SEC != 1000)
		t = clock() * 1000 / CLOCKS_PER_SEC;
	else
		t = clock();
	if (t - w->lastFlush >= ms) {
		aWait0(0);
		aFlushAll0(w);
	}
}

ASTATIC void aLeapFlushAll(AWindow *w, AInt32 ms)
{
	if (w != 0 && w->win != 0) {
		aLeapFlushAll0(w, ms);
	} else {
		int i;
		for (i = 0; i < AMAXWINDOWS; i++) {
			if (aWinTable_w[i] != 0 && aWinTable_h[i] != 0)
				aLeapFlushAll0(aWinTable_w[i], ms);
		}
	}
}

#endif

ASTATIC void aPutKeybuf(AWindow *w, AInt32 c);
ASTATIC AInt aGetSpcKeybuf(AWindow *w);

ASTATIC AWindow *aGetWinFromWId(HWND hw)
{
	int j;
	for (j = 0; j < AMAXWINDOWS; j++) {
		if (aWinTable_h[j] == hw)
			break;
	}
	if (j >= AMAXWINDOWS)
		return 0;
	return aWinTable_w[j];
}

static LRESULT CALLBACK aWndProc(HWND hw, unsigned int msg, WPARAM wp, LPARAM lp)
{
	AWindow *w = aGetWinFromWId(hw);
//	int i, j;
//	int i;
	if (w == 0)
		return DefWindowProc(hw, msg, wp, lp);
	if (msg == WM_PAINT) {
		PAINTSTRUCT ps;
		HDC hdc = BeginPaint(hw, &ps);
		SetDIBitsToDevice(hdc, 0, 0, w->xsiz, w->ysiz,
			0, 0, 0, w->ysiz, w->buf, &w->bmi, DIB_RGB_COLORS);
		EndPaint(hw, &ps);
		return 0;
	}
	if (msg == WM_DESTROY) {
		PostQuitMessage(0); // ȂƃXbhIȂ.
		return 0;
	}
#if (AKEYBUFSIZ > 0)
#if (!defined(ANOUSE_KEY))
	if (msg == WM_KEYDOWN || msg == WM_SYSKEYDOWN) {
		int i = -1;
		if (wp == VK_RETURN)	i = AKEY_ENTER;
		if (wp == VK_ESCAPE)	i = AKEY_ESC;
		if (wp == VK_BACK)		i = AKEY_BACKSPACE;
		if (wp == VK_TAB)		i = AKEY_TAB;
		if (wp == VK_PRIOR)		i = AKEY_PAGEUP;
		if (wp == VK_NEXT)		i = AKEY_PAGEDWN;
		if (wp == VK_END)		i = AKEY_END;
		if (wp == VK_HOME)		i = AKEY_HOME;
		if (wp == VK_LEFT)		i = AKEY_LEFT;
		if (wp == VK_RIGHT)		i = AKEY_RIGHT;
		if (wp == VK_UP)		i = AKEY_UP;
		if (wp == VK_DOWN)		i = AKEY_DOWN;
		if (wp == VK_INSERT)	i = AKEY_INS;
		if (wp == VK_DELETE)	i = AKEY_DEL;
//		j = getKeyState1();
//		if (j != 0 && ' ' <= wp && wp <= 0x7e)
//			i = wp;	// CtrlAltƉĂꍇ́Aput.
//		i |= getKeyState0();
//		if ((w->keyMode & 0xf0) >= bla_MOUSE_LV1)
//			i |= getMouseState0();
		if (i != -1) {
			if (w->keyLv >= 1)
				aPutKeybuf(w, i /* | j */);
			return 0;
		}
	}
	if (msg == WM_CHAR) {
		if (' ' <= wp && wp <= 0x7e) {
	//		i = wp | getKeyState0();
			int i = wp;
	//		j = getKeyState1();
	//		if ((w->keyMode & 0xf0) >= bla_MOUSE_LV1)
	//			i |= getMouseState0();
			if (w->keyLv >= 1)
				aPutKeybuf(w, i /* | j */);
			return 0;
		}
	}
#endif
#if (!defined(ANOUSE_MOUSE))
	if (msg == WM_LBUTTONDOWN || msg == WM_RBUTTONDOWN || msg == WM_MBUTTONDOWN) {
		if (w->mosLv >= 1 && aGetSpcKeybuf(w) >= 2) {
			int i = -1;
			if (msg == WM_LBUTTONDOWN) i = 0;
			if (msg == WM_RBUTTONDOWN) i = 1;
			if (msg == WM_MBUTTONDOWN) i = 2;
			if (i >= 0) {
				aPutKeybuf(w, 0x4000 | i);
				aPutKeybuf(w, (LOWORD(lp) & 0xffff) | (HIWORD(lp) & 0xffff) << 16);
			}
		}
	}
#endif
#endif
	return DefWindowProc(hw, msg, wp, lp);
}

ASTATIC int aAliveWindows();

ASTATIC void aWait0(AInt32 msec)
{
	do {
		if (msec < 0)
			Sleep(64);
		if (msec > 0) {
			if (msec >= 64) {
				Sleep(64);
				msec -= 64;
			} else {
				Sleep(msec);
				msec = 0;
			}
		}
		if (aAutoQuit > 0 && aAliveWindows() == 0)
			aExitInt(aWait_exitCode);
	} while (msec != 0);
}

