//////////////////////////////////////////////////////////////// ASP0

typedef struct ASP0_ {	// size and pointer, simple.
	AInt s, s1;
	char *p;
} ASP0;

ASTATIC ASP0 *ASP0_init(ASP0 *w, AInt s1)
{
	if (w == 0)
		w = aMalloc(sizeof (ASP0));
	w->p = aMalloc(s1);
	w->s = 0;
	w->s1 = s1;
	return w;
}

ASTATIC ASP0 *ASP0_deinit(ASP0 *w)
{
	if (w->p != 0)
		aFree(w->p, w->s1);
	w->s1 = 0;
	w->p = 0;
	return w;
}

ASTATIC ASP0 *ASP0_resize(ASP0 *w, AInt s1)
{
	if (s1 > w->s1 && w->p != 0) {
		AInt s0 = w->s1;
		do {
			w->s1 *= 2;
		} while (s1 > w->s1);
		w->p = aRealloc(w->p, w->s1, s0);
	}
	return w;
}

ASTATIC ASP0 *ASP0_addInt1(ASP0 *w, AInt i0)
{
	ASP0_resize(w, w->s + sizeof (AInt));
	AInt *p = (AInt *) (w->p + w->s);
	p[0] = i0;
	w->s += sizeof (AInt);
	return w;
}

ASTATIC ASP0 *ASP0_addInt2(ASP0 *w, AInt i0, AInt i1)
{
	ASP0_resize(w, w->s + 2 * sizeof (AInt));
	AInt *p = (AInt *) (w->p + w->s);
	p[0] = i0;
	p[1] = i1;
	w->s += 2 * sizeof (AInt);
	return w;
}

ASTATIC ASP0 *ASP0_addInt3(ASP0 *w, AInt i0, AInt i1, AInt i2)
{
	ASP0_resize(w, w->s + 3 * sizeof (AInt));
	AInt *p = (AInt *) (w->p + w->s);
	p[0] = i0;
	p[1] = i1;
	p[2] = i2;
	w->s += 3 * sizeof (AInt);
	return w;
}

ASTATIC ASP0 *ASP0_addInt4(ASP0 *w, AInt i0, AInt i1, AInt i2, AInt i3)
{
	ASP0_resize(w, w->s + 4 * sizeof (AInt));
	AInt *p = (AInt *) (w->p + w->s);
	p[0] = i0;
	p[1] = i1;
	p[2] = i2;
	p[3] = i3;
	w->s += 4 * sizeof (AInt);
	return w;
}

ASTATIC ASP0 *ASP0_loadFile(ASP0 *w, const char *path, AInt ms)
{
	AInt i;
	if (w == 0)
		w = aMalloc(sizeof (ASP0));
	w->p = 0;
	FILE *fp = fopen(path, "rb");
	if (fp == 0) goto ret;
	ASP0_init(w, 64 * 1024);
	for (;;) {
		i = fread(w->p + w->s, 1, w->s1 - w->s, fp);
		if (i <= 0) break;
		w->s += i;
		if (w->s >= w->s1)
			ASP0_resize(w, w->s1 + 1);
	}
	fclose(fp);
	if (ms > 0) {
		ASP0_resize(w, w->s + ms);
		memset(w->p + w->s, 0, ms);
	}
ret:
	return w;
}

ASTATIC ASP0 *ASP0_addStr0(ASP0 *w, const char *s, AInt l)
{
	ASP0_resize(w, w->s + l);
	memcpy(w->p + w->s, s, l);
	w->s += l;
	return w;
}

ASTATIC ASP0 *ASP0_addStr(ASP0 *w, const char *s)
{
	return ASP0_addStr0(w, s, strlen(s));
}

//////////////////////////////////////////////////////////////// AEs

typedef struct AEs_ {
	ASP0 ic, vr, misc;
	AInt aId;
	unsigned char *jq0, *jq1, modeOpt;
		// ɒ[ȃTCYD
		// TCYD
		// xD
} AEs;

enum { AEs_AlcNul, AEs_AlcMem, AEs_AlcReg, AEs_AlcConst };
enum { AEs_TypNul, AEs_TypInt, AEs_TypPtr, AEs_TypLabel, AEs_TypFlt };

typedef struct AEs_VirReg_ {
	AUInt8 alc0, alc1, typ0;
	AInt namLen, typ1;
	AInt64 alc2;
	const char *nam;

//	AInt avl, typ0, typ1, alc[5], namLen;
//	AInt8 alc0;
	// [typ0] 1:label, 2:AInt
	// typ1typ0ʂȒl̎.
	// label̂ƂAalc[0]ic̉oCgڂȂ̂\B
	// 		alc[1]x864̉ԖڂȂ̂\B
} AEs_VirReg;

ASTATIC AEs *AEs_init(AEs *w)
{
	if (w == 0)
		w = aMalloc(sizeof (AEs));
	ASP0_init(&w->ic, 256 * sizeof (AInt));
	ASP0_init(&w->vr, 16 * sizeof (AEs_VirReg));
	ASP0_init(&w->misc, 256 * sizeof (AInt));
	w->vr.s = 4 * sizeof (AEs_VirReg);
	w->aId = 0x40000000;
	w->jq0 = 0;
	return w;
}

AINLINESTATIC AEs *AEs_setIcMrgn(AEs *w, AInt n)
{
	if (w->ic.s > w->ic.s1)
		aErrExit("AEs_setIcMrgn: buffer overrun: s=%d, s1=%d", w->ic.s, w->ic.s1);
	ASP0_resize(&w->ic, w->ic.s + n * sizeof (AInt));
	return w;
}

AINLINESTATIC AEs *AEs_putIcP4(AEs *w, AInt op, AInt p0, AInt p1, AInt p2, AInt p3)
{
	AInt *p = (AInt *) (w->ic.p + w->ic.s);
	p[0] = op;
	p[1] = p0;
	p[2] = p1;
	p[3] = p2;
	p[4] = p3;
    w->ic.s += 5 * sizeof (AInt);
	return w;
}

AINLINESTATIC AEs *AEs_putIcP2(AEs *w, AInt op, AInt p0, AInt p1)
{
	return AEs_putIcP4(w, op, p0, p1, 0, 0);
}

AINLINESTATIC AEs *AEs_putIcP3(AEs *w, AInt op, AInt p0, AInt p1, AInt p2)
{
	return AEs_putIcP4(w, op, p0, p1, p2, 0);
}

enum { AEs_Op0, AEs_Op1, AEs_OpVoid, AEs_OpSetCc, AEs_OpCpy, AEs_OpNeg, AEs_OpArySet, AEs_OpAryGet,
	AEs_OpCmpEq, AEs_OpCmpNe, AEs_OpCmpLt, AEs_OpCmpGe, AEs_OpCmpLe, AEs_OpCmpGt, AEs_OpCmpRnz, AEs_OpCmpRtEqM1,
	AEs_OpAdd, AEs_OpSub, AEs_OpMul, AEs_OpDiv, AEs_OpMod, AEs_OpAnd, AEs_OpXor, AEs_OpOr, AEs_OpShl, AEs_OpShr, AEs_OpM64s
};

enum { AEs_Op0Nop, AEs_Op0DefLb, AEs_Op0Jmp, AEs_Op0Jcc, AEs_Op0Ent, AEs_Op0Ret, AEs_Op0SysFn, AEs_Op0SysFnP };

// [AEs_Op0SysFn] 0, n, 2:op, 3:retVr, 4:sub, 5:prmNum, 6:...

//////////////////////////////////////////////////////////////// AEs_VirReg

ASTATIC AInt AEs_newVr(ASP0 *vr)
{
	AInt i = vr->s / sizeof (AEs_VirReg);
	ASP0_resize(vr, vr->s + sizeof (AEs_VirReg));
	vr->s += sizeof (AEs_VirReg);
	return i;
}

ASTATIC AEs_VirReg *AEs_getVr(ASP0 *vr, AInt i)
{
	AEs_VirReg *vr0 = (AEs_VirReg *) vr->p;
	return vr0 + i;
}

ASTATIC AInt AEs_VirReg_isConstInt(AEs_VirReg *vr, AInt i)
{
	AInt rv = 0;
	if (vr->alc0 == AEs_AlcConst && vr->alc2 == i)
		rv = -1;
	return rv;
}

AINLINESTATIC AInt AEs_VirReg_isConstInt0(AEs_VirReg *vr)
{
	AInt rv = 0;
	if (vr->alc0 == AEs_AlcConst)
		rv = -1;
	return rv;
}

AINLINESTATIC AInt AEs_VirReg_getConstInt(AEs_VirReg *vr)
{
	return vr->alc2;
}

AINLINESTATIC void AEs_VirReg_setConstInt(AEs_VirReg *vr, AInt i)
{
	vr->alc0 = AEs_AlcConst;
	vr->typ0 = AEs_TypInt;
	vr->alc1 = 0;
	vr->alc2 = i;
}

ASTATIC void AEs_VirReg_setLabel2(AEs_VirReg *vr, void *p)
{
	vr->alc0 = AEs_AlcConst;
	vr->typ0 = AEs_TypLabel;
	vr->alc1 = 2;
	vr->alc2 = (AInt) p;
}

//////////////////////////////////////////////////////////////// AEs_optimize

ASTATIC AInt AEs_initConstIntTbl(ASP0 *cit, ASP0 *vr)
{
	AInt i, i1 = vr->s / sizeof (AEs_VirReg);
	AEs_VirReg *vr0 = (AEs_VirReg *) vr->p;
	ASP0_init(cit, 256 * sizeof (AInt));
	for (i = 0; i < i1; i++) {
		if (AEs_VirReg_isConstInt0(&vr0[i]) != 0) {
			ASP0_resize(cit, cit->s + 2 * sizeof (AInt));
			AInt *cit0 = (AInt *) cit->p, j = cit->s / (2 * sizeof (AInt));
			cit0[j * 2    ] = i;
			cit0[j * 2 + 1] = AEs_VirReg_getConstInt(&vr0[i]);
			cit->s += 2 * sizeof (AInt);
		}
	}
	return cit->s / (2 * sizeof (AInt));
}

ASTATIC AInt AEs_getConstIntTbl(ASP0 *cit, AInt i, ASP0 *vr)
{
	AInt *cit0 = (AInt *) cit->p, j, j1 = cit->s / (2 * sizeof (AInt));
	for (j = 0; j < j1; j++) {
		if (cit0[j * 2 + 1] == i) goto fin;
	}
	ASP0_resize(cit, cit->s + 2 * sizeof (AInt));
	cit0 = (AInt *) cit->p;
	cit->s += 2 * sizeof (AInt);
	cit0[j * 2    ] = vr->s / sizeof (AEs_VirReg);
	cit0[j * 2 + 1] = i;
	ASP0_resize(vr, vr->s + sizeof (AEs_VirReg));
	AEs_VirReg *vrk = (AEs_VirReg *) (vr->p + vr->s);
	vr->s += sizeof (AEs_VirReg);
	AEs_VirReg_setConstInt(vrk, i);
	vrk->nam = 0;
fin:
	return cit0[j * 2];
}

ASTATIC AInt AEs_isConstIntTbl(ASP0 *cit, AInt i)
{
	AInt *cit0 = (AInt *) cit->p, j, j1 = cit->s / (2 * sizeof (AInt)), rv = -1;
	for (j = 0; j < j1; j++) {
		if (cit0[j * 2 + 1] == i) goto fin;
	}
	rv = 0;
fin:
	return rv;
}

ASTATIC AInt AEs_isConstIntTblRev(ASP0 *cit, AInt i)
{
	AInt *cit0 = (AInt *) cit->p, j, j1 = cit->s / (2 * sizeof (AInt)), rv = -1;
	for (j = 0; j < j1; j++) {
		if (cit0[j * 2] == i) goto fin;
	}
	rv = 0;
fin:
	return rv;
}

ASTATIC AInt AEs_getConstIntTblRev(ASP0 *cit, AInt i)
{
	AInt *cit0 = (AInt *) cit->p, j;
	for (j = 0; ; j++) {
		if (cit0[j * 2] == i) break;
	}
	return cit0[j * 2 + 1];
}

ASTATIC AInt AEs_getConstIntVal(ASP0 *civ, AInt i)
{
	AInt *civ0 = (AInt *) civ->p, j;
	for (j = 0; ; j++) {
		if (civ0[j * 2] == i) break;
	}
	return civ0[j * 2 + 1];
}

ASTATIC AInt AEs_setConstIntVal(ASP0 *civ, AInt i, AInt v)
{
	AInt *civ0 = (AInt *) civ->p, j, j1 = civ->s / (2 * sizeof (AInt));
	for (j = 0; j < j1; j++) {
		if (civ0[j * 2] == i) goto find;
	}
	ASP0_resize(civ, civ->s + 2 * sizeof (AInt));
	civ->s += 2 * sizeof (AInt);
	civ0 = (AInt *) civ->p;
	civ0[j * 2    ] = i;
find:
	civ0[j * 2 + 1] = v;
	return v;
}

ASTATIC AInt AEs_isConstIntVal(ASP0 *civ, AInt i, ASP0 *cit)
{
	AInt rv = -1, *civ0 = (AInt *) civ->p, j, j1 = civ->s / (2 * sizeof (AInt));
	for (j = 0; j < j1; j++) {
		if (civ0[j * 2] == i) goto fin;
	}
	if (AEs_isConstIntTblRev(cit, i) != 0) {
		AEs_setConstIntVal(civ, i, AEs_getConstIntTblRev(cit, i));
		goto fin;
	}
	rv = 0;
fin:
	return rv;
}

ASTATIC AInt AEs_rmvConstIntVal(ASP0 *civ, AInt i)
{
	AInt *civ0 = (AInt *) civ->p, j, j1 = civ->s / (2 * sizeof (AInt));
	for (j = 0; j < j1; j++) {
		if (civ0[j * 2] == i) {
			civ0[j * 2    ] = civ0[j1 * 2 - 2];
			civ0[j * 2 + 1] = civ0[j1 * 2 - 1];
			civ->s -= 2 * sizeof (AInt);
			break;
		}
	}
	return i;
}

ASTATIC AInt AEs_isConstIntVal1(ASP0 *civ, AInt i, AInt *vi, ASP0 *cit)
{
	AInt rv = 0;
	if (AEs_isConstIntVal(civ, i, cit) != 0) {
		*vi = AEs_getConstIntVal(civ, i);
		rv = -1;
	}
	return rv;
}

ASTATIC AInt AEs_isConstIntVal2(ASP0 *civ, AInt i, AInt j, AInt *vi, AInt *vj, ASP0 *cit)
{
	AInt rv = 0;
	if (AEs_isConstIntVal(civ, i, cit) != 0 && AEs_isConstIntVal(civ, j, cit) != 0) {
		*vi = AEs_getConstIntVal(civ, i);
		*vj = AEs_getConstIntVal(civ, j);
		rv = -1;
	}
	return rv;
}

AINLINESTATIC void AEs_clrConstIntVal(ASP0 *civ)
{
	civ->s = 0;
}

AINLINESTATIC AInt *AEs_putIc0P4(AInt *p, AInt op, AInt p0, AInt p1, AInt p2, AInt p3)
{
	p[0] = op;
	p[1] = p0;
	p[2] = p1;
	p[3] = p2;
	p[4] = p3;
	return p + 5;
}

AINLINESTATIC void AEs_putIc0Nop0(AInt *p)
{
	AEs_putIc0P4(p, 0, 0, AEs_Op0Nop, 0, 0);
}

ASTATIC void AEs_putCpyConst(ASP0 *civ, ASP0 *cit, ASP0 *vr, AInt *p, AInt v)
{
	AInt i;
	AEs_setConstIntVal(civ, p[1], v);
	i = AEs_getConstIntTbl(cit, v, vr);
	AEs_putIc0P4(p, AEs_OpCpy, p[1], i, 0, 0);
}

ASTATIC AInt AEs_putInt(AInt *p, AInt i)
{
	AInt rv = 0;
	if (*p != i) {
		*p = i;
		rv = 1;
	}
	return rv;
}

ASTATIC AInt AEs_optimizeSub4(AEs *w, AInt *p0, AInt *p1, ASP0 *cit)
{
	AInt rv = 0, vi, vj, *p, ai[99];
	ASP0 civ, *vr = &w->vr;
	ASP0_init(&civ, 256 * sizeof (AInt));
	unsigned char cc = 0, uc;
	for (p = p0; p < p1; p += 5) {
		AInt op = p[0];
		AEs_VirReg *vr0 = (AEs_VirReg *) vr->p;
		switch (p[0]) {
		case 0x00:
			switch (p[2]) {
			case AEs_Op0Nop:
			case AEs_Op0Jmp:
				break;
			case AEs_Op0Jcc:
				if (cc == 2) { AEs_putIc0P4(p, 0, 0, AEs_Op0Nop, 0, 0); }
				if (cc == 3) { AEs_putIc0P4(p, 0, 0, AEs_Op0Jmp, p[3], 0); }
				break;
			case AEs_Op0DefLb:
			case AEs_Op0Ent:
			case AEs_Op0Ret:
				AEs_clrConstIntVal(&civ);
				break;
			case AEs_Op0SysFn:
			case AEs_Op0SysFnP:
				uc = 0;
				for (vj = 0; vj < p[5]; vj++) {
					if (AEs_isConstIntVal1(&civ, p[6 + vj], &vi, cit) != 0) {
						ai[vj] = vi;
						rv += AEs_putInt(&p[6 + vj], AEs_getConstIntTbl(cit, vi, vr));
						uc++;
					}
				}
				if (uc == p[5] && p[5] <= 4 && p[2] == AEs_Op0SysFnP) {
					AInt (*fn)(AInt, AInt, AInt, AInt);
					rv++;
					vi = p[3];
					fn = (void *) (AInt) vr0[p[4]].alc2;
					AEs_putIc0P4(p + 5, 0, p[1] - 1, AEs_Op0Nop, 0, 0);
					p[1] = vi;
					AEs_putCpyConst(&civ, cit, vr, p, fn(ai[0], ai[1], ai[2], ai[3]));
				} else {
					AEs_rmvConstIntVal(&civ, p[3]);
				}
				break;
			}
			break;
		case AEs_OpSetCc:
			if (cc == 2) { AEs_putCpyConst(&civ, cit, vr, p, 0); }
			if (cc == 3) { AEs_putCpyConst(&civ, cit, vr, p, 1); }
			break;
		case AEs_OpVoid:
		case AEs_OpAryGet:
//			AEs_rmvConstIntVal(&civ, p[1]);
//			break;
		case AEs_OpArySet:
			break;
		case AEs_OpCmpRnz:	cc = 0; break;
		case AEs_OpCmpRtEqM1:	cc = 0; break;
		case AEs_OpCmpEq:	cc = 0;	if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0) { AEs_putIc0Nop0(p); cc = ((vi == vj) & 1) | 2; } break;
		case AEs_OpCmpNe:	cc = 0; if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0) { AEs_putIc0Nop0(p); cc = ((vi != vj) & 1) | 2; } break;
		case AEs_OpCmpLt:	cc = 0; if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0) { AEs_putIc0Nop0(p); cc = ((vi <  vj) & 1) | 2; } break;
		case AEs_OpCmpGe:	cc = 0; if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0) { AEs_putIc0Nop0(p); cc = ((vi >= vj) & 1) | 2; } break;
		case AEs_OpCmpLe:	cc = 0; if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0) { AEs_putIc0Nop0(p); cc = ((vi <= vj) & 1) | 2; } break;
		case AEs_OpCmpGt:	cc = 0; if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0) { AEs_putIc0Nop0(p); cc = ((vi >  vj) & 1) | 2; } break;
		case AEs_OpCpy:
			if (AEs_isConstIntVal1(&civ, p[2], &vi, cit) != 0) {
				AEs_setConstIntVal(&civ, p[1], vi);
				rv += AEs_putInt(&p[2], AEs_getConstIntTbl(cit, vi, vr));
			}
			break;
		case AEs_OpNeg:
			if (AEs_isConstIntVal1(&civ, p[2], &vi, cit) != 0)				{ AEs_putCpyConst(&civ, cit, &w->vr, p, - vi); }
			break;
		case AEs_OpAdd:
			if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi + vj); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]],  0) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[2], 0, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[2]],  0) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[3], 0, 0); }
			break;
		case AEs_OpSub:
			if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi - vj); }
			else if (p[2] == p[3])											{ AEs_putCpyConst(&civ, cit, vr, p, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]],  0) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[2], 0, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[2]],  0) != 0) 			{ AEs_putIc0P4(p, AEs_OpNeg, p[1], p[3], 0, 0); }
			break;
		case AEs_OpMul:
			if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi * vj); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]],  1) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[2], 0, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]],  0) != 0) 			{ AEs_putCpyConst(&civ, cit, vr, p, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]], -1) != 0) 			{ AEs_putIc0P4(p, AEs_OpNeg, p[1], p[2], 0, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[2]],  1) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[3], 0, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[2]],  0) != 0) 			{ AEs_putCpyConst(&civ, cit, vr, p, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[2]], -1) != 0) 			{ AEs_putIc0P4(p, AEs_OpNeg, p[1], p[3], 0, 0); }
			break;
		case AEs_OpDiv:
			if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi / vj); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]],  1) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[2], 0, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]], -1) != 0) 			{ AEs_putIc0P4(p, AEs_OpNeg, p[1], p[2], 0, 0); }
			// ToDo: KvɉShrɏ.
			break;
		case AEs_OpMod:
			if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi % vj); }
			else if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi % vj); }
			break;
		case AEs_OpAnd:
			if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi & vj); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]],  0) != 0) 			{ AEs_putCpyConst(&civ, cit, vr, p, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[3]], -1) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[2], 0, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[2]],  0) != 0) 			{ AEs_putCpyConst(&civ, cit, vr, p, 0); }
			else if (AEs_VirReg_isConstInt(&vr0[p[2]], -1) != 0) 			{ AEs_putIc0P4(p, AEs_OpCpy, p[1], p[3], 0, 0); }
			break;
		case AEs_OpShr:
			if (AEs_isConstIntVal2(&civ, p[2], p[3], &vi, &vj, cit) != 0)	{ AEs_putCpyConst(&civ, cit, vr, p, vi >> vj); }
			break;
		default:
			AEs_clrConstIntVal(&civ);	// mȂ߂ɓAŜ߂civNA.
		}
		vr0 = (AEs_VirReg *) vr->p;
		if (op != p[0])
			rv++;
		if (p[0] == AEs_OpCpy && p[1] == p[2]) {
			AEs_putIc0Nop0(p);
			rv++;
		}
		if (p[0] == 0)
			p += p[1] * 5;
		else {
			for (vj = 2; vj < 5; vj++) {
				if (p[vj] > 0 && AEs_isConstIntVal1(&civ, p[vj], &vi, cit) != 0) {
					rv += AEs_putInt(&p[vj], AEs_getConstIntTbl(cit, vi, vr));
				}
			}
			if (p[1] != 0 && !(p[0] == AEs_OpCpy && AEs_VirReg_isConstInt0(&vr0[p[2]]) != 0))
				AEs_rmvConstIntVal(&civ, p[1]);
		}
	}
	ASP0_deinit(&civ);
	return rv;
}

ASTATIC AInt *AEs_skipNopVoid(AInt *p, AInt *p1)
{
	for (; p < p1; p += 5) {
		if (p[0] == 0 && p[2] == AEs_Op0Nop) { p += p[1] * 5; continue; }
		if (p[0] == AEs_OpVoid) continue;
		break;
	}
	return p;
}

ASTATIC AInt AEs_isVoid(AInt *p, AInt *p1, AInt i)
{
	AInt j, j1;
	for (; p < p1; p += 5) {
		if (p[0] == 0) {
			if (AEs_Op0Jmp <= p[2] && p[2] <= AEs_Op0Jcc) goto r0;
			if (p[2] == AEs_Op0Ret) goto r1;	// ЂƂ܂[Jϐz.
			if (AEs_Op0SysFn <= p[2] && p[2] <= AEs_Op0SysFnP) {
				j1 = p[5] + 6;
				for (j = 6; j < j1; j++) {
					if (p[j] == i) goto r0;
				}
				if (p[3] == i) goto r1;
			}
			p += p[1] * 5;
			continue;
		}
		for (j = 2; j < 5; j++) {
			if (p[j] == i) goto r0;
		}
		if (p[1] == i) goto r1;	// VoidɊY.
	}
r0:
	return 0;
r1:
	return -1;
}

ASTATIC AInt AEs_optimizeSub0(AEs *w, AInt *p0, AInt *p1)
// OpSetCc + OpCmpEq/OpCmpNe ̑gݍ킹AΏł.
{
	AInt *p, *q, *r = 0, rv = 0;
	AEs_VirReg *vr = (AEs_VirReg *) w->vr.p;
	for (p = p0; p < p1; p += 5) {
		if (AEs_OpCmpEq <= p[0] && p[0] <= AEs_OpCmpRtEqM1)
			r = p;
		if (p[0] == AEs_OpSetCc) {
			q = AEs_skipNopVoid(p + 5, p1);
			if (q + 5 <= p1 && AEs_OpCmpEq <= q[0] && q[0] <= AEs_OpCmpNe && AEs_isVoid(q + 5, p1, p[1]) != 0
				&& p[1] == q[2] && AEs_VirReg_isConstInt(&vr[q[3]], 0) != 0) {
				if (q[0] == AEs_OpCmpEq) {
					r[0] = ((r[0] - AEs_OpCmpEq) ^ 1) + AEs_OpCmpEq;
				}
				p[0] = p[1] = 0; p[2] = AEs_Op0Nop; // SetCcԂ.
				q[0] = q[1] = 0; q[2] = AEs_Op0Nop; // CmpEq/CmpNeԂ.
				rv++;
			}
		}
		if (p[0] == 0) p += p[1] * 5;
	}
	return rv;
}

ASTATIC AInt AEs_optimizeSub2(AEs *w, AInt *p0, AInt *p1)
// gotoœK & gpx.
{
	AInt rv = 0, vrLen = w->vr.s / sizeof (AEs_VirReg);
	AInt *lbInf = (AInt *) aMalloc(vrLen * sizeof (AInt) * 2), *p, *q = 0, *r;
	aArySetInt(lbInf, 0, vrLen * 2, 0);
	for (p = p0; p < p1; p += 5) {	// x`ʒu̔c.
		if (p[0] == 0 && p[2] == AEs_Op0DefLb) {
			lbInf[p[3] * 2    ] = (AInt) p;
//			lbInf[p[3] * 2 + 1] = 0;
		}
		if (p[0] == 0) p += p[1] * 5;
	}
	for (p = p0; p < p1; p += 5) {	// goto̍œK.
		if (p[0] == 0 && AEs_Op0Jmp <= p[2] && p[2] <= AEs_Op0Jcc) {
			AInt8 cutOff = 127;
			if (lbInf[p[3] * 2    ] == 0) { aErrExit("AEs_optimizeSub2: internal error #0 : %d", p[3]); }
			for (r = (AInt *) lbInf[p[3] * 2]; r < p1; r += 5) {
				if (r[0] == 0 && r[2] == AEs_Op0Jmp && cutOff > 0) {
					if (lbInf[r[3] * 2    ] == 0) { aErrExit("AEs_optimizeSub2: internal error #1 : %d", r[3]); }
					r = (AInt *) lbInf[r[3] * 2];
					cutOff--;
				}
				if (r[0] == 0 && r[2] == AEs_Op0DefLb) { p[3] = r[3]; continue; }
				if (r[0] > AEs_OpVoid) break;
				if (r[0] == 0 && r[2] != AEs_Op0Nop) break;
				if (r[0] == 0) r += r[1] * 5;
			}
//			lbInf[p[3] * 2 + 1]++;
		}
		if (p[0] == 0) p += p[1] * 5;
	}
	ASP0 stk;	// gpxo.
	ASP0_init(&stk, 256);
	stk.s = sizeof (AInt *);
	((AInt **) stk.p)[0] = p0;
	while (stk.s > 0) {
		p = ((AInt **) (stk.p + stk.s))[-1];
		stk.s -= sizeof (AInt *);
		for (; p < p1; p += 5) {
			if (p[0] == 0) {
				if (AEs_Op0Jmp <= p[2] && p[2] <= AEs_Op0Jcc) {
					if (lbInf[p[3] * 2 + 1] == 0) {
						ASP0_resize(&stk, stk.s + sizeof (AInt *));
						((AInt **) (stk.p + stk.s))[0] = (AInt *) lbInf[p[3] * 2];
						stk.s += sizeof (AInt *);
					}
					lbInf[p[3] * 2 + 1]++;
				}
				if (p[2] == AEs_Op0Jmp || p[2] == AEs_Op0Ret) break;
				p += p[1] * 5;
			}
		}
	}
	ASP0_deinit(&stk);
	for (p = p0; p < p1; p += 5) {	// gpxNop.
		if (p[0] == 0 && p[2] == AEs_Op0DefLb && lbInf[p[3] * 2 + 1] == 0) {
			p[2] = AEs_Op0Nop;
			p[3] = 0;
			rv++;
		}
		if (p[0] == 0) p += p[1] * 5;
	}
	for (p = p0; p < p1; p += 5) {	// fbhR[h̏.
		if (p[0] == 0 && p[2] == AEs_Op0Jmp) {
			for (r = p + 5; r < p1 && !(r[0] == 0 && r[2] == AEs_Op0DefLb); r += 5) {
				if (r[0] == 0) r += r[1] * 5;
			}
			if (r > p + 5 && !(p[5] == 0 && p[6] * 5 == r - p - 10 && p[7] == AEs_Op0Nop)) {
				rv++;
				p[5] = 0; p[6] = (r - p - 10) / 5; p[7] = AEs_Op0Nop;
			}
		}
		if (p[0] == 0) p += p[1] * 5;
	}
	for (p = p0; p < p1; p += 5) {	// gotȍ.
		if (AEs_OpCmpEq <= p[0] && p[0] <= AEs_OpCmpRtEqM1)
			q = p;
		if (p[0] == 0 && AEs_Op0Jmp <= p[2] && p[2] <= AEs_Op0Jcc) {
			r = AEs_skipNopVoid(p + 5, p1);
			if (r < p1 && r[0] == 0 && r[2] == AEs_Op0DefLb && p[3] == r[3]) {
				if (p[2] == AEs_Op0Jcc) {
					q[0] = q[1] = 0; q[2] = AEs_Op0Nop;
				}
				p[0] = p[1] = 0; p[2] = AEs_Op0Nop;
				rv++;
			}
		}
		if (p[0] == 0) p += p[1] * 5;
	}
	aFree(lbInf, vrLen * sizeof (AInt) * 2);
	return rv;
}

ASTATIC AInt AEs_optimizeSub3(AEs *w, AInt *p0, AInt *p1)
// svȉẐĂ.
{
	(void) w;
	AInt tsz = (p1 - p0) / 5 * sizeof (AInt *), **t = aMalloc(tsz), *p, *r, i = 0, rv = 0, j;
	for (p = p0; p < p1; p += 5) {
		if ((p[0] >= AEs_OpSetCc && p[1] > 0) || (p[0] == 0 && AEs_Op0SysFn <= p[2] && p[2] <= AEs_Op0SysFnP && p[3] > 0)) {
			t[i++] = p;
		}
		if (p[0] == 0) p += p[1] * 5;
	}
	for (i--; i >= 0; i--) {	// tŎgȂZĂ.
		p = t[i];
		r = p + 5; if (p[0] == 0) r += p[1] * 5;
		r = AEs_skipNopVoid(r, p1);
		j = 1;
		if (p[0] == 0) { j = 3; }
		if (r < p1 && r[0] == AEs_OpCpy && p[j] == r[2] && AEs_isVoid(r + 5, p1, r[2]) != 0) {
			p[j] = r[1];
			r[0] = r[1] = 0; r[2] = AEs_Op0Nop;
			rv++;
		}
		if (p[0] != 0 && AEs_isVoid(r, p1, p[1]) != 0) {
			p[0] = p[1] = 0; p[2] = AEs_Op0Nop;
			rv++;
		}
		if (p[0] == 0 && p[2] == AEs_Op0SysFnP && AEs_isVoid(r, p1, p[3]) != 0) {
			p[2] = AEs_Op0Nop;
			rv++;
		}
	}
	aFree(t, tsz);
	return rv;
}

ASTATIC AInt AEs_optimize(AEs *w, AInt *p0, AInt *p1, AInt i1)
{
	ASP0 cit;
	AEs_initConstIntTbl(&cit, &w->vr);
	AInt i, rv = 0;
	AEs_optimizeSub0(w, p0, p1);
	for (i = 0; i < i1; i++) {
		AInt rv0 = rv;
		rv += AEs_optimizeSub4(w, p0, p1, &cit);
		rv += AEs_optimizeSub2(w, p0, p1);
		rv += AEs_optimizeSub3(w, p0, p1);
		if (rv == rv0) break;
	}
	ASP0_deinit(&cit);
	return rv;
}

ASTATIC void AEs_dump(AInt *p, AInt *p1)
{
	static char op[][8] = {
		"       ", "       ", "Void   ", "SetCc  ", "Cpy    ", "Neg    ", "ArySet ", "AryGet ",
		"CmpEq  ", "CmpNe  ", "CmpLt  ", "CmpGe  ", "CmpLe  ", "CmpGt  ", "CmpRnz ", "CmREqM1",
		"Add    ", "Sub    ", "Mul    ", "Div    ", "Mod    ", "And    ", "Xor    ", "Shl    ",
		"Shr    ", "M64Shr "
	};
	static char op0[][8] = {
		"Nop    ", "DefLb  ", "Jmp    ", "Jcc    ", "Ent    ", "Ret    ", "SysFn  ", "SysFnP ",
	};
	while (p < p1) {
		AInt i, i0 = 1, i1 = 5;
		if (p[0] > 0) {
			printf("%02d:%s ", (int) p[0], op[p[0]]);
		} else {
			i0 = 3;
			i1 += p[1] * 5;
			printf("00 %d %02d:%s ", (int) p[1], (int) p[2], op0[p[2]]);
		}
		for (i = i0; i < i1; i++) {
			printf("%d ", (int) p[i]);
		}
		printf("\n");
		p += i1;
	}
}

ASTATIC AInt aDecodeHex(int c) // 16iɎg镶Ȃ炻0`15̐ɕϊAłȂ-1Ԃ֐.
{
    if ('0' <= c && c <= '9') return c - '0';
    if ('a' <= c && c <= 'f') return c - 'a' + 10;
    if ('A' <= c && c <= 'F') return c - 'A' + 10;
    return -1;
}

typedef struct AEs_Indeterminate_ {
	AInt64 vp;
	int opt;
	unsigned char t;
} AEs_Indeterminate;

AINLINESTATIC AEs_Indeterminate *AEs_Indeterminate_moveObj(AEs_Indeterminate *w, AEs_Indeterminate *q)
{
	*q = *w;
	return w;
}

AINLINESTATIC AEs_Indeterminate *AEs_Indeterminate_deinit(AEs_Indeterminate *w)
{
	return w;
}

ASTATIC const char *AEs_skipSpc(const char *s)
{
	while (*s == ' ' || *s == '_' || *s == ':')
		s++;
	return s;
}

ASTATIC AInt AEs_decodeHexEx(const char **ps, AInt *p, const char *s0)
{
	AInt v = 0, u, sg = 1;
	const char *s = AEs_skipSpc(*ps);
	if (*s == '%') {
		*ps = s + 2;
		return p[aDecodeHex(s[1])];
	}
	if (*s == '+') { s++; }
	if (*s == '-') { s++; sg = -1; }
	if (*s == ';')
		aErrExit("AEs_decodeHexEx: internal error #0 : '%s'(%s)", s, s0);
	for (;;) {
		u = aDecodeHex(*s++);
		if (u < 0) break;
		v = v << 4 | u;
	}
	*ps = s - 1;
	return sg * v;
}
