enum { AEs_run_OpCpy, AEs_run_OpRet, AEs_run_OpSysFn2, AEs_run_OpSysFn6, AEs_run_OpSysFn10, AEs_run_OpPrm,
	AEs_run_OpAdd, AEs_run_OpSub, AEs_run_OpMul, AEs_run_OpDiv, AEs_run_OpMod, AEs_run_OpAnd, AEs_run_OpXor, AEs_run_OpOr, AEs_run_OpShl, AEs_run_OpShr, 
	AEs_run_OpCeq, AEs_run_OpCne, AEs_run_OpClt, AEs_run_OpCge, AEs_run_OpCle, AEs_run_OpCgt,
	AEs_run_OpJeq, AEs_run_OpJne, AEs_run_OpJlt, AEs_run_OpJge, AEs_run_OpJle, AEs_run_OpJgt, AEs_run_OpJrnz, AEs_run_OpJrem1,
	AEs_run_OpLopLtCI, AEs_run_OpJmp, AEs_run_OpM64s, AEs_run_OpNeg, AEs_run_OpArySet, AEs_run_OpAryGet
};

AINLINESTATIC AInt AEs_run_getVarPtr(AEs_VirReg *vr)
{
	if (AEs_VirReg_isConstInt0(vr) != 0)
		return (AInt) &vr->alc2;
	return vr->alc2;
}

ASTATIC AInt AEs_run_compile(AEs *w, AInt *p, AInt *p1, ASP0 *sp)
{
	AInt s0 = sp->s, i1, *pi = 0, *pj = 0, cc = 0, pp0, pp1, pp2, pp3;
	AEs_VirReg *vr = (AEs_VirReg *) w->vr.p;
	static AInt dmy;
	vr[0].alc2 = (AInt) &dmy;
	AInt *px = 0, *px1;
	for (; p < p1; p += 5) {
		ASP0_resize(sp, sp->s + 256 * sizeof (AInt));
		px = (AInt *) (sp->p + sp->s);
		if (p[0] == AEs_OpAdd && p[2] == p[1] && AEs_VirReg_isConstInt(&vr[p[3]], 1) != 0) {
			pi = AEs_skipNopVoid(p + 5, p1);
			if (pi < p1 && pi[0] == AEs_OpCmpLt && pi[2] == p[1] && AEs_VirReg_isConstInt0(&vr[pi[3]]) != 0) {
				pj = AEs_skipNopVoid(pi + 5, p1);
				if (pj < p1 && pj[0] == 0 && pj[2] == AEs_Op0Jcc) {
					px = AEs_putIc0P4(px, AEs_run_OpLopLtCI, pj[3], AEs_run_getVarPtr(&vr[p[1]]), AEs_VirReg_getConstInt(&vr[pi[3]]), 0);
					p = pj;	// +5Ă͂Ȃ(for+5邩).
					goto nxt;
				}
			}
		}
		switch (p[0]) {
		case 0:
			switch (p[2]) {
			case AEs_Op0Nop:
			case AEs_Op0Ent:
				break;
			case AEs_Op0DefLb:
				vr[p[3]].alc2 = px - (AInt *) sp->p;
				break;
			case AEs_Op0Jmp:
				px = AEs_putIc0P4(px, AEs_run_OpJmp, p[3], 0, 0, 0);
				break;
			case AEs_Op0Jcc:
				px = AEs_putIc0P4(px, AEs_run_OpJeq + cc, p[3], (AInt) pi, (AInt) pj, 0);
				break;
			case AEs_Op0Ret:
				px = AEs_putIc0P4(px, AEs_run_OpRet, 0, 0, 0, 0);
				break;
			case AEs_Op0SysFn:
			case AEs_Op0SysFnP:
				i1 = p[5];
				pi = (AInt *) AEs_run_getVarPtr(&vr[p[3]]);
				if (i1 <= 2) {
					pp0 = (AInt) &dmy; if (i1 >= 1) { pp0 = AEs_run_getVarPtr(&vr[p[6]]); }
					pp1 = (AInt) &dmy; if (i1 >= 2) { pp1 = AEs_run_getVarPtr(&vr[p[7]]); }
					px = AEs_putIc0P4(px, AEs_run_OpSysFn2, (AInt) pi, vr[p[4]].alc2, pp0, pp1);
					break;
				}
				if (i1 <= 6) {
					px = AEs_putIc0P4(px, AEs_run_OpSysFn6, (AInt) pi, vr[p[4]].alc2, AEs_run_getVarPtr(&vr[p[6]]), AEs_run_getVarPtr(&vr[p[7]]));
					pp0 = (AInt) &dmy; if (i1 >= 3) { pp0 = AEs_run_getVarPtr(&vr[p[ 8]]); }
					pp1 = (AInt) &dmy; if (i1 >= 4) { pp1 = AEs_run_getVarPtr(&vr[p[ 9]]); }
					pp2 = (AInt) &dmy; if (i1 >= 5) { pp2 = AEs_run_getVarPtr(&vr[p[10]]); }
					pp3 = (AInt) &dmy; if (i1 >= 6) { pp3 = AEs_run_getVarPtr(&vr[p[11]]); }
					px = AEs_putIc0P4(px, AEs_run_OpPrm, pp0, pp1, pp2, pp3);
					break;
				}
				if (i1 <= 10) {
					px = AEs_putIc0P4(px, AEs_run_OpSysFn10, (AInt) pi, vr[p[4]].alc2, AEs_run_getVarPtr(&vr[p[6]]), AEs_run_getVarPtr(&vr[p[7]]));
					px = AEs_putIc0P4(px, AEs_run_OpPrm, AEs_run_getVarPtr(&vr[p[ 8]]), AEs_run_getVarPtr(&vr[p[ 9]]), AEs_run_getVarPtr(&vr[p[10]]), AEs_run_getVarPtr(&vr[p[11]]));
					pp0 = (AInt) &dmy; if (i1 >=  7) { pp0 = AEs_run_getVarPtr(&vr[p[12]]); }
					pp1 = (AInt) &dmy; if (i1 >=  8) { pp1 = AEs_run_getVarPtr(&vr[p[13]]); }
					pp2 = (AInt) &dmy; if (i1 >=  9) { pp2 = AEs_run_getVarPtr(&vr[p[14]]); }
					pp3 = (AInt) &dmy; if (i1 >= 10) { pp3 = AEs_run_getVarPtr(&vr[p[15]]); }
					px = AEs_putIc0P4(px, AEs_run_OpPrm, pp0, pp1, pp2, pp3);
					break;
				}
				aErrExit("AEs_run_compile: internal error #2: i1=%d", (int) i1);
			default:
				aErrExit("AEs_run_compile: internal error #1: %d", (int) p[2]);
			}
			p += p[1] * 5;
			break;
		case AEs_OpCpy:
			px = AEs_putIc0P4(px, AEs_run_OpCpy, AEs_run_getVarPtr(&vr[p[1]]), AEs_run_getVarPtr(&vr[p[2]]), 0, 0);
			break;
		case AEs_OpCmpEq:
		case AEs_OpCmpNe:
		case AEs_OpCmpLt:
		case AEs_OpCmpGe:
		case AEs_OpCmpLe:
		case AEs_OpCmpGt:
			cc = p[0] - AEs_OpCmpEq;
			pi = (AInt *) AEs_run_getVarPtr(&vr[p[2]]);
			pj = (AInt *) AEs_run_getVarPtr(&vr[p[3]]);
			break;
		case AEs_OpCmpRnz:
			cc = 0x6;
			pi = pj = 0;
			break;
		case AEs_OpCmpRtEqM1:
			cc = 0x7;
			pi = pj = 0;
			break;
		case AEs_OpAdd:
		case AEs_OpSub:
		case AEs_OpMul:
		case AEs_OpDiv:
		case AEs_OpMod:
		case AEs_OpAnd:
		case AEs_OpXor:
		case AEs_OpOr:
		case AEs_OpShl:
		case AEs_OpShr:
			px = AEs_putIc0P4(px, p[0] + (AEs_run_OpAdd - AEs_OpAdd), AEs_run_getVarPtr(&vr[p[1]]),
				AEs_run_getVarPtr(&vr[p[2]]), AEs_run_getVarPtr(&vr[p[3]]), 0);
			break;
		case AEs_OpSetCc:
			px = AEs_putIc0P4(px, AEs_run_OpCeq + cc, AEs_run_getVarPtr(&vr[p[1]]), (AInt) pi, (AInt) pj, 0);
			break;
		case AEs_OpM64s:
			px = AEs_putIc0P4(px, AEs_run_OpM64s, AEs_run_getVarPtr(&vr[p[1]]), AEs_run_getVarPtr(&vr[p[2]]),
				AEs_run_getVarPtr(&vr[p[3]]), AEs_run_getVarPtr(&vr[p[4]]));
			break;
		case AEs_OpNeg:
			px = AEs_putIc0P4(px, AEs_run_OpNeg, AEs_run_getVarPtr(&vr[p[1]]), AEs_run_getVarPtr(&vr[p[2]]), 0, 0);
			break;
		case AEs_OpArySet:
			px = AEs_putIc0P4(px, AEs_run_OpArySet, AEs_run_getVarPtr(&vr[p[2]]), AEs_run_getVarPtr(&vr[p[3]]), AEs_run_getVarPtr(&vr[p[4]]), 0);
			break;
		case AEs_OpAryGet:
			px = AEs_putIc0P4(px, AEs_run_OpAryGet, AEs_run_getVarPtr(&vr[p[2]]), AEs_run_getVarPtr(&vr[p[3]]), AEs_run_getVarPtr(&vr[p[1]]), 0);
			break;
		case AEs_OpVoid:
			break;
		default:
			aErrExit("AEs_run_compile: internal error #0: %d", (int) p[0]);
		}
nxt:
		sp->s = (char *) px - sp->p;
	}
	px1 = px;
	// ͕ʃ[`ɂقȂ.
	for (px = (AInt *) (sp->p + s0); px < px1; px += 5) {
		if (AEs_run_OpJeq <= px[0] && px[0] <= AEs_run_OpJmp) {
			px[1] = (AInt) (((AInt *) sp->p) + vr[px[1]].alc2);
		}
	}
	return (sp->s - s0) / (5 * sizeof (AInt));
}

void AEs_run_run(AInt **p)
{
	AInt (*fn2)(AInt, AInt);
	AInt (*fn6)(AInt, AInt, AInt, AInt, AInt, AInt);
	AInt (*fn10)(AInt, AInt, AInt, AInt, AInt, AInt, AInt, AInt, AInt, AInt);
	AInt rv = 0, *a;
    for (;;) {
        switch ((AInt) p[0]) {
		case AEs_run_OpRet:		return;
        case AEs_run_OpCpy:		*p[1] =   *p[2];		p += 5; continue;
		case AEs_run_OpNeg:		*p[1] = - *p[2];		p += 5; continue;
		case AEs_run_OpAdd:		*p[1] = *p[2] +  *p[3];	p += 5; continue;
		case AEs_run_OpSub:		*p[1] = *p[2] -  *p[3];	p += 5; continue;
		case AEs_run_OpMul:		*p[1] = *p[2] *  *p[3];	p += 5; continue;
		case AEs_run_OpDiv:		*p[1] = *p[2] /  *p[3];	p += 5; continue;
		case AEs_run_OpMod:		*p[1] = *p[2] %  *p[3];	p += 5; continue;
		case AEs_run_OpAnd:		*p[1] = *p[2] &  *p[3];	p += 5; continue;
		case AEs_run_OpXor:		*p[1] = *p[2] ^  *p[3];	p += 5; continue;
		case AEs_run_OpOr:		*p[1] = *p[2] |  *p[3];	p += 5; continue;
		case AEs_run_OpShl:		*p[1] = *p[2] << *p[3];	p += 5; continue;
		case AEs_run_OpShr:		*p[1] = *p[2] >> *p[3];	p += 5; continue;
		case AEs_run_OpCeq:		*p[1] = *p[2] == *p[3];	p += 5; continue;
		case AEs_run_OpCne:		*p[1] = *p[2] != *p[3];	p += 5; continue;
		case AEs_run_OpClt:		*p[1] = *p[2] <  *p[3];	p += 5; continue;
		case AEs_run_OpCge:		*p[1] = *p[2] >= *p[3];	p += 5; continue;
		case AEs_run_OpCle:		*p[1] = *p[2] <= *p[3];	p += 5; continue;
		case AEs_run_OpCgt:		*p[1] = *p[2] >  *p[3];	p += 5; continue;
		case AEs_run_OpJeq:		if (*p[2] == *p[3])	{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJne:		if (*p[2] != *p[3])	{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJlt:		if (*p[2] <  *p[3])	{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJge:		if (*p[2] >= *p[3])	{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJle:		if (*p[2] <= *p[3])	{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJgt:		if (*p[2] >  *p[3])	{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJrnz:	if (rv != 0)		{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJrem1:	if (rv == -1)		{ p = (AInt **) p[1]; continue; } p += 5; continue;
		case AEs_run_OpJmp:		p = (AInt **) p[1]; continue;
		case AEs_run_OpM64s:	*p[1] = (((AInt64) *p[2]) * ((AInt64) *p[3])) >> *p[4]; p += 5; continue;
		case AEs_run_OpArySet:
            a = (AInt *) *p[1];
            a[*p[2]] = *p[3];
            p += 5;
            continue;
        case AEs_run_OpAryGet:
            a = (AInt *) *p[1];
            *p[3] = a[*p[2]];
            p += 5;
            continue;
		case AEs_run_OpSysFn2:
			fn2 = (void *) p[2];
			*p[1] = rv = fn2(*p[3], *p[4]);
			p += 5;
			continue;
		case AEs_run_OpSysFn6:
			fn6 = (void *) p[2];
			*p[1] = rv = fn6(*p[3], *p[4], *p[6], *p[7], *p[8], *p[9]);
			p += 10;
			continue;
		case AEs_run_OpSysFn10:
			fn10 = (void *) p[2];
			*p[1] = rv = fn10(*p[3], *p[4], *p[6], *p[7], *p[8], *p[9], *p[11], *p[12], *p[13], *p[14]);
			p += 15;
			continue;
		case AEs_run_OpLopLtCI:
			rv = *p[2] + 1;
			*p[2] = rv;
			if (rv < (AInt) p[3]) { p = (AInt **) p[1]; continue; }
			p += 5;
			continue;
        }
    }
}
