typedef struct AEs_X864_ {
	unsigned char op, sub, reg, mod, bas, idx, scl, tds, tim, len0, len1;
	AInt64 dsp, imm;
	AInt vrIdx;
} AEs_X864;

typedef struct AEs_X864_Man_ {
	AEs *es;
	ASP0 x864, aft;
	unsigned char x64, useIncDec, usePushPop, nouseUnderSc;
	AInt stkEnt, stkRet;
} AEs_X864_Man;

ASTATIC AEs_X864_Man *AEs_X864_Man_init(AEs_X864_Man *w)
{
	w->useIncDec = 0;
	w->usePushPop = 0;
	w->nouseUnderSc = 0;
	return w;
}

unsigned char AEs_putX864_tbl[] = {
	0x00, 0, 0x00,	// 00:NOP
	0x00, 1, 0x01,	// 01:RETN
	0x11, 1, 0x02,	// 02:0:PUSH(simple)
					// 02:1:POP(simple)
	0x14, 2, 0xff,	// 03:0:CALL(near-label)
					// 03:1:JMP(near-label)
	0x03, 2, 0xff,	// 04:MOV(load)
	0x03, 2, 0xff,	// 05:MOV(store)
	0x18, 0, 0xff,	// 06:0:MOV(L)
					// 06:1:MOVȂL
	0x08, 0, 0xff,	// 07:MOV(S)
	0x13, 2, 0xff,	// 08:0:ADD(r,r/m/i)
					// 08:1:OR(r,r/m/i)
					// 08:2:ADC
					// 08:3:SBB
					// 08:4:AND
					// 08:5:SUB
					// 08:6:XOR
					// 08:7:CMP
	0x03, 2, 0xff,	// 09:IMUL
	0x12, 2, 0xff,	// 0a:IMUL,IDIV
	0x00, 1, 2,		// 0b:CDQ(CQO)
	0x11, 6, 0xff,	// 0c:x:SETcc, MOVZX
	0x14, 0, 0xff,	// 0d:x:Jcc
	0x11, 2, 2, 	// 0e:SHLȂ(r,CL)
	0x15, 2, 3, 	// 0f:SHLȂ(r,imm)
	0x18, 0, 0,		// 10:0:defLabel
	0x01, 2, 2,		// 11:TEST(r,r)
	0x11, 2, 0xff,	// 12:x:NOT/NEG
	0x13, 3, 0xff,	// 13:x:SHLD,SHRD r,CL
	0x17, 4, 0xff,	// 14:x:SHLD,SHRD r,imm
	0x02, 0, 0,		// 15:void
	0x03, 2, 0xff,	// 16:LEA
};

ASTATIC void AEs_putX864Sub0(AEs_X864 *q, AEs_VirReg *vr, AInt i)
{
	switch (vr->alc0) {
	case AEs_AlcConst:
		q->tds = vr->alc1;
		q->dsp = vr->alc2;
		q->mod = 9;
		q->bas = 0xff;
		break;
	case AEs_AlcReg:
		q->tds = 0;
		q->dsp = 0;
		q->mod = 12;
		q->bas = vr->alc1;
		break;
	case AEs_AlcMem:
		q->tds = 0;
		q->dsp = vr->alc2;
		q->mod = 5;
		q->bas = vr->alc1;
		if (q->bas == 0xff)
			q->mod = 1;
		break;
	}
	q->idx = 0xff;
	q->scl = 0;
	q->vrIdx = i;
}

ASTATIC AInt AEs_X864_regVar(AEs_VirReg *vr)
{
	AInt rv = -1;
	if (vr->alc0 == AEs_AlcReg)
		rv = vr->alc1;
	return rv;
}

ASTATIC AEs_X864 *AEs_putX864P4(AEs *w, AEs_X864 *q, const char *s, AInt p0, AInt p1, AInt p2, AInt p3)
{
	const char *s0 = s;
	AInt pp[16], i, j, k, l;
	pp[0] = p0;
	pp[1] = p1;
	pp[2] = p2;
	pp[3] = p3;
	AEs_VirReg *vr = (AEs_VirReg *) w->vr.p;
	while (*s != 0) {
		s = AEs_skipSpc(s);
		if (*s == 0) break;
		i = AEs_decodeHexEx(&s, pp, s0);
		if (i < 0 || ((AInt) sizeof AEs_putX864_tbl) / 3 <= i)
			aErrExit("AEs_putX864P4: internal error #0 : '%s'", s0);
		q->op  = i;
		int flg = AEs_putX864_tbl[i * 3];
		q->len0 = AEs_putX864_tbl[i * 3 + 1];
		q->len1 = AEs_putX864_tbl[i * 3 + 2];
		q->sub = 0;    if ((flg    & 16) != 0) q->sub = AEs_decodeHexEx(&s, pp, s0);
		q->reg = 0xff; if ((flg    &  1) != 0) q->reg = AEs_decodeHexEx(&s, pp, s0);
		q->mod = 0;    if ((flg    &  2) != 0) q->mod = AEs_decodeHexEx(&s, pp, s0);
		q->bas = 0xff; if ((q->mod &  4) != 0) q->bas = AEs_decodeHexEx(&s, pp, s0);
		q->idx = 0xff; if ((q->mod &  2) != 0) q->idx = AEs_decodeHexEx(&s, pp, s0);
		q->scl = 0;    if ((q->mod &  2) != 0) q->scl = AEs_decodeHexEx(&s, pp, s0);
		q->tds = 0;    if ((q->mod &  1) != 0) q->tds = AEs_decodeHexEx(&s, pp, s0);
		q->dsp = 0;    if ((q->mod &  1) != 0) q->dsp = AEs_decodeHexEx(&s, pp, s0);
		// mod: 0:StB[hgp, 1:[dsp], 2:[idx*scl], 4:[bas], 8:virtualRegister, 9:imm, 12:reg
		q->vrIdx = 0;
		if (q->mod == 8) {
			i = AEs_decodeHexEx(&s, pp, s0);
			AEs_putX864Sub0(q, &vr[i], i);
		}
		if (q->bas == 0xff) q->mod &= ~4;
		if (q->idx == 0xff || q->scl == 0) q->mod &= ~2;
		if (q->dsp == 0 && q->mod < 8) q->mod &= ~1;
		q->tim = 0;    if ((flg    &  4) != 0) q->tim = AEs_decodeHexEx(&s, pp, s0);
		q->imm = 0;    if ((flg    &  4) != 0) q->imm = AEs_decodeHexEx(&s, pp, s0);
		               if ((flg    &  8) != 0) q->imm = AEs_decodeHexEx(&s, pp, s0);
		// mod: c:reg, 1:[disp], 4:[bas], 2:[idx*scl].
		if (*s != ';')
			aErrExit("AEs_putX864P4: internal error #1 : '%s'", s0);
		s++;
		if (q->op == 0x06) {	// MOV (L)
			i = (q->imm >> 12) & 0x0f;
			j = (q->imm >>  8) & 0x0f;
			k = (q->imm >>  4) & 0x0f;
			l =  q->imm        & 0x0f;
			i = 15 - i;
			if (AEs_X864_regVar(&vr[pp[j]]) >= 0 && pp[j] == pp[k]) {
				pp[i] = AEs_X864_regVar(&vr[pp[j]]);
				q->len0 = q->len1 = 0;
			} else {
				pp[i] = 0;
				if (AEs_X864_regVar(&vr[pp[k]]) >= 0 && pp[k] != pp[l])
					pp[i] = AEs_X864_regVar(&vr[pp[k]]);
				// pp[i]pp[j]load.
				if (q->sub == 0) {
					q->op = 0x04;
					q->len0 = AEs_putX864_tbl[q->op * 3 + 1];
					q->len1 = AEs_putX864_tbl[q->op * 3 + 2];
					q->reg = pp[i];
					AEs_putX864Sub0(q, &vr[pp[j]], pp[j]);
				} else {
					q->len0 = q->len1 = 0;
    			}
			}
		}
		if (q->op == 0x07) {	// MOV (S)
			i = (q->imm >>  4) & 0x0f;
			j =  q->imm        & 0x0f;
			i = 15 - i;
			if (pp[i] != 0) {
				q->len0 = q->len1 = 0;
			} else {
				q->op = 0x05;
				q->len0 = AEs_putX864_tbl[q->op * 3 + 1];
				q->len1 = AEs_putX864_tbl[q->op * 3 + 2];
				q->reg = pp[i];
				AEs_putX864Sub0(q, &vr[pp[j]], pp[j]);
			}
		}
		q++;
	}
	return q;
}

ASTATIC AEs_X864 *AEs_putX864P0(AEs *w, AEs_X864 *q, const char *s)
{
	return AEs_putX864P4(w, q, s, 0, 0, 0, 0);
}

ASTATIC AEs_X864 *AEs_putX864P1(AEs *w, AEs_X864 *q, const char *s, AInt p0)
{
	return AEs_putX864P4(w, q, s, p0, 0, 0, 0);
}

ASTATIC AEs_X864 *AEs_putX864P2(AEs *w, AEs_X864 *q, const char *s, AInt p0, AInt p1)
{
	return AEs_putX864P4(w, q, s, p0, p1, 0, 0);
}

ASTATIC AEs_X864 *AEs_putX864P3(AEs *w, AEs_X864 *q, const char *s, AInt p0, AInt p1, AInt p2)
{
	return AEs_putX864P4(w, q, s, p0, p1, p2, 0);
}

ASTATIC AEs_X864 *AEs_X864_compileCpy(AEs *w, AEs_X864 *px, AInt to, AInt fr)
{
	AEs_VirReg *vr = (AEs_VirReg *) w->vr.p;
	if (fr == -1) {
		px = AEs_putX864P1(w, px, "5_0_8:%0;", to);
	} else if (AEs_X864_regVar(&vr[to]) < 0) {	// ւ̃XgA.
		px = AEs_putX864P2(w, px, "6:0_111; 5_%f_8:%0;", to, fr);
	} else {	// WX^ւ̑.
		px = AEs_putX864P2(w, px, "6:0_000; 4_%f_8:%1;", to, fr);
	}
	return px;
}

const char *AEs_opBin[] = {
	"6:0_102; 8:0_%f_8:%2; 7_0;",	// OpAdd
	"6:0_102; 8:5_%f_8:%2; 7_0;",	// OpSub
	"6:0_102; 9_%f_8:%2; 7_0;",	// OpMul
	"4_0_8:%1; b; a:7_8:%2; 5_0_8:%0;",		// OpDiv
	"4_0_8:%1; b; a:7_8:%2; 5_2_8:%0;",		// OpMod
	"6:0_102; 8:4_%f_8:%2; 7_0;", 	// OpAnd
	"6:0_102; 8:6_%f_8:%2; 7_0;", 	// OpXor
	"6:0_102; 8:1_%f_8:%2; 7_0;", 	// OpOr
};

ASTATIC AInt AEs_X864_compile(AEs_X864_Man *xm, AInt *p, AInt *p1)
{
	static unsigned char condCode[6] = { 0x4, 0x5, 0xc, 0xd, 0xe, 0xf };
	int x64 = xm->x64;
	ASP0 *sp = &xm->x864;
	AInt s0 = sp->s, i, i1;
	AEs *w = xm->es;
	AEs_VirReg *vr = (AEs_VirReg *) w->vr.p;
	static AInt8 cc;
	AInt savRegs = 0xe8;
	if (x64 != 0)
		savRegs = 0xffe8;
	for (; p < p1; p += 5) {
		ASP0_resize(sp, sp->s + 64 * sizeof (AEs_X864));
		AEs_X864 *px = (AEs_X864 *) (sp->p + sp->s);
		switch (p[0]) {
		case 0:
			switch (p[2]) {
			case AEs_Op0Nop:
				break;
			case AEs_Op0DefLb:
				vr[p[3]].alc2 = px - (AEs_X864 *) sp->p;
				px = AEs_putX864P1(w, px, "10:0_%0;", p[3]);
				break;
			case AEs_Op0Jmp:
				px = AEs_putX864P1(w, px, "3:1_1:%0;", p[3]);
				break;
			case AEs_Op0Jcc:
				px = AEs_putX864P2(w, px, "d:%0_1:%1;", cc, p[3]);
				break;
			case AEs_Op0Ent:
				for (i = 15; i >= 0; i--) {	// ToDo: gȂWX^̑ޔȗ.
					if (((savRegs >> i) & 1) != 0) {
						px = AEs_putX864P1(w, px, "2:0_%0;", i);
					}
				}
				xm->stkEnt = px - (AEs_X864 *) sp->p;
				px = AEs_putX864P0(w, px, "8:5_4_9:0:0; 16_5_5:4:0:0;");
				break;
			case AEs_Op0Ret:
				xm->stkRet = px - (AEs_X864 *) sp->p;
				px = AEs_putX864P0(w, px, "8:0_4_9:0:0;");
				for (i = 0; i <= 15; i++) {
					if (((savRegs >> i) & 1) != 0) {
						px = AEs_putX864P1(w, px, "2:1_%0;", i);
					}
				}
				px = AEs_putX864P0(w, px, "1;");
				break;
			case AEs_Op0SysFn:
			case AEs_Op0SysFnP:
				i1 = p[5];
				for (i = 0; i < i1; i++) {
					vr[0].alc0 = AEs_AlcMem;
					vr[0].alc1 = 4; // ESP, RSP.
					if (x64 == 0) {
						vr[0].alc2 = i * 4;
					} else if (x64 == 1) {	// MSW64
						if (i < 4) {
							static unsigned char tbl[4] = { 1, 2, 8, 9 };
							vr[0].alc0 = AEs_AlcReg;
							vr[0].alc1 = tbl[i];
						} else {
							vr[0].alc2 = i * 8;
						}
					} else if (x64 == 2) {	// SYSV64
						if (i < 6) {
							static unsigned char tbl[6] = { 7, 6, 2, 1, 8, 9 };
							vr[0].alc0 = AEs_AlcReg;
							vr[0].alc1 = tbl[i];
						} else {
							vr[0].alc2 = (i - 6) * 8;
						}
					}
					px = AEs_X864_compileCpy(w, px, 0, p[i + 6]);
				}
				px = AEs_putX864P1(w, px, "3:0_1:%0;", p[4]);
				if (p[3] > 0)
					px = AEs_X864_compileCpy(w, px, p[3], -1);
				break;
			}
			p += p[1] * 5;
			break;
		case AEs_OpCpy:
			px = AEs_X864_compileCpy(w, px, p[1], p[2]);
			break;
		case AEs_OpCmpEq:
		case AEs_OpCmpNe:
		case AEs_OpCmpLt:
		case AEs_OpCmpGe:
		case AEs_OpCmpLe:
		case AEs_OpCmpGt:
			cc = condCode[p[0] - AEs_OpCmpEq];
			px = AEs_putX864P2(w, px, "6:0_000; 8:7_%f_8:%1;", p[2], p[3]);
			break;
		case AEs_OpCmpRnz:
			cc = 0x5;
			px = AEs_putX864P0(w, px, "11_0;");
			break;
		case AEs_OpCmpRtEqM1:
			cc = 0x4;
			px = AEs_putX864P0(w, px, "8:7_0_9:0:-1;");
			break;
		case AEs_OpSetCc:
			px = AEs_putX864P2(w, px, "6:1_111; c:%0_%f; 7_1;", cc, p[1]);
			break;
		case AEs_OpAdd:
		case AEs_OpSub:
		case AEs_OpMul:
		case AEs_OpDiv:
		case AEs_OpMod:
		case AEs_OpAnd:
		case AEs_OpXor:
		case AEs_OpOr:
			px = AEs_putX864P3(w, px, AEs_opBin[p[0] - AEs_OpAdd], p[1], p[2], p[3]);
			break;
		case AEs_OpShl:
			if (AEs_VirReg_isConstInt0(&vr[p[3]]) != 0) {
				px = AEs_putX864P3(w, px, "6:0_102; f:4_%f_0:%2; 7_0;", p[1], p[2], vr[p[3]].alc2);
			} else {
				px = AEs_putX864P3(w, px, "6:0_102; 4_1_8:%2; e:4_%f; 7_0;", p[1], p[2], p[3]);
			}
			break;
		case AEs_OpShr:
			if (AEs_VirReg_isConstInt0(&vr[p[3]]) != 0) {
				px = AEs_putX864P3(w, px, "6:0_102; f:7_%f_0:%2; 7_0;", p[1], p[2], vr[p[3]].alc2);
			} else {
				px = AEs_putX864P3(w, px, "6:0_102; 4_1_8:%2; e:7_%f; 7_0;", p[1], p[2], p[3]);
			}
			break;
		case AEs_OpNeg:
			px = AEs_putX864P3(w, px, "6:0_102; 12:3_%f; 7_0;", p[1], p[2], 0);
			break;
		case AEs_OpM64s:
			if (x64 == 0) {
				if (AEs_VirReg_isConstInt0(&vr[p[4]]) != 0) {
					px = AEs_putX864P4(w, px, "4_0_8:%1; a:5_8:%2; 14:c_2_c:0_0:%3; 5_0_8:%0;", p[1], p[2], p[3], vr[p[4]].alc2);
				} else {
					px = AEs_putX864P4(w, px, "4_0_8:%1; 4_1_8:%3; a:5_8:%2; 13:d_2_c:0; 5_0_8:%0;", p[1], p[2], p[3], p[4]);
				}
			} else {
				if (AEs_VirReg_isConstInt0(&vr[p[4]]) != 0) {
					px = AEs_putX864P4(w, px, "6:0_102; 9_%f_8:%2; f:7_%f_0:%3; 7_0;", p[1], p[2], p[3], vr[p[4]].alc2);
				} else {
					px = AEs_putX864P4(w, px, "6:0_102; 4_1_8:%3; 9_%f_8:%2; e:7_%f; 7_0;", p[1], p[2], p[3], p[4]);
				}
			}
			break;
		case AEs_OpArySet:
			i = 4;
			if (x64 != 0)
				i = 8;
			if (AEs_VirReg_isConstInt0(&vr[p[3]]) != 0) {
				if (AEs_X864_regVar(&vr[p[2]]) >= 0) {
					px = AEs_putX864P3(w, px, "6:0_222; 5_%f_5:%0:0:%1;", AEs_X864_regVar(&vr[p[2]]), AEs_VirReg_getConstInt(&vr[p[3]]) * i, p[4]);
				} else {
					px = AEs_putX864P3(w, px, "4_2_8:%0; 6:0_222; 5_%f_5:2:0:%1;", p[2], AEs_VirReg_getConstInt(&vr[p[3]]) * i, p[4]);
				}
			} else {
				if (AEs_X864_regVar(&vr[p[2]]) >= 0) {
					px = AEs_putX864P4(w, px, "4_1_8:%1; 6:0_222; 5_%f_6:%0:1:%3;", AEs_X864_regVar(&vr[p[2]]), p[3], p[4], i);
				} else {
					px = AEs_putX864P4(w, px, "4_2_8:%0; 4_1_8:%1; 6:0_222; 5_%f_6:2:1:%3;", p[2], p[3], p[4], i);
				}
			}
			break;
		case AEs_OpAryGet:
			i = 4;
			if (x64 != 0)
				i = 8;
			if (AEs_VirReg_isConstInt0(&vr[p[3]]) != 0) {
				if (AEs_X864_regVar(&vr[p[2]]) >= 0) {
					px = AEs_putX864P3(w, px, "6:1_000; 4_%f_5:%1:0:%2; 7_0;", p[1], AEs_X864_regVar(&vr[p[2]]), AEs_VirReg_isConstInt0(&vr[p[3]]) * i);
				} else {
					px = AEs_putX864P3(w, px, "4_2_8:%1; 6:1_000; 4_%f_5:2:0:%2; 7_0;", p[1], p[2], AEs_VirReg_getConstInt(&vr[p[3]]) * i);
				}
			} else {
				if (AEs_X864_regVar(&vr[p[2]]) >= 0) {
					px = AEs_putX864P4(w, px, "4_1_8:%2; 6:1_000; 4_%f_6:%1:1:%3; 7_0;", p[1], AEs_X864_regVar(&vr[p[2]]), p[3], i);

				} else {
					px = AEs_putX864P4(w, px, "4_2_8:%1; 4_1_8:%2; 6:1_000; 4_%f_6:2:1:%3; 7_0;", p[1], p[2], p[3], i);
				}
			}
			break;
		case AEs_OpVoid:
			px = AEs_putX864P1(w, px, "15_8:%0;", p[1]);
			break;
		default:
			aErrExit("AEs_X864_compile: internal error #0: %d", (int) p[0]);
		}
		sp->s = (char *) px - sp->p;
	}
	return (sp->s - s0) / sizeof (AEs_X864);
}

ASTATIC void AEs_X864_setStk(AEs_X864_Man *xm, AInt stksz, AInt bpOfs)
{
	AEs_X864 *px0 = (AEs_X864 *) xm->x864.p;
	px0[xm->stkEnt].dsp = stksz;
	px0[xm->stkRet].dsp = stksz;
	px0[xm->stkEnt + 1].dsp = bpOfs;
	px0[xm->stkEnt + 1].mod |= 1;
	px0[xm->stkEnt + 1].len1 = 16;
	if ((bpOfs & 1) != 0) {
		px0[xm->stkEnt + 1].len0 = px0[xm->stkEnt + 1].len1 = 0;
	}
}

ASTATIC AInt AEs_X864_cmpModRm(AEs_X864 *q, AEs_X864 *r)
{
	if (q->mod == r->mod && q->bas == r->bas && q->idx == r->idx && q->scl == r->scl && q->tds == r->tds && q->dsp == r->dsp)
		return 0;
	return -1;
}

static AEs_X864 AEs_X864_optRegVal0[1] = {{
	0, 0, 0,						// op, sub, reg
	0xff, 0xff, 0xff, 0xff, 0xff,	// mod, bas, idx, scl, tds, tim
	0, 0, 0,						// tim, len0, len1
	0, 0, 0							// dsp, imm, vrIdx
}};

void AEs_X864_optClearRegVal(AEs_X864 **regVal)
{
	AInt i;
	for (i = 0; i < 16; i++) {
		regVal[i] = AEs_X864_optRegVal0;
	}
}

ASTATIC AInt AEs_X864_optimize(AEs_X864_Man *w, AEs_X864 *q0, AEs_X864 *q1)
{
	(void) w;
	AInt rv = 0;
	AEs_X864 *q, *r, *rr, *regVal[16];
	for (;;) {
		AInt rv0 = rv;
		for (q = q0; q < q1; q++) {
			if (q->op == 0x05) {
				for (r = q + 1; r < q1 && (r->op == 0x15 || r->op == 0x00); r++);
				if (r < q1 && r->op == 0x04 && q->reg == r->reg && AEs_X864_cmpModRm(q, r) == 0) {
					r->op = 0x00; r->vrIdx = 0;
					rv++;
					for (rr = r + 1; rr < q1; rr++) {
						if ((rr->op == 0x15 || rr->op == 0x05) && AEs_X864_cmpModRm(q, rr) == 0) {
							q->op = 0x00; q->vrIdx = 0;
							rv++;
							break;
						}
						if (AEs_X864_cmpModRm(q, rr) == 0) break;
						if (rr->op == 0x01 /* ret */ || rr->op == 0x03 /* call */ || rr->op == 0x0d /* jcc */ || rr->op == 0x10 /* deflbl */ || rr->op == 0x11 /* jrnz */) break;
					}
				}
			}
			if (q->op == 0x04) {
				for (r = q + 1; r < q1 && (r->op == 0x15 || r->op == 0x00); r++);
				if (r < q1 && r->op == 0x05 && q->reg == r->reg && AEs_X864_cmpModRm(q, r) == 0) {
					r->op = 0x00; r->vrIdx = 0;
					rv++;
					for (rr = r + 1; rr < q1; rr++) {
						if ((rr->op == 0x15 || rr->op == 0x04) && AEs_X864_cmpModRm(q, rr) == 0) {
							q->op = 0x00; q->vrIdx = 0;
							rv++;
							break;
						}
						if (q->reg == rr->reg) break;
						if (rr->op == 0x01 /* ret */ || rr->op == 0x03 /* call */ || rr->op == 0x0d /* jcc */ || rr->op == 0x10 /* deflbl */ || rr->op == 0x11 /* jrnz */) break;
					}
				}
			}
		}
		AEs_X864_optClearRegVal(regVal);
		for (q = q0; q < q1; q++) {
			if (q->op == 0x10 && q->sub == 0x00) { AEs_X864_optClearRegVal(regVal);
			} else if (q->op == 0x04) {	// MOV(load)
				if (AEs_X864_cmpModRm(q, regVal[q->reg]) == 0) {
					q->op = 0x00; q->vrIdx = 0;
					rv++;
				} else {
					regVal[q->reg] = q;
				}
			} else if (q->op == 0x05) {	;	// MOV(store)
			} else if (q->op == 0x08) {	// ADD - CMP
				if (q->sub != 7) {
					regVal[q->reg] = AEs_X864_optRegVal0;
				} else {	;
				}
			} else if (q->op == 0x0d) {	;	// Jcc
			} else if (q->op == 0x11) {	;	// TEST
			} else {
				AEs_X864_optClearRegVal(regVal);	// mȂ߂͈Ŝ߂ɃNAƂ.
			}
		}
		if (rv == rv0) break;
	}
	return rv;
}

ASTATIC void AEs_X864_dump(AEs_X864 *q, AEs_X864 *q1)
{
	for (; q < q1; q++) {
		printf("op=%x:%x reg=%x mod=%x bas=%x idx=%x scl=%x dsp=%x\n", q->op, q->sub, q->reg, q->mod, q->bas, q->idx, q->scl, (int) q->dsp);
	}
}

ASTATIC AInt AEs_X864_getBinSiz(AEs_X864 *q, AEs_X864 *q1, AInt *ps0)
{
	AInt s0 = 0, s1 = 0;
	for (; q < q1; q++) {
		s0 += q->len0;
		s1 += q->len1;
	}
	if (ps0 != 0)
		*ps0 = s0;
	return s1;
}

ASTATIC unsigned char *AEs_X864_put32(unsigned char *p, AInt32 i)
{
	p[0] =  i        & 0xff;
	p[1] = (i >>  8) & 0xff;
	p[2] = (i >> 16) & 0xff;
	p[3] = (i >> 24) & 0xff;
	return p + 4;
}

AINLINESTATIC AEs_Indeterminate *AEs_X864_ind(AEs_Indeterminate *w, int opt, unsigned char t, AInt64 vp)
{
	w->t = t;
	w->vp = vp;
	w->opt = opt;
	return w;
}

AINLINESTATIC AEs_Indeterminate *AEs_X864_ind1(AEs_Indeterminate *w, int opt, unsigned char t, AInt64 vp)
{
	w->t = t;
	w->vp = vp;
	w->opt = opt | 0x10000;
	return w;
}

ASTATIC AInt AEs_X864_indBit0(AEs_Indeterminate *w)
// 0:[0,0], 1:[-128,+127], 2:[-2G,+2G], 3:ȏ.
{
	if (w->t == 0) {
		AInt64 vp = w->vp;
		if (vp == 0) return 0;
		if (-128 <= vp && vp <= 127) return 1;
	    if (-0x80000000LL <= vp && vp <= 0x7fffffffLL) return 2;
		return 3;
	}
	aErrExit("AEs_X864_indBit0: internal error #0");	// xT|[g.
	return -1;
}

ASTATIC AInt AEs_X864_indBit1(AEs_Indeterminate *w)
// 1:[0,4G], 0:ȏ.
{
	if (w->t == 0) {
		if (w->vp >= 0 && (w->vp >> 32) == 0) return 1;
		return 0;
	}
	aErrExit("AEs_X864_indBit1: internal error #0");	// xT|[g.
	return -1;
}

ASTATIC AInt AEs_X864_indBit2(AEs_Indeterminate *w, AEs_X864 *q, char x64, char mod, AEs *es, AEs_X864 *q00)
// 0:[0,0], 1:[-128,+127], 2:[-2G,+2G], 3:ȏ.
{
	(void) q;
	AEs_VirReg *vr = (AEs_VirReg *) es->vr.p;
	if (mod == 1) { 	// for near-call
		if (x64 == 0) return 2;
		if (w->t == 1 && vr[(AInt) w->vp].alc1 == 3) return 2;
		return 3;
	} else { 	// for near/short-jmp
		AEs_X864 *q0 = vr[(AInt) w->vp].alc2 + q00;
		AInt s0, s1;
		if (q0 <= q + 1) {
			s0 = - AEs_X864_getBinSiz(q0, q + 1, &s1);
			s1 = - s1;
		} else {
			s1 =   AEs_X864_getBinSiz( q + 1, q0, &s0);
		}
		if ((w->opt & 1) == 0) {
			if (s0 <= 0 && 0 <= s1) return 0;
			if (s0 <= +127 && -128 <= s1) return 1;
			return 2;
		} else {
			if (s0 == 0 && s1 == 0) return 0;
			if (-128 <= s0 && s1 <= +127) return 1;
			return 2;
		}
	}
	aErrExit("AEs_X864_indBit2: internal error #0");	// xT|[g.
	return -1;
}

enum { AEs_X864_Aft8_1, AEs_X864_Aft32_1 };

ASTATIC unsigned char *AEs_X864_put8aft(AEs_Indeterminate *w, unsigned char *p, ASP0 *aft, unsigned char rx)
{
	(void) aft; (void) rx;
	if (w->t == 0) {
		*p++ = w->vp & 0xff;
		return p;
	}
	aErrExit("AEs_X864_put8aft: internal error #0");	// xT|[g.
	return 0;
}

ASTATIC unsigned char *AEs_X864_put8aft1(AEs_Indeterminate *w, unsigned char *p, ASP0 *aft, AEs_X864 *q, AEs *es, AEs_X864 *q00)
// jmpp.
{
	if (w->t == 1) {
		AEs_VirReg *vr = (AEs_VirReg *) es->vr.p;
		ASP0_addInt4(aft, AEs_X864_Aft8_1, (AInt) p, (q + 1) - q00, vr[(AInt) w->vp].alc2);
		return p + 1;
	}
	aErrExit("AEs_X864_put8aft1: internal error #0");	// xT|[g.
	return 0;
}

ASTATIC unsigned char *AEs_X864_put32aft(AEs_Indeterminate *w, unsigned char *p, ASP0 *aft, unsigned char rx)
{
	(void) aft; (void) rx;
	if (w->t == 0) {
		return AEs_X864_put32(p, w->vp);
	}
	aErrExit("AEs_X864_put32aft: internal error #0");	// xT|[g.
	return 0;
}

ASTATIC unsigned char *AEs_X864_put32aft1(AEs_Indeterminate *w, unsigned char *p, ASP0 *aft, AEs_X864 *q, AEs *es, AEs_X864 *q00)
{
	if (w->t == 1) {
		AEs_VirReg *vr = (AEs_VirReg *) es->vr.p, *pvr = &vr[(AInt) w->vp];
		if (pvr->alc1 == 1) {	// jmpp.
			ASP0_addInt4(aft, AEs_X864_Aft32_1, (AInt) p, (q + 1) - q00, pvr->alc2);
			return p + 4;
		} else if (pvr->alc1 == 2) {
			return AEs_X864_put32(p, pvr->alc2 - (AInt) (p + 4));
		}
	}
	aErrExit("AEs_X864_put32aft1: internal error #0");	// xT|[g.
	return 0;
}

ASTATIC unsigned char *AEs_X864_put64aft(AEs_Indeterminate *w, unsigned char *p, ASP0 *aft, unsigned char rx, AEs *es)
{
	(void) aft; (void) rx;
	if (w->t == 1) {
		AEs_VirReg *vr = (AEs_VirReg *) es->vr.p, *pvr = &vr[(AInt) w->vp];
		if (pvr->alc1 == 2) {
			p = AEs_X864_put32(p, pvr->alc2);
			p = AEs_X864_put32(p, pvr->alc2 >> 32);
			return p;
		}
	}
	if (w->t == 0 || w->t == 2) {	// w->t == 2͂gĂȂ.
		p = AEs_X864_put32(p, w->vp);
		p = AEs_X864_put32(p, w->vp >> 32);
		return p;
	}
	aErrExit("AEs_X864_put64aft: internal error #0");	// xT|[g.
	return 0;
}

ASTATIC unsigned char *AEs_X864_put64aft1(AEs_Indeterminate *w, unsigned char *p, ASP0 *aft, unsigned char rx, AEs *es, AEs_X864 *q00)
{
	(void) w; (void) p; (void) aft; (void) rx;
	aErrExit("AEs_X864_put64aft1: internal error #0");	// xT|[g.
}

ASTATIC unsigned char *AEs_X864_putModRm(unsigned char *p, unsigned char *rx, AEs_X864 *q, unsigned char reg, int x64, int indOpt, ASP0 *aft)
{
	AEs_Indeterminate ind;
	if (reg >= 8) *rx |= 4;
	reg = (reg & 7) << 3;
	if (8 <= q->bas && q->bas <= 15) *rx |= 1;
	if (8 <= q->idx && q->idx <= 15) *rx |= 2;
	unsigned char bas = 0xff;
	if (q->bas <= 15) bas = q->bas & 7;
	if (q->mod == 12) {
		*p++ = 0xc0 | reg | bas;
		goto ret;
	} else /* if (q->mod < 8) */ {
		unsigned char sib = 0, modrm, width;
		width = AEs_X864_indBit0(AEs_X864_ind(&ind, indOpt, q->tds, q->dsp));
		if (width > 2) width = 2;
		if (bas == 5 && width == 0)
			width = 1;
		modrm = width << 6 | reg | bas;
		if (bas == 0xfe) {	// RIP.
			aErrExit("AEs_X864_putModRm: internal error #0");	// RIP.
		}
		if (bas == 0xff) {
			width = 2;
			modrm = reg | 0x05;
		}
		if (bas == 4 || q->idx <= 15 || (x64 != 0 && bas == 0xff)) {
			sib = modrm & 7;
			modrm = (modrm & 0xf8) | 4;
			if (q->idx == 0xff)
				sib |= 4 << 3;
			else {
				sib |= (q->idx & 7) << 3;
				if (q->scl == 2) sib |= 0x40;
				if (q->scl == 4) sib |= 0x80;
				if (q->scl == 8) sib |= 0xc0;
			}
		}
		*p++ = modrm;
		if ((modrm & 7) == 4)
			*p++ = sib;
		if (width == 1)
			p = AEs_X864_put8aft(&ind, p, aft, *rx);
		if (width == 2)
			p = AEs_X864_put32aft(&ind, p, aft, *rx);
		AEs_Indeterminate_deinit(&ind);
		goto ret;
	}
ret:
	return p;
}

ASTATIC unsigned char *AEs_X864_putBin0LoadImm(unsigned char *p, AEs_Indeterminate *ind, int reg, int x64, ASP0 *aft, AEs_X864_Man *w)
{
	int i = AEs_X864_indBit0(ind);
	if (w->usePushPop != 0 && i == 1) {
		*p++ = 0x6a;
		p = AEs_X864_put8aft(ind, p, aft, 0);
		if (reg >= 8) *p++ = 0x41;
		*p++ = 0x58 | (reg & 7);
		goto fin;
	}
	if (i == 0) {
		if (reg >= 8) *p++ = 0x45;
		*p++ = 0x31;
		*p++ = 0xc0 | ((reg & 7) * 9);
	} else if (x64 == 0) {
		*p++ = 0xb8 | reg;
		p = AEs_X864_put32aft(ind, p, aft, 0);
	} else if (AEs_X864_indBit1(ind) != 0) {
		if (reg >= 8) *p++ = 0x41;
		*p++ = 0xb8 | (reg & 7);
		p = AEs_X864_put32aft(ind, p, aft, 0);
	} else if (i <= 2) {
		*p = 0x48;
		if (reg >= 8) *p = 0x49;
		p++;
		*p++ = 0xc7;
		*p++ = 0xc0 | (reg & 7);
		p = AEs_X864_put32aft(ind, p, aft, 0);
	} else {
		*p = 0x48;
		if (reg >= 8) *p = 0x49;
		p++;
		*p++ = 0xb8 | (reg & 7);
		p = AEs_X864_put64aft(ind, p, aft, 0, w->es);
	}
fin:
	return p;
}

ASTATIC AInt AEs_X864_putBin0(AEs_X864_Man *w, AEs_X864 *q, AEs_X864 *q1, unsigned char *p, int x64, int indOpt, ASP0 *aft, AEs_X864 *q00)
{
	unsigned char *p0 = p, *pp, rx;
	AEs_Indeterminate ind;
	AInt i;
	ind.t = 0xff;
	for (; q < q1; q++) {
		pp = p;
		rx = 0;
		if (q->len1 == 0) continue;
		switch (q->op) {
		case 0x00:	// NOP
			break;
		case 0x01:	// RETN (no-wordcount)
			*p++ = 0xc3;
			break;
		case 0x02:	// PUSH (simple), POP(simple)
			if (q->reg >= 8) rx = 1;
			*p++ = 0x50 | (q->reg & 7) | q->sub << 3;
			break;
		case 0x04:	// MOV(load)
		case 0x16:	// LEA
			if (x64 != 0) rx = 8;
			if (q->mod == 12) {	// reg
				*p++ = 0x89;
				*p++ = 0xc0 | (q->bas & 7) << 3 | (q->reg & 7);
				if (q->bas >= 8) rx |= 4;
				if (q->reg >= 8) rx |= 1;
			} else if (q->mod == 9) {	// imm
				AEs_X864_ind(&ind, indOpt, q->tds, q->dsp);
				pp = p = AEs_X864_putBin0LoadImm(p, &ind, q->reg, x64, aft, w);
				rx = 0;
			} else if (q->mod < 8) {
				if (q->op == 0x04)
					*p++ = 0x8b;
				else
					*p++ = 0x8d;
				p = AEs_X864_putModRm(p, &rx, q, q->reg, x64, indOpt, aft);
			}
			break;
		case 0x05:	// MOV (store)
			if (x64 != 0) rx = 8;
			*p++ = 0x89;
			p = AEs_X864_putModRm(p, &rx, q, q->reg, x64, indOpt, aft);
			break;
		case 0x03:	// CALL(imm, relative-only), JMP(imm, relative-only)
			i = AEs_X864_indBit2(AEs_X864_ind1(&ind, indOpt, q->tim, q->imm), q, x64, 1, w->es, q00);	// jmpp(xԍĂĂĂ͂Ȃ).
			// tim=1:[Jx(Ƃvrԍ).
			// tim=2:΃AhX.
			if (q->sub == 1) {
				if (i == 0) break;
				if (i <= 1) {
					*p++ = 0xeb;
					p = AEs_X864_put8aft1(&ind, p, aft, q, w->es, q00);
					break;
				}
			}
			if (i <= 2 || q->sub == 1) {
				*p++ = 0xe8 | q->sub;
				p = AEs_X864_put32aft1(&ind, p, aft, q, w->es, q00);
			} else {
				*p++ = 0x48;
				*p++ = 0xb8;
				p = AEs_X864_put64aft(&ind, p, aft, rx, w->es);	// ΃[h.
				*p++ = 0xff; // CALL(RAX), JMP(RAX)
				if (q->op == 0x03)
					*p++ = 0xd0;
				else
					*p++ = 0xe0;
			}
			break;
		case 0x08:	// 8:0:ADD(r,r/m/i)
					// 8:1:OR(r,r/m/i)
					// 8:2:ADC
					// 8:3:SBB
					// 8:4:AND
					// 8:5:SUB
					// 8:6:XOR
					// 8:7:CMP
			if (x64 != 0) rx = 8;
			if (q->mod == 9) {	// imm
				i = AEs_X864_indBit0(AEs_X864_ind(&ind, indOpt, q->tds, q->dsp));
				if (w->useIncDec != 0) {
					if (x64 == 0 && q->sub == 0 && q->tds == 0 && q->dsp == 1) {
						*p++ = 0x40 | q->reg;
						break;
					}
					if (x64 == 0 && q->sub == 5 && q->tds == 0 && q->dsp == 1) {
						*p++ = 0x48 | q->reg;
						break;
					}
				}
				if (q->sub == 7 && i == 0) {	// CMP r,0  TEST r,r
					if (q->reg >= 8) rx = 8 | 4 | 1;
					*p++ = 0x85;
					*p++ = 0xc0 | ((q->reg & 7) * 9);
				} else if (i <= 1) {
					*p++ = 0x83;
					*p++ = 0xc0 | q->sub << 3 | (q->reg & 7);
					if (q->reg >= 8)
						rx |= 1;
					p = AEs_X864_put8aft(&ind, p, aft, rx);
				} else if (i >= 3 && x64 != 0) {
					// RCXoRɂ.
				} else if (q->reg == 0) {
					*p++ = 0x05 | q->sub << 3;
					p = AEs_X864_put32aft(&ind, p, aft, rx);
				} else {
					*p++ = 0x81;
					*p++ = 0xc0 | q->sub << 3 | (q->reg & 7);
					if (q->reg >= 8)
						rx |= 1;
					p = AEs_X864_put32aft(&ind, p, aft, rx);
				}
			} else {
				*p++ = 0x03 | q->sub << 3;
				p = AEs_X864_putModRm(p, &rx, q, q->reg, x64, indOpt, aft);
			}
			break;
		case 0x09:	// 09:IMUL
			if (x64 != 0) rx = 8;
			if (q->mod == 9) {	// imm
				i = AEs_X864_indBit0(AEs_X864_ind(&ind, indOpt, q->tds, q->dsp));
				if (i <= 1) {
					*p++ = 0x6b;
					*p++ = 0xc0 | ((q->reg & 7) * 9);
					if (q->reg >= 8)
						rx |= 5;
					p = AEs_X864_put8aft(&ind, p, aft, rx);
				} else if (i >= 3 && x64 != 0) {
					// RCXoRɂ,
				} else {
					*p++ = 0x69;
					*p++ = 0xc0 | ((q->reg & 7) * 9);
					if (q->reg >= 8)
						rx |= 5;
					p = AEs_X864_put32aft(&ind, p, aft, rx);
				}
			} else {
				*p++ = 0x0f;
				*p++ = 0xaf;
				p = AEs_X864_putModRm(p, &rx, q, q->reg, x64, indOpt, aft);
			}
			break;
		case 0x0a:	// 0a:IMUL,IDIV
			if (x64 != 0) rx = 8;
			if (q->mod == 9) {	// imm
				AEs_X864_ind(&ind, indOpt, q->tds, q->dsp);
				pp = p = AEs_X864_putBin0LoadImm(p, &ind, 1, x64, aft, w);
				*p++ = 0xf7;
				*p++ = 0xf9;
			} else {
				*p++ = 0xf7;
				p = AEs_X864_putModRm(p, &rx, q, q->sub, x64, indOpt, aft);
			}
			break;
		case 0x0b:	// 0b:CDQ(CQO)
			if (x64 != 0) *p++ = 0x48;
			*p++ = 0x99;
			break;
		case 0x0c:	// 0c:SETcc, MOVZX
			*p++ = 0x0f;
			*p++ = 0x90 | q->sub;
			*p++ = 0xc0;
			if (q->reg >= 8)
				*p++ = 0x44;
			*p++ = 0x0f;
			*p++ = 0xb6;
			*p++ = 0xc0 | (q->reg & 7) << 3;
			break;
		case 0x0d:	// 0d:Jcc
			i = AEs_X864_indBit2(AEs_X864_ind1(&ind, indOpt, q->tim, q->imm), q, x64, 0, w->es, q00);
			if (i == 0) break;
			if (i == 1) {
				*p++ = 0x70 | q->sub;
				p = AEs_X864_put8aft1(&ind, p, aft, q, w->es, q00);
			} else {
				*p++ = 0x0f;
				*p++ = 0x80 | q->sub;
				p = AEs_X864_put32aft1(&ind, p, aft, q, w->es, q00);
			}
			break;
		case 0x0e:	// SHL r,CL Ȃ.
			if (x64 != 0) rx = 8;
			if (q->reg >= 8) rx = 9;
			*p++ = 0xd3;
			*p++ = 0xc0 | q->sub << 3 | (q->reg & 7);
			break;
		case 0x0f:	// SHL r,imm Ȃ.
			if (x64 != 0) rx = 8;
			if (q->reg >= 8) rx = 9;
			if (q->tim == 0 && q->imm == 1) {
				*p++ = 0xd1;
				*p++ = 0xc0 | q->sub << 3 | (q->reg & 7);
			} else {
				*p++ = 0xc1;
				*p++ = 0xc0 | q->sub << 3 | (q->reg & 7);
				AEs_X864_ind(&ind, indOpt, q->tim, q->imm);
				p = AEs_X864_put8aft(&ind, p, aft, rx);
			}
			break;
		case 0x11:	// TEST
			if (x64 != 0) rx = 8;
			if (q->reg >= 8) rx = 8 | 4 | 1;
			*p++ = 0x85;
			*p++ = 0xc0 | ((q->reg & 7) * 9);
			break;
		case 0x12:	// NOT/NEG r
			if (x64 != 0) rx = 8;
			if (q->reg >= 8) rx = 9;
			*p++ = 0xf7;
			*p++ = 0xc0 | q->sub << 3 | (q->reg & 7);
			break;
		case 0x13:	// SHLD,SHRD r,CL
			if (x64 != 0) rx = 8;
			*p++ = 0x0f;
			*p++ = 0xa0 | q->sub;
			p = AEs_X864_putModRm(p, &rx, q, q->reg, x64, indOpt, aft);
			break;
		case 0x14:	// SHLD,SHRD r,imm
			if (x64 != 0) rx = 8;
			*p++ = 0x0f;
			*p++ = 0xa0 | q->sub;
			p = AEs_X864_putModRm(p, &rx, q, q->reg, x64, indOpt, aft);
			AEs_X864_ind(&ind, indOpt, q->tim, q->imm);
			p = AEs_X864_put8aft(&ind, p, aft, rx);
			break;
		default:
			aErrExit("AEs_X864_putBin: internal error #0 : op=0x%x", q->op);
		}
		if (rx != 0) {
			memmove(pp + 1, pp, p - pp);
			p++;
			*pp = rx | 0x40;
		}
		if (ind.t != 0xff) {
			AEs_Indeterminate_deinit(&ind);
			ind.t = 0xff;
		}
	}
	return p - p0;
}

ASTATIC AInt AEs_X864_optBinSiz(AEs_X864_Man *w, AEs_X864 *q, AEs_X864 *q1, int x64, AEs_X864 *q00)
{
	AInt s0 = 0, s1 = 0;
	unsigned char buf[256];
	ASP0 aft;
	ASP0_init(&aft, 256);
	for (; q < q1; q++) {
		if (q->len0 < q->len1) {
			aft.s = 0;
			q->len0 = AEs_X864_putBin0(w, q, q + 1, buf, x64, 0, &aft, q00);
			q->len1 = AEs_X864_putBin0(w, q, q + 1, buf, x64, 1, &aft, q00);
		}
		s0 += q->len0;
		s1 += q->len1;
	}
	ASP0_deinit(&aft);
	return s1 - s0;
}

ASTATIC AInt AEs_X864_putBin1(AEs_X864_Man *w, AEs_X864 *q, AEs_X864 *q1, unsigned char *p, AInt opt1)
{
	AInt i, ss = 0x7fffffff, tss;
	unsigned char *p0 = p;
	AEs_X864 *q00 = (AEs_X864 *) w->x864.p;
	for (i = 0; i < opt1; i++) {
		tss = AEs_X864_optBinSiz(w, q, q1, w->x64, q00);
		if (ss == tss || tss == 0) break;
		ss = tss;
	}
	ASP0_init(&w->aft, 256);
	for (; q < q1; q++) {
		q->len0 = q->len1 = AEs_X864_putBin0(w, q, q + 1, p, w->x64, 1, &w->aft, q00);
		p += q->len1;
	}
	AInt *ap = (AInt *) w->aft.p, as = w->aft.s / sizeof (AInt);
	for (i = 0; i < as;) {
		if (ap[i] == AEs_X864_Aft8_1 || ap[i] == AEs_X864_Aft32_1) {
			AInt s0, s1;
			if (ap[i + 3] <= ap[i + 2]) {
				s0 = - AEs_X864_getBinSiz(q00 + ap[i + 3], q00 + ap[i + 2], &s1);
				s1 = - s1;
			} else {
				s1 =   AEs_X864_getBinSiz(q00 + ap[i + 2], q00 + ap[i + 3], &s0);
			}
			if (ap[i] == AEs_X864_Aft8_1)
				*((unsigned char *) ap[i + 1]) = s1 & 0xff;
			if (ap[i] == AEs_X864_Aft32_1)
				AEs_X864_put32((unsigned char *) ap[i + 1], s1);
			i += 4;
			continue;
		}
		aErrExit("AEs_X864_putBin1: internal error #0 : ap[i]=%d", ap[i]);
	}
	ASP0_deinit(&w->aft);
	return p - p0;
}

char AEs_X864_regNam[2][16][5] = {
	{ "EAX", "ECX", "EDX", "EBX", "ESP", "EBP", "ESI", "EDI", "R8D", "R9D", "R10D", "R11D", "R12D", "R13D", "R14D", "R15D" },
    { "RAX", "RCX", "RDX", "RBX", "RSP", "RBP", "RSI", "RDI", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15" }
};

void AEs_X864_nasm_loadImm(ASP0 *asmout, AInt reg, AInt64 im, AInt x64, AEs_X864_Man *w, AInt vrIdx)
{
	char st[100];
	if (im != 0 && -128 <= im && im <= 127 && w->usePushPop != 0) {
		sprintf(st, "%-8s%d\n", "PUSH", (int) im);
		ASP0_addStr(asmout, st);
		ASP0_addStr(asmout, "        ");
		sprintf(st, "%-8s%s\n", "POP", AEs_X864_regNam[x64][reg]);
		ASP0_addStr(asmout, st);
		goto fin;
	}
	if (im == 0) {
		sprintf(st, "%-8s%s,%s\n", "XOR", AEs_X864_regNam[x64][reg], AEs_X864_regNam[x64][reg]);
		ASP0_addStr(asmout, st);
		goto fin;
	}
	AEs_VirReg *vr = 0;
	if (vrIdx > 0) {
		vr = AEs_getVr(&w->es->vr, vrIdx);
		if (vr->nam == 0)
			vr = 0;
	}
	if (x64 != 0 && (im >> 32) == 0) {
		if (vr != 0) {
			sprintf(st, "%-8s%s,%.*s\n", "MOV", AEs_X864_regNam[0][reg], vr->namLen, vr->nam);
		} else {
			sprintf(st, "%-8s%s,%d\n", "MOV", AEs_X864_regNam[0][reg], (int) im);
		}
		ASP0_addStr(asmout, st);
		goto fin;
	}
	if (vr != 0) {
		sprintf(st, "%-8s%s,%.*s\n", "MOV", AEs_X864_regNam[x64][reg], vr->namLen, vr->nam);
	} else {
		sprintf(st, "%-8s%s,%d\n", "MOV", AEs_X864_regNam[x64][reg], (int) im);
	}
	ASP0_addStr(asmout, st);
fin:
	;
}

void AEs_X864_nasm(AEs_X864_Man *w, AEs_X864 *q, AEs_X864 *q1, ASP0 *asmout)
{
	char st[100];
	AEs_VirReg *vr;
	AInt x64 = w->x64;
	if (x64 > 1) x64 = 1;
	static char tbl[][16] = {
		"\x01\x00""000RET",   "\x02\x00""100PUSH",  "\x02\x01""100POP",
		"\x03\x00""700CALL",  "\x03\x01""400JMP",   "\x04\x00""120MOV",  "\x05\x00""210MOV",
		"\x08\x00""120ADD",   "\x08\x01""120OR",    "\x08\x04""120AND",
		"\x08\x05""120SUB",   "\x08\x06""120XOR",   "\x08\x07""120CMP",
		"\x09\x00""120IMUL",  "\x0a\x05""200IMUL",  "\x0a\x07""200IDIV",
		"\x0c\x04""500SETE",  "\x0c\x05""500SETNE", "\x0c\x0c""500SETL",
		"\x0c\x0d""500SETGE", "\x0c\x0e""500SETLE", "\x0c\x0f""500SETG",
		"\x0d\x04""400JE",    "\x0d\x05""400JNE",   "\x0d\x0c""400JL",
		"\x0d\x0d""400JGE",   "\x0d\x0e""400JLE",   "\x0d\x0f""400JG",
		"\x0e\x07""160SAR",   "\x0f\x07""130SAR",
		"\x11\x00""110TEST",  "\x12\x03""100NEG",   "\x13\x0d""216SHRD", "\x14\x0c""213SHRD",
		"\x16\x00""120LEA",
		""
	};
	char *datTyp = "DWORD";
	if (w->x64 == 0)
		ASP0_addStr(asmout, "BITS 32\n");
	else {
		ASP0_addStr(asmout, "BITS 64\n");
		datTyp = "QWORD";
	}
	char *underSc = "_";
	if (w->nouseUnderSc != 0)
		underSc = "";
	ASP0_addStr(asmout, "SECTION .text\n");
	sprintf(st, "GLOBAL %saMain\n", underSc);
	ASP0_addStr(asmout, st);
    ASP0_addStr(asmout, "        ALIGNB  16\n");
	sprintf(st, "%saMain:\n", underSc);
    ASP0_addStr(asmout, st);
	for (; q < q1; q++) {
		AInt i, j, opsub = q->op << 8 | q->sub;
		if (opsub == 0x0000) continue;	// NOP
		if (opsub == 0x1500) continue;	// void
		if (opsub == 0x1000) {
			vr = AEs_getVr(&w->es->vr, q->imm);
			sprintf(st, ".%.*s:\n", vr->namLen, vr->nam);
			ASP0_addStr(asmout, st);
			continue;
		}
		if (q->len1 == 0) continue;
		ASP0_addStr(asmout, "        ");
		if (opsub == 0x0b00) {
			if (x64 == 0)
				ASP0_addStr(asmout, "CDQ\n");
			else
				ASP0_addStr(asmout, "CQO\n");
			continue;
		}
		for (i = 0; tbl[i][0] != 0; i++) {
			if (q->op == tbl[i][0] && q->sub == tbl[i][1]) break;
		}
		if (w->useIncDec != 0) {
			if (opsub == 0x0800 && q->tds == 0 && q->dsp == 1) {
				sprintf(st, "%-8s%s\n", "INC", AEs_X864_regNam[x64][q->reg]);
				ASP0_addStr(asmout, st);
				continue;
			}
			if (opsub == 0x0805 && q->tds == 0 && q->dsp == 1) {
				sprintf(st, "%-8s%s\n", "DEC", AEs_X864_regNam[x64][q->reg]);
				ASP0_addStr(asmout, st);
				continue;
			}
		}
		if (opsub == 0x0807 && q->tds == 0 && q->dsp == 0) {
			sprintf(st, "%-8s%s,%s\n", "TEST", AEs_X864_regNam[x64][q->reg], AEs_X864_regNam[x64][q->reg]);
			ASP0_addStr(asmout, st);
			continue;
		}
		if (opsub == 0x0400 && q->mod == 9 && q->tds == 0) {
			AEs_X864_nasm_loadImm(asmout, q->reg, q->dsp, x64, w, q->vrIdx);
			continue;
		}
		if (q->op == 0x0a && q->mod == 9 && q->tds == 0) {
			AEs_X864_nasm_loadImm(asmout, 1, q->dsp, x64, w, q->vrIdx);
			ASP0_addStr(asmout, "        ");
			if (q->sub == 0x05) {
				sprintf(st, "%-8s%s\n", "IMUL", AEs_X864_regNam[x64][1]);
			} else if (q->sub == 0x07) {
				sprintf(st, "%-8s%s\n", "IDIV", AEs_X864_regNam[x64][1]);
			}
			ASP0_addStr(asmout, st);
			continue;
		}
		if (tbl[i][0] == 0) {
			sprintf(st, "(op=%x, sub=%x)\n", q->op, q->sub);
			ASP0_addStr(asmout, st);
		} else {
			sprintf(st, "%-8s", &tbl[i][5]);
			ASP0_addStr(asmout, st);
			for (j = 0; j < 3; j++) {
				char c = tbl[i][2 + j];
				if (c == '0') break;
				if (j > 0)
					ASP0_addStr(asmout, ",");
				switch (c) {
				case '1':
					ASP0_addStr(asmout, AEs_X864_regNam[x64][q->reg]);
					break;
				case '2':
					if (q->mod == 12) {
						ASP0_addStr(asmout, AEs_X864_regNam[x64][q->bas]);
					} else if (q->mod == 9) {
						vr = AEs_getVr(&w->es->vr, q->vrIdx);
						if (q->vrIdx > 0 && vr->nam != 0) {
							ASP0_addStr0(asmout, vr->nam, vr->namLen);
						} else {
							sprintf(st, "%d", (int) q->dsp);
							ASP0_addStr(asmout, st);
						}
					} else if (q->mod == 6) {
						sprintf(st, "%s [%s+%s*%d]", datTyp, AEs_X864_regNam[x64][q->bas], AEs_X864_regNam[x64][q->idx], q->scl);
						ASP0_addStr(asmout, st);
					} else if (q->mod == 5) {
						sprintf(st, "%s [%s%+d]", datTyp, AEs_X864_regNam[x64][q->bas], (int) q->dsp);
						ASP0_addStr(asmout, st);
					} else if (q->mod == 4) {
						sprintf(st, "%s [%s]", datTyp, AEs_X864_regNam[x64][q->bas]);
						ASP0_addStr(asmout, st);
					} else {
						sprintf(st, "(mod=%d)", q->mod);
						ASP0_addStr(asmout, st);
					}
					// mod: 0:StB[hgp, 1:[dsp], 2:[idx*scl], 4:[bas], 8:virtualRegister, 9:imm, 12:reg
					break;
				case '3':
					sprintf(st, "%d", (int) q->imm);
					ASP0_addStr(asmout, st);
					break;
				case '4':
					vr = AEs_getVr(&w->es->vr, q->imm);
					ASP0_addStr(asmout, ".");
					ASP0_addStr0(asmout, vr->nam, vr->namLen);
					break;
				case '5':
					ASP0_addStr(asmout, "AL");
					break;
				case '6':
					ASP0_addStr(asmout, "CL");
					break;
				case '7':
					vr = AEs_getVr(&w->es->vr, q->imm);
					if (w->nouseUnderSc != 0 && strncmp(vr->nam, "_sub_", 5) == 0) {
						ASP0_addStr0(asmout, vr->nam + 1, vr->namLen - 1);
					} else {
						ASP0_addStr0(asmout, vr->nam, vr->namLen);
					}
					break;
				}
			}
			ASP0_addStr(asmout, "\n");
			if (q->op == 0x0c) {
				ASP0_addStr(asmout, "        ");
				sprintf(st, "%-8s%s,AL\n", "MOVZX", AEs_X864_regNam[0][q->reg]);
				ASP0_addStr(asmout, st);
			}
		}
	}
}

// VRɑ΂Ă肽ƁB
//  typ0, typ1, name, alc
//		memȂ: base, offset
//		regȂ: reg
//		constȂ: Value
//		labelȂ


