#include <acl.c>
#include "esvm.c"
#include "esvm_run.c"
#include "esvm_x864.c"
//#include "esvm_x86_mini1.c"

typedef unsigned char *String;	//  String  unsigned char * ̑pɂȂ.

ASP0 *loadText(ASP0 *sp, String path)
{
	unsigned char s[1000];
	int i = 0, j;
	if (path[0] == 34) { i = 1; } // _uNH[g΂͂.
	for (j = 0; ; j++) {
		if (path[i + j] == 0 || path[j + i] == 34)
			break; // t@C̖ɗ炻ŏI.
		s[j] = path[i + j];
	}
	s[j] = 0;
	sp = ASP0_loadFile(sp, s, 1);
	if (sp->p == 0)
		printf("fopen error : %s\n", path);
	return sp;
}

///////////////////////////////////////////////////////////////////////////////

#define MAX_TC  1000 // g[NR[h̍ől.
String ts[MAX_TC + 1]; // g[N̓e()L.
int tl[MAX_TC + 1]; // g[N̒.
unsigned char tcBuf[(MAX_TC + 1) * 10]; // g[N1蕽10oCgz.
int tcs = 0, tcb = 0;

AInt var[MAX_TC + 1];	// ϐ.

int extConst(String s)
{
	int l = strlen(s);
	if (l == 3 && s[0] == 39 && s[2] == 39) return s[1];
	if (strcmp(s, "AKEY_ENTER") == 0) return 10;
	if (strcmp(s, "AOPT_Cf") == 0) return 1;
	if (strcmp(s, "AOPT_Rf") == 0) return 2;
	if (strcmp(s, "AOPT_RfCf") == 0) return 3;
	if (strcmp(s, "AOPT_Gn") == 0) return 4;
	if (strcmp(s, "AOPT_GnCf") == 0) return 5;
	if (strcmp(s, "AOPT_GnRf") == 0) return 6;
	if (strcmp(s, "AOPT_GnRfCf") == 0) return 7;
	if (strcmp(s, "CF") == 0) return 1;
	if (strcmp(s, "RF") == 0) return 2;
	if (strcmp(s, "GN") == 0) return 4;
	if (strcmp(s, "'\\0'") == 0) return '\0';
	if (strcmp(s, "'\\1'") == 0) return '\1';
	if (strcmp(s, "'\\2'") == 0) return '\2';
	if (strcmp(s, "'\\3'") == 0) return '\3';
	if (strcmp(s, "'\\4'") == 0) return '\4';
	if (strcmp(s, "'\\5'") == 0) return '\5';
	if (strcmp(s, "'\\6'") == 0) return '\6';
	if (strcmp(s, "'\\7'") == 0) return '\7';
	if (strcmp(s, "'\\n'") == 0) return '\n';
	if (strcmp(s, "'\\t'") == 0) return '\t';
	if (strcmp(s, "'\\b'") == 0) return '\b';
	if (strcmp(s, "'\\r'") == 0) return '\r';
	if (strcmp(s, "$$1") == 0) return -1;	// VXe萔.
	return -999;
}

int getTc(String s, int len) // g[Nԍ𓾂邽߂̊֐.
{
	int i;
	for (i = 0; i < tcs; i++) { // o^ς݂̒T.
		if (len == tl[i] && strncmp(s, ts[i], len) == 0)
			break;
	}
	if (i == tcs) {
		if (tcs >= MAX_TC) {
			printf("too many tokens\n");
			exit(1);
		}
		strncpy(&tcBuf[tcb], s, len); // Ȃ̂ŐVKo^.
		tcBuf[tcb + len] = 0; // I[R[h.
		ts[i] = &tcBuf[tcb];
		tl[i] = len;
		tcb += len + 1;
		tcs++;
		var[i] = strtol(ts[i], 0, 0);	// 萔ꍇɏlݒi萔ł͂ȂƂ0ɂȂj.
		if (ts[i][0] == 34) { // 擪_uNH[e[V
			char *p = malloc(len - 1);
			var[i] = (AInt) p;
			AInt j, k = 0;
			for (j = 1; j < len - 1;) {
				if (ts[i][j] == '\\') {
					if (ts[i][j + 1] == 'n')
						p[k] = '\n';
					j += 2;
				} else {
					p[k] = ts[i][j];
					j++;
				}
				k++;
			}
	//		memcpy(p, ts[i] + 1, len - 2); // 蔲.
	//		p[len - 2] = 0;
			p[k] = 0;
		}
		if (var[i] == 0) {
			var[i] = extConst(ts[i]);
			if (var[i] == -999) var[i] = 0;
		}
	}
	return i;
}

///////////////////////////////////////////////////////////////////////////////

int isAlphabetOrNumber(unsigned char c)		// ϐɎgpł镶ǂ.
{
	if ('0' <= c && c <= '9') return 1;
	if ('a' <= c && c <= 'z') return 1;
	if ('A' <= c && c <= 'Z') return 1;
	if (c == '_' || c == '@' || c == '$') return 1;
	return 0;
}

int lexer(String s, AInt tc[], String pos[])		// vOg[NR[hɕϊ.
{
	int i = 0, j = 0, len; // i:s[]̂ǂǂł邩Aj:܂łɕϊg[N̒.
	for (;;) {
		if (s[i] == ' ' || s[i] == '\t' || s[i] == '\n' || s[i] == '\r') {	// Xy[XA^uAs.
			i++;
			continue;
		}
		if (s[i] == 0)	// t@CI[.
			return j;
		len = 0;
		if (strchr("(){}[];,\\", s[i]) != 0) {	// 1L.
			len = 1;
		} else if (isAlphabetOrNumber(s[i])) {  // 1ڂp.
			while (isAlphabetOrNumber(s[i + len]))
				len++;
		} else if (strchr("=+-*/!%&~^|<>?:.#", s[i]) != 0) {  // 1ڂʂ̋L.
			while (strchr("=+-*/!%&~^|<>?:.#", s[i + len]) != 0 && s[i + len] != 0)
				len++;
		} else if (s[i] == 34 || s[i] == 39) {	// "" or ''.
			len = 1;
			while (s[i + len] != s[i] && s[i + len] >= ' ')
				len++;
			if (s[i + len] == s[i])
				len++;
		} else {
			printf("syntax error : %.10s\n", &s[i]);
			exit(1);
		}
		if (strncmp(&s[i], "//", 2) == 0) {	// Rg.
comment:
			while (s[i] != 0 && s[i] != '\n')
				i++;
			continue;
		}
		if (len == 7 && strncmp(&s[i], "include", 7) == 0) goto comment;	// include Rg().
		if (len == 5 && strncmp(&s[i], "ifdef",   5) == 0) goto comment;
		if (len == 6 && strncmp(&s[i], "ifndef",  6) == 0) goto comment;
		if (len == 5 && strncmp(&s[i], "endif",   5) == 0) goto comment;
		tc[j] = getTc(&s[i], len);
		pos[j] = &s[i];
		i += len;
		j++;
	}
}

AInt tc[10000];	// g[NR[h.
String tcpos[10000];

enum { TcSemi = 0, TcDot, TcWiCard, TcExpr, TcExpr0, Tc0, Tc1, Tc2, Tc3, Tc4, Tc5, Tc6, Tc7, Tc8, TcBrOpn, TcBrCls, TcSqBrOpn, TcSqBrCls, TcCrBrOpn, TcCrBrCls,
	TcEEq, TcNEq, TcLt, TcGe, TcLe, TcGt, TcPlus, TcMinus, TcAster, TcSlash, TcPerce, TcAnd, TcXor, TcOr, TcShl, TcShr, TcAAnd, TcOOr,
	TcPlPlus, TcMiMinus, TcNot, TcEqu, TcPlEq, TcMiEq, TcAsEq, TcSlEq, TcPrEq, TcAnEq, TcXrEq, TcOrEq, TcShlEq, TcShrEq, TcComma,
	TcTmp0, TcTmp1, TcTmp2, TcTmp3, TcTmp4, TcTmp5, TcTmp6, TcTmp7, TcTmp8, TcTmp9, TcThen, TcGoto, TcBreak, TcCont, TcAND, TcOR, TcNOT, TcRepC, TcMns1,
	TcSbPrint, TcSbTime, TcSbRgb8, TcSbXorShft, TcSbGetPix, TcSbF16Sin, TcSbF16Cos, TcSbInkey, TcSbPrints, TcSbSetPix0, TcSbFillRect, TcSbFillOval, TcSbDrawStr,
	TcSbOpnWin, TcSbWait, TcSbBitblt, TcSbAryNew, TcSbAryInit, TcSbPrintf, TcSbInputInt, TcSbDbgTestInt, TcSbOpnWinEx, TcSbRnd, TcSbCls, TcSbGrPrint, TcSbEch,
	TcSbEchBox, TcSbInkeyWRC, TcSbSatuInt, TcSbWaitKey, TcSbMovDx, TcSbMovDy, TcSbInkeyWR, TcSbScroll8, TcSbGetEch, TcSbEchSav, TcSbGetEchCol, TcSbGetEchBak,
	TcSbGetEchBox, TcSbArySetInt, TcSbAryMovInt, TcSbUpper, TcSbLower, TcSbMaxInt, TcSbMinInt, TcSbArgMaxRndInt, TcSbDrawRect, TcSbDrawOval, TcSbDrawLine,
	TcSbFill, TcSbClrKeybuf, TcSbInkeyWait, TcSbGetPal, TcSbGetEchBoxCol, TcSbGetEchBoxBak, TcSbDrawOvalCent, TcSbFillOvalCent, TcSbSetPix, TcSbLeapFlush
};

char tcInit[] = "; . !!* !!** !!*** 0 1 2 3 4 5 6 7 8 ( ) [ ] { } == != < >= <= > + - * / % & ^ | << >> && || ++ -- ! = += -= *= /= %= &= ^= |= <<= >>= ,"
	" _t0 _t1 _t2 _t3 _t4 _t5 _t6 _t7 _t8 _t9 THEN GOTO BREAK CONTINUE AND OR NOT aRepC $$1 _sub_print _sub_time _sub_aRgb8 _sub_XorShift _sub_getPix"
	" _sub_f16Sin _sub_f16Cos _sub_aInkey _sub_prints _sub_setPix0 _sub_fillRect _sub_fillOval _sub_drawStr _sub_OpnWin _sub_aWait _sub_bitblt _sub_aryNew"
	" _sub_aryInit _sub_printf _sub_inputInt _sub_dbgTestInt _sub_opnWinEx _sub_rnd _sub_cls _sub_grPrintf _sub_ech _sub_echBox _sub_inkeyWRC _sub_satuInt"
	" _sub_waitKey _sub_movDx sub_movDy _sub_inkeyWR _sub_scroll8 _sub_getEch _sub_echSav _sub_getEchCol _sub_getEchBak _sub_getEchBox _sub_arySetInt"
	" _sub_aryMovInt _sub_upper, _sub_lower _sub_maxInt _sub_minInt _sub_argMaxRndInt _sub_drawRect _sub_drawOval _sub_drawLine _sub_fill _sub_clrKeyBuf"
	" _sub_inkeyWait _sub_getPal _sub_getEchBoxCol _sub_getEchBoxBak _sub_drawOvalCent _sub_fillOvalCent _sub_setPix _sub_leapFlush";

#define TCSBLAST	TcSbLeapFlush

///////////////////////////////////////////////////////////////////////////////

AInt phrCmp_tc[900 * 64], ppc1, wpc[9], wpc1[9], closBlk; // ppc1:vt[Y̎̃g[N, wpc[]:ChJ[h̃g[N̏ꏊ.

int phrCmp(int pid, String phr, int pc)
{
	int i0 = pid * 64, i, i1, j, k, t;
	if (phrCmp_tc[i0 + 63] == 0) {
		String phrCmp_tcpos[64];
		i1 = lexer(phr, &phrCmp_tc[i0], phrCmp_tcpos);
		phrCmp_tc[i0 + 63] = i1;
	}
	i1 = phrCmp_tc[i0 + 63];
	for (i = 0; i < i1; i++) {
//if (pid ==153&&i>0) printf("[%d]", i);
		if (i == 0) {
			if (phrCmp_tc[i0 + 0] == TcCrBrCls) {
				if (closBlk != 0) continue;
				return 0;
			} else {
				if (closBlk != 0) return 0;
			}
		}
		t = phrCmp_tc[i0 + i];
		if (t == TcWiCard || t == TcExpr || t == TcExpr0) {
			i++;
			j = phrCmp_tc[i0 + i] - Tc0; // 㑱̔ԍ擾.
			wpc[j] = pc;
			if (t == TcWiCard) {
				pc++;
				continue;
			}
			k = 0; // JbR̐[.
			for (;;) {
				if (tc[pc] == TcSemi || tc[pc] == TcThen || tc[pc] == TcGoto || tc[pc] == TcBreak || tc[pc] == TcCont) break;
				if (tc[pc] == TcComma && k == 0) break;
				if (tc[pc] == TcBrOpn || tc[pc] == TcSqBrOpn) k++;
				if (tc[pc] == TcBrCls || tc[pc] == TcSqBrCls) k--;
				if (k < 0) break;
				pc++;
			}
			wpc1[j] = pc;
			if (t == TcExpr && wpc[j] == pc) return 0; // "!!**"ł́A0͕svƂ.
			if (k > 0) return 0; // JbR̐[svƂ.
			continue;
		}
		if (t != tc[pc]) return 0; // }b`.
		pc++;
	}
	ppc1 = pc;
	return 1; // }b`.
}

///////////////////////////////////////////////////////////////////////////////

AInt opBin[] = {
	AEs_OpCmpEq, AEs_OpCmpNe, AEs_OpCmpLt, AEs_OpCmpGe, AEs_OpCmpLe, AEs_OpCmpGt,
	AEs_OpAdd, AEs_OpSub, AEs_OpMul, AEs_OpDiv, AEs_OpMod, AEs_OpAnd, AEs_OpXor, AEs_OpOr, AEs_OpShl, AEs_OpShr
};

AInt regVarTbl[8];
char regVarNo0[3][8] = {
	{ 3, 6,  7,  5,  0,  0,  0,  0 },
	{ 3, 6,  7,  5, 12, 13, 14, 15 },
	{ 3, 5, 12, 13, 14, 15,  0,  0 }
};
char regVarNo[8], regVarLen;

void setRegVarNo(AInt cmod, AInt useBp)
{
	AInt i;
	regVarLen = 0;
	for (i = 0; i < 8; i++) {
		char c = regVarNo0[cmod - 1][i];
		if (c == 0) break;
		if (c == 5 && useBp != 0) continue;
		regVarNo[(AInt) (regVarLen++)] = c;
	}
}

int isConst(int i)
{
	if ('0' <= ts[i][0] && ts[i][0] <= '9') return 1;
	if (ts[i][0] == '-' && '0' <= ts[i][1] && ts[i][1] <= '9') return 1;
	if (ts[i][0] == 34) return 1;
	if (extConst(ts[i]) != -999) return 1;
	return 0;
}

AEs es;
unsigned char *ic, *icq; // ic[]:R[hAicq:ic[]ւ̏ݗp|C^.
int vc[MAX_TC + 1];

///////////////////////////////////////////////////////////////////////////////

char tmp_flag[10];

int tmpAlloc()
{
	int i;
	for (i = 0; i < 10; i++) {
		if (tmp_flag[i] == 0) break;
	}
	if (i >= 10) {
		printf("tmpAlloc: error\n");
		return -1;
	}
	tmp_flag[i] = 1;
	return i + TcTmp0;
}

void tmpFree(int i)
{
	if (TcTmp0 <= i && i <= TcTmp9) {
		if (tmp_flag[i - TcTmp0] != 0) {
			AEs_putIcP2(&es, AEs_OpVoid, i, 0);
			tmp_flag[i - TcTmp0] = 0;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////

int toExit, toExitFlg;
int codemode, codeopt; // 0.0: esvm_run, 1.0:x86-win32, 1.1:x86-linux, 2.0:x64-win, 2.1:x64-linux
int codedump;	// 0:run, 1:bin-dump, 2:asm
int optmode = 0;
int opnWinFulClr = 1;

clock_t t0;
AWindow *win;

AInt testInkey(AInt i)
{
	if (i == 27) toExitFlg = -1;
	return i;
}

AInt16 xvsz, yvsz;

void sub_clrKeyBuf()					{ while (testInkey(aInkey(win, 1)) != 0); }
void sub_print(AInt i)					{ printf("%d\n", (int) i); }
void sub_time()							{ printf("time: %.3f[sec] (codemode=%d, optmode=%d)\n", (clock() - t0) / (double) CLOCKS_PER_SEC, codemode, optmode); }
void sub_fillRect(AInt opt, AInt xs, AInt ys, AInt x, AInt y, AInt c) { aFillRectOpt(win, opt, xs, ys, x, y, c); }
void sub_drawRect(AInt opt, AInt xs, AInt ys, AInt x, AInt y, AInt c) { aDrawRectOpt(win, opt, xs, ys, x, y, c); }
void sub_fillOval(AInt opt, AInt xs, AInt ys, AInt x, AInt y, AInt c) { aFillOvalOpt(win, opt, xs, ys, x, y, c); }
void sub_drawOval(AInt opt, AInt xs, AInt ys, AInt x, AInt y, AInt c) { aDrawOvalOpt(win, opt, xs, ys, x, y, c); }
void sub_drawLine(AInt opt, AInt x0, AInt y0, AInt x1, AInt y1, AInt c) { aDrawLineOpt(win, opt, x0, y0, x1, y1, c); }
void sub_setPix(AInt opt, AInt x, AInt y, AInt c) { aSetPixOpt(win, opt, x, y, c); }
void sub_setPix0(AInt x, AInt y, AInt c) { aSetPix0(win, x, y, c); }
AInt sub_getPix(AInt opt, AInt x, AInt y) { return aGetPixOpt(win, opt, x, y); }
void sub_drawStr(AInt opt, AInt x, AInt y, AInt c, AInt b, const char *s) { aDrawStrOpt(win, opt, x, y, c, b, s); }
void sub_ech(AInt opt, AInt x, AInt y, AInt ch, AInt c, AInt b) { aEchOpt(win, opt, x, y, ch, c, b); }
AInt sub_getEch(AInt opt, AInt x, AInt y) { return aGetEchOpt(win, opt, x, y, 0); }
AInt sub_getEchCol(AInt opt, AInt x, AInt y) { return aGetEchOpt(win, opt, x, y, 1); }
AInt sub_getEchBak(AInt opt, AInt x, AInt y) { return aGetEchOpt(win, opt, x, y, 2); }
void sub_echBox(AInt opt, AInt xs, AInt ys, AInt x, AInt y, AInt ch, AInt c, AInt b) { aEchBoxOpt(win, opt, xs, ys, x, y, ch, c, b); }
AInt sub_getEchBox(AInt opt, AInt xs, AInt ys, AInt x, AInt y) { return aGetEchBoxOpt(win, opt, xs, ys, x, y, 0); }
AInt sub_getEchBoxCol(AInt opt, AInt xs, AInt ys, AInt x, AInt y) { return aGetEchBoxOpt(win, opt, xs, ys, x, y, 1); }
AInt sub_getEchBoxBak(AInt opt, AInt xs, AInt ys, AInt x, AInt y) { return aGetEchBoxOpt(win, opt, xs, ys, x, y, 2); }
void sub_echSav(AInt opt, AInt x, AInt y, AInt ch, AInt c, AInt b) { aEchSavOpt(win, opt, x, y, ch, c, b); }
void sub_scroll8(AInt opt, AInt xs, AInt ys, AInt x, AInt y, AInt dx, AInt dy, AInt mod) { aScrollOpt(win, opt, xs, ys, x, y, dx, dy, mod, 0, 0, 0); }
void sub_grPrintf(AInt opt, AInt x, AInt y, AInt c, AInt b, const char *f, AInt a0, AInt a1, AInt a2, AInt a3) { aGrPrintfOpt(win, opt, x, y, c, b, f, a0, a1, a2, a3); }
void sub_fillOvalCent(AInt opt, AInt x, AInt y, AInt a, AInt b, AInt c) { aFillOvalCentOpt(win, opt, x, y, a, b, c); }
void sub_drawOvalCent(AInt opt, AInt x, AInt y, AInt a, AInt b, AInt c) { aDrawOvalCentOpt(win, opt, x, y, a, b, c); }
void sub_fill(AInt opt, AInt x, AInt y, AInt c) { aFillOpt(win, opt, x, y, c); }
AInt sub_aRgb8(AInt r, AInt g, AInt b)	{ return aRgb8(r, g, b); }
AInt sub_XorShift()						{ return aXorShift32(); }
AInt sub_f16Sin(AInt x)					{ return (AInt) (sin(x * (2 * 3.14159265358979323 / 65536)) * 65536); }
AInt sub_f16Cos(AInt x)					{ return (AInt) (cos(x * (2 * 3.14159265358979323 / 65536)) * 65536); }
AInt sub_aInkey(AInt opt)				{ return testInkey(aInkey(win, opt)); }
void sub_prints(char *s)				{ printf("%s\n", s); }
//void sub_gprDec(int x, int y, int w, int c, int b, int i)   { char s[100]; sprintf(s, "%*d", w, i); aDrawStr0(win, x, y, c, b, s); }
void sub_printf(char *s, AInt a, AInt b, AInt c, AInt d)    { printf(s, a, b, c, d); }
AInt sub_inputInt()						{ int i; scanf("%d", &i); return i; }
AInt sub_dbgTestInt(AInt i)				{ printf("dbgTestInt:%d\n", i); return i; }
void sub_leapFlush(AInt ms)				{ aLeapFlushAll(win, ms); }

AInt sub_OpnWin(AInt xsz, AInt ysz, char *s)
{
	if (win != 0) {
		if (win->xsiz < xsz || win->ysiz < ysz) {
			printf("openWin error\n");
			return 1;
		}
		win->optDef = 7;
		if (opnWinFulClr != 0) {
			aFillRectOpt(win, AOPT_Rf, win->xsiz, win->ysiz, 0, 0, 0);
			aFillRectOpt(win, AOPT_RfCf, xsz + 2, ysz + 2, 0, 0, 0xffffff);
			aFillRectOpt(win, AOPT_Rf, xsz, ysz, 0, 0, 0);
			aClrKeybuf(win);
		}
	} else
		win = aOpenWin(xsz, ysz, s, 0);
	xvsz = xsz;
	yvsz = ysz;
	return 0;
}

AInt sub_aWait(AInt msec)
{
	if (msec == -1) {
		if (win != 0) {
			aFlushAll(win);
		}
		for (;;) {
			if (testInkey(aInkey(win, 1)) == 0) {
				if (toExitFlg != 0) return -1;
				aWait(127);
			}
		}
	}
	aWait(msec);
	return 0;
}

void sub_cls(AInt opt, AInt c)
{
	/* aClsOpt(win, opt, c); */
	if (opt == -1) opt = win->optDef;
	aFillRectOpt(win, opt | AOPT_Rf, xvsz, yvsz, 0, 0, c);
	int i;
	for (i = 0; i < 16; i++)
		win->savXy[i * 2 + 0] = 0x7fffffff;
	if ((opt & 4) == 0)
		memset(win->cb, 0, win->cbxs * win->cbys * (3 * sizeof (AInt32a)));
}

void sub_bitblt(AInt xsz, AInt ysz, AInt x0, AInt y0, AInt *a)
{
	AInt32 *p32 = &win->buf[x0 + y0 * win->xsiz];
	int i, j;
	for (j = 0; j < ysz; j++) {
		for (i = 0; i < xsz; i++) {
			p32[i] = a[i];
		}
		a += xsz;
		p32 += win->xsiz;
	}
}

AInt *sub_aryNew(int n)
{
	AInt *p = malloc(n * sizeof (AInt));
	memset((char *) p, 0, n * sizeof (AInt));
	return p;
}

void sub_aryInit(AInt *a, AInt *ip)
{
	memcpy((char *) a, (char *) ip, ip[-1] * sizeof (AInt));
}

AInt sub_opnWinEx(AInt xsz, AInt ysz, char *s)
{
	if (win != 0) {
		if (win->cb == 0 || xsz * 16 > win->xsiz || ysz * 16 > win->ysiz) {
			printf("openWinEx error\n");
			return 1;
		}
		win->optDef = 0;
		if (opnWinFulClr != 0) {
			aFillRectOpt(win, AOPT_Rf, win->xsiz, win->ysiz, 0, 0, 0);
			aFillRectOpt(win, AOPT_Rf, xsz * 16 + 2, ysz * 16 + 2, 0, 0, 7);
			aFillRectOpt(win, AOPT_Rf, xsz * 16, ysz * 16, 0, 0, 0);
			aClrKeybuf(win);
		}
	} else
		win = aOpenWinEx(xsz, ysz, s, 0);
	xvsz = xsz * 16;
	yvsz = ysz * 16;
	return 0;
}

AInt sub_waitKey(AInt k)
{
	if (win != 0)
		aFlushAll(win);
	for (;;) {
		AInt i = testInkey(aInkey(win, 1));
		if (i == k) break;
		if (toExitFlg != 0) return -1;
		if (i == 0)
			aWait(127);
	}
	return 0;
}

AInt sub_rnd(AInt r1) { return aRnd(r1); }
AInt sub_inkeyWRC(AInt ms) { sub_clrKeyBuf(); AInt i = testInkey(aInkey_waitR(win, ms)); if (toExitFlg != 0) return -1; return i; }
AInt sub_satuInt(AInt i, AInt i0, AInt i1) { return aSaturateInt(i, i0, i1); }
AInt sub_movDx(AInt k) { return aMoveDx(k); }
AInt sub_movDy(AInt k) { return aMoveDy(k); }
AInt sub_inkeyWR(AInt ms) { AInt i = testInkey(aInkey_waitR(win, ms)); if (toExitFlg != 0) return -1; return i; }
void sub_arySetInt(AInt *a, AInt i0, AInt i1, AInt v) { aArySetInt(a, i0, i1, v); }
void sub_aryMovInt(AInt *a, AInt i0, AInt i1, AInt n) { aAryMovInt(a, i0, i1, n); }
AInt sub_uppercase(AInt c) { return aUppercase(c); }
AInt sub_lowercase(AInt c) { return aLowercase(c); }
AInt sub_maxInt(AInt i0, AInt i1) { return aMaxInt(i0, i1); }
AInt sub_minInt(AInt i0, AInt i1) { return aMinInt(i0, i1); }
AInt sub_argMaxRndInt(AInt *a, AInt i0, AInt i1) { return aArgMaxRndInt(a, i0, i1); }
AInt sub_inkeyWait(AInt mod) { AInt i = testInkey(aInkeyWait(win, mod)); if (toExitFlg != 0) return -1; return i; }
AInt sub_getPal(AInt c) { return aGetPal(win, c); }

// TCSBLAST

void *subTbl[] = {
	sub_print, sub_time, sub_aRgb8, sub_XorShift, sub_getPix, sub_f16Sin, sub_f16Cos, sub_aInkey, sub_prints, sub_setPix0,
	sub_fillRect, sub_fillOval, sub_drawStr, sub_OpnWin, sub_aWait, sub_bitblt, sub_aryNew, sub_aryInit, sub_printf,
	sub_inputInt, sub_dbgTestInt, sub_opnWinEx, sub_rnd, sub_cls, sub_grPrintf, sub_ech, sub_echBox, sub_inkeyWRC, sub_satuInt, sub_waitKey,
	sub_movDx, sub_movDy, sub_inkeyWR, sub_scroll8, sub_getEch, sub_echSav, sub_getEchCol, sub_getEchBak, sub_getEchBox, sub_arySetInt, sub_aryMovInt,
	sub_uppercase, sub_lowercase, sub_maxInt, sub_minInt, sub_argMaxRndInt, sub_drawRect, sub_drawOval, sub_drawLine, sub_fill, sub_clrKeyBuf,
	sub_inkeyWait, sub_getPal, sub_getEchBoxCol, sub_getEchBoxBak, sub_drawOvalCent, sub_fillOvalCent, sub_setPix, sub_leapFlush
};

///////////////////////////////////////////////////////////////////////////////

int epc, epc1;	// expr̂߂pcpc1.

int exprSub(int priority);	// exprSub1()QƂ̂ŁAvg^Cv錾.
int expr(int j);
int phrCmpPutIc(int pid, String phr, int pc, int *pi, int lenExpr, AInt sub, int *err,AInt xe0);

int exprSub1(int i, int priority, int op)	// 񍀉Zq̏̕W`.
{
	int j, k;
	epc++;
	j = exprSub(priority);
	k = tmpAlloc();
	if (op < TcPlus) {	// TcEEq ...  TcGt
		AEs_putIcP3(&es, opBin[op - TcEEq], 0, i, j);
		AEs_putIcP2(&es, AEs_OpSetCc, k, 0);
	} else
		AEs_putIcP3(&es, opBin[op - TcEEq], k, i, j);
	tmpFree(i);
	tmpFree(j);
	if (i < 0 || j < 0) return -1;
	return k;
}

int tmpLabelAlloc();
void defLabel(int i);

int exprSub(int priority)
{
	int i = -1, e0 = 0, e1 = 0, j;
	ppc1 = 0;
	if (phrCmp(99, "( !!**0 )", epc)) {	// .
		i = expr(0);
	} else if (tc[epc] == TcPlPlus) {	// OuCNg.
		epc++;
		i = exprSub(2);
		AEs_putIcP3(&es, AEs_OpAdd, i, i, Tc1);
	} else if (tc[epc] == TcMiMinus) {	// OufNg.
		epc++;
		i = exprSub(2);
		AEs_putIcP3(&es, AEs_OpSub, i, i, Tc1);
	} else if (tc[epc] == TcMinus) {	// P}CiX.
		epc++;
		e0 = exprSub(2);
		i = tmpAlloc();
		AEs_putIcP2(&es, AEs_OpNeg, i, e0);
	} else if (tc[epc] == TcPlus) {	// PvX.
		epc++;
		i = exprSub(2);
	} else if (tc[epc] == TcNot || tc[epc] == TcNOT) {	// P!.
		int label = tmpLabelAlloc();
		epc++;
		e0 = exprSub(2);
		i = tmpAlloc();
		AEs_putIcP2(&es, AEs_OpCpy, i, Tc0);
		AEs_putIcP3(&es, AEs_OpCmpNe, 0, e0, Tc0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, label);
		AEs_putIcP2(&es, AEs_OpCpy, i, Tc1);
		defLabel(label);
	} else if (phrCmp(72, "aMul64Shr(!!**0, !!**1, !!**2)", epc)) {
m64shr:
		e0 = expr(0);
		e1 = expr(1);
		int e2 = expr(2);
		i = tmpAlloc();
		AEs_putIcP4(&es, AEs_OpM64s, i, e0, e1, e2);
		tmpFree(e2);
		if (e2 < 0) {
			e0 = -1;
		}
	} else if (phrCmpPutIc(73, "aRgb8(!!**0, !!**1, !!**2)",             epc, &i, ~3, TcSbRgb8,    &e0, 0)) {
	} else if (phrCmpPutIc(74, "aOpenWin(!!**0, !!**1, !!***2, !!***8)", epc, 0,   3, TcSbOpnWin,  &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRnz, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
		i = Tc0;
	} else if (phrCmpPutIc(176, "aOpenWinEx(!!**0, !!**1, !!***2, !!***8)", epc, 0,   3, TcSbOpnWinEx,  &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRnz, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
		i = Tc0;
	} else if (phrCmpPutIc(75, "aXorShift32()",                          epc, &i,  0, TcSbXorShft, &e0, 0)) {
	} else if (phrCmpPutIc(77, "aFf16Sin(!!**0)",                         epc, &i, ~1, TcSbF16Sin,  &e0, 0)) {
	} else if (phrCmpPutIc(78, "aFf16Cos(!!**0)",                         epc, &i, ~1, TcSbF16Cos,  &e0, 0)) {
	} else if (phrCmpPutIc(79, "aInkey(!!***8 , !!**0)",                 epc, &i,  1, TcSbInkey,   &e0, 0)) {
	} else if (phrCmpPutIc(80, "aInputInt()",                             epc, &i,  0, TcSbInputInt, &e0, 0)) {
	} else if (phrCmpPutIc(81, "dbgTestInt(!!**0)",                      epc, &i,  1, TcSbDbgTestInt, &e0, 0)) {
	} else if (phrCmpPutIc(177, "aRnd(!!**0)",							 epc, &i,  1, TcSbRnd, &e0, 0)) {
	} else if (phrCmpPutIc(179, "aInkey_waitRC(!!***8,!!**0)",			 epc, &i,  1, TcSbInkeyWRC, &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
	} else if (phrCmpPutIc(180, "aSaturateInt(!!**0,!!**1,!!**2)",		 epc, &i,  3, TcSbSatuInt, &e0, 0)) {
	} else if (phrCmpPutIc(181, "aMoveDx(!!**0)",						 epc, &i,  1, TcSbMovDx, &e0, 0)) {
	} else if (phrCmpPutIc(182, "aMoveDy(!!**0)",						 epc, &i,  1, TcSbMovDy, &e0, 0)) {
	} else if (phrCmpPutIc(185, "aUppercase(!!**0)",					epc, &i,  1, TcSbUpper, &e0, 0)) {
	} else if (phrCmpPutIc(186, "aLowercase(!!**0)",					epc, &i,  1, TcSbLower, &e0, 0)) {
	} else if (phrCmpPutIc(187, "aInkey_waitR(!!***8,!!**0)",			 epc, &i,  1, TcSbInkeyWR, &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
	} else if (phrCmpPutIc(188, "aMaxInt(!!**0,!!**1)",					epc, &i,  2, TcSbMaxInt, &e0, 0)) {
	} else if (phrCmpPutIc(189, "aMinInt(!!**0,!!**1)",					epc, &i,  2, TcSbMinInt, &e0, 0)) {
	} else if (phrCmpPutIc(190, "aArgMaxRndInt(!!**0,!!**1,!!**2)",		epc, &i,  3, TcSbArgMaxRndInt, &e0, 0)) {
	} else if (phrCmpPutIc(193, "aInkeyWait(!!**0)",					epc, &i, 1, TcSbInkeyWait, &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
	} else if (phrCmpPutIc(183, "aGetEchCol(!!**8, !!**1, !!**2)",       epc, &i,  3, TcSbGetEchCol, &e0, TcMns1)) {
	} else if (phrCmpPutIc(191, "aGetEchBak(!!**8, !!**1, !!**2)",       epc, &i,  3, TcSbGetEchBak, &e0, TcMns1)) {
	} else if (phrCmpPutIc(184, "aGetEchBox(!!**8, !!**1, !!**2, !!**3, !!**4)", epc, &i,  5, TcSbGetEchBox, &e0, TcMns1)) {
	} else if (phrCmpPutIc(192, "aGetEchBoxCol(!!**8, !!**1, !!**2, !!**3, !!**4)", epc, &i,  5, TcSbGetEchBoxCol, &e0, TcMns1)) {
	} else if (phrCmpPutIc(194, "aGetEchBoxBak(!!**8, !!**1, !!**2, !!**3, !!**4)", epc, &i,  5, TcSbGetEchBoxBak, &e0, TcMns1)) {
	} else if (phrCmpPutIc(76, "aGetPix(!!**8, !!**1, !!**2)",           epc, &i,  3, TcSbGetPix,  &e0, TcMns1)) {
	} else if (phrCmpPutIc(178, "aGetEch(!!***8,!!**1,!!**2)",			 epc, &i,  3, TcSbGetEch, &e0, TcMns1)) {
	} else if (phrCmpPutIc(199, "aGetPal(!!**8, !!**0)", 				epc, &i, 1, TcSbGetPal, &e0, 0)) {
	} else if (phrCmpPutIc(200, "aGetPixOpt(!!**8, !!**0,!!**1, !!**2)", epc, &i,  3, TcSbGetPix,  &e0, 0)) {
	} else if (phrCmpPutIc(201, "aGetEchOpt(!!***8,!!**0,!!**1,!!**2)", epc, &i,  3, TcSbGetEch, &e0, 0)) {

	} else if (phrCmp(500, "MUL64SHR(!!**0, !!**1, !!**2)", epc)) { goto m64shr;
	} else if (phrCmpPutIc(501, "RGB8(!!**0, !!**1, !!**2)",             epc, &i, ~3, TcSbRgb8,    &e0, 0)) {
	} else if (phrCmpPutIc(170, "RND(!!**0)",							 epc, &i,  1, TcSbRnd, &e0, 0)) {
	} else if (phrCmpPutIc(171, "INKEY@WRC(!!**0)",						 epc, &i,  1, TcSbInkeyWRC, &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
	} else if (phrCmpPutIc(172, "MINMAX(!!**0,!!**1,!!**2)",			 epc, &i,  3, TcSbSatuInt, &e0, 0)) {
	} else if (phrCmpPutIc(173, "XMOVE(!!**0)",							 epc, &i,  1, TcSbMovDx, &e0, 0)) {
	} else if (phrCmpPutIc(174, "YMOVE(!!**0)",							 epc, &i,  1, TcSbMovDy, &e0, 0)) {
	} else if (phrCmpPutIc(175, "INKEY@WR(!!**0)",						 epc, &i,  1, TcSbInkeyWR, &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
	} else if (phrCmpPutIc(502, "INKEY@(!!**0)",                 epc, &i,  1, TcSbInkey,   &e0, 0)) {
	} else if (phrCmpPutIc(503, "INPUT()",                             epc, &i,  0, TcSbInputInt, &e0, 0)) {
	} else if (phrCmpPutIc(504, "UPPER(!!**0)",					epc, &i,  1, TcSbUpper, &e0, 0)) {
	} else if (phrCmpPutIc(505, "LOWER(!!**0)",					epc, &i,  1, TcSbLower, &e0, 0)) {
	} else if (phrCmpPutIc(506, "MAX(!!**0,!!**1)",					epc, &i,  2, TcSbMaxInt, &e0, 0)) {
	} else if (phrCmpPutIc(507, "MIN(!!**0,!!**1)",					epc, &i,  2, TcSbMinInt, &e0, 0)) {
	} else if (phrCmpPutIc(508, "ARGMAXRND(!!**0,!!**1,!!**2)",		epc, &i,  3, TcSbArgMaxRndInt, &e0, 0)) {
	} else if (phrCmpPutIc(509, "INKEYWAIT@(!!**0)",					epc, &i, 1, TcSbInkeyWait, &e0, 0)) {
		AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
		AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
	} else if (phrCmpPutIc(510, "GETCHCOL@(!!**1, !!**2)",       epc, &i,  3, TcSbGetEchCol, &e0, TcMns1)) {
	} else if (phrCmpPutIc(511, "GETCHBAK@(!!**1, !!**2)",       epc, &i,  3, TcSbGetEchBak, &e0, TcMns1)) {
	} else if (phrCmpPutIc(512, "GETCHBOX@(!!**1, !!**2, !!**3, !!**4)", epc, &i,  5, TcSbGetEchBox, &e0, TcMns1)) {
	} else if (phrCmpPutIc(513, "GETCHBOXCOL@(!!**1, !!**2, !!**3, !!**4)", epc, &i,  5, TcSbGetEchBoxCol, &e0, TcMns1)) {
	} else if (phrCmpPutIc(514, "GETCHBOXBAK@(!!**1, !!**2, !!**3, !!**4)", epc, &i,  5, TcSbGetEchBoxBak, &e0, TcMns1)) {
	} else if (phrCmpPutIc(515, "GETPIX@(!!**1, !!**2)",           epc, &i,  3, TcSbGetPix,  &e0, TcMns1)) {
	} else if (phrCmpPutIc(516, "GETCH@(!!**1,!!**2)",			 epc, &i,  3, TcSbGetEch, &e0, TcMns1)) {
	} else if (phrCmpPutIc(517, "GETPAL@(!!**0)", 				epc, &i, 1, TcSbGetPal, &e0, 0)) {
	} else if (phrCmpPutIc(518, "GETPIX@@(!!**0,!!**1, !!**2)", epc, &i,  3, TcSbGetPix,  &e0, 0)) {
	} else if (phrCmpPutIc(519, "GETCH@@(!!**0,!!**1,!!**2)", epc, &i,  3, TcSbGetEch, &e0, 0)) {
// ToDo: r[ȏ֐ǂBtO~Bp͂ȂiʂgȂ̂Ȃ̂ĂjA
// QƂ̂ŃIuWFNgȂƌĂׂȂiOɌʂ萔邱Ƃ܂ł͂łȂjA݂ȁB
	} else {		// ϐ͒萔.
		i = tc[epc];
		epc++;
	}
	if (ppc1 > 0)
		epc = ppc1;
	for (;;) {
		tmpFree(e0);
		tmpFree(e1);
		if (i < 0 || e0 < 0 || e1 < 0) return -1;	// ܂łŃG[΁Ał؂.
		if (epc >= epc1) break;
		e0 = e1 = 0;
		if (tc[epc] == TcPlPlus) {		// uCNg.
			epc++;
			e0 = i;
			i = tmpAlloc();
			AEs_putIcP2(&es, AEs_OpCpy, i, e0);
			AEs_putIcP3(&es, AEs_OpAdd, e0, e0, Tc1);
		} else if (tc[epc] == TcMiMinus) {		// ufNg.
			epc++;
			e0 = i;
			i = tmpAlloc();
			AEs_putIcP2(&es, AEs_OpCpy, i, e0);
			AEs_putIcP3(&es, AEs_OpSub, e0, e0, Tc1);
		} else if (phrCmp(70, "[!!**0]=", epc) && priority >= 15) {
			e1 = i;
			e0 = expr(0);
			epc = ppc1;
			i = exprSub(15);
			AEs_putIcP4(&es, AEs_OpArySet, 0, e1, e0, i);
		} else if (phrCmp(71, "[!!**0]", epc)) {
			e1 = i; 
			i = tmpAlloc();
			e0 = expr(0);
			AEs_putIcP3(&es, AEs_OpAryGet, i, e1, e0);
			epc = ppc1;
		} else if (TcAster <= tc[epc] && tc[epc] <= TcPerce && priority >= 4) {	// * / %
			i = exprSub1(i, 3, tc[epc]); // Ȃ̂41.
		} else if (TcPlus  <= tc[epc] && tc[epc] <= TcMinus && priority >= 5) {
			i = exprSub1(i, 4, tc[epc]); // Ȃ̂51.
		} else if (TcShl <= tc[epc] && tc[epc] <= TcShr && priority >= 6) {
			i = exprSub1(i, 5, tc[epc]); // Ȃ̂61.
		} else if (TcLt    <= tc[epc] && tc[epc] <= TcGt    && priority >= 7) {
			i = exprSub1(i, 6, tc[epc]); // Ȃ̂71.
		} else if (TcEEq   <= tc[epc] && tc[epc] <= TcNEq   && priority >= 8) {
			i = exprSub1(i, 7, tc[epc]); // Ȃ̂81.
		} else if ((tc[epc] == TcAnd || tc[epc] == TcAND) && priority >= 9) {
			i = exprSub1(i, 8, TcAnd); // Ȃ̂91.
		} else if (tc[epc] == TcXor && priority >= 10) {
			i = exprSub1(i, 9, TcXor); // Ȃ̂91.
		} else if ((tc[epc] == TcOr || tc[epc] == TcOR) && priority >= 11) {
			i = exprSub1(i, 10, TcOr); // Ȃ̂91.
		} else if (tc[epc] == TcAAnd && priority >= 12) {
			int label = tmpLabelAlloc();
			epc++;
			e0 = i;
			i = tmpAlloc();
			AEs_putIcP2(&es, AEs_OpCpy, i, Tc0);
			AEs_putIcP3(&es, AEs_OpCmpEq, 0, e0, Tc0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, label);
			e1 = exprSub(11);
			AEs_putIcP3(&es, AEs_OpCmpEq, 0, e1, Tc0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, label);
			AEs_putIcP2(&es, AEs_OpCpy, i, Tc1);
			defLabel(label);
		} else if (tc[epc] == TcOOr && priority >= 13) {
			int label = tmpLabelAlloc();
			epc++;
			e0 = i;
			i = tmpAlloc();
			AEs_putIcP2(&es, AEs_OpCpy, i, Tc1);
			AEs_putIcP3(&es, AEs_OpCmpNe, 0, e0, Tc0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, label);
			e1 = exprSub(12);
			AEs_putIcP3(&es, AEs_OpCmpNe, 0, e1, Tc0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, label);
			AEs_putIcP2(&es, AEs_OpCpy, i, Tc0);
			defLabel(label);
		} else if (tc[epc] == TcEqu && priority >= 15) {
			epc++;
			e0 = exprSub(15);	// EȂ̂15̂܂.
			AEs_putIcP2(&es, AEs_OpCpy, i, e0);
		} else if (TcPlEq <= tc[epc] && tc[epc] <= TcShrEq && priority >= 15) {
			j = opBin[tc[epc] - (TcPlEq - 6)];
			epc++;
			e0 = exprSub(15);	// EȂ̂15̂܂.
			AEs_putIcP3(&es, j, i, i, e0);
		} else
			break;
	}
	return i;
}

int expr(int j)
{
	int i, k, old_epc = epc, old_epc1 = epc1, s[19]; // epc, epc1ۑ.
	if (wpc[j] == wpc1[j]) return 0;
	epc  = wpc [j];
	epc1 = wpc1[j];
	for (k = 0; k < 9; k++) {
		s[k]     = wpc [k];
		s[k + 9] = wpc1[k];
	}
	s[18] = ppc1;
	i = exprSub(99);
	if (epc < epc1) return -1;
	epc  = old_epc;
	epc1 = old_epc1;
	for (k = 0; k < 9; k++) {
		wpc [k] = s[k];
		wpc1[k] = s[k + 9];
	}
	ppc1 = s[18];
	return i;
}

int testExpr(int j)
{
	int s = es.ic.s, e0 = expr(j);
	tmpFree(e0);
	es.ic.s = s;
	if (e0 < 0) return -1;
	return 0;
}

///////////////////////////////////////////////////////////////////////////////

enum { IfTrue = 0, IfFalse = 1 };

int ifgoto(int i, int not, int label)
{
	i = expr(i);
	if (i < 0) return -1;
	AEs_putIcP3(&es, AEs_OpCmpNe - not, 0, i, Tc0);
	tmpFree(i);
	AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, label);
	return 0;
}

int tmpLabelNo;

int tmpLabelAlloc()
{
	char s[10];
	sprintf(s, "_l%d", tmpLabelNo);
	tmpLabelNo++;
	return getTc(s, strlen(s));
}

int align, urc;
char lbMark[MAX_TC + 1];

void defLabel(int i)
{
	AEs_putIcP3(&es, 0, 0, AEs_Op0DefLb, i);
	lbMark[i] = 1;
}

#define BInfSiz		10

int binf[BInfSiz * 100], bd, lbd; // binf:block-info, bd:block-depth, lbd:loop-block-depth

enum { BlkIf = 1, BlkFor, BlkMain };
enum { IfLabel0 = 1, IfLabel1 };
enum { ForLopBgn = 1, ForCont, ForBrk, ForLbd0, ForWpc01, ForWpc11, ForWpc02, ForWpc12 };

int phrCmpPutIc(int pid, String phr, int pc, int *pi, int lenExpr, AInt sub, int *err, AInt xe0)
{
	int e[9], i;
	char pure = 0;
	if (lenExpr < 0) {
		pure = 1;
		lenExpr = ~lenExpr;
	}
	if (phr == 0 || phrCmp(pid, phr, pc)) {
		e[0] = e[1] = e[2] = e[3] = e[4] = e[5] = e[6] = e[7] = e[8] = 0;
		if (xe0 == 0) {
			for (i = 0; i < lenExpr; i++) {
				e[i] = expr(i);
			}
		} else {
			e[0] = xe0;
			for (i = 1; i < lenExpr; i++) {
				e[i] = expr(i);
			}
		}
		AInt *p = (AInt *) (es.ic.p + es.ic.s);
		p[0] = 0;
		p[1] = (lenExpr + (6 - 5 + 4)) / 5;
		p[2] = AEs_Op0SysFn;
		p[3] = 0;
		p[4] = sub;
		p[5] = lenExpr;
		for (i = 0; i < lenExpr; i++) {
			p[i + 6] = e[i];
		}
		es.ic.s += ((p[1] + 1) * 5) * sizeof (AInt);
		for (i = 0; i < lenExpr; i++) {
			if (e[i] < 0) {
				*err = -1;
			}
			tmpFree(e[i]);
		}
		if (pure != 0) {
			p[2] = AEs_Op0SysFnP;
		}
		if (pi != 0) {
			if (*pi <= 0) {
				*pi = tmpAlloc();
			}
			p[3] = *pi;
		}
		return 1;
	}
	return 0;
}

///////////////////////////////////////////////////////////////////////////////

AInt getConstTc(AInt64 i, AInt j)
{
	char s[64];
	if (j < 0)
		sprintf(s, "0x%08x%08x", (int) ((i >> 32) & 0xffffffff), (int) (i & 0xffffffff));
	else
		sprintf(s, "0x%08x%08x+0*%d", (int) ((i >> 32) & 0xffffffff), (int) (i & 0xffffffff), (int) j);
	AInt c = getTc(s, strlen(s));
	var[c] = i;
	return c;
}

int cmp_vct(const void *a, const void *b)
{
	return ((AInt *) b)[1] - ((AInt *) a)[1];
}

int xpc;

void xpcCpy(int pc0, int pc1)
{
	int i;
	for (i = pc0; i < pc1; i++)
		tc[xpc++] = tc[i];
}

int compile(String s)
{
	int pc, pc1, i, j, k, autoBlk = 0;
	closBlk = 0;
	tc[0]= Tc1;
	pc1 = lexer(s, tc + 1, tcpos + 1) + 1;
	tc[pc1++] = TcSemi;	tc[pc1++] = TcSemi; // Ɂu;vtY邱Ƃ̂ŁAtĂ.
//	tc[pc1] = tc[pc1 + 1] = tc[pc1 + 2] = tc[pc1 + 3] = TcDot;	// G[\p̂߂ɖɃsIho^Ă.
	xpc = pc1 + 8;
	AEs_init(&es);
	AEs_setIcMrgn(&es, 4096);
	AEs_putIcP2(&es, 0, 0, AEs_Op0Ent);
	for (i = 0; i < 10; i++) {
		tmp_flag[i] = 0;
	}
	tmpLabelNo = 0;
	for (i = 0; i < MAX_TC + 1; i++) {
		vc[i] = 0;
		lbMark[i] = 0;
	}
	bd = lbd = 0;
	toExit = tmpLabelAlloc();
	AInt urpc = 0;
	urc = 0;
	for (pc = 0+1; pc < pc1; ) { // RpCJn.
		int e0 = 0, e2 = 0;
		AEs_setIcMrgn(&es, 4096);
		closBlk = 0;
		if (autoBlk != 0 && pc > 1 && tc[pc - 1] == TcSemi) {
			autoBlk = 0;
			closBlk = 1;
		} else if (tc[pc] == TcCrBrCls) {
			pc++;
			closBlk = 1;
		}
		if (phrCmpPutIc(4, "print !!**0;", pc, 0, 1, TcSbPrint, &e0, 0)) {
		} else if (phrCmp( 0, "!!*0:", pc)) {	// x`.
			if (urc == 0)
				defLabel(tc[wpc[0]]); // xɑΉicqL^Ă.
		} else if (phrCmp( 5, "goto !!*0;", pc)) { // goto.
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jmp, tc[wpc[0]]);
		} else if (phrCmp( 6, "if (!!**0) goto !!*1;", pc)) {
			if (ifgoto(0, IfTrue, tc[wpc[1]]) < 0) goto err;
		} else if (phrCmpPutIc( 7, "time;", pc, 0, 0, TcSbTime, &e0, 0)) {
		} else if (phrCmp(11, "if ( !!**0 ) {", pc) && autoBlk == 0) {	// 	ubNif.
from105:
			bd += BInfSiz;
			binf[bd] = BlkIf;
			binf[bd + IfLabel0] = tmpLabelAlloc(); // ŝƂ̔ѐ.
			binf[bd + IfLabel1] = 0;
			if (ifgoto(0, 1, binf[bd + IfLabel0]) < 0) goto err; // 𖞂Ȃ΁Abinf[bd + IfLabel0]goto.
		} else if (phrCmp(12, "} else {", pc) && binf[bd] == BlkIf && autoBlk == 0) {
from106:
			if (binf[bd + IfLabel1] == 0)
				binf[bd + IfLabel1] = tmpLabelAlloc(); // else߂̏I[.
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jmp, binf[bd + IfLabel1]);
			defLabel(binf[bd + IfLabel0]);
		} else if (phrCmp(45, "} else if ( !!**0 ) {", pc) && binf[bd] == BlkIf && autoBlk == 0) {
from107:
			if (binf[bd + IfLabel1] == 0)
				binf[bd + IfLabel1] = tmpLabelAlloc(); // else߂̏I[.
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jmp, binf[bd + IfLabel1]);
			defLabel(binf[bd + IfLabel0]);
			binf[bd + IfLabel0] = tmpLabelAlloc(); // ŝƂ̔ѐĐݒ.
			if (ifgoto(0, 1, binf[bd + IfLabel0]) < 0) goto err; // 𖞂Ȃ΁Abinf[bd + IfLabel0]goto.
		} else if (phrCmp(197, "} else", pc) != 0 && binf[bd] == BlkIf && autoBlk == 0) {
			autoBlk = 1;
			goto from106;
		} else if (phrCmp(198, "} else if ( !!**0 )", pc) && binf[bd] == BlkIf && autoBlk == 0) {
			autoBlk = 1;
			goto from107;
		} else if (closBlk != 0 && binf[bd] == BlkIf) {
			ppc1 = pc;
from108:
			if (binf[bd + IfLabel1] == 0) {
				defLabel(binf[bd + IfLabel0]);
			} else {
				defLabel(binf[bd + IfLabel1]);
			}
			bd -= BInfSiz;
		} else if (phrCmp(42, "unroll(!!*0)", pc)) {
			urc = var[tc[wpc[0]]];
		} else if (phrCmp(14, "for (!!***0; !!***1; !!***2) {", pc) && autoBlk == 0) {	// for
from100:
			bd += BInfSiz;
			binf[bd] = BlkFor; // ubÑ^Cv.
			binf[bd + ForLopBgn] = tmpLabelAlloc(); // [v̓ɖ߂p.
			binf[bd + ForCont  ] = tmpLabelAlloc(); // continuep.
			binf[bd + ForBrk   ] = tmpLabelAlloc(); // breakp.
			binf[bd + ForLbd0  ] = lbd; // Âlۑ.
			if (wpc[1] == wpc1[1]) { wpc[1] = 0; wpc1[1] = 1; }
			binf[bd + ForWpc01 ] = wpc [1];
			binf[bd + ForWpc11 ] = wpc1[1];
			binf[bd + ForWpc02 ] = wpc [2];
			binf[bd + ForWpc12 ] = wpc1[2];
			lbd = bd;
			e0 = expr(0);
			if (testExpr(2) < 0) goto err;
			if (ifgoto(1, IfFalse, binf[bd + ForBrk]) < 0) goto err; // ŏsȂbreak.
			if (urc == 0)
				defLabel(binf[bd + ForLopBgn]);	// xɑΉicqL^Ă.
			urpc = ppc1;
		} else if (closBlk != 0 && binf[bd] == BlkFor) {
			ppc1 = pc;
from102:
			if (urc == 0)
				defLabel(binf[bd + ForCont]);	// xɑΉicqL^Ă.
			wpc [1] = binf[bd + ForWpc01];
			wpc1[1] = binf[bd + ForWpc11];
			wpc [2] = binf[bd + ForWpc02];
			wpc1[2] = binf[bd + ForWpc12];
			e2 = expr(2);
		//	tmpFree(e2);
		//	e2 = 0;
			if (urc > 0) {
				urc--;
				ppc1 = urpc;
				if (ifgoto(1, IfFalse, binf[bd + ForBrk]) < 0) goto err;
				if (urc ==0)
					defLabel(binf[bd + ForLopBgn]);	// xɑΉicqL^Ă.
			} else {
				if (ifgoto(1, 0, binf[bd + ForLopBgn]) < 0) goto err;
				defLabel(binf[bd + ForBrk]);	// xɑΉicqL^Ă.
				lbd = binf[bd+ ForLbd0]; // ȑO̒l𕜌.
				bd -= BInfSiz;
			}
		} else if (phrCmp(16, "continue;", pc) && lbd > 0) {
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jmp, binf[lbd + ForCont]);
		} else if (phrCmp(17, "break;", pc) && lbd > 0) {
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jmp, binf[lbd + ForBrk ]);
		} else if (phrCmp(18, "if ( !!**0 ) continue;", pc) && lbd > 0) {
			if (ifgoto(0, IfTrue, binf[lbd + ForCont]) < 0) goto err;
		} else if (phrCmp(19, "if ( !!**0 ) break;", pc) && lbd > 0) {
			if (ifgoto(0, IfTrue, binf[lbd + ForBrk ]) < 0) goto err;
		} else if (phrCmpPutIc(20, "prints !!**0;", pc, 0, 1, TcSbPrints, &e0, 0)) { // prints.
		} else if (phrCmp(33, "int", pc) || phrCmp(34, "AWindow", pc) || phrCmp(52, "AInt", pc) || phrCmp(113, "INT", pc) || phrCmp(350, "AInt8", pc) ||
			phrCmp(351, "AInt16", pc) || phrCmp(352, "AInt32", pc) || phrCmp(353, "AUInt8", pc) || phrCmp(354, "AUInt16", pc) || phrCmp(355, "AUInt32", pc) ||
			phrCmp(356, "AInt8a", pc) || phrCmp(357, "AInt16a", pc) || phrCmp(358, "AInt32a", pc) || phrCmp(359, "AUInt8a", pc) ||
			phrCmp(360, "AUInt16a", pc) || phrCmp(361, "AUInt32a", pc) || phrCmp(362, "char", pc) || phrCmp(363, "short", pc) || phrCmp(364, "long", pc) ||
			phrCmp(365, "short int", pc) || phrCmp(366, "long int", pc) || phrCmp(367, "unsigned int", pc) || phrCmp(368, "unsigned short", pc) ||
			phrCmp(369, "unsigned long", pc) || phrCmp(370, "unsigned char", pc) || phrCmp(371, "signed char", pc)) {
			for (pc++; pc < pc1 && tc[pc] != TcSemi;) {
				if (tc[pc] == TcAster || tc[pc] == TcComma) { pc++; continue; }
				if (phrCmp(22, "!!*2[!!**0] = {", pc)) {
					i = tc[wpc[2]];
					phrCmpPutIc(0, 0, 0, &i, 1, TcSbAryNew, &e0, 0);
					j = 0;
					for (i = ppc1; i < pc1; i++) {	// R}ȊÕg[N𐔂.
						if (tc[i] == TcCrBrCls) break;
						if (tc[i] != TcComma && tc[i] != TcPlus && tc[i] != TcMinus) {
							j++;
						}
					}
					if (i >= pc1) goto err;
					AInt *ip = (AInt *) (((char *) malloc(j * sizeof (AInt) + 16)) + 16);
					ip[-1] = j;
					j = 0;
					for (i = ppc1; tc[i] != TcCrBrCls; i++) {
						if (tc[i] == TcCrBrCls) break;
						if (tc[i] != TcComma) {
							if (tc[i] == TcPlus) {
								i++;
								ip[j] = + var[tc[i]];
							} else if (tc[i] == TcMinus) {
								i++;
								ip[j] = - var[tc[i]];
							} else {
								ip[j] =   var[tc[i]];
							}
							j++;
						}
					}
					tc[pc1 + 4] = getConstTc((AInt) ip, 0);
					wpc[0] = wpc[2];  wpc1[0] = wpc[0] + 1;
					wpc[1] = pc1 + 4; wpc1[1] = pc1 + 5;
					phrCmpPutIc(0, 0, 0, 0, 2, TcSbAryInit, &e0, 0);
					pc = i + 1; // } ̕.
					continue;
				}
				if (phrCmp(21, "!!*2[!!**0]", pc)) {
					i = tc[wpc[2]];
					phrCmpPutIc(0, 0, 0, &i, 1, TcSbAryNew, &e0, 0);
					pc = ppc1;
					continue;
				}
				if (phrCmp(114, "!!*1= !!**0", pc)) {
					e0 = expr(0);
					AEs_putIcP2(&es, AEs_OpCpy, tc[wpc[1]], e0);
					tmpFree(e0);
					if (e0 < 0) goto err;
					e0 = 0;
					pc = ppc1;
					continue;
				}
				if (tc[pc + 1] == TcComma || tc[pc + 1] == TcSemi) {
					pc++;
					continue;
				}
				goto err;
			}
			if (tc[pc] != TcSemi) goto err;
			pc++;
			continue;
		} else if (phrCmpPutIc(24, "aWait(!!**0);",                                                pc, 0, 1, TcSbWait,    &e0, 0)) {
			AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
		} else if (phrCmpPutIc(28, "aBitBlt(!!***8, !!**0, !!**1, !!**2, !!**3, !!**4);",           pc, 0, 5, TcSbBitblt,  &e0, 0)) {
		} else if (phrCmpPutIc(29, "aPrintTime();",                                                 pc, 0, 0, TcSbTime,    &e0, 0)) { // time;ƓiCۂ悤ɂj
		} else if (phrCmp(30, "void aMain() {", pc)) {
			bd += BInfSiz;
			binf[bd] = BlkMain;
		} else if (phrCmp(31, "}", pc) && binf[bd] == BlkMain) {
			bd -= BInfSiz;
		} else if (phrCmp(32, "#", pc)) {
		} else if (phrCmp(36, "codedump !!*0;", pc)) {
			codedump = var[tc[wpc[0]]];
		} else if (phrCmp(43, "codemode !!*0;", pc)) {
			codemode = var[tc[wpc[0]]];
		} else if (phrCmp(44, "optmode !!*0;", pc)) {
			optmode = var[tc[wpc[0]]];
		} else if (phrCmp(37, "regVar(!!*0", pc)) {
			i = tc[wpc[0]] - Tc0;
			for (pc = ppc1; tc[pc] != TcBrCls; pc++) {
				if (tc[pc] == TcComma) continue;
				if (0 <= i && i <= 7) {
					regVarTbl[i] = tc[pc];
					if (tc[pc] == Tc0)
						regVarTbl[i] = 0;
				}
				i++;
			}
			ppc1 = pc + 2;
		} else if (phrCmp(46, "regVarOpt(!!*0", pc)) {
			j = tc[wpc[0]] - Tc0;
			if (j == optmode) {
				for (i = 0; i <= 7;i++) {
					regVarTbl[i] = 0;
				}
			}
			i = 0;
			for (pc = ppc1; tc[pc] != TcBrCls; pc++) {
				if (tc[pc] == TcComma) continue;
				if (j == optmode) {
					if (0 <= i && i <= 7) {
						regVarTbl[i] = tc[pc];
						if (tc[pc] == Tc0)
							regVarTbl[i] = 0;
					}
				}
				i++;
			}
			ppc1 = pc + 2;
		} else if (phrCmp(38, "!!*3 = aMul64Shr(!!*0, !!*1, !!*2);", pc) /* && strtol(ts[tc[wpc[2]]], 0, 0) > 0 */) {
			AEs_putIcP4(&es, AEs_OpM64s, tc[wpc[3]], tc[wpc[0]], tc[wpc[1]], tc[wpc[2]]);
		} else if (phrCmp(39, "align();", pc)) {
			align = 1;
		} else if (phrCmp(40, "align(!!*0);", pc)) {
			align = var[tc[wpc[0]]];
		} else if (phrCmpPutIc(47, "printf(!!**0);",                             pc, 0, 1, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(48, "printf(!!**0, !!**1);",                      pc, 0, 2, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(49, "printf(!!**0, !!**1, !!**2);",               pc, 0, 3, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(50, "printf(!!**0, !!**1, !!**2, !!**3);",        pc, 0, 4, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(51, "printf(!!**0, !!**1, !!**2, !!**3, !!**4);", pc, 0, 5, TcSbPrintf, &e0, 0)) {

		} else if (phrCmp(100, "FOR !!*0 = !!**1,!!**2;", pc)) {	// for
			int i00 = wpc[0], i20 = wpc[2], i21 = wpc1[2];
			wpc[0] = xpc;
			tc[xpc++] = tc[i00]; tc[xpc++] = TcEqu; xpcCpy(wpc[1], wpc1[1]); tc[xpc++] = TcSemi;
			wpc1[0] = xpc - 1;
			wpc[1] = xpc;
			tc[xpc++] = tc[wpc[0]]; tc[xpc++] = TcNEq; xpcCpy(i20, i21); tc[xpc++] = TcSemi; // !!*0 != !!**2;
			wpc1[1] = xpc - 1;
			wpc[2] = xpc;
			tc[xpc++] = TcPlPlus; tc[xpc++] = tc[i00]; tc[xpc++] = TcSemi;
			wpc1[2] = xpc - 1;
			goto from100;
		} else if (phrCmp(101, "FOR !!*0 = !!**1,!!**2,!!**3;", pc)) {	// for
			int i00 = wpc[0], i20 = wpc[2], i21 = wpc1[2];
			wpc[0] = xpc;
			tc[xpc++] = tc[i00]; tc[xpc++] = TcEqu; xpcCpy(wpc[1], wpc1[1]); tc[xpc++] = TcSemi;
			wpc1[0] = xpc - 1;
			wpc[1] = xpc;
			tc[xpc++] = tc[wpc[0]]; tc[xpc++] = TcNEq; xpcCpy(i20, i21); tc[xpc++] = TcSemi; // !!*0 != !!**2;
			wpc1[1] = xpc - 1;
			wpc[2] = xpc;
			tc[xpc++] = tc[i00]; tc[xpc++] = TcPlEq; xpcCpy(wpc[3], wpc1[3]); tc[xpc++] = TcSemi;
			wpc1[2] = xpc - 1;
			goto from100;
		} else if (phrCmp(102, "NEXT;", pc) && binf[bd] == BlkFor) {
			goto from102;
		} else if (phrCmp(103, "CONTINUE;", pc) && lbd > 0) {
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jmp, binf[lbd + ForCont]);
		} else if (phrCmp(104, "BREAK;", pc) && lbd > 0) {
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jmp, binf[lbd + ForBrk ]);
		} else if (phrCmp(105, "IF !!**0 THEN", pc) && autoBlk == 0) {	// 	ubNif.
			goto from105;
		} else if (phrCmp(106, "ELSE", pc) && binf[bd] == BlkIf && autoBlk == 0) {
			goto from106;
		} else if (phrCmp(107, "ELSE IF !!**0 THEN", pc) && binf[bd] == BlkIf && autoBlk == 0) {
			goto from107;
		} else if (phrCmp(108, "FI", pc) && binf[bd] == BlkIf) {
			goto from108;
		} else if (phrCmp(109, "FOR !!***0;", pc) && autoBlk == 0) {	// for
			wpc[1] = wpc1[1] = wpc[2] = wpc1[2] = wpc1[0];
			goto from100;
		} else if (phrCmp(110, "IF !!**0 BREAK;", pc) && lbd > 0) {
			if (ifgoto(0, IfTrue, binf[lbd + ForBrk ]) < 0) goto err;
		} else if (phrCmp(111, "IF !!**0 CONTINUE;", pc) && lbd > 0) {
			if (ifgoto(0, IfTrue, binf[lbd + ForCont]) < 0) goto err;
		} else if (phrCmp(112, "IF !!**0 GOTO !!*1;", pc)) {
			if (ifgoto(0, IfTrue, tc[wpc[1]]) < 0) goto err;

		} else if (phrCmpPutIc(140, "CANVAS !!**0, !!**1, !!**2;", pc, 0, 3, TcSbOpnWinEx, &e0, 0)) {
			AEs_putIcP2(&es, AEs_OpCmpRnz, 0, 0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
		} else if (phrCmpPutIc(141, "CLS@ !!**1;", pc, 0, 2, TcSbCls, &e0, TcMns1)) {
		} else if (phrCmpPutIc(142, "PRINT@ !!**1,!!**2,!!**3,!!**4;",      pc, 0, 5, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(143, "PRINT@ !!**1,!!**2,!!**3,!!**4,!!**5;", pc, 0, 6, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(144, "PRINT@ !!**1,!!**2,!!**3,!!**4,!!**5,!!**6;", pc, 0, 7, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(145, "PRINT@ !!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7;", pc, 0, 8, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(146, "PRINT@ !!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7,!!**8;", pc, 0, 9, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(147, "CHAR@ !!**1,!!**2,!!**3,!!**4,!!**5;", pc, 0, 6, TcSbEch, &e0, TcMns1)) {
		} else if (phrCmpPutIc(148, "CHARBOX@ !!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7;", pc, 0, 8, TcSbEchBox, &e0, TcMns1)) {
		} else if (phrCmpPutIc(149, "WAIT !!**0;", pc, 0, 1, TcSbWait, &e0, 0)) {
			AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
		} else if (phrCmpPutIc(150, "WAITKEY@ !!**0;", pc, 0, 1, TcSbWaitKey, &e0, 0)) {
			AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
		} else if (phrCmpPutIc(151, "SCROLL@ !!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7;", pc, 0, 8, TcSbScroll8, &e0, TcMns1)) {

		} else if (phrCmp(195, "if ( !!**0 )", pc) != 0 && autoBlk == 0) {
			autoBlk = 1;
			goto from105;
		} else if (phrCmp(196, "for (!!***0; !!***1; !!***2)", pc) != 0 && autoBlk == 0) {	// for
			autoBlk = 1;
			goto from100;
		} else if (phrCmpPutIc(161, "aWaitKey(!!***8,!!**0);", pc, 0, 1, TcSbWaitKey, &e0, 0)) {
			AEs_putIcP2(&es, AEs_OpCmpRtEqM1, 0, 0);
			AEs_putIcP3(&es, 0, 0, AEs_Op0Jcc, toExit);
		} else if (phrCmp(162, "ARep0(!!**1,!!*0) {", pc) && autoBlk == 0) {
			int i00 = wpc[0], i10 = wpc[1], i11 = wpc1[1];
			wpc[0] = xpc;
			tc[xpc++] = tc[i00]; tc[xpc++] = TcEqu; tc[xpc++] = Tc0; tc[xpc++] = TcSemi;
			wpc1[0] = xpc - 1;
			wpc[1] = xpc;
			tc[xpc++] = tc[i00]; tc[xpc++] = TcNEq; xpcCpy(i10, i11); tc[xpc++] = TcSemi; // !!*0 != !!**1;
			wpc1[1] = xpc - 1;
			wpc[2] = xpc;
			tc[xpc++] = TcPlPlus; tc[xpc++] = tc[i00]; tc[xpc++] = TcSemi;
			wpc1[2] = xpc - 1;
			goto from100;
		} else if (phrCmp(163, "ARep0(!!**1,!!*0)", pc) && autoBlk == 0) {
			autoBlk = 1;
			int i00 = wpc[0], i10 = wpc[1], i11 = wpc1[1];
			wpc[0] = xpc;
			tc[xpc++] = tc[i00]; tc[xpc++] = TcEqu; tc[xpc++] = Tc0; tc[xpc++] = TcSemi;
			wpc1[0] = xpc - 1;
			wpc[1] = xpc;
			tc[xpc++] = tc[i00]; tc[xpc++] = TcNEq; xpcCpy(i10, i11); tc[xpc++] = TcSemi; // !!*0 != !!**1;
			wpc1[1] = xpc - 1;
			wpc[2] = xpc;
			tc[xpc++] = TcPlPlus; tc[xpc++] = tc[i00]; tc[xpc++] = TcSemi;
			wpc1[2] = xpc - 1;
			goto from100;
		} else if (phrCmp(164, "ARep(!!**1) {", pc) && autoBlk == 0) {
			int i10 = wpc[1], i11 = wpc1[1];
			wpc[0] = xpc;
			tc[xpc++] = TcRepC; tc[xpc++] = TcEqu; tc[xpc++] = Tc0; tc[xpc++] = TcSemi;
			wpc1[0] = xpc - 1;
			wpc[1] = xpc;
			tc[xpc++] = TcRepC; tc[xpc++] = TcNEq; xpcCpy(i10, i11); tc[xpc++] = TcSemi; // !!*0 != !!**1;
			wpc1[1] = xpc - 1;
			wpc[2] = xpc;
			tc[xpc++] = TcPlPlus; tc[xpc++] = TcRepC; tc[xpc++] = TcSemi;
			wpc1[2] = xpc - 1;
			goto from100;
		} else if (phrCmp(165, "ARep(!!**1)", pc) && autoBlk == 0) {
			autoBlk = 1;
			int i10 = wpc[1], i11 = wpc1[1];
			wpc[0] = xpc;
			tc[xpc++] = TcRepC; tc[xpc++] = TcEqu; tc[xpc++] = Tc0; tc[xpc++] = TcSemi;
			wpc1[0] = xpc - 1;
			wpc[1] = xpc;
			tc[xpc++] = TcRepC; tc[xpc++] = TcNEq; xpcCpy(i10, i11); tc[xpc++] = TcSemi; // !!*0 != !!**1;
			wpc1[1] = xpc - 1;
			wpc[2] = xpc;
			tc[xpc++] = TcPlPlus; tc[xpc++] = TcRepC; tc[xpc++] = TcSemi;
			wpc1[2] = xpc - 1;
			goto from100;
		} else if (phrCmpPutIc(167, "aArySetInt(!!**0,!!**1,!!**2,!!**3);", pc, 0, 4, TcSbArySetInt, &e0, 0)) {
		} else if (phrCmpPutIc(168, "aAryMovInt(!!**0,!!**1,!!**2,!!**3);", pc, 0, 4, TcSbAryMovInt, &e0, 0)) {
		} else if (phrCmpPutIc(23, "aSetPix0(!!***8, !!**0, !!**1, !!**2);",                       pc, 0, 3, TcSbSetPix0, &e0, 0)) {
		} else if (phrCmpPutIc(25, "aFillRect(!!***8, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbFillRect, &e0, TcMns1)) {
		} else if (phrCmpPutIc(41, "aFillOval(!!***8, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbFillOval, &e0, TcMns1)) {
		} else if (phrCmpPutIc(26, "aDrawStr(!!***8, !!**1, !!**2, !!**3, !!**4, !!**5);",         pc, 0, 6, TcSbDrawStr, &e0, TcMns1)) {
		} else if (phrCmpPutIc(152, "aCls(!!***8,!!**1);", pc, 0, 2, TcSbCls, &e0, TcMns1)) {
		} else if (phrCmpPutIc(153, "aScroll(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7,0,0,0);", pc, 0, 8, TcSbScroll8, &e0, TcMns1)) {
		} else if (phrCmpPutIc(154, "aGrPrintf(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5);",      pc, 0, 6, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(155, "aGrPrintf(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6);", pc, 0, 7, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(156, "aGrPrintf(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7);", pc, 0, 8, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(157, "aGrPrintf(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7,!!**8);", pc, 0, 9, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(159, "aEch(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5);", pc, 0, 6, TcSbEch, &e0, TcMns1)) {
		} else if (phrCmpPutIc(160, "aEchSav(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5);", pc, 0, 6, TcSbEchSav, &e0, TcMns1)) {
		} else if (phrCmpPutIc(166, "aEchBox(!!***8,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7);", pc, 0, 8, TcSbEchBox, &e0, TcMns1)) {
		} else if (phrCmpPutIc(300, "aDrawRect(!!***8, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbDrawRect, &e0, TcMns1)) {
		} else if (phrCmpPutIc(301, "aDrawOval(!!***8, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbDrawOval, &e0, TcMns1)) {
		} else if (phrCmpPutIc(302, "aFill(!!***8, !!**1, !!**2, !!**3);",        pc, 0, 4, TcSbFill, &e0, TcMns1)) {
		} else if (phrCmpPutIc(303, "aDrawOvalCent(!!***8, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbDrawOvalCent, &e0, TcMns1)) {
		} else if (phrCmpPutIc(304, "aFillOvalCent(!!***8, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbFillOvalCent, &e0, TcMns1)) {
		} else if (phrCmpPutIc(305, "aSetPix(!!***8, !!**1, !!**2, !!**3);",        pc, 0, 4, TcSbSetPix, &e0, TcMns1)) {

		} else if (phrCmpPutIc(400, "aFillRectOpt(!!***8, !!**0, !!**1, !!**2, !!**3, !!**4, !!**5);", pc, 0, 6, TcSbFillRect, &e0, 0)) {
		} else if (phrCmpPutIc(401, "aFillOvalOpt(!!***8, !!**0, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbFillOval, &e0, 0)) {
		} else if (phrCmpPutIc(402, "aDrawStrOpt(!!***8, !!**0, !!**1, !!**2, !!**3, !!**4, !!**5);",         pc, 0, 6, TcSbDrawStr, &e0, 0)) {
		} else if (phrCmpPutIc(403, "aClsOpt(!!***8,!!**0,!!**1);", pc, 0, 2, TcSbCls, &e0, 0)) {
		} else if (phrCmpPutIc(404, "aScrollOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7,0,0,0);", pc, 0, 8, TcSbScroll8, &e0, 0)) {
		} else if (phrCmpPutIc(405, "aGrPrintfOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5);",      pc, 0, 6, TcSbGrPrint, &e0, 0)) {
		} else if (phrCmpPutIc(406, "aGrPrintfOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6);", pc, 0, 7, TcSbGrPrint, &e0, 0)) {
		} else if (phrCmpPutIc(407, "aGrPrintfOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7);", pc, 0, 8, TcSbGrPrint, &e0, 0)) {
		} else if (phrCmpPutIc(408, "aGrPrintfOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7,!!**8);", pc, 0, 9, TcSbGrPrint, &e0, 0)) {
//		} else if (phrCmpPutIc(158, "aGrPrintf(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7,!!**8);", pc, 0, 9, TcSbGrPrint, &e0, TcMns1)) {
		} else if (phrCmpPutIc(409, "aEchOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5);", pc, 0, 6, TcSbEch, &e0, 0)) {
		} else if (phrCmpPutIc(410, "aEchSavOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5);", pc, 0, 6, TcSbEchSav, &e0, 0)) {
		} else if (phrCmpPutIc(411, "aEchBoxOpt(!!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7);", pc, 0, 8, TcSbEchBox, &e0, 0)) {
		} else if (phrCmpPutIc(412, "aDrawRectOpt(!!***8, !!**0,!!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbDrawRect, &e0, 0)) {
		} else if (phrCmpPutIc(413, "aDrawOvalOpt(!!***8, !!**0,!!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbDrawOval, &e0, 0)) {
		} else if (phrCmpPutIc(414, "aFillOpt(!!***8, !!**0,!!**1, !!**2, !!**3);",        pc, 0, 4, TcSbFill, &e0, 0)) {
		} else if (phrCmpPutIc(415, "aDrawOvalCentOpt(!!***8, !!**0, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbDrawOvalCent, &e0, 0)) {
		} else if (phrCmpPutIc(416, "aFillOvalCentOpt(!!***8, !!**0, !!**1, !!**2, !!**3, !!**4, !!**5);",        pc, 0, 6, TcSbFillOvalCent, &e0, 0)) {
		} else if (phrCmpPutIc(417, "aSetPixOpt(!!***8, !!**0, !!**1, !!**2, !!**3);",        pc, 0, 4, TcSbSetPix, &e0, 0)) {
		} else if (phrCmpPutIc(418, "aLeapFlushAll(!!***8, !!**0);",        pc, 0, 1, TcSbLeapFlush, &e0, 0)) {

		} else if (phrCmpPutIc(600, "ARYSET !!**0,!!**1,!!**2,!!**3;", pc, 0, 4, TcSbArySetInt, &e0, 0)) {
		} else if (phrCmpPutIc(601, "ARYMOVE !!**0,!!**1,!!**2,!!**3;", pc, 0, 4, TcSbAryMovInt, &e0, 0)) {
		} else if (phrCmpPutIc(602, "SETPIX0@ !!**0,!!**1,!!**2;",                       pc, 0, 3, TcSbSetPix0, &e0, 0)) {
		} else if (phrCmpPutIc(603, "FILLRECT@ !!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbFillRect, &e0, TcMns1)) {
		} else if (phrCmpPutIc(604, "FILLOVAL@ !!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbFillOval, &e0, TcMns1)) {
		} else if (phrCmpPutIc(605, "DRAWSTR@ !!**1,!!**2,!!**3,!!**4,!!**5;",         pc, 0, 6, TcSbDrawStr, &e0, TcMns1)) {
		} else if (phrCmpPutIc(606, "CHARSAVE@ !!**1,!!**2,!!**3,!!**4,!!**5;", pc, 0, 6, TcSbEchSav, &e0, TcMns1)) {
		} else if (phrCmpPutIc(607, "DRAWRECT@ !!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbDrawRect, &e0, TcMns1)) {
		} else if (phrCmpPutIc(608, "DRAWOVAL@ !!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbDrawOval, &e0, TcMns1)) {
		} else if (phrCmpPutIc(609, "FILL@ !!**1,!!**2,!!**3;",        pc, 0, 4, TcSbFill, &e0, TcMns1)) {
		} else if (phrCmpPutIc(610, "DRAWOVALCENTER@ !!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbDrawOvalCent, &e0, TcMns1)) {
		} else if (phrCmpPutIc(611, "FILLOVALCENTER@ !!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbFillOvalCent, &e0, TcMns1)) {
		} else if (phrCmpPutIc(612, "SETPIX@ !!**1,!!**2,!!**3;",        pc, 0, 4, TcSbSetPix, &e0, TcMns1)) {

		} else if (phrCmpPutIc(613, "FILLRECT@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;", pc, 0, 6, TcSbFillRect, &e0, 0)) {
		} else if (phrCmpPutIc(614, "FILLOVAL@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbFillOval, &e0, 0)) {
		} else if (phrCmpPutIc(615, "DRAWSTR@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;",         pc, 0, 6, TcSbDrawStr, &e0, 0)) {
		} else if (phrCmpPutIc(616, "CLS@@ !!**0,!!**1;", pc, 0, 2, TcSbCls, &e0, 0)) {
		} else if (phrCmpPutIc(617, "SCROLL@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7;", pc, 0, 8, TcSbScroll8, &e0, 0)) {
		} else if (phrCmpPutIc(618, "PRINT@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;",      pc, 0, 6, TcSbGrPrint, &e0, 0)) {
		} else if (phrCmpPutIc(619, "PRINT@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6;", pc, 0, 7, TcSbGrPrint, &e0, 0)) {
		} else if (phrCmpPutIc(620, "PRINT@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7;", pc, 0, 8, TcSbGrPrint, &e0, 0)) {
		} else if (phrCmpPutIc(621, "PRINT@@ !!***8,!!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7,!!**8;", pc, 0, 9, TcSbGrPrint, &e0, 0)) {
		} else if (phrCmpPutIc(622, "CHAR@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;", pc, 0, 6, TcSbEch, &e0, 0)) {
		} else if (phrCmpPutIc(623, "CHARSAVE@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;", pc, 0, 6, TcSbEchSav, &e0, 0)) {
		} else if (phrCmpPutIc(624, "CHARBOX@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5,!!**6,!!**7;", pc, 0, 8, TcSbEchBox, &e0, 0)) {
		} else if (phrCmpPutIc(625, "DRAWRECT@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5",        pc, 0, 6, TcSbDrawRect, &e0, 0)) {
		} else if (phrCmpPutIc(626, "DRAWOVAL@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbDrawOval, &e0, 0)) {
		} else if (phrCmpPutIc(627, "FILL@@ !!**0,!!**1,!!**2,!!**3;",        pc, 0, 4, TcSbFill, &e0, 0)) {
		} else if (phrCmpPutIc(628, "DRAWOVALCENTER@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbDrawOvalCent, &e0, 0)) {
		} else if (phrCmpPutIc(629, "FILLOVALCENTER@@ !!**0,!!**1,!!**2,!!**3,!!**4,!!**5;",        pc, 0, 6, TcSbFillOvalCent, &e0, 0)) {
		} else if (phrCmpPutIc(630, "SETPIX@@ !!**0,!!**1,!!**2,!!**3;",        pc, 0, 4, TcSbSetPix, &e0, 0)) {
		} else if (phrCmpPutIc(631, "LEAPFLUSHALL@ !!**0;",        pc, 0, 1, TcSbLeapFlush, &e0, 0)) {
		} else if (phrCmpPutIc(632, "PRINTF !!**0;",                             pc, 0, 1, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(633, "PRINTF !!**0,!!**1;",                      pc, 0, 2, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(634, "PRINTF !!**0,!!**1,!!**2;",               pc, 0, 3, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(635, "PRINTF !!**0,!!**1,!!**2,!!**3;",        pc, 0, 4, TcSbPrintf, &e0, 0)) {
		} else if (phrCmpPutIc(636, "PRINTF !!**0,!!**1,!!**2,!!**3,!!**4;", pc, 0, 5, TcSbPrintf, &e0, 0)) {
		} else if (phrCmp(637, "LOOP !!**1;", pc) && autoBlk == 0) {
			int i10 = wpc[1], i11 = wpc1[1];
			wpc[0] = xpc;
			tc[xpc++] = TcRepC; tc[xpc++] = TcEqu; tc[xpc++] = Tc0; tc[xpc++] = TcSemi;
			wpc1[0] = xpc - 1;
			wpc[1] = xpc;
			tc[xpc++] = TcRepC; tc[xpc++] = TcNEq; xpcCpy(i10, i11); tc[xpc++] = TcSemi; // !!*0 != !!**1;
			wpc1[1] = xpc - 1;
			wpc[2] = xpc;
			tc[xpc++] = TcPlPlus; tc[xpc++] = TcRepC; tc[xpc++] = TcSemi;
			wpc1[2] = xpc - 1;
			goto from100;
		} else if (phrCmp( 8, "!!***0;", pc)) {	// ͂Ȃ}b`₷̂ōŌɂ.
			e0 = expr(0);
		} else
			goto err;
		tmpFree(e0);
		tmpFree(e2);
		if (e0 < 0 || e2 < 0 || pc > ppc1) goto err;
		pc = ppc1;
	}
	if (bd > 0) {
		printf("block nesting error (bd=%d, lbd=%d, pc=%d, pc1=%d\n", bd, lbd, pc, pc1);
		return -1;
	}
	defLabel(toExit);
	AEs_putIcP2(&es, 0, 0, AEs_Op0Ret);

	ASP0_resize(&es.vr, tcs * sizeof (AEs_VirReg));
	es.vr.s = tcs * sizeof (AEs_VirReg);
	for (i = 4; i < tcs; i++) {
		AEs_VirReg *pvr = AEs_getVr(&es.vr, i);
		pvr->nam = ts[i];
		pvr->namLen = tl[i];
		if (TcSbPrint <= i && i <= TCSBLAST) {
			AEs_VirReg_setLabel2(pvr, subTbl[i - TcSbPrint]);
			continue;
		}
		if (isConst(i) != 0) {
			AEs_VirReg_setConstInt(pvr, var[i]);
		} else if (lbMark[i] != 0) {
			pvr->alc0 = AEs_AlcConst;
			pvr->typ0 = AEs_TypLabel;
			pvr->alc1 = 1;
			pvr->alc2 = (AInt) &var[i];
		} else {
			pvr->alc0 = AEs_AlcMem;
			pvr->alc1 = 0xff; // no base-reg.
			pvr->alc2 = (AInt) &var[i];
			pvr->typ0 = AEs_TypInt;
		}
	}
	if (codemode >= 1) {
		if ((optmode & 1) == 0) {	// xD.
			setRegVarNo(codemode, 0);
		} else {	// TCYD.
			setRegVarNo(codemode, 1);
		}
	}
	for (i = 0; i < regVarLen; i++) {
		if (regVarTbl[i] != 0) {
			AEs_VirReg *pvr = AEs_getVr(&es.vr, regVarTbl[i]);
			pvr->alc0 = AEs_AlcReg;
			pvr->alc1 = regVarNo[i];
		}
	}
	if ((optmode & 8) == 0) {
		i = AEs_optimize(&es, (AInt *) es.ic.p, (AInt *) (es.ic.p + es.ic.s), 10000);
	}
	if (codedump == 1)
		printf("optimize=%d\n", i);
	return 0;
err: ;
	String ln = s;
	j = 1;
	for (i = 0; s[i] != 0 && &s[i] < tcpos[pc]; i++) {
		if (s[i] == '\n') {
			ln = &s[i] + 1;
			j++;
		}
	}
	for (k = 0; ln[k] != '\n' && ln[k] != 0; k++);
	printf("error in line:%d\n>> %.*s\n", j, k, ln);
	return -1;
}

#if (defined(AARCH_X86))
	#define CODEMODE0	1
#elif (defined(AARCH_X64))
	#define CODEMODE0	2
#endif

int run(String s)
{
	AInt i, j, k, icLen = compile(s);
	if (icLen < 0)
		return 1;
	toExitFlg = 0;
	if (codemode == 0) {
		if (codedump == 1) {
			AEs_dump((AInt *) es.ic.p, (AInt *) (es.ic.p + es.ic.s));
		}
		if (codedump == 0) {
			ASP0 runIc;
			ASP0_init(&runIc, 256);
			AEs_run_compile(&es, (AInt *) es.ic.p, (AInt *) (es.ic.p + es.ic.s), &runIc);
			t0 = clock();
			AEs_run_run((AInt **) runIc.p);
			if (win != 0) {
				aFlushAll(win);
			}
		}
	}
	if (1 <= codemode && codemode <= 3) {
		AEs_X864_Man xm;
		AEs_X864_Man_init(&xm);
		AInt isz = 4;
		xm.es = &es;
		xm.x64 = codemode - 1;
		xm.useIncDec = xm.usePushPop = optmode & 1;
		char useBp = optmode & 1;
		if (xm.x64 != 0)
			isz = 8;
		if (2 <= codemode && codemode <= 3)
			xm.nouseUnderSc = 1;
		ASP0_init(&xm.x864, 256);
		AEs_X864_compile(&xm, (AInt *) es.ic.p, (AInt *) (es.ic.p + es.ic.s));
		if ((optmode & 8) == 0) {
			i = AEs_X864_optimize(&xm, (AEs_X864 *) xm.x864.p, (AEs_X864 *) (xm.x864.p + xm.x864.s));
		}
		AEs_X864 *p0 = (AEs_X864 *) xm.x864.p, *p1= (AEs_X864 *) (xm.x864.p + xm.x864.s), *p;
		for (p = p0; p < p1; p++) {
			if (p->len1 == 0) continue;
			if (p->op == 0x00) continue;
			vc[p->vrIdx]++;
			if (codedump == 2) {
				AEs_VirReg *pvr = AEs_getVr(&es.vr, p->vrIdx);
				if (pvr->alc0 == AEs_AlcConst && pvr->nam != 0) {
					if (pvr->nam[0] == 34) {
						pvr->nam = malloc(10);
						sprintf((char *) pvr->nam, "._str%d", (int) p->vrIdx);
						pvr->namLen = strlen(pvr->nam);
					} else {
						char *pp = strstr((char *) pvr->nam, "+0*");
						if (pp != 0) {
							switch (strtol(pp + 3, 0, 0)) {
							case 0:
								pvr->nam = malloc(10);
								sprintf((char *) pvr->nam, "._tbl%d", (int) p->vrIdx);
								pvr->namLen = strlen(pvr->nam);
								break;
							}
						}
					}
				}
			}
		}
		AInt *vct = aMalloc(tcs * (2 * sizeof (AInt))), vcts = 0;
		for (i = 4; i < tcs; i++) {
			if (vc[i] == 0) continue;
			AEs_VirReg *pvr = AEs_getVr(&es.vr, i);
			if (pvr->alc0 == AEs_AlcMem) {	// ϐ̂ݓo^.
				vct[vcts * 2    ] = i;
				vct[vcts * 2 + 1] = vc[i];
				vcts++;
			} else
				vc[i] = 0;
		}
		qsort(vct, vcts, 2 * sizeof (AInt), cmp_vct);
		for (i = 0; i < vcts; i++) {
			j = vct[i * 2];
			AEs_VirReg *pvr = AEs_getVr(&es.vr, j);
			if (useBp != 0) {
				pvr->alc1 = 5;	// EBP, RBP.
				pvr->alc2 = i * isz - 128;
			} else {
				pvr->alc1 = 4; // ESP, RSP.
				pvr->alc2 = (i + 32) * isz;
			}
		}
		if (codedump == 1) {
			for (i = 0; i < vcts; i++) {
				j = vct[i * 2];
				printf("#%04d(%08x): %06d: %s\n", j, (int) (AInt) &var[j], vc[j], ts[j]);
			}
		}
		for (p = p0; p < p1; p++) {
			if (p->len1 == 0) continue;
			if (p->op == 0x00) continue;
			if (4 <= p->vrIdx && p->vrIdx < tcs && vc[p->vrIdx] > 0) {
				AEs_putX864Sub0(p, AEs_getVr(&es.vr, p->vrIdx), p->vrIdx);
			}
		}
		AInt stksz = (((vcts + 32) * isz + 15) & ~15) + 16 - isz;
		if (useBp != 0) {
			AEs_X864_setStk(&xm, stksz, 32 * isz + 128);
		} else {
			AEs_X864_setStk(&xm, stksz, -1);
		}
		aFree(vct, tcs * (2 * sizeof (AInt)));
		//	AEs_X864_dump((AEs_X864 *) xm.x864.p, (AEs_X864 *) (xm.x864.p + xm.x864.s));
		if (codedump == 1)
			printf("x864_optimize=%d\n", i);
		icLen = AEs_X864_putBin1(&xm, (AEs_X864 *) xm.x864.p, (AEs_X864 *) (xm.x864.p + xm.x864.s), ic, 10);
		if (es.ic.s > 5 * 3 * aSizeof (AInt)) {
			if (codedump == 0) {
				void (*func)() = (void (*)()) ic;
				t0 = clock();
				if (codemode != CODEMODE0) goto badmode;
				func();
				if (win != 0) {
					aFlushAll(win);
				}
			} else if (codedump == 1) {
				for (i = 0; i < icLen; i++) {
					printf("%02x ", ic[i]);
				}
				printf("\n(len=%d, codemode=%d, optmode=%d)\n", icLen, codemode, optmode);
			} else if (codedump == 2) {
				char st[100];
				ASP0 asmout;
				ASP0_init(&asmout, 256);
				AEs_X864_nasm(&xm, (AEs_X864 *) xm.x864.p, (AEs_X864 *) (xm.x864.p + xm.x864.s), &asmout);
				for (i = TcSbPrint; i <= TcSbInputInt; i++) {
					sprintf(st, "        EXTERN  %.*s\n", tl[i] - xm.nouseUnderSc, ts[i] + xm.nouseUnderSc);
					ASP0_addStr(&asmout, st);
				}
				j = es.vr.s / sizeof (AEs_VirReg);
				for (i = 4; i < j; i++) {
					AEs_VirReg *pvr = AEs_getVr(&es.vr, i);
					if (pvr->nam != 0 && strncmp((char *) pvr->nam, "._str", 5) == 0) {
						sprintf(st, "._str%d: DB  ", (int) i);
						ASP0_addStr(&asmout, st);
						ASP0_addStr0(&asmout, ts[i], tl[i]);
						ASP0_addStr(&asmout, ",0\n");
					}
				}
				char *datTyp = "DD", flg = 0;
				if (isz == 8)
					datTyp = "DQ";
				for (i = 4; i < j; i++) {
					AEs_VirReg *pvr = AEs_getVr(&es.vr, i);
					if (pvr->nam != 0 && strncmp((char *) pvr->nam, "._tbl", 5) == 0) {
						AInt *ip = (AInt *) (AInt) pvr->alc2;
						if (flg == 0) {
							sprintf(st, "        ALIGNB %d\n", isz);
							ASP0_addStr(&asmout, st);
							flg = 1;
						}
						sprintf(st, "        %s  %d\n", datTyp, (int) ip[-1]);
						ASP0_addStr(&asmout, st);
						sprintf(st, "._tbl%d:\n", (int) i);
						ASP0_addStr(&asmout, st);
						for (k = 0; k < ip[-1]; k++) {
							sprintf(st, "        %s  %d\n", datTyp, (int) ip[k]);
							ASP0_addStr(&asmout, st);
						}
					}
				}
				fwrite(asmout.p, 1, asmout.s, stdout);
				ASP0_deinit(&asmout);
			}
		}
	}
	return 0;
badmode:
	printf("(codemode mismatch. now=%d, executable=0,%d)\n", codemode, CODEMODE0);
	return 0;
}

// ȉmallocRWX()Windowsp̋Lq.

#include <windows.h>

void *mallocRWX(int siz)
{
	return VirtualAlloc(0, siz, MEM_COMMIT, PAGE_EXECUTE_READWRITE);
}

///////////////////////////////////////////////////////////////////////////////

void aMain()
{
	unsigned char cmdlin[10000];
	AInt i;
	ASP0 sp;
	ic = mallocRWX(1024 * 1024); // 1MB
	lexer(tcInit, tc, tcpos);
	codemode = CODEMODE0;
	if (aArgc >= 2) {
		int wait = 0;
		for (i = 1; i < aArgc && aArgv[i][0] == '-'; i++) {
			if (strcmp(aArgv[i], "-asm") == 0) { codedump = 2; }
			if (strcmp(aArgv[i], "-wait") == 0) { wait = -1; }
			if (strncmp(aArgv[i], "-cmd:", 5) == 0) { run(aArgv[i] + 5); }
		}
		if (i < aArgc && loadText(&sp, aArgv[i])->p != 0) {
			run(sp.p);
			ASP0_deinit(&sp);
			if (win != 0) { aWait(wait); }
		}
		exit(0);
	}
	for (;;) { // Read-Eval-Print Loop.
		printf("\n");
prompt:
		printf("hlx>");
		fgets(cmdlin, 10000, stdin);
		i = strlen(cmdlin);
		if (cmdlin[i - 1] == '\n') { // ɉsR[htĂ΂.
			cmdlin[i - 1] = 0;
		}
		if (strlen(cmdlin) == 0) goto prompt;
		if (strncmp(cmdlin, "run ", 4) == 0 || strncmp(cmdlin, "RUN ", 4) == 0) {
			if (loadText(&sp, &cmdlin[4])->p != 0) {
				run(sp.p);
				ASP0_deinit(&sp);
			}
		} else if (strncmp(cmdlin, "shell ", 6) == 0 || strncmp(cmdlin, "SHELL ", 6) == 0) {
			char s[1000];
			sprintf(s, "cmd.exe /C %s", &cmdlin[6]);
			system(s);
		} else if (strcmp(cmdlin, "exit") == 0 || strcmp(cmdlin, "EXIT") == 0) {
			exit(0);
		} else {
			run(cmdlin);
		}
	}
}
