#include <acl.c>

AWindow *win;

void sub_print(AInt i)					{ printf("%d\n", (int) i); }
void sub_time()							{ printf("time: %.3f[sec]\n", clock() / (double) CLOCKS_PER_SEC); }
AInt sub_aRgb8(AInt r, AInt g, AInt b)	{ return aRgb8(r, g, b); }
AInt sub_XorShift()						{ return aXorShift32(); }
AInt sub_aGetPix(AInt x, AInt y)		{ return aGetPix(win, x, y); }
AInt sub_f16Sin(AInt x)					{ return (AInt) (sin(x * (2 * 3.14159265358979323 / 65536)) * 65536); }
AInt sub_f16Cos(AInt x)					{ return (AInt) (cos(x * (2 * 3.14159265358979323 / 65536)) * 65536); }
AInt sub_aInkey(AInt opt)				{ return aInkey(win, opt); }
void sub_prints(char *s)				{ printf("%s\n", s); }
void sub_aSetPix0(AInt x, AInt y, AInt c) { aSetPix0(win, x, y, c); }
void sub_aFilRct0(AInt xsz, AInt ysz, AInt x0, AInt y0, AInt c)  { aFillRect0(win, xsz, ysz, x0, y0, c); }
void sub_aFilOvl0(AInt xsz, AInt ysz, AInt x0, AInt y0, AInt c)  { aFillOval0(win, xsz, ysz, x0, y0, c); }
void sub_aDrwStr0(AInt x, AInt y, AInt c, AInt b, char *s)       { aDrawStr0(win, x, y, c, b, s); }
void sub_gprDec(AInt x, AInt y, AInt w, AInt c, AInt b, AInt i)  { char s[100]; sprintf(s, "%*d", w, i); aDrawStr0(win, x, y, c, b, s); }
void sub_printf(char *s, AInt a, AInt b, AInt c, AInt d)         { printf(s, a, b, c, d); }
AInt sub_inputInt()						{ int i; scanf("%d", &i); return i; }

AInt sub_OpnWin(AInt xsz, AInt ysz, char *s)
{
	if (win != 0) {
		if (win->xsiz < xsz || win->ysiz < ysz) {
			printf("openWin error\n");
			return 1;
		}
	} else
		win = aOpenWin(xsz, ysz, s, 0);
	return 0;
}

AInt sub_aWait(AInt msec)
{
	aWait(msec);
	return 0;
}

void sub_bitblt(AInt xsz, AInt ysz, AInt x0, AInt y0, AInt *a)
{
	AInt32 *p32 = &win->buf[x0 + y0 * win->xsiz];
	int i, j;
	for (j = 0; j < ysz; j++) {
		for (i = 0; i < xsz; i++) {
			p32[i] = a[i];
		}
		a += xsz;
		p32 += win->xsiz;
	}
}

AInt *sub_aryNew(AInt n)
{
	AInt *p = malloc(n * sizeof (AInt));
	memset((char *) p, 0, n * sizeof (AInt));
	return p;
}

void sub_aryInit(AInt *a, AInt *ip)
{
	memcpy((char *) a, (char *) ip, ip[-1] * sizeof (AInt));
}
