#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>

char *loadFile(char *path)
{
	int sz = 1024 * 1024;
	char *b = malloc(sz);
	FILE *fp = fopen(path, "rt");
	if (fp == 0) {
		fprintf(stderr, "fopen error : %s\n", path);
		exit(1);
	}
	int i = fread(b, 1, sz - 4, fp);
	fclose(fp);
	if (i >= sz - 4) {
		fprintf(stderr, "too large file : %s\n", path);
		exit(1);
	}
	b[i] = 0;
	return realloc(b, i + 4);
}

int strlenLf0(const char *s)
{
	int l = 0;
	while (s[l] != 0 && s[l] != '\n')
		l++;
	return l;
}

int strlenLf1(const char *s)
{
	int l = strlenLf0(s);
	if (s[l] == '\n')
		l++;
	return l;
}

int isAlphabetOrNumber(unsigned char c)  // ϐɎgpł镶ǂ.
{
    if ('0' <= c && c <= '9') return 1;
    if ('a' <= c && c <= 'z') return 1;
    if ('A' <= c && c <= 'Z') return 1;
    if (c == '_') return 1;
    return 0;
}

typedef struct TmpWrk_ {
	void *p[8];
	int i[8];
} TmpWrk;

int tkncmp(const char *s, int len, const char *t)
{
	int l = strlen(t);
	if (len == l && strncmp(s, t, len) == 0) return 1;
	return 0;
}

int tcmp(TmpWrk *tw, const char *t) { return tkncmp(tw->p[0], tw->i[0], t); }

char *lv2(char *s)
{
	TmpWrk tw[1];
	int sz = 1024 * 1024, j = 0;
	char *b = malloc(sz);
	char *lb = malloc(64 * 1024);
	int kakko = 0;
	while (*s != 0) {
		int l = strlenLf1(s);
		if (l == 0) break;
		memcpy(lb, s, l);
		s += l;
		while (l > 0 && (lb[l - 1] == ' ' || lb[l - 1] == '\n' || lb[l - 1] == '\t')) l--;
	//	if (l > 0 && strchr("({[;,", lb[l - 1]) == 0) lb[l++] = ';';
		lb[l] = 0;
		int i = 0;
		char flg = 0, flg2 = 0;
		while (lb[i] == ' ' || lb[i] == '\n' || lb[i] == '\t') { i++; }
		if (lb[i] == '#') goto skip;
		while (lb[i] != 0) {
			if (lb[i] == ' ' || lb[i] == '\n' || lb[i] == '\t') { i++; continue; }
			int len = 0;
			if (strchr("(){}[];,", lb[i]) != 0)
				len = 1;
			else if (isAlphabetOrNumber(lb[i]) != 0) {  // 1ڂp.
				while (isAlphabetOrNumber(lb[i + len]) != 0)
					len++;
			} else if (strchr("=+-*/!%&^~|<>?:.#", lb[i]) != 0) {  // 1ڂʂ̋L.
            	while (lb[i + len] != 0 && strchr("=+-*/!%&^~|<>?:.#", lb[i + len]) != 0)
                	len++;
			} else if (lb[i] == 0x22 || lb[i] == 0x27) {
				len = 1;
				while (lb[i + len] != lb[i] && lb[i + len] != 0) len++;
				if (lb[i + len] == lb[i]) len++;
			} else {
	            printf("syntax error : %.10s\n", &lb[i]);
    	        exit(1);
			}
			if (len >= 2 && lb[i] == '/' && lb[i + 1] == '/') break;
			if (len == 1 && 'I' <= lb[i] && lb[i] <= 'N') lb[i] += 'a' - 'A';
			tw->p[0] = &lb[i];
			tw->i[0] = len;
			if (tcmp(tw, "PR")) memcpy(&lb[i], "pr", 2);
			if (tcmp(tw, "GO")) memcpy(&lb[i], "go", 2);
			if (tcmp(tw, "IF")) memcpy(&lb[i], "if", 2);
			if (tcmp(tw, "PRS")) memcpy(&lb[i], "prs", 3);
			if (tcmp(tw, "PRF")) memcpy(&lb[i], "prf", 3);
			if (tcmp(tw, "INT")) memcpy(&lb[i], "int", 3);
			if (tcmp(tw, "FOR")) memcpy(&lb[i], "for", 3);
			if (tcmp(tw, "PRSP")) memcpy(&lb[i], "prsp", 4);
			if (tcmp(tw, "PRLF")) memcpy(&lb[i], "prlf", 4);
			if (tcmp(tw, "PRINTF")) memcpy(&lb[i], "printf", 6);
			if (len == 1 && lb[i] == ';' && kakko == 0) {
				if (flg != 0) {
					memmove(&lb[i + 1], &lb[i], l - i + 1);
					lb[i++] = ')';
					l++;
				}
				flg = 0;
				flg2 = 0;
			}
			if (len == 1 && lb[i] == '(') kakko++;
			if (len == 1 && lb[i] == ')') {
				kakko--;
				if (kakko == 0 && flg2 == 1) flg2 = 2;
				i++;
				continue;
			}
			if (tcmp(tw, "}")) {
				flg2 = 0;
			}
			if (tcmp(tw, "if")) flg2 = 1;
			else if (tcmp(tw, "for")) flg2 = 1;
			else if (tcmp(tw, "else")) flg2 = 2;
			else if (tcmp(tw, "do")) flg2 = 2;
			else if (tcmp(tw, "while")) flg2 = 1;
			else if (flg2 == 2) flg2 = 0;
			char flg1 = 0;
			if (tcmp(tw, "pr")) flg1 = 1;
			if (tcmp(tw, "go")) flg1 = 1;
			if (tcmp(tw, "prs")) flg1 = 1;
			if (tcmp(tw, "prf")) flg1 = 1;
			if (tcmp(tw, "prsp")) flg1 = 1;
			if (tcmp(tw, "prlf")) flg1 = 1;
			i += len;
			if (flg1 != 0) {
				while (lb[i] == ' ' || lb[i] == '\n' || lb[i] == '\t') i++;
				if (lb[i] != '(') {
					flg = 1;
					memmove(&lb[i + 1], &lb[i], l - i + 1);
					lb[i++] = '(';
					l++;
				}
			}
		}
		if (lb[i] == 0 && flg2 == 0 && kakko == 0) {
			if (flg != 0) {
				lb[i++] = ')';
				l++;
			}
		}
skip:
		memcpy(&b[j], lb, l);
		j += l;
		b[j++] = '\n';
	}
	b[j] = 0;
	return realloc(b, j + 4);
}

int CtrlC = FALSE;

BOOL WINAPI CtrlHandler(DWORD fdwCtrlType)
{
	if (fdwCtrlType == CTRL_C_EVENT)
		return CtrlC; // Ԃ.
	return FALSE;
}

#define HistFile	"ecc0hist.c"
#define OutFile		"tmp.c"

int main(int argc, char **argv)
{
	(void) argc; (void) argv;
	SetConsoleCtrlHandler(CtrlHandler, TRUE);
	char *b, *b0, *p, *bn = "cmdline";
	int i, l, m;
	FILE *fp;
	b0 = malloc(64 * 1024);
retry:
	printf("1ec>");
	gets(b0);
	if (b0[0] == 0) goto retry;
	if (strcmp(b0, "exit") == 0 || strcmp(b0, "EXIT") == 0) return 0;
	if (strncmp(b0, "shell ", 6) == 0 || strncmp(b0, "SHELL ", 6) == 0) {
		CtrlC = TRUE;
		system(&b0[6]);
		CtrlC = FALSE;
		printf("\n");
		goto retry;
	}
	if (strncmp(b0, "run ", 4) == 0 || strncmp(b0, "RUN ", 4) == 0) {
		memmove(b0 + 2, b0, strlen(b0) + 1);
		b0[0] = 'e';
		b0[1] = 'c';
		CtrlC = TRUE;
		system(b0);
		CtrlC = FALSE;
prompt:
		printf("\n");
		goto retry;
	}
	l = strlen(b0);
	b0[l] = ';';
	b0[l + 1] = 0;
	b = lv2(b0);
	if (b == 0) goto prompt;
	l = strlen(b);

	char *a = "", *ab = b;
	if (b[0] == ';') {
		fp = fopen(HistFile, "rb");
		if (fp != 0) {
			fclose(fp);
			a = loadFile(HistFile);
			m = strlen(a);
			ab = malloc(m + l + 1);
			memcpy(ab, a, m);
			memcpy(ab + m, b, l);
			ab[m + l] = 0;
		}
	}

	FILE *fpo = fopen(OutFile, "wt");

	for (p = ab; *p != 0; ) {
		if (strncmp(p, ";//0", 4) == 0) {
			l = strlenLf1(p + 4);
			printf("%.*s", l, p + 4);
		}
		p += strlenLf1(p);
	}

// ToDo: ̕ӂHvāACuJxł悤ɂ.

	fprintf(fpo, "#include <acl1.c>\n");
	fprintf(fpo, "#define pr(i) printf(\"%%d\", i)\n");
	fprintf(fpo, "#define prf(f) printf(\"%%f\", f)\n");
	fprintf(fpo, "#define prs(s) printf(\"%%s\", s)\n");
	fprintf(fpo, "#define prsp() printf(\" \")\n");
	fprintf(fpo, "#define prlf() printf(\"\\n\")\n");
	fprintf(fpo, "#define go(l) goto l\n");
	for (p = ab; *p != 0; ) {
		if (strncmp(p, ";//1", 4) == 0) {
			l = strlenLf1(p + 4);
			fprintf(fpo, "%.*s", l, p + 4);
		}
		p += strlenLf1(p);
	}

	fprintf(fpo, "void aMain(AComArg *aCA)\n{\n\t(void) aCA;\n");
	fprintf(fpo, "\tint i, j, k, l, m, n;\n");
	fprintf(fpo, "\t(void) i;\n");
	fprintf(fpo, "\t(void) j;\n");
	fprintf(fpo, "\t(void) k;\n");
	fprintf(fpo, "\t(void) l;\n");
	fprintf(fpo, "\t(void) m;\n");
	fprintf(fpo, "\t(void) n;\n");
	if (*a != 0) {
		fprintf(fpo, "\n#line 1 \"%s\"\n", HistFile);
		fprintf(fpo, "%s", a);
	}
	fprintf(fpo, "\n#line 1 \"%s\"\n", bn);
	fprintf(fpo, "%s", b);
	fprintf(fpo, "}\n");

	if (b[0] == ';' && b[1] != '\n') {
		if (b[1] == ';')
			b[0] = b[1] = '/';
		FILE *fp = fopen(HistFile, "at");
		fwrite(b, 1, strlen(b), fp);
		fclose(fp);
	}
	fclose(fpo);
	CtrlC = TRUE;
	i = system("gcc -m32 -Wall -Wextra -Wl,-s,-Map,tmp_map.txt -Wno-unused-function -Wno-unused-but-set-variable -Wno-unused-label -O0 -DAArch_X86 -DAGraph_Win -DADbgLv=1 -DAStatic= -I./acl1 -o tmp.exe tmp.c -lgdi32 -lwinmm");
	if (i == 0)
		system("tmp.exe");
	if (ab != b) free(ab);
	free(b);
	if (a[0] != 0) free(a);
	CtrlC = FALSE;
	goto prompt;
}
