#include "stdlibs.c"
#include "acl0.c"
#include "mem.c"

#if (!defined(ANoUse_Graphics))
	#if (!defined(AMaxWin))
		#define AMaxWin	16
	#endif
	#if (!defined(AWinKey_BufSiz))
		#define AWinKey_BufSiz		1024
	#endif
	#if (defined(AGraph_Win))
		#include "win.c"
	#elif (defined(AGraph_SDL2)
		#include "sdl2.c"
	#endif
	#include "chr.c"
	#include "graphics.c"
#endif

#include "play.c"

AStatic void ACA_waitForExit(AComArg *aCA)
{
	#if (!defined(ANoUse_Graphics))
		AWin_flushAll(0);
		while (aCA->com->winClsWait < aAliveWin())
			ACA_wait0(aCA, 64);
	#endif
}

AStatic LONG WINAPI aExceptionHandler(struct _EXCEPTION_POINTERS *ExceptionInfo)
{
    char *s = "unknown";
    DWORD c = ExceptionInfo->ExceptionRecord->ExceptionCode;
    if (c == EXCEPTION_ACCESS_VIOLATION)       s = "EXCEPTION_ACCESS_VIOLATION"; // NULL pointer Ȃ.
    if (c == EXCEPTION_GUARD_PAGE)             s = "EXCEPTION_GUARD_PAGE";
    if (c == EXCEPTION_ILLEGAL_INSTRUCTION)    s = "EXCEPTION_ILLEGAL_INSTRUCTION";
    if (c == EXCEPTION_IN_PAGE_ERROR)          s = "EXCEPTION_IN_PAGE_ERROR";
    if (c == EXCEPTION_INT_DIVIDE_BY_ZERO)     s = "EXCEPTION_INT_DIVIDE_BY_ZERO";
    if (c == EXCEPTION_PRIV_INSTRUCTION)       s = "EXCEPTION_PRIV_INSTRUCTION";
    fprintf(stderr, "aExceptionHandler: addr=%08x, code=%s(%08x), flags=%08x\n",
        (int) ExceptionInfo->ExceptionRecord->ExceptionAddress,
        s,
        (int) ExceptionInfo->ExceptionRecord->ExceptionCode,
        (int) ExceptionInfo->ExceptionRecord->ExceptionFlags
    );
    int i, n = ExceptionInfo->ExceptionRecord->NumberParameters;
    fprintf(stderr, "  ExceptionInformation: n=%d", n);
    for (i = 0; i < n; i++)
        fprintf(stderr, ", %08x", (int) ExceptionInfo->ExceptionRecord->ExceptionInformation[i]);
    fprintf(stderr, "\n");
    return EXCEPTION_EXECUTE_HANDLER; // Ԃ΂ɏIĂ.
}

AClass(AVec3) { double x, y, z; };
AVec3  AVec3_new(double x, double y, double z) { AVec3 v = { x, y, z }; return v; }
AVec3  AVec3_add(AVec3 a, AVec3 b)  { return AVec3_new(a.x + b.x, a.y + b.y, a.z + b.z); }
AVec3  AVec3_sub(AVec3 a, AVec3 b)  { return AVec3_new(a.x - b.x, a.y - b.y, a.z - b.z); }
AVec3  AVec3_mul(double t, AVec3 v) { return AVec3_new(t * v.x,   t * v.y,   t * v.z);   }
double AVec3_dot(AVec3 a, AVec3 b)  { return a.x * b.x + a.y * b.y + a.z * b.z;        }
double AVec3_length(AVec3 v)        { return sqrt(AVec3_dot(v, v));                      }

AVec3 AVec3_normalize(AVec3 v)
{
	double len = AVec3_length(v);
	if (len > 1.0e-50)
		v = AVec3_mul(1.0 / len, v);
	return v;
}

AClass(AMat33) { double xx, xy, xz, yx, yy, yz, zx, zy, zz; };

AVec3 AMat33Vec3_mul(AMat33 m, AVec3 v)
{
	AVec3 w;
	w.x = m.xx * v.x + m.xy * v.y + m.xz * v.z;
	w.y = m.yx * v.x + m.yy * v.y + m.yz * v.z;
	w.z = m.zx * v.x + m.zy * v.y + m.zz * v.z;
	return w;
}

AMat33 AMat33_mul(AMat33 a, AMat33 b) {
	AMat33 m;
	m.xx = a.xx * b.xx + a.xy * b.yx + a.xz * b.zx;
	m.xy = a.xx * b.xy + a.xy * b.yy + a.xz * b.zy;
	m.xz = a.xx * b.xz + a.xy * b.yz + a.xz * b.zz;
	m.yx = a.yx * b.xx + a.yy * b.yx + a.yz * b.zx;
	m.yy = a.yx * b.xy + a.yy * b.yy + a.yz * b.zy;
	m.yz = a.yx * b.xz + a.yy * b.yz + a.yz * b.zz;
	m.zx = a.zx * b.xx + a.zy * b.yx + a.zz * b.zx;
	m.zy = a.zx * b.xy + a.zy * b.yy + a.zz * b.zy;
	m.zz = a.zx * b.xz + a.zy * b.yz + a.zz * b.zz;
	return m; }

AMat33 AMat33_rotX(double t) {
	AMat33 m;
	double c = cos(t), s = sin(t);
	m.xx = 1;
	m.xy = 0;
	m.xz = 0;
	m.yx = 0;
	m.yy =   c;
	m.yz = - s;
	m.zx = 0;
	m.zy =   s;
	m.zz =   c;
	return m; }

AMat33 AMat33_rotY(double t) {
	AMat33 m;
	double c = cos(t), s = sin(t);
	m.xx =   c;
	m.xy = 0;
	m.xz =   s;
	m.yx = 0;
	m.yy = 1;
	m.yz = 0;
	m.zx = - s;
	m.zy = 0;
	m.zz =   c;
	return m; }

AMat33 AMat33_rotZ(double t) {
	AMat33 m;
	double c = cos(t), s = sin(t);
	m.xx =   c;
	m.xy = - s;
	m.xz = 0;
	m.yx =   s;
	m.yy =   c;
	m.yz = 0;
	m.zx = 0;
	m.zy = 0;
	m.zz = 1;
	return m; }


AMat33 AMat33_eulerAnglesXyz(double a, double b, double c) {
	return AMat33_mul(AMat33_rotZ(c), AMat33_mul(AMat33_rotY(b), AMat33_rotX(a))); }
    // Ql: https://programming-surgeon.com/script/euler-angle/




double aSaturateDbl(double x, double x0, double x1)
{
	if (x < x0) x = x0;
	if (x > x1) x = x1;
	return x;
}

AInlineStatic AInt aMul64Shr(AInt i, AInt j, AInt k)
{
	return ((long long) i) * ((long long) j) >> k;
}

AInlineStatic void aPrintTime()
{
	printf("time: %.3f[sec]\n", clock() / (double) CLOCKS_PER_SEC);
}

AInlineStatic AInt aFf16Sin(AInt x)
{
	return (AInt) (sin(x * (2 * 3.14159265358979323 / 65536)) * 65536);
}

AInlineStatic AInt aFf16Cos(AInt x)
{
	return (AInt) (cos(x * (2 * 3.14159265358979323 / 65536)) * 65536);
}

AInlineStatic AInt aFf16Sqrt(AInt x)
{
	return (AInt) (sqrt(x * (1.0 / 65536)) * 65536);
}

#if (!defined(ANoUse_Xorshift32))

static AUInt32 aXorShift32_i = 2463534242U;

AStatic void aXorShift32_seed(AUInt32 s)
{
	aXorShift32_i = 2463534242U ^ s;
}

AStatic AUInt32 aXorShift32()
{
	AUInt32 i = aXorShift32_i;
	i = i ^ (i << 13);
	i = i ^ (i >> 17);
	i = i ^ (i <<  5);
	aXorShift32_i = i;
	return i;
}

#endif

AInt aRepC;
#define ARep(n) for (aRepC = 0; aRepC < n; aRepC++)
#define ARep0(n, i)	for (i = 0; i < n; i++)

AStatic AInt aRnd(AInt32 n)
{
	return aXorShift32() % n;
}

#define aArgMaxRndInt(a, i0, i1)	ACA_argMaxRndInt(aCA, a, i0, i1)
AStatic AInt ACA_argMaxRndInt(AComArg *aCA, AInt *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	char *b = AMem_malloc(aCA->mem, i1 - i0);
	AInt max = a[i0], i, i00 = i0, s = 0;
	memset(b, 0, i1 - i0);
	for (i = i0; i < i1; i++) {
		if (max < a[i]) {
			max = a[i];
			i00 = i;
		}
		b[i - i0] = (a[i] == max);
	}
	for (i = i00; i < i1; i++)
		s += b[i - i0];
	s = aRnd(s);
	for (i = i00; i < i1; i++) {
		if (b[i - i0] == 0) continue;
		if (s == 0) break;
		s--;
	}
	AMem_free(aCA->mem, i1 - i0, b);
	return i;
}

AStatic AInt aArgMaxFstInt(AInt *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	AInt max = a[i0], i, j = i0;
	for (i = i0; i < i1; i++) {
		if (max < a[i]) {
			max = a[i];
			j = i;
		}
	}
	return j;
}

AStatic AInt aArgMaxLstInt(AInt *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	AInt max = a[i0], i, j = i0;
	for (i = i0; i < i1; i++) {
		if (max <= a[i]) {
			max = a[i];
			j = i;
		}
	}
	return j;
}

AStatic AInt aArgMaxLstDbl(double *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	double max = a[i0];
	AInt i, j = i0;
	for (i = i0; i < i1; i++) {
		if (max <= a[i]) {
			max = a[i];
			j = i;
		}
	}
	return j;
}

#define AUpdateMinMax(min, max, x)  if (min > x) min = x; if (max < x) max = x

AStatic double aReminder0(double a, double b) {
	double p = (AInt64) (a / b);
	return a - p * b; }

AStatic double aReminder1(double a, double b) {
	double r = aReminder0(a, b);
	if (r < 0) r += b;
	return r; }

#define ASwapTmp(a, b, t)  do { t = a; a = b; b = t; } while (0)

#define aGetArgc()	ACA_getArgc(aCA)
AInlineStatic int ACA_getArgc(AComArg *aCA) { return aCA->com->argc; }

#define aGetArgv()	ACA_getArgv(aCA)
AInlineStatic void *ACA_getArgv(AComArg *aCA) { return aCA->com->argv; } // const̗LŃG[ɂȂ߂ void * ƂĂ.




void aMain(AComArg *aCA);

int main(int argc, const char **argv)
{
//	(void) AWin_chrFontEx;
	#if (ADbgLv >= 1)
		SetUnhandledExceptionFilter(aExceptionHandler);
	#endif
	#if (!defined(ANoUse_Xorshift32))
		aXorShift32_seed(time(0));
	#endif
	AComArg aCA[1];
	AComArgCom aCAC[1];
	AMem0 mem0[1];
	aCA->mem = mem0;
	aCA->ctx = 0;
	aCA->memDbg = 0;
	aCA->com = aCAC;
	aCAC->argc = argc;
	aCAC->argv = argv;
	#if (!defined(ANoUse_Graphics))
		aCAC->winClsWait = 0;
	#endif
	AMem0_init(mem0);
	#if (ADbgLv >= 2)
		AMem0 mem0Dbg[1];
		aCA->memDbg = mem0Dbg;
		AMem0_init(mem0Dbg);
	#endif
	ACA_set(aCA);
	aMain(aCA);
	ACA_waitForExit(aCA);
	return 0;
}


#define aInput(s)	ACA_input(aCA, s)
double ACA_input(AComArg *aCA, const char *s)
{
	(void) aCA;
	double x;
    if (s != 0)
        printf("%s", s);
	scanf("%lf", &x);
	return x;
}

typedef char *AStr;

#define aInputStr()	ACA_inputStr(aCA)
AStr ACA_inputStr(AComArg *aCA)
{
	(void) aCA;
	AStr s = malloc(64 * 1024);
	scanf("%s", s);
	return realloc(s, strlen(s) + 1);
}

#define aStrcat(s, t)	ACA_strcat(aCA, s, t)
AStr ACA_strcat(AComArg *aCA, AStr s, AStr t)
{
	(void) aCA;
	AStr u = malloc(strlen(s) + strlen(t) + 1);
	sprintf(u, "%s%s", s, t);
	return u;
}

#define aSprintf(...)	ACA_sprintf(aCA, __VA_ARGS__)
AStr ACA_sprintf(AComArg *aCA, const char *s, ...)
{
	(void) aCA;
	va_list ap;
	va_start(ap, s);
	AStr t = malloc(256 * 1024);
	vsprintf(t, s, ap);
	va_end(ap);
	return realloc(t, strlen(t) + 1);
}

#define aPrintInt(i)	ACA_printInt(aCA, i)
void ACA_printInt(AComArg *aCA, AInt i)
{
	(void) aCA;
	printf("%d\n", (int) i);
}



