
#define aOpenWin		AWin_open
#define aSetMode		AWin_setMode
#define aSetPix0		AWin_setPix0
#define aSetPix			AWin_setPix
#define aGetPix			AWin_getPix
#define aFillRect		AWin_fillRect
#define aDrawRect		AWin_drawRect
#define aDrawLine		AWin_drawLine
#define aFillOval		AWin_fillOval
#define aDrawOval		AWin_drawOval
#define aFillOvalCent	AWin_fillOvalCent
#define aDrawOvalCent	AWin_drawOvalCent

#define AWin_setPix(w, x, y, c)					AWin_setPixOpt(w, -1, x, y, c)
#define AWin_getPix(w, x, y)					AWin_getPixOpt(w, -1, x, y)
#define AWin_fillRect(w, xs, ys, x, y, c)		AWin_fillRectOpt(w, -1, xs, ys, x, y, c)
#define AWin_drawRect(w, xs, ys, x, y, c)		AWin_drawRectOpt(w, -1, xs, ys, x, y, c)
#define AWin_drawLine(w, x0, y0, x1, y1, c)		AWin_drawLineOpt(w, -1, x0, y0, x1, y1, c)
#define AWin_fillOval(w, xs, ys, x, y, c)		AWin_fillOvalOpt(w, -1, xs, ys, x, y, c)
#define AWin_drawOval(w, xs, ys, x, y, c)		AWin_drawOpt(w, -1, xs, ys, x, y, c)
#define AWin_fillOvalCent(w, x, y, a, b, c)		AWin_fillOvalCentOpt(w, -1, x, y, a, b, c)
#define AWin_drawOvalCent(w, x, y, a, b, c)		AWin_drawOvalCentOpt(w, -1, x, y, a, b, c)




#if (ADbgLv >= 2)

#if (!defined(ADbgMaxWin))
	#define ADbgMaxWin	(AMaxWin + 4)
#endif
AWin *aDbgWinTable[ADbgMaxWin + 1];

AStatic void aDbg_testWin(AWin *w, const char *msg)
{
	int i;
	for (i = 0; i < ADbgMaxWin; i++) {
		if (aDbgWinTable[i] == w) return;
	}
	aErrExit("%s: invalid window handle", msg);
}

AStatic void aDbg_testCol(AInt32 c, const char *msg)
{
	if (c < 0 || 0xffffff < c)
		aErrExit("%s: invalid color code : 0x%x (%d)", msg, (int) c, (int) c);
}

#else

#define aDbg_testWin(w, msg)
#define aDbg_testCol(c, msg)

#endif

#if (ADbgLv <= 1)

AInlineStatic void AWin_setPix0(AWin *w, AInt16 x, AInt16 y, AInt32 c) { w->buf[x + y * w->xsiz] = c; }
AInlineStatic AInt32 aRgb8(AInt32 r, AInt32 g, AInt32 b) { return r << 16 | g << 8 | b; }
AInlineStatic void AWin_setMode(AWin *w, int m) { w->mode = m; }

#else

AStatic void AWin_setPix0(AWin *w, AInt16 x, AInt16 y, AInt32 c)
{
	aDbg_testWin(w, "aSetPix0");
	aDbg_testCol(c, "aSetPix0");
	#if (defined(ADEBUG) || ADbgLv >= 1)
		if (x < 0 || w->xsiz <= x || y < 0 || w->ysiz <= y)
			aErrExit("aSetPix0 : out of range");
	#endif
	w->buf[x + y * w->xsiz] = c;
}

AStatic AInt32 aRgb8(AInt32 r, AInt32 g, AInt32 b)
{
	#if (defined(ADEBUG) || ADbgLv >= 1)
		if (r < 0 || 255 < r) aErrExit("aRgb8 : out of range : r=%d", r);
		if (g < 0 || 255 < g) aErrExit("aRgb8 : out of range : g=%d", g);
		if (b < 0 || 255 < b) aErrExit("aRgb8 : out of range : b=%d", b);
	#endif
	return r << 16 | g << 8 | b;
}

AStatic void AWin_setMode(AWin *w, int m)
{
	aDbg_testWin(w, "AWin_setMode");
	w->mode = m;
}

#endif

AStatic int aAliveWin()
{
	int i, c = 0;
	for (i = 0; i < AMaxWin; i++) {
		AWin *w = aWinTable_w[i];
		if (w != 0 && w->phase <= 1)
			c++;
	}
	return c;
}

AStatic void AWin_initSub(AComArg *aCA, AWin *w, AInt16 xsiz, AInt16 ysiz, const char *title)
{
	strncpy(w->title, title, 255);
	w->ca = aCA;
	w->title[255] = '\0';
	w->xsiz = xsiz;
	w->ysiz = ysiz;
	w->buf = AMem_malloc(aCA->mem, xsiz * ysiz * aSizeof (AInt32));
	memset(w->buf, 0, xsiz * ysiz * aSizeof (AInt32));
	#if (AKeyBufSiz > 0)
		w->kbw = w->kbr = 0;
	#endif
	#if (!defined(ANoUse_LeapFlush))
		if (CLOCKS_PER_SEC != 1000)
			w->lastFlush = clock() * 1000 / CLOCKS_PER_SEC;
		else
			w->lastFlush = clock();
	#endif
	w->phase = 0;
	w->mode = 0;
//	w->autoClose = autoClose;
	w->autoClose = 1;
	w->reqClose = 0;
	w->keyLv = 1;
	w->mosLv = 0;
	int i;
	for (i = 0; aWinTable_w[i] != 0; i++);
	#if (ADbgLv >= 2)
		if (i >= AMaxWin)
			aErrExit("AWin_init0: too many windows");
	#endif
	w->table_i = i;
	aWinTable_w[i] = w;
	aWinTable_h[i] = 0;
	w->win = 0;
	w->optDef = 7;
	w->cbxs = w->cbys = 0;
	w->cb = 0;
	w->savBuf = 0;
	#if (ADbgLv >= 2)
		for (i = 0; aDbgWinTable[i] != 0; i++);
		if (i >= ADbgMaxWin)
			aErrExit("AWin_init0: too many windows (DEBUG)");
		aDbgWinTable[i] = w;
	#endif
}

#if (AKeyBufSiz > 0)

AStatic void AWin_putKeyBuf(AWin *w, AInt32 c)
{
	if (((w->kbw + 1) & (AKeyBufSiz - 1)) != w->kbr) {
		w->keyBuf[w->kbw] = c;
		w->kbw = (w->kbw + 1) & (AKeyBufSiz - 1);
	}
}

AStatic AInt AWin_getSpcKeyBuf(AWin *w)
{
	if (w->kbr <= w->kbw)
		return AKeyBufSiz - (w->kbw - w->kbr);
	return w->kbr - w->kbw - 1;
}

#endif

#define aWait(ms)	ACA_wait(aCA, ms)
AStatic void ACA_wait(AComArg *aCA, AInt32 ms)
{
	AWin_flushAll(0);
	ACA_wait0(aCA, ms);
}

AStatic void AWin_setPixOpt0(AWin *w, AInt32 x, AInt32 y, AInt32 c)
{
	aDbg_testWin(w, "AWin_setPix");
	aDbg_testCol(c, "AWin_setPix");
	if (c >= 0 && 0 <= x && x < w->xsiz && 0 <= y && y < w->ysiz) {
		if (w->mode == AWinMode_Set) w->buf[y * w->xsiz + x] =  c;
		if (w->mode == AWinMode_Or)  w->buf[y * w->xsiz + x] |= c;
		if (w->mode == AWinMode_And) w->buf[y * w->xsiz + x] &= c;
		if (w->mode == AWinMode_Xor) w->buf[y * w->xsiz + x] ^= c;
	}
}

AStatic void AWin_setPixOpt(AWin *w, AInt8 opt, AInt32 x, AInt32 y, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	AWin_setPixOpt0(w, x, y, c);
}

AStatic AInt32 AWin_getPixOpt0(AWin *w, AInt16 x, AInt16 y)
{
	aDbg_testWin(w, "AWin_getPix");
	#if (ADbgLv >= 2)
		if (x < 0 || w->xsiz < x || y < 0 || w->ysiz < y)
			aErrExit("AWin_getPix : out of range");
	#endif
	return w->buf[y * w->xsiz + x];
}

AStatic AInt AWin_getPixOpt(AWin *w, AInt8 opt, AInt16 x, AInt16 y)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	if (x < 0 || w->xsiz <= x || y < 0 || w->ysiz <= y) return -1; // optł͉ʊOǂ߂.
	return AWin_getPixOpt0(w, x, y);
}

AStatic void AWin_fillRect0(AWin *w, AInt16 sx, AInt16 sy, AInt16 x0, AInt16 y0, AInt32 c)
{
	aDbg_testWin(w, "AWin_fillRect");
	aDbg_testCol(c, "AWin_fillRect");
	#if (ADbgLv >= 2)
		if (x0 < 0 || w->xsiz < sx + x0 || y0 < 0 || w->ysiz < sy + y0)
			aErrExit("AWin_fillRect : out of range");
	#endif
	int i, j;
	AInt32a *b = w->buf + x0 + y0 * w->xsiz;
	for (j = 0; j < sy; j++) {
		for (i = 0; i < sx; i++)
			b[i] = c;
		b += w->xsiz;
	}
}

AStatic void AWin_fillRectOpt0(AWin *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	AInt32 i, j;
	aDbg_testWin(w, "AWin_fillRect");
	aDbg_testCol(c, "AWin_fillRect");
	if (w->mode == AWinMode_Set && x0 >= 0 && y0 >= 0 && x0 + sx <= w->xsiz && y0 + sy <= w->ysiz) {
		AWin_fillRect0(w, sx, sy, x0, y0, c);
		return;
	}
	for (j = 0; j < sy; j++) {
		for (i = 0; i < sx; i++) {
			AWin_setPixOpt0(w, x0 + i, y0 + j, c);
		}
	}
}

AStatic void AWin_fillRectOpt(AWin *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; xs <<= 4; ys <<= 4; }
	AWin_fillRectOpt0(w, xs, ys, x, y, c);
}


AStatic void AWin_drawRectOpt0(AWin *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	aDbg_testWin(w, "AWin_drawRect");
	aDbg_testCol(c, "AWin_drawRect");
	if (sx <= 1 || sy <= 1)
		AWin_fillRectOpt0(w, sx, sy, x0, y0, c);
	else {
		AWin_fillRectOpt0(w, sx, 1,      x0,          y0,          c);
		AWin_fillRectOpt0(w, sx, 1,      x0,          y0 + sy - 1, c);
		AWin_fillRectOpt0(w, 1,  sy - 2, x0,          y0 + 1,      c);
		AWin_fillRectOpt0(w, 1,  sy - 2, x0 + sx - 1, y0 + 1,      c);
	}
}

AStatic void AWin_drawRectOpt(AWin *w, AInt8 opt, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { sx <<= 4; sy <<= 4; x0 <<= 4; y0 <<= 4; }
	AWin_drawRectOpt0(w, sx, sy, x0, y0, c);
}

AStatic void AWin_drawLineOpt0(AWin *w, AInt32 x0, AInt32 y0, AInt32 x1, AInt32 y1, AInt32 c)
{
	AInt32 x, y, dx, dy, sx, sy, err, e2;
	aDbg_testWin(w, "AWin_drawLine");
	aDbg_testCol(c, "AWin_drawLine");
	dx = x1 - x0;
	dy = y1 - y0;
	sx = sy = 1;
	if (dx < 0) { dx *= -1; sx = -1; }
	if (dy < 0) { dy *= -1; sy = -1; }
	err = dx - dy;
	x = x0;
	y = y0;
	for (;;) {
		AWin_setPixOpt0(w, x, y, c);
		if (x == x1 && y == y1) break;
		e2 = err * 2;
		if (e2 > - dy) {
			err -= dy;
			x += sx;
		}
		if (e2 <   dx) {
			err += dx;
			y += sy;
		}
	}
}

AStatic void AWin_drawLineOpt(AWin *w, AInt opt, AInt32 x0, AInt32 y0, AInt32 x1, AInt32 y1, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x0 <<= 4; y0 <<= 4; x1 <<= 4; y1 <<= 4; }
	AWin_drawLineOpt0(w, x0, y0, x1, y1, c);
}

AStatic void AWin_fillOval0(AWin *w, AInt16 sx, AInt16 sy, AInt16 x0, AInt16 y0, AInt16 c)
{
	double dcx, dcy, dcxy, dtx, dty;
	AInt16 x, y;
	aDbg_testWin(w, "AWin_fillOval0");
	aDbg_testCol(c, "AWin_fillOval0");
	#if (ADbgLv >= 2)
		if (x0 < 0 || w->xsiz < sx + x0 || y0 < 0 || w->ysiz < sy + y0)
			aErrExit("AWin_fillOval0 : out of range");
	#endif
	dcx = 0.5 * (sx - 1);
	dcy = 0.5 * (sy - 1);
	dcxy = (dcx + 0.5) * (dcy + 0.5) - 0.1;
	dcxy *= dcxy;
	for (y = 0; y < sy; y++) {
		dty = (y - dcy) * dcx;
		for (x = 0; x < sx; x++) {
			dtx = (x - dcx) * dcy;
			if (dtx * dtx + dty * dty > dcxy) continue;
				AWin_setPix0(w, x + x0, y + y0, c);
		}
	}
}

AStatic void AWin_fillOvalOpt0(AWin *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	double dcx, dcy, dcxy, dtx, dty;
	AInt32 x, y;
	if (w->mode == AWinMode_Set && x0 >= 0 && y0 >= 0 && x0 + sx < w->xsiz && y0 + sy < w->ysiz) {
		AWin_fillOval0(w, sx, sy, x0, y0, c);
		return;
	}
	aDbg_testWin(w, "AWin_fillOval");
	aDbg_testCol(c, "AWin_fillOval");
	dcx = 0.5 * (sx - 1);
	dcy = 0.5 * (sy - 1);
	dcxy = (dcx + 0.5) * (dcy + 0.5) - 0.1;
	dcxy *= dcxy;
	for (y = 0; y < sy; y++) {
		dty = (y - dcy) * dcx;
		for (x = 0; x < sx; x++) {
			dtx = (x - dcx) * dcy;
			if (dtx * dtx + dty * dty > dcxy) continue;
				AWin_setPixOpt0(w, x + x0, y + y0, c);
		}
	}
}

AStatic void AWin_fillOvalOpt(AWin *w, AInt opt, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { sx <<= 4; sy <<= 4; x0 <<= 4; y0 <<= 4; }
	AWin_fillOvalOpt0(w, sx, sy, x0, y0, c);
}

#define ADrawOvalParam	1

AStatic void AWin_drawOvalOpt0(AWin *w, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	double dcx, dcy, dcxy, dtx, dty, dcx1, dcy1, dcxy1, dtx1, dty1;
	int x, y;
	aDbg_testWin(w, "AWin_drawOval");
	aDbg_testCol(c, "AWin_drawOval");
	dcx = 0.5 * (sx - 1);
	dcy = 0.5 * (sy - 1);
	dcxy = (dcx + 0.5) * (dcy + 0.5) - 0.1;
	dcxy *= dcxy;
	dcx1 = 0.5 * (sx - (1 + ADrawOvalParam * 2));
	dcy1 = 0.5 * (sy - (1 + ADrawOvalParam * 2));
	dcxy1 = (dcx1 + 0.5) * (dcy1 + 0.5) - 0.1;
	dcxy1 *= dcxy1;
	for (y = 0; y < sy; y++) {
		dty  = (y - dcy) * dcx;
		dty1 = (y - dcy) * dcx1;
		for (x = 0; x < sx; x++) {
			dtx = (x - dcx) * dcy;
			dtx1 = (x - dcx) * dcy1;
			if (dtx * dtx + dty * dty > dcxy) continue;
			if (ADrawOvalParam <= x && x < sx - ADrawOvalParam && ADrawOvalParam <= y && y < sy - ADrawOvalParam) {
				if (dtx1 * dtx1 + dty1 * dty1 < dcxy1) continue;
			}
			AWin_setPixOpt0(w, x + x0, y + y0, c);
		}
	}
}

AStatic void AWin_drawOvalOpt(AWin *w, AInt opt, AInt32 sx, AInt32 sy, AInt32 x0, AInt32 y0, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { sx <<=4; sy <<= 4; x0 <<= 4; y0 <<= 4; }
	AWin_drawOvalOpt0(w, sx, sy, x0, y0, c);
}

AStatic void AWin_fillOvalCentOpt(AWin *w, AInt8 opt, AInt16 x, AInt16 y, AInt16 a, AInt16 b, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; a <<= 4; b <<= 4; }
	AWin_fillOvalOpt0(w, a * 2, b * 2, x - a, y - b, c);
}

AStatic void AWin_drawOvalCentOpt(AWin *w, AInt8 opt, AInt16 x, AInt16 y, AInt16 a, AInt16 b, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; a <<= 4; b <<= 4; }
	AWin_drawOvalOpt0(w, a * 2, b * 2, x - a, y - b, c);
}

static AInt32 AWin_colTbl16[16] = {
	0x000000, 0x0000ff, 0x00ff00, 0x00ffff, 0xff0000, 0xff00ff, 0xffff00, 0xffffff,
	0x555555, 0x0000aa, 0x00aa00, 0x00aaaa, 0xaa0000, 0xaa00aa, 0xaaaa00, 0xaaaaaa
};

AInlineStatic AInt32 AWin_col16(AInt i) { return AWin_colTbl16[i]; }

AClass(AWin_Point) {
	int x, y;
};

AStatic void AWin_fillOpt0(AWin *w, AInt32 x, AInt32 y, AInt32 c)
{
	int b, sp, sx = w->xsiz, sy = w->ysiz, u, v, *q = w->buf;
	AWin_Point *p;
	if (x < 0 || x >= sx || y < 0 || y >= sy || c < 0) return;
	b = q[x + y * sx];
	if (b == c) return;
	p = AMem_malloc(w->ca->mem, sx * sy * aSizeof (AWin_Point));
	sp = 0; p[sp].x = x; p[sp].y = y; q[x + y * sx] = c;
	do {
		x = p[sp].x;
		y = p[sp].y;
		sp--;
		u = x;     v = y + 1; if (v < sy && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
		u = x;     v = y - 1; if (v >= 0 && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
		u = x + 1; v = y;     if (u < sx && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
		u = x - 1; v = y;     if (u >= 0 && q[u + v * sx] == b) { sp++; p[sp].x = u; p[sp].y = v; q[u + v * sx] = c; }
	} while (sp >= 0);
	AMem_free(w->ca->mem, sx * sy * aSizeof (AWin_Point), p);
}

AStatic void AWin_fillOpt(AWin *w, AInt8 opt, AInt32 x, AInt32 y, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	AWin_fillOpt0(w, x, y, c);
}

#if (!defined(ANoUse_DrawStr))

AStatic AUInt8a AWin_fontData[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x00, 0x00,
	0x10, 0x3a, 0x56, 0x92, 0x92, 0x90, 0x50, 0x38, 0x14, 0x12, 0x92, 0x92, 0xd4, 0xb8, 0x10, 0x10,
	0x62, 0x92, 0x94, 0x94, 0x68, 0x08, 0x10, 0x10, 0x20, 0x2c, 0x52, 0x52, 0x92, 0x8c, 0x00, 0x00,
	0x00, 0x70, 0x88, 0x88, 0x88, 0x90, 0x60, 0x47, 0xa2, 0x92, 0x8a, 0x84, 0x46, 0x39, 0x00, 0x00,
	0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x00,
	0x80, 0x40, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x40, 0x80, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x08, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x80, 0x80,
	0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x02, 0x04, 0x08, 0x10, 0x20, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x02, 0x02, 0x04, 0x18, 0x04, 0x02, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x0c, 0x0c, 0x0c, 0x14, 0x14, 0x14, 0x24, 0x24, 0x44, 0x7e, 0x04, 0x04, 0x1e, 0x00, 0x00,
	0x00, 0x7c, 0x40, 0x40, 0x40, 0x58, 0x64, 0x02, 0x02, 0x02, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x7e, 0x42, 0x42, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x26, 0x1a, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x08, 0x10,
	0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x04, 0x08, 0x10, 0x10, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x9c, 0x80, 0x46, 0x38, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x18, 0x18, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xf0, 0x48, 0x44, 0x44, 0x44, 0x48, 0x78, 0x44, 0x42, 0x42, 0x42, 0x44, 0xf8, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x42, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x42, 0x44, 0x38, 0x00, 0x00,
	0x00, 0xf8, 0x44, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x44, 0xf8, 0x00, 0x00,
	0x00, 0xfe, 0x42, 0x42, 0x40, 0x40, 0x44, 0x7c, 0x44, 0x40, 0x40, 0x42, 0x42, 0xfe, 0x00, 0x00,
	0x00, 0xfe, 0x42, 0x42, 0x40, 0x40, 0x44, 0x7c, 0x44, 0x44, 0x40, 0x40, 0x40, 0xf0, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x42, 0x82, 0x80, 0x80, 0x9e, 0x82, 0x82, 0x82, 0x42, 0x46, 0x38, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x48, 0x30, 0x00,
	0x00, 0xe7, 0x42, 0x44, 0x48, 0x50, 0x50, 0x60, 0x50, 0x50, 0x48, 0x44, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xf0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0xfe, 0x00, 0x00,
	0x00, 0xc3, 0x42, 0x66, 0x66, 0x66, 0x5a, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xc7, 0x42, 0x62, 0x62, 0x52, 0x52, 0x52, 0x4a, 0x4a, 0x4a, 0x46, 0x46, 0xe2, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x00, 0xf8, 0x44, 0x42, 0x42, 0x42, 0x44, 0x78, 0x40, 0x40, 0x40, 0x40, 0x40, 0xf0, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0x8a, 0x44, 0x3a, 0x00, 0x00,
	0x00, 0xfc, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x82, 0x82, 0x80, 0x40, 0x38, 0x04, 0x02, 0x82, 0x82, 0xc4, 0xb8, 0x00, 0x00,
	0x00, 0xfe, 0x92, 0x92, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x3c, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x24, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x5a, 0x5a, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x24, 0x24, 0x24, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xee, 0x44, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0xfe, 0x84, 0x84, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x42, 0x82, 0xfe, 0x00, 0x00,
	0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00,
	0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x04, 0x02, 0x02,
	0x00, 0x7c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00,
	0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00,
	0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x04, 0x3c, 0x44, 0x84, 0x84, 0x8c, 0x76, 0x00, 0x00,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4c, 0x84, 0x84, 0x80, 0x80, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x0c, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x36, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0xfc, 0x80, 0x82, 0x42, 0x3c, 0x00, 0x00,
	0x0e, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x34, 0x04, 0x04, 0x78,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe3, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x30,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x4e, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0xe6, 0x00, 0x00,
	0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0xdb, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe3, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0xe0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x34, 0x04, 0x0e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x62, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x86, 0x82, 0xc0, 0x38, 0x06, 0x82, 0xc2, 0xbc, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x5a, 0x5a, 0x5a, 0x24, 0x24, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x44, 0x28, 0x28, 0x10, 0x28, 0x28, 0x44, 0xc6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x10, 0x10, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x84, 0x08, 0x10, 0x20, 0x42, 0x82, 0xfe, 0x00, 0x00,
	0x00, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x60, 0x10, 0x10, 0x10, 0x10, 0x08, 0x06, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x60, 0x10, 0x08, 0x08, 0x08, 0x08, 0x06, 0x08, 0x08, 0x08, 0x08, 0x10, 0x60, 0x00, 0x00,
	0x00, 0x72, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0xfe, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00
};

AStatic void AWin_drawStr0(AWin *w, AInt16 x, AInt16 y, AInt32 c, AInt32 b, const char *s)
{
	AInt i, j, ch;
	AInt16 k, pt;
	aDbg_testWin(w, "aDrawStr0");
	aDbg_testCol(c, "aDrawStr0");
	for (i = 0; s[i] != '\0'; i++) {
		#if (ADbgLv >= 2)
			if (x < 0 || w->xsiz < 8 + x || y < 0 || w->ysiz < 16 + y)
				aErrExit("aDrawStr0 : out of range");
		#endif
		ch = s[i];
		if (ch < ' ' || ch > 0x7f) ch = ' ';
		ch = (ch - ' ') * 16;
		for (j = 0; j < 16; j++) {
			pt = AWin_fontData[ch + j];
			for (k = 0; k < 8; k++) {
				if ((pt & 0x80) != 0) {
					AWin_setPix0(w, x + k, y + j, c);
				} else {
					AWin_setPix0(w, x + k, y + j, b);
				}
				pt <<= 1;
			}
		}
		x += 8;
	}
}

AStatic void AWin_drawStrOpt0(AWin *w, AInt32 x, AInt32 y, AInt32 c, AInt32 b, const char *s)
{
	AInt i, j, ch;
	AInt16 k, pt;
	aDbg_testWin(w, "aDrawStr");
	aDbg_testCol(c, "aDrawStr");
	for (i = 0; s[i] != '\0'; i++) {
		ch = s[i];
		if (ch < ' ' || ch > 0x7f) ch = ' ';
		ch = (ch - ' ') * 16;
		for (j = 0; j < 16; j++) {
			pt = AWin_fontData[ch + j];
			for (k = 0; k < 8; k++) {
				if ((pt & 0x80) != 0) {
					if (c >= 0)
						AWin_setPixOpt0(w, x + k, y + j, c);
				} else {
					if (b >= 0)
						AWin_setPixOpt0(w, x + k, y + j, b);
				}
				pt <<= 1;
			}
		}
		x += 8;
	}
}

AStatic void AWin_drawStrOpt(AWin *w, AInt8 opt, AInt32 x, AInt32 y, AInt32 c, AInt32 b, const char *s)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c& 15]; if (b >= 0) c = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	AWin_drawStrOpt0(w, x, y, c, b, s);
}

#endif

#if (AWinKey_BufSiz > 0)

AInlineStatic AInt32 aInkeySub1(AWin *w, AInt i) { return w->keyBuf[(w->kbr + i) & (AWinKey_BufSiz - 1)]; }

AStatic AInt aInkeySub0(AWin *w)
{
	AInt32 i, j;
	if (w->kbr == w->kbw) return 0;
	i = w->keyBuf[w->kbr];
	w->inkeyPrm[0] = i;
	if ((i & 0xc000) == 0) return 1;
	if ((i & 0xc000) == 0x4000) {
		j = w->keyBuf[(w->kbr + 1) & (AWinKey_BufSiz - 1)];
		w->inkeyPrm[1] = j & 0xffff;
		if ((w->inkeyPrm[1] & 0x8000) != 0) {
			w->inkeyPrm[1] -= 0x10000;
			if (w->inkeyPrm[1] == -0x8000)
				w->inkeyPrm[1] = ~(AInt) 0x7fffffff; // (AInt) (-1) << 31;
		}
		w->inkeyPrm[2] = (j >> 16) & 0xffff;
		if ((w->inkeyPrm[2] & 0x8000) != 0)
			w->inkeyPrm[2] -= 0x10000;
		return 2;
	}
	#if (ADbgLv >= 2)
		aErrExit("aInkeySub0: internal error: i=0x%x", i);
	#endif
	return 0; // dummy
}

AStatic AInt32 aInkey(AWin *w, AInt flg)
{
	aDbg_testWin(w, "aInkey");
	ACA_wait0(w->ca, 0);
	AInt i = aInkeySub0(w);
	if (i == 0) return 0;
	if ((flg & 1) != 0)
		w->kbr = (w->kbr + i) & (AWinKey_BufSiz - 1);
	i = w->inkeyPrm[0];
	if ((flg & 2) == 0) i &= 0xffff;
	return i;
}

#if (ADbgLv < 2)

AInlineStatic void aClrKeybuf(AWin *w) { w->kbw = w->kbr = 0; }

#else

AStatic void aClrKeybuf(AWin *w)
{
	aDbg_testWin(w, "aClrKeybuf");
	w->kbw = w->kbr = 0;
}

#endif

AStatic void aSetInkey(AWin *w, AInt8 mod)
{
	aDbg_testWin(w, "aSetInkey");
	w->keyLv =  mod       & 0xf;
	w->mosLv = (mod >> 4) & 0xf;
	aClrKeybuf(w);
}

AStatic AInt32 aInkeyWait(AWin *w, AInt flg)
{
	aDbg_testWin(w, "aInkeyWait");
	if (w->kbr != w->kbw)
		return aInkey(w, flg);
	AWin_flushAll(0);
	while (w->kbr == w->kbw)
		ACA_wait0(w->ca, 32);
	return aInkey(w, flg);
}

#endif

AStatic AWin *AWin_openExOptCa(AComArg *aCA, AInt8 opt, AInt16 xs, AInt16 ys, const char *t)
{
	if ((opt & 2) == 0) { xs <<= 4; ys <<= 4; }
	AWin *w = AWin_openCa(aCA, xs, ys, t);
	w->cbxs = xs >> 4;
	w->cbys = ys >> 4;
	w->cb = AMem_malloc(aCA->mem, w->cbxs * w->cbys * (3 * sizeof (AInt32a)));
	memset(w->cb, 0, w->cbxs * w->cbys * (3 * sizeof (AInt32a)));
	w->savBuf = AMem_malloc(aCA->mem, 256 * 16 * sizeof (AInt32a));
	AInt i;
	for (i = 0; i < 16; i++)
		w->savXy[i * 2 + 0] = 0x7fffffff;
	memcpy(w->pal, AWin_colTbl16, sizeof AWin_colTbl16);
	w->optDef = 0;
	return w;
}

AStatic AInt32 AWin_getPal(AWin *w, AInt32 c)
{
	return w->pal[c & 15];
}

AStatic void AWin_echOpt0(AWin *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	AInt16 ecx = x >> 4, ecy = y >> 4;
	if ((opt & 4) == 0 && 0 <= ecx && ecx < w->cbxs && 0 <= ecy && ecy < w->cbys) {
		AInt xy = (ecx + ecy * w->cbxs) * 3;
		w->cb[xy + 0] = ch;
		w->cb[xy + 1] = c;
		w->cb[xy + 2] = b;
	}
	AInt xsiz = w->xsiz;
	AInt32 xx, yy, *q = &w->buf[x + y * xsiz], t;
	const char *p = &AWin_chrFontEx[ch * 256];
	for (yy = 0; yy < 16; yy++) {
		if (0 <= y + yy && y + yy < w->ysiz) {
			for (xx = 0; xx < 16; xx++) {
				if (0 <= x + xx && x + xx < xsiz) {
					t = b;
					if (p[xx + yy * 16] == '*')
						t = c;
					if (t >= 0)
						q[xx + yy * xsiz] = t;
				}
			}
		}
	}
}

AStatic void AWin_echOpt(AWin *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	AWin_echOpt0(w, opt, x, y, ch, c, b);
}

AStatic void AWin_clsOpt(AWin *w, AInt8 opt, AInt32 c)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; }
	AWin_fillRectOpt0(w, w->xsiz, w->ysiz, 0, 0, c);
	AInt i;
	for (i = 0; i < 16; i++)
		w->savXy[i * 2 + 0] = 0x7fffffff;
	if ((opt & 4) == 0)
		memset(w->cb, 0, w->cbxs * w->cbys * (3 * sizeof (AInt32a)));
}

AStatic AInt AWin_getEchOpt(AWin *w, AInt8 opt, AInt16 x, AInt16 y, AInt8 ofs)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 2) != 0) { x >>= 4; y >>= 4; }
	return w->cb[(x + y * w->cbxs) * 3 + ofs];
}

AStatic void AWin_echBoxOpt0(AWin *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	AInt xx, yy;
	for (yy = 0; yy < ys; yy += 16) {
		for (xx = 0; xx < xs; xx += 16)
			AWin_echOpt0(w, opt, x + xx, y + yy, ch, c, b);
	}
}

AStatic void AWin_echBoxOpt(AWin *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; xs <<= 4; ys <<= 4; }
	AWin_echBoxOpt0(w, opt, xs, ys, x, y, ch, c, b);
}


#if 0

AINLINESTATIC AInt32 aRgb8_nd(AInt32 r, AInt32 g, AInt32 b) { return r << 16 | g << 8 | b; }





















AStatic AInt32 aGetEchBoxOpt(AWin *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt8 ofs)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 2) != 0) { x >>= 4; y >>= 4; xs >>= 4; ys >>= 4; }
	AInt32 c = -1, cc;
	AInt16 xx, yy;
	for (yy = 0; yy < ys; yy++) {
		for (xx = 0; xx < xs; xx++) {
			if (0 <= x + xx && x + xx < w->cbxs && 0 <= y + yy && y + yy < w->cbys) {
				cc = w->cb[((x + xx) + (y + yy) * w->cbxs) * 3 + ofs];
				if (c == -1) c = cc;
				if (c != cc) return -1;
			}
		}
	}
	return c;
}

AStatic AInt aSaturateInt(AInt i, AInt i0, AInt i1)
{
	if (i < i0) i = i0;
	if (i > i1) i = i1;
	return i;
}

AStatic void aWaitKey(AWin *w, AInt32 k)
{
	for (;;) {
		aWait(100);
		for (;;) {
			AInt32 i = aInkey(w, 1);
			if (i == k) return;
			if (i == 0) break;
		}
	}
}

AStatic AInt aMoveDx(AInt32 k)
{
	AInt dx = 0;
	if (k == AKEY_LEFT)  dx = -1;
	if (k == AKEY_RIGHT) dx = +1;
	return dx;
}

AStatic AInt aMoveDy(AInt32 k)
{
	AInt dy = 0;
	if (k == AKEY_UP)   dy = -1;
	if (k == AKEY_DOWN) dy = +1;
	return dy;
}

AStatic void aEchSav0(AWin *w, AInt16 x, AInt16 y)
{
	AInt i, xx, yy;
	for (i = 0; i < 16; i++) {
		if (w->savXy[i * 2 + 0] == 0x7fffffff) goto skip;
	}
	goto fin;
skip:
	w->savXy[i * 2 + 0] = x;
	w->savXy[i * 2 + 1] = y;
	AInt xsiz = w->xsiz;
	AInt32a *p = &w->buf[x + y * xsiz];
	for (yy = 0; yy < 16; yy++) {
		if (0 <= y + yy && y + yy < w->ysiz) {
			for (xx = 0; xx < 16; xx++) {
				if (0 <= x + xx && x + xx < xsiz) {
					w->savBuf[i * 256 + yy * 16 + xx] = p[xx + yy * xsiz];
				}
			}
		}
	}
fin:	;
}

AStatic void aEchSavOpt(AWin *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
	aEchSav0(w, x, y);
	aEchOpt0(w, 4, x, y, ch, c, b);
}

AStatic void aEchRst(AWin *w)
{
	AInt i, x, y, xx, yy;
	AInt xsiz = w->xsiz;
	AInt32 *p = w->buf;
	for (i = 15; i >= 0; i--) {
		x = w->savXy[i * 2 + 0];
		if (x == 0x7fffffff) continue;
		y = w->savXy[i * 2 + 1];
		w->savXy[i * 2 + 0] = 0x7fffffff;
		for (yy = 0; yy < 16; yy++) {
			if (0 <= y + yy && y + yy < w->ysiz) {
				for (xx = 0; xx < 16; xx++) {
					if (0 <= x + xx && x + xx < xsiz) {
						p[(x + xx) + (y + yy) * xsiz] = w->savBuf[i * 256 + yy * 16 + xx];
					}
				}
			}
		}
	}
}

AStatic AInt aInkey_waitRC(AWin *w, AInt32 msec)
{
	aClrKeybuf(w);
	aWait(msec);
	AInt k = aInkey(w, 1);
	aEchRst(w);
	return k;
}

AStatic AInt aInkey_waitR(AWin *w, AInt32 msec)
{
	aWait(msec);
	AInt k = aInkey(w, 1);
	aEchRst(w);
	return k;
}

AStatic void aScrollOpt(AWin *w, AInt8 opt, AInt16 xs, AInt16 ys, AInt16 x, AInt16 y, AInt16 dx, AInt16 dy, AInt16 mod, AInt32 ch, AInt32 c, AInt32 b)
{
	if (opt == -1) opt = w->optDef;
	AInt32 xsiz = w->xsiz, ysiz = w->ysiz, *p = w->buf, yy;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; xs <<= 4; ys <<= 4; dx <<= 4; dy <<= 4; }
	if (xs > 0 && ys > 0 && 0 <= x && x + xs <= xsiz && 0 <= y && y + ys <= ysiz && 0 <= x + dx && x + dx + xs <= xsiz && 0 <= y + dy && y + dy + ys <= ysiz) {
		if (dy <= 0) {
			for (yy = 0; yy < ys; yy++) {
				memmove(&p[(x + dx) + (y + dy + yy) * xsiz], &p[x + (y + yy) * xsiz], xs * sizeof (AInt32a));
			}
			if ((opt & 4) == 0) {
				for (yy = 0; yy < ys; yy += 16) {
					memmove(&w->cb[(((x + dx) + (y + dy + yy) * w->cbxs) >> 4) * 3], &w->cb[((x + (y + yy) * w->cbxs) >> 4) * 3], (xs >> 4) * 3 * sizeof (AInt32a));
				}
			}
		} else {
			for (yy = ys - 1; yy >= 0; yy--) {
				memmove(&p[(x + dx) + (y + dy + yy) * xsiz], &p[x + (y + yy) * xsiz], xs * sizeof (AInt32a));
			}
			if ((opt & 4) == 0) {
				for (yy = ys - 16; yy >= 0; yy -= 16) {
					memmove(&w->cb[(((x + dx) + (y + dy + yy) * w->cbxs) >> 4) * 3], &w->cb[((x + (y + yy) * w->cbxs) >> 4) * 3], (xs >> 4) * 3 * sizeof (AInt32a));
				}
			}
		}
		if (mod == 1) {
			if (dx <  0 && dy == 0) aEchBoxOpt0(w, opt & ~3, - dx, ys, x + xs + dx, y, ch, c, b);
			if (dx >  0 && dy == 0) aEchBoxOpt0(w, opt & ~3,   dx, ys, x,           y, ch, c, b);
			if (dx == 0 && dy <  0) aEchBoxOpt0(w, opt & ~3, xs, - dy, x, y + ys + dy, ch, c, b);
			if (dx == 0 && dy >  0) aEchBoxOpt0(w, opt & ~3, xs,   dy, x, y,           ch, c, b);
		}
	}
}

AStatic void aGrPrintfOpt(AWin *w, AInt8 opt, AInt16 x, AInt16 y, AInt32 c, AInt32 b, const char *f,...)
{
	char s[1024];
    va_list ap;
	if (opt == -1) opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
    va_start(ap, f);
    vsprintf(s, f, ap);
	aDrawStrOpt0(w, x, y, c, b, s);
}

AStatic void aGrPrintf(AWin *w, AInt16 x, AInt16 y, AInt32 c, AInt32 b, const char *f,...)
{
	char s[1024];
    va_list ap;
	AInt8 opt = w->optDef;
	if ((opt & 1) == 0) { if (c >= 0) c = w->pal[c & 15]; if (b >= 0) b = w->pal[b]; }
	if ((opt & 2) == 0) { x <<= 4; y <<= 4; }
    va_start(ap, f);
    vsprintf(s, f, ap);
	aDrawStrOpt0(w, x, y, c, b, s);
}


AStatic void aBitBlt(AWin *w, AInt sx, AInt sy, AInt x, AInt y, AInt32a *p)
{
	AInt32a *q = &w->buf[x + y * w->xsiz];
	AInt i, j;
	for (j = 0; j < sy; j++) {
		for (i = 0; i < sx; i++) {
			q[i] = p[i];
		}
		p += sx;
		q += w->xsiz;
	}
}



#endif

#define AWin_Cf		1	// 16col / 16Mcol
#define AWin_Rf		2	// W16hbgP / 1hbgP
#define AWin_RfCf	3
#define AWin_Ec		4	// LN^[obt@ɏ / Ȃ
#define AWin_EcCf	5
#define AWin_EcRf	6
#define AWin_EcRfCf	7


#define aOpenWinEx(xs, ys, t)			AWin_openExOptCa(aCA, 0, xs, ys, t)
#define aOpenWinExOpt(opt, xs, ys, t)	AWin_openExOptCa(aCA, opt, xs, ys, t)
#define aEch(w, x, y, ch, c, b)			AWin_echOpt(w, -1, x, y, ch, c, b)
#define aEchBox(w, xs, ys, x, y, ch, c, b)	AWin_echBoxOpt(w, -1, xs, ys, x, y, ch, c, b)
#define aCls(w, c)						AWin_clsOpt(w, -1, c)
#define aScroll(w, xs, ys, x, y, dx, dy, mod, ch, c, b)		aScrollOpt(w, -1, xs, ys, x, y, dx, dy, mod, ch, c, b)
#define aEchSav(w, x, y, ch, c, b)		aEchSavOpt(w, -1, x, y, ch, c, b)
//#define aGetPix(w, x, y)				AWin_getPixOpt(w, -1, x, y)
#define aGetEch(w, x, y)				AWin_getEchOpt(w, -1, x, y, 0)
#define aGetEchCol(w, x, y)				AWin_getEchOpt(w, -1, x, y, 1)
#define aGetEchBak(w, x, y)				AWin_getEchOpt(w, -1, x, y, 2)
#define aGetEchBox(w, xs, ys, x, y)		AWin_getEchBoxOpt(w, -1, xs, ys, x, y, 0)
#define aGetEchBoxCol(w, xs, ys, x, y)	AWin_getEchBoxOpt(w, -1, xs, ys, x, y, 1)
#define aGetEchBoxBak(w, xs, ys, x, y)	AWin_getEchBoxOpt(w, -1, xs, ys, x, y, 2)
#define aDrawStr(w, x, y, c, b, s)		AWin_drawStrOpt(w, -1, x, y, c, b, s)


