#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, const char **argv)
{
	char cachePath[1024], cacheExe[1024+4], s[1024*2];
	if (argc <= 1) return 1;
	sprintf(cachePath, "cache\\%s", argv[1]);
	int i;
	for (i = 6; cachePath[i] != 0; i++) {
		if (cachePath[i] == '/' || cachePath[i] == ':' || cachePath[i] == '\\')
			cachePath[i] = '_';
	}
	sprintf(cacheExe, "%s.exe", cachePath);
	int sz = 16 * 1024 * 1024;
	char *b0 = malloc(sz);
	char *b1 = malloc(sz);
	FILE *fp;
	fp = fopen(argv[1], "rb");
	if (fp == 0) {
		fprintf(stderr, "fopen error: %s\n", argv[1]);
		return 1;
	}
 	int fsz0 = fread(b0, 1, sz, fp);
 	fclose(fp);
	fp = fopen(cachePath, "rb");
	if (fp == 0) goto compile;
	int fsz1 = fread(b1, 1, sz, fp);
	fclose(fp);
	if (fsz0 == fsz1 && memcmp(b0, b1, fsz0) == 0) {
		fp = fopen(cacheExe, "rb");
		fclose(fp);
		if (fp != 0) goto skip;
	}
compile:
	fprintf(stderr, "compiling...\n");
	sprintf(s, "ecc0 %s > tmp.c", argv[1]);
	if (system(s) != 0) return 1;
	sprintf(s, "gcc -m32 -Wall -Wextra -Wl,-s,-Map,tmp_map.txt -Wno-unused-function -Wno-unused-but-set-variable -Wno-unused-label -Os -DAArch_X86 -DAGraph_Win -DADbgLv=1 -DAStatic= -I./acl1 -o %s tmp.c -lgdi32 -lwinmm", cacheExe);
	if (system(s) != 0) return 1;
	fp = fopen(cachePath, "wb");
	fwrite(b0, 1, fsz0, fp);
	fclose(fp);
	fprintf(stderr, "done.\n");
skip:
	return system(cacheExe);
}
