#include <acl1.c>

typedef char *String; // Ă String  char * ̑ƂĎg.
typedef int *TknStr; // TknStr  int * ̑.

#define MaxTkn  1000 // g[NR[h̍ől(+1).
String tStr[MaxTkn]; // g[N̓e()L.
int tokens = 1;	// o^ς݂̑g[N.
intptr_t var[MaxTkn]; // ϐ.
#define MaxPhr  1000 // t[YECfbNX̍ől.
TknStr phr_tkn[MaxPhr];
enum { TcSemi = 1, TcColon, TcNot, TcEEq, TcNEq, TcLt, TcGe, TcLe, TcGt, TcBrOpn, TcBrCls,
    TcSqBrOpn, TcSqBrCls, TcCrBrOpn, TcCrBrCls, TcPlus, TcMinus, TcAster, TcSlash, TcPerce,
    TcAnd, TcXor, TcShr, TcPlPlus, TcEqu, TcComma, TcWiCard, TcExpr, TcExpr0, Tc0, Tc1, TcAndAnd,
    TcOrOr, TcTmp0, TcTmp1, TcTmp2, TcTmp3, TcTmp4, TcTmp5, TcTmp6, TcTmp7, TcTmp8, TcTmp9 };
char tknInit[] = "; : ! == != < >= <= > ( ) [ ] { } + - * / % & ^ >> ++ = , .! .% .& 0 1 && || "
    "_t0 _t1 _t2 _t3 _t4 _t5 _t6 _t7 _t8 _t9";
enum { OpCpy = 0, OpCeq, OpCne, OpClt, OpCge, OpCle, OpCgt, OpAdd, OpSub, OpMul, OpDiv, OpMod,
    OpAnd, OpXor, OpShr, OpAdd1, OpNeg, OpGoto, OpJeq, OpJne, OpJlt, OpJge, OpJle, OpJgt, OpLoop,
    OpPrint, OpTime, OpEnd, OpPrints, OpAryNew, OpAryInit, OpArySet, OpAryGet, OpPrm,
    OpPrntf1, OpPrntf2, OpOpnWin, OpSetPix, OpRgb8, OpFilRct, OpSetMod, OpDrwLin, OpFilOvC, OpWait,
    OpSqrt, OpSin, OpCos, OpIsClos, OpMulShr, OpAgMxLI, OpCol16, OpUdMnMx, OpSwpTmp, OpOpWnEx,
    OpEchBox, OpEch, OpRnd, OpGetEch, OpAgMxRI, OpOpnPly, OpPlyMml, OpPlyRun, OpPrsp, OpPrlf,
    OpPrs, OpInput };
#define IcSiz  10000
intptr_t ic[IcSiz], ici; // ic[]:R[hAici:ic[]̂ǂɏނ.
#define SzInt  sizeof (intptr_t)
AComArg *aCA;
AWin *win;
APlay *ply;

String loadText(String path)  // t@Cǂݍ.
{
    int siz = 1000000; // 100Ȃ̂ŁAőŖ1MB܂őΉ.
    FILE *fp = fopen(path, "rb");
    if (fp == 0) {
        printf("fopen error : %s\n", path);
        return 0;
    }
    String s = malloc(siz);
    int i = fread(s, 1, siz - 1, fp);
    fclose(fp);
    if (i == siz - 1)
        printf("too large file : %s\n", path);
    s[i] = 0; // 0ǉ.
    return realloc(s, i + 1); // s̑傫i+1oCgɕύX̂Ԃ.
}

int token(String s)  // g[NR[h߂.
{
    int i, j, k, l;
    for (i = 1; i < tokens; i++) {
        if (strcmp(s, tStr[i]) == 0) return i; // .
    }
    if (i >= MaxTkn - 1) { // ɗƂ i == tokens ɂȂĂ.
        printf("too many tokens\n");
        exit(1);
    }
    tokens++; // Ȃ̂ŐVKo^.
    tStr[i] = malloc(strlen(s) + 1); // sRs[̂ɏ\ȑ傫̔zp.
    var[i] = strtol(strcpy(tStr[i], s), 0, 0); // strcpyŃRs[ĂA萔ꍇɏlݒi萔ł͂ȂƂ0ɂȂj.
    if (tStr[i][0] == 34) { // 擪_uNH[e[V
        j = strlen(s) - 2;
        char *p = malloc(j + 1), *q = tStr[i] + 1;
        var[i] = (intptr_t) p;
        k = 0;
        for (l = 0; l < j;) {
            if (q[l] != 92) {
                p[k++] = q[l++];
                continue;
            }
            l++;
            if (q[l] == 'n') {
                p[k++] = 10;
                l++;
                continue;
            }
            if (q[l] == 'r') {
                p[k++] = 13;
                l++;
                continue;
            }
            p[k++] = q[l++];
        }
//        memcpy(p, tStr[i] + 1, strlen(s) - 2); // 蔲iGXP[vV[PXĂȂj.
//        p[strlen(s) - 2] = 0;
        p[k] = 0;
    }
    return i;
}

int isAlphabetOrNumber(unsigned char c)  // ϐɎgpł镶ǂ.
{
    if ('0' <= c && c <= '9') return 1;
    if ('a' <= c && c <= 'z') return 1;
    if ('A' <= c && c <= 'Z') return 1;
    if (c == '_') return 1;
    return 0;
}

TknStr lexer(String s) // vOg[Nɕϊ.
{
    int pc, qc, len; // pc:s[]̂ǂǂł邩Aqc:ǂ܂ŏo͂ip̎qȂ̂ŁAKqcɂ܂j.
    int siz = 1000000; // ő100g[N܂őΉ.
    if (s == 0) return 0; // sۂȂÂ܂0ԂďI.
    TknStr t = malloc(siz * sizeof (int));  // sizint̔z.
    for (pc = qc = 0; s[pc] != 0;) {
        if (s[pc] == ' ' || s[pc] == '\t' || s[pc] == '\n' || s[pc] == '\r') {	// Xy[XA^uAs.
            pc++;
            continue;
        }
        if (s[pc] == '/' && s[pc + 1] == '/') {
            while (s[pc] != 0 && s[pc] != '\n')
                pc++;
            continue;
        }
        len = 0;
        if (strchr("(){}[];,", s[pc]) != 0) {	// 1L.
            len = 1;
        } else if (isAlphabetOrNumber(s[pc]) != 0) {  // 1ڂp.
            while (isAlphabetOrNumber(s[pc + len]) != 0)
                len++;
        } else if (strchr("=+-*/!%&^~|<>?:.#", s[pc]) != 0) {  // 1ڂʂ̋L.
            while (s[pc + len] != 0 && strchr("=+-*/!%&^~|<>?:.#", s[pc + len]) != 0)
                len++;
        } else if (s[pc] == 34 || s[pc] == 39) { // "" or ''.
            len = 1;
            while (s[pc + len] != s[pc] && s[pc + len] >= ' ')
                len++;
            if (s[pc + len] == s[pc])
                len++;
        } else {
            printf("syntax error : %.10s\n", &s[pc]);
            free(t);
            return 0;
        }
        char tkn[10000]; // g[N͍őł10000܂.
        tkn[len] = 0; // 0ɓĂ.
        t[qc++] = token(strncpy(tkn, &s[pc], len)); // lenRs[tokenĂяoǍʂtɓ.
        pc += len;
    }
    t[qc] = t[qc + 1] = t[qc + 2] = t[qc + 3] = 0; // 0. 30Ă̂̓G[̒P̂߂̂܂.
    return realloc(t, (qc + 4) * sizeof (int)); // qc+4ɕύX.
}

int phr(int i, String phrs, TknStr s, int *wpc)
{
    int j, k, pc = wpc[0];
    TknStr t = phr_tkn[i];
    if (t == 0) { // ̌Ăяo.
        t = phr_tkn[i] = lexer(phrs);
        if (phrs[0] != ' ') { // ȗ`𒼂.
            for (j = 0; t[j] != 0; j++) {
                if (t[j] == TcNot)   t[j] = TcWiCard;
                if (t[j] == TcPerce) t[j] = TcExpr;
                if (t[j] == TcAnd)   t[j] = TcExpr0;
            }
        }
    }
    for (j = 0; t[j] != 0; j++) { // r̃[v.
        if (t[j] == TcWiCard && s[pc] != 0) { // ChJ[h.
            wpc[var[t[++j]]] = pc++;  // ̐lǂŁAChJ[hʒuL.
        } else if (t[j] == TcExpr || t[j] == TcExpr0) { // .
            wpc[var[t[++j]]] = pc;  // ̐lǂŁAʒuL.
            for (k = 0; ; pc++) {
                if (s[pc] == TcSemi) break;
                if (s[pc] == TcComma && k == 0) break;
                if (s[pc] == TcBrOpn || s[pc] == TcSqBrOpn) k++; // 蔲.
                if (s[pc] == TcBrCls || s[pc] == TcSqBrCls) k--;
                if (k < 0) break;
            }
            wpc[var[t[j]] + 1] = pc;  // IʒuL.
            if (t[j - 1] == TcExpr && wpc[var[t[j]]] == pc) return 0; // 0͕sv.
            if (k > 0) return 0; // JbR̐[sv.
        } else if (t[j] != s[pc++])
            return 0; // svȂI.
    }
    wpc[1] = pc; // ǂ܂œǂݐi߂.
    return 1; // t[Yׂ͂Ĉv.
}

void putIc(int op, int p1, int p2, int p3, int p4)  // ic[]֊ȒPɏނ߂֗̕֐.
{
    ic[ici    ] = op;
    ic[ici + 1] = p1;
    ic[ici + 2] = p2;
    ic[ici + 3] = p3;
    ic[ici + 4] = p4;
    ici += 5;
    if (ici >= IcSiz) {
        printf("ic buffer full\n");
        exit(1);
    }
}

char tmpFlag[10]; // ꎞϐ̗p󋵂Ǘ.

int tmpAlloc() // gp̈ꎞϐm.
{
    int i;
    for (i = 0; i < 10; i++) {
        if (tmpFlag[i] == 0) break;
    }
    if (i >= 10) {
        printf("tmpAlloc: error\n");
        return -1;
    }
    tmpFlag[i] = 1;
    return i + TcTmp0;
}

void tmpFree(int i) // ꎞϐ𖢎gpɖ߂. Aw肳ꂽg[NR[hꎞϐłȂƂ͉Ȃ.
{
    if (TcTmp0 <= i && i <= TcTmp9)
        tmpFlag[i - TcTmp0] = 0;
}

int tmpLabelNo;

int tmpLabelAlloc()
{
    char s[10];
    sprintf(s, "_l%d", tmpLabelNo);
    tmpLabelNo++;
    return token(s);
}

int phrFnc(int i, String phrs, TknStr s, int *wpc, int params, int op, int *pj);

#define Op2(prio)  pc++; e = expr(prio, s, &pc, pc1); j = tmpAlloc(); putIc(op, j, i, e, 0)

int expr(int priority, TknStr s, int *ppc, int pc1)
{
    int pc = *ppc, wpc[99], i = 0, e = 0, j = 0, op; // i͂܂ł̌vZʂĂϐ̃g[NR[hԍ.
    if (pc >= pc1) return 0; // ȂI.
    wpc[0] = pc; // phrg߂̏.
    wpc[1] = 0;
    if (phr(80, "(%2)", s, wpc)) {	// .
        j = expr(99, s, &wpc[2], wpc[3]);
        pc = wpc[1];
    } else if (s[pc] == TcPlPlus) {	// OuCNg.
        pc++; // Zqǂݔ΂.
        j = expr(2, s, &pc, pc1);
        putIc(OpAdd1, j, 0, 0, 0);
    } else if (s[pc] == TcMinus) {	// P}CiX.
        pc++; // Zqǂݔ΂.
        e = expr(2, s, &pc, pc1);
        j = tmpAlloc();
        putIc(OpNeg, j, e, 0, 0);
    } else if (phrFnc(200, "printf(%2)", s, wpc, 1, OpPrntf1, &j)) {
    } else if (phrFnc(201, "printf(%2, %4)", s, wpc, 2, OpPrntf1, &j)) {
    } else if (phrFnc(202, "printf(%2, %4, %6)", s, wpc, 3, OpPrntf1, &j)) {
    } else if (phrFnc(203, "printf(%2, %4, %6, %8)", s, wpc, 4, OpPrntf2, &j)) {
    } else if (phrFnc(204, "printf(%2, %4, %6, %8, %10)", s, wpc, 5, OpPrntf2, &j)) {
    } else if (phrFnc(210, "aOpenWin(%2, %4, %6)", s, wpc, 3, OpOpnWin, &j)) {
    } else if (phrFnc(211, "aSetPix(%2, %4, %6, %8)", s, wpc, 4, OpSetPix, &j)) {
    } else if (phrFnc(212, "aRgb8(%2, %4, %6)", s, wpc, 3, OpRgb8, &j)) {
    } else if (phrFnc(213, "aFillRect(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpFilRct, &j)) {
    } else if (phrFnc(214, "aSetMode(%2, %4)", s, wpc, 2, OpSetMod, &j)) {
    } else if (phrFnc(215, "aDrawLine(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpDrwLin, &j)) {
    } else if (phrFnc(216, "aFillOvalCent(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpFilOvC, &j)) {
    } else if (phrFnc(217, "aWait(%2)", s, wpc, 1, OpWait, &j)) {
    } else if (phrFnc(218, "aFf16Sqrt(%2)", s, wpc, 1, OpSqrt, &j)) {
    } else if (phrFnc(219, "aFf16Sin(%2)", s, wpc, 1, OpSin, &j)) {
    } else if (phrFnc(220, "aFf16Cos(%2)", s, wpc, 1, OpCos, &j)) {
    } else if (phrFnc(221, "AWin_isClose(%2)", s, wpc, 1, OpIsClos, &j)) {
    } else if (phrFnc(222, "aMul64Shr(%2, %4, %6)", s, wpc, 3, OpMulShr, &j)) {
    } else if (phrFnc(223, "aArgMaxLstInt(%2, %4, %6)", s, wpc, 3, OpAgMxLI, &j)) {
    } else if (phrFnc(224, "AWin_col16(%2)", s, wpc, 1, OpCol16, &j)) {
    } else if (phrFnc(225, "AUpdateMinMax(%2, %4, %6)", s, wpc, 3, OpUdMnMx, &j)) {
    } else if (phrFnc(226, "ASwapTmp(%2, %4, %6)", s, wpc, 3, OpSwpTmp, &j)) {
    } else if (phrFnc(227, "aEchBox(%2, %4, %6, %8, %10, %12, %14, %16)", s,wpc,8,OpEchBox,&j)) {
    } else if (phrFnc(228, "aEch(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpEch, &j)) {
    } else if (phrFnc(229, "aRnd(%2)", s, wpc, 1, OpRnd, &j)) {
    } else if (phrFnc(230, "aGetEch(%2, %4, %6)", s, wpc, 3, OpGetEch, &j)) {
    } else if (phrFnc(231, "aArgMaxRndInt(%2, %4, %6)", s, wpc, 3, OpAgMxRI, &j)) {
    } else if (phrFnc(232, "aOpenWinEx(%2, %4, %6)", s, wpc, 3, OpOpWnEx, &j)) {
    } else if (phrFnc(233, "aOpenPlay16(%2)", s, wpc, 1, OpOpnPly, &j)) {
    } else if (phrFnc(234, "APlay_mml(%2, %4, %6)", s, wpc, 3, OpPlyMml, &j)) {
    } else if (phrFnc(235, "APlay_run(%2)", s, wpc, 1, OpPlyRun, &j)) {
    } else if (phrFnc(236, "aPrintTime()", s, wpc, 0, OpTime, &j)) {
    } else if (phrFnc(237, "aInput(%2)", s, wpc, 1, OpInput, &j)) {
    } else // ϐ͒萔.
        j = s[pc++];
    if (wpc[1] > 0)
        pc = wpc[1];
    for (;;) {
        tmpFree(i);
        tmpFree(e);
        i = j;
        if (j < 0 || e < 0) { tmpFree(i); return -1; }	// ܂łŃG[΁Ał؂.
        if (pc >= pc1) break;
        j = e = 0;
        wpc[0] = pc; // phrg߂̏.
        if (s[pc] == TcPlPlus) {		// uCNg.
            pc++;
            j = tmpAlloc();
            putIc(OpCpy,  j, i, 0, 0);
            putIc(OpAdd1, i, 0, 0, 0);
        } else if (phr(81, "[%2]=", s, wpc) && priority >= 15) {
            e = expr(99, s, &wpc[2], wpc[3]);
            pc = wpc[1];
            j = expr(15, s, &pc, pc1);	// EȂ̂15̂܂.
            putIc(OpArySet, i, e, j, 0);
        } else if (phr(82, "[%2]", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            pc = wpc[1];
            j = tmpAlloc();
            putIc(OpAryGet, i, e, j, 0);
        } else if (TcAster <= s[pc] && s[pc] <= TcPerce && priority >= 4) {
            op = OpMul + s[pc] - TcAster; Op2(3); // Ȃ̂41.
        } else if (TcPlus  <= s[pc] && s[pc] <= TcMinus && priority >= 5) {
            op = OpAdd + s[pc] - TcPlus;  Op2(4); // Ȃ̂51.
        } else if (s[pc] == TcShr && priority >= 6) {
            op = OpShr;                   Op2(5); // Ȃ̂51.
        } else if (TcLt    <= s[pc] && s[pc] <= TcGt    && priority >= 7) {
            op = OpClt + s[pc] - TcLt;    Op2(6); // Ȃ̂71.
        } else if (TcEEq   <= s[pc] && s[pc] <= TcNEq   && priority >= 8) {
            op = OpCeq + s[pc] - TcEEq;   Op2(7); // Ȃ̂81.
        } else if (s[pc] == TcAnd && priority >= 9) {
            op = OpAnd;                   Op2(8); // Ȃ̂91.
        } else if (s[pc] == TcXor && priority >= 10) {
            op = OpXor;                   Op2(9); // Ȃ̂101.
        } else if (s[pc] == TcAndAnd && priority >= 12) {
            pc++;
            j = tmpAlloc();
            putIc(OpCpy,  j, Tc0, 0, 0);
            int label = tmpLabelAlloc();
            putIc(OpJeq, label, 0, i, Tc0);
            e = expr(11, s, &pc, pc1); // Ȃ̂121.
            putIc(OpJeq, label, 0, e, Tc0);
            putIc(OpCpy,  j, Tc1, 0, 0);
            var[label] = ici; // x`.
        } else if (s[pc] == TcOrOr && priority >= 13) {
            pc++;
            j = tmpAlloc();
            putIc(OpCpy,  j, Tc1, 0, 0);
            int label = tmpLabelAlloc();
            putIc(OpJne, label, 0, i, Tc0);
            e = expr(12, s, &pc, pc1); // Ȃ̂131.
            putIc(OpJne, label, 0, e, Tc0);
            putIc(OpCpy,  j, Tc0, 0, 0);
            var[label] = ici; // x`.
        } else if (s[pc] == TcEqu && priority >= 15) {
            pc++;
            e = expr(15, s, &pc, pc1);	// EȂ̂15̂܂.
            putIc(OpCpy, i, e, 0, 0);
            j = i; i = 0;
        } else
            break; // 𖞂̂ȂΑł؂.
    }
    if (priority == 99 && pc < pc1) { tmpFree(i); return -1; } // Ō܂ŉ߂łȂG[.
    *ppc = pc; // pc̒l*ppc֏߂.
    return i;
}

enum { IfTrue = 0, IfFalse = 1 };

void ifgoto(TknStr s, int pc, int pc1, int not, int label, int *pe)
{
    if (pc1 - pc == 3 && TcEEq <= s[pc + 1] && s[pc + 1] <= TcGt) { // ̒3g[NŁA^񒆂rZq.
        putIc(((s[pc + 1] - TcEEq) ^ not) + OpJeq, label, 0, s[pc], s[pc + 2]);
    } else {
        int i = expr(99, s, &pc, pc1);
        putIc(OpJne - not, label, 0, i, Tc0);
        tmpFree(i);
        if (i < 0) {
            tmpFree(*pe);
            *pe = -1;
        }
    }
}

int phrFnc(int i, String phrs, TknStr s, int *wpc, int params, int op, int *pj)
{
    int e[11];
    if (phr(i, phrs, s, wpc) == 0) return 0;
    int j = tmpAlloc();
    for (i = 0; i < 11; i++)
        e[i] = 0;
    for (i = 0; i < params; i++)
        e[i] = expr(99, s, &wpc[i * 2 + 2], wpc[i * 2 + 3]);
    putIc(op, j, e[0], e[1], e[2]);
    if (params >= 4)
        putIc(OpPrm, e[3], e[4], e[5], e[6]);
    if (params >= 8)
        putIc(OpPrm, e[7], e[8], e[9], e[10]);
    for (i = 0; i < params; i++) {
        tmpFree(e[i]);
        if (e[i] < 0) {
            tmpFree(j);
            j = -1;
        }
    }
    *pj = j;
    return 1;
}

#define BInfSiz  10
int binf[BInfSiz * 100], bd, lbd; // binf:block-info, bd:block-depth, lbd:loop-block-depth
enum { BlkIf = 1, BlkFor };
enum { IfLabel0 = 1, IfLabel1 };
enum { ForLopBgn = 1, ForCont, ForBrk, ForLbd0, ForWpc4, ForWpc5, ForWpc6, ForWpc7 };
#define S(i)  s[wpc[i]]

int defArray(TknStr s, int pc, int *pe)
{
	int wpc[99];
    wpc[0] = pc;
    if (phr(150, "static", s, wpc)) // staticƏĂǂݔ΂.
        pc++;
	pc++; // ^̖Oǂݔ΂(intȂ).
    while (s[pc - 1] != TcSemi) {
        int e = 0, i, j;
        wpc[0] = pc;
		if (phr(100, "!2[%3];", s, wpc) || phr(101, "!2[%3],", s, wpc)) {
            e = expr(99, s, &wpc[3], wpc[4]);
            putIc(OpAryNew, S(2), e, 0, 0);
		} else if (phr(102, "!2[%3] = {", s, wpc)) {
            e = expr(99, s, &wpc[3], wpc[4]);
            putIc(OpAryNew, S(2), e, 0, 0);
            j = 0; // R}ȊÕg[N𐔂.
            for (i = wpc[1]; s[i] != 0 && s[i] != TcCrBrCls; i++) {
                if (s[i] != TcComma && s[i] != TcMinus) j++;
            }
            if (s[i] != TcCrBrCls) {
                tmpFree(e);
                *pe = -1;
                break;
            }
            intptr_t *ip = malloc(j * SzInt);
            j = 0;
            for (i = wpc[1]; s[i] != TcCrBrCls; i++) {
                if (s[i] == TcMinus) {
                    ip[j++] = - var[s[++i]];
                } else if (s[i] != TcComma)
                    ip[j++] = var[s[i]];
            }
            putIc(OpAryInit, S(2), (intptr_t) ip, j, 0);
            wpc[1] = i + 2; // },܂łǂݔ΂( }; Ȃ).
        } else if (phr(103, "*", s, wpc)) { // int *a ݂ȃp^[. ЂƂ܂ * ǂݔ΂.
            pc++;
            continue;
        } else if (phr(104, "!2,", s, wpc) || phr(105, "!2;", s, wpc)) { // Ȃ.
        } else if (phr(106, "!2 = %3,", s, wpc) || phr(107, "!2 = %3;", s, wpc)) {
            e = expr(99, s, &wpc[3], wpc[4]);
            putIc(OpCpy, S(2), e, 0, 0);
        } else
            break; // 悭킩Ȃ̂łЂƂ܂break;
        tmpFree(e);
        if (e < 0) {
            *pe = -1;
            break;
        }
        pc = wpc[1]; // R}̓Z~R܂łǂݔ΂.
    }
    return pc;
}

int compile(String src)
{
    int pc, wpc[99], i, j;
    TknStr s = lexer(src);
    if (s == 0) return 1;
    for (pc = 0; s[pc] != 0; pc++); // ܂œǂݔ΂.
    s[pc] = TcSemi; // Ɂu;vtY邱Ƃ̂ŁAtĂ.
	ici = 0; // ݈ʒu.
    for (i = 0; i < 10; i++) // ꎞϐׂĖgpɂ.
        tmpFlag[i] = 0;
    tmpLabelNo = 0;
    bd = lbd = 0;
    for (pc = 0; s[pc] != 0;) { // RpCJn.
        int e = 0;
        wpc[0] = pc;
        if (phr( 0, "!2 = !3;", s, wpc)) {
            putIc(OpCpy, S(2), S(3), 0, 0);
        } else if (phr(10, "!2 = !3 + 1; if (!4 < !5) goto !6;", s, wpc) && S(2) == S(3) && S(2) == S(4)) {
            putIc(OpLoop, S(6), 0, S(2), S(5));
        } else if (phr( 9, "!2 = !3 + 1;", s, wpc) && S(2) == S(3)) { // eNjbN#2
            putIc(OpAdd1, S(2), 0, 0, 0);
        } else if (phr( 1, "!2 = !3 !4 !5;", s, wpc) && TcPlus <= S(4) && S(4) <= TcShr) {
            putIc(OpAdd + S(4) - TcPlus, S(2), S(3), S(5), 0);
        } else if (phr( 3, "print %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPrint, e, 0, 0, 0);
        } else if (phr( 4, "goto !2;", s, wpc)) {
            putIc(OpGoto, S(2), 0, 0, 0);
        } else if (phr( 5, "if (%2) goto !4;", s, wpc)) {
            ifgoto(s, wpc[2], wpc[3], IfTrue, S(4), &e);
        } else if (phr( 6, "time;", s, wpc)) {
            putIc(OpTime, 0, 0, 0, 0);
        } else if (phr( 7, "!2:", s, wpc)) {
            var[S(2)] = ici;
        } else if (phr(11, "if (%2) {", s, wpc)) {	// 	ubNif.
            bd += BInfSiz;
            binf[bd] = BlkIf;
            binf[bd + IfLabel0] = tmpLabelAlloc(); // ŝƂ̔ѐ.
            binf[bd + IfLabel1] = 0;
            ifgoto(s, wpc[2], wpc[3], IfFalse, binf[bd + IfLabel0], &e); // 𖞂Ȃ΁Abinf[bd + IfLabel0]goto.
        } else if (phr(12, "} else {", s, wpc) && binf[bd] == BlkIf) {
            binf[bd + IfLabel1] = tmpLabelAlloc(); // else߂̏I[.
            putIc(OpGoto, binf[bd + IfLabel1], 0, 0, 0);
            var[binf[bd + IfLabel0]] = ici;	// x`.
        } else if (phr( 13, "}", s, wpc) && binf[bd] == BlkIf) {
            if (binf[bd + IfLabel1] == 0) { // elseȂꍇ.
                var[binf[bd + IfLabel0]] = ici;	// x`.
            } else {
                var[binf[bd + IfLabel1]] = ici;	// x`.
            }
            bd -= BInfSiz;
        } else if (phr(14, "for (&2; &4; &6) {", s, wpc)) {	// for
            bd += BInfSiz;
            binf[bd] = BlkFor; // ubÑ^Cv.
            binf[bd + ForLopBgn] = tmpLabelAlloc(); // [v̓ɖ߂p.
            binf[bd + ForCont  ] = tmpLabelAlloc(); // continuep.
            binf[bd + ForBrk   ] = tmpLabelAlloc(); // breakp.
            binf[bd + ForLbd0  ] = lbd; // Âlۑ.
            binf[bd + ForWpc4  ] = wpc[4];
            binf[bd + ForWpc5  ] = wpc[5];
            binf[bd + ForWpc6  ] = wpc[6];
            binf[bd + ForWpc7  ] = wpc[7];
            lbd = bd;
            e = expr(99, s, &wpc[2], wpc[3]);
            if (wpc[4] < wpc[5]) // &4ɎĂ.
                ifgoto(s, wpc[4], wpc[5], IfFalse, binf[bd + ForBrk], &e); // ŏsȂbreak.
            var[binf[bd + ForLopBgn]] = ici; // x`.
        } else if (phr(15, "}", s, wpc) && binf[bd] == BlkFor) {
            var[binf[bd + ForCont]] = ici; // x`.
            i = binf[bd + ForWpc4];
            j = binf[bd + ForWpc6];
            if (binf[bd + ForWpc5] - i == 3 && binf[bd + ForWpc7] - j == 2 && s[i] == s[j] && s[i + 1] == TcLt && s[j + 1] == TcPlPlus) {
                // &4ui < ?vA&6ui++viϐiȂĂǁAʂłKvj.
                putIc(OpLoop, binf[bd + ForLopBgn], 0, s[i], s[i + 2]);
            } else {
                wpc[4] = binf[bd + ForWpc4];
                wpc[5] = binf[bd + ForWpc5];
                wpc[6] = binf[bd + ForWpc6];
                wpc[7] = binf[bd + ForWpc7];
                e = expr(99, s, &wpc[6], wpc[7]);
                if (wpc[4] < wpc[5]) {	// &4ɉ炩̎Ă.
                    ifgoto(s, wpc[4], wpc[5], IfTrue, binf[bd + ForLopBgn], &e);
                } else
                    putIc(OpGoto, binf[bd + ForLopBgn], 0, 0, 0);
            }
            var[binf[bd + ForBrk]] = ici; // x`.
            lbd = binf[bd + ForLbd0]; // ȑO̒l𕜌.
            bd -= BInfSiz;
        } else if (phr(16, "continue;", s, wpc) && lbd > 0) {
            putIc(OpGoto, binf[lbd + ForCont], 0, 0, 0);
        } else if (phr(17, "break;", s, wpc) && lbd > 0) {
            putIc(OpGoto, binf[lbd + ForBrk ], 0, 0, 0);
        } else if (phr(18, "if (%2) continue;", s, wpc) && lbd > 0) {
            ifgoto(s, wpc[2], wpc[3], IfTrue, binf[lbd + ForCont], &e);
        } else if (phr(19, "if (%2) break;", s, wpc) && lbd > 0) {
            ifgoto(s, wpc[2], wpc[3], IfTrue, binf[lbd + ForBrk], &e);
        } else if (phr(20, "prints %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPrints, e, 0, 0, 0);
        } else if (phr(21, "int", s, wpc) || phr(22, "AWin", s, wpc) || phr(24, "AInt", s, wpc)) {
            wpc[1] = defArray(s, pc, &e);
        } else if (phr(23, "static", s, wpc)) {
        } else if (phr(25, "APlay", s, wpc) || phr(26, "AInt32", s, wpc)) {
            wpc[1] = defArray(s, pc, &e);
        } else if (phr(27, "char", s, wpc)) {
            wpc[1] = defArray(s, pc, &e);
        } else if (phr(28, "pr %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPrint, e, 0, 0, 0);
        } else if (phr(29, "prs %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPrs, e, 0, 0, 0);
        } else if (phr(30, "prsp;", s, wpc)) {
            putIc(OpPrsp, 0, 0, 0, 0);
        } else if (phr(30, "prlf;", s, wpc)) {
            putIc(OpPrlf, 0, 0, 0, 0);
        } else if (phr( 8, "&2;", s, wpc)) { // ͂Ȃ}b`₷̂ōŌɂ.
            e = expr(99, s, &wpc[2], wpc[3]);
        } else {
err:
            printf("syntax error : %s %s %s %s\n", tStr[s[pc]], tStr[s[pc + 1]], tStr[s[pc + 2]], tStr[s[pc + 3]]);
            free(s); // s.
            return 1; // G[I.
        }
        tmpFree(e);
        if (e < 0) goto err;
        pc = wpc[1]; // Z~R̎܂œǂݔ΂.
    }
    free(s); // s.
    putIc(OpEnd, 0, 0, 0, 0);
    if (bd > 0) {
        printf("block nesting error (bd=%d, lbd=%d)\n", bd, lbd);
        return 1; // G[I.
    }
    for (ici = 0; ic[ici] != OpEnd; ici += 5) {  // goto̍.
        if (OpGoto <= ic[ici] && ic[ici] <= OpLoop) {
            i = var[ic[ici + 1]];
            while (ic[i] == OpGoto)
                i = var[ic[i + 1]];
            ic[ici + 2] = i;
        }
    }
    return 0; // I.
}

#define V(i)  var[ic[pc + i]]
#define Nxt   pc += 5; continue
#define Jmp   pc = ic[pc + 2]; continue
#define Nxt2  pc += 10; continue
#define Nxt3  pc += 15; continue

void exec(clock_t t0)
{
    intptr_t pc = 0, i, *a;
    for (;;) {
        switch (ic[pc]) {
        case OpNeg:     V(1) = - V(2); Nxt;
        case OpAdd1:    V(1)++; Nxt;
        case OpMul:     V(1) = V(2) *  V(3); Nxt;
        case OpDiv:     V(1) = V(2) /  V(3); Nxt;
        case OpMod:     V(1) = V(2) %  V(3); Nxt;
        case OpAdd:     V(1) = V(2) +  V(3); Nxt;
        case OpSub:     V(1) = V(2) -  V(3); Nxt;
        case OpShr:     V(1) = V(2) >> V(3); Nxt;
        case OpClt:     V(1) = V(2) <  V(3); Nxt;
        case OpCge:     V(1) = V(2) >= V(3); Nxt;
        case OpCle:     V(1) = V(2) <= V(3); Nxt;
        case OpCgt:     V(1) = V(2) >  V(3); Nxt;
        case OpCeq:     V(1) = V(2) == V(3); Nxt;
        case OpCne:     V(1) = V(2) != V(3); Nxt;
        case OpAnd:     V(1) = V(2) &  V(3); Nxt;
        case OpXor:     V(1) = V(2) ^  V(3); Nxt;
        case OpCpy:     V(1) = V(2); Nxt;
        case OpPrint:   printf("%d\n", V(1)); Nxt;
        case OpGoto:    Jmp;
        case OpJlt:     if (V(3) <  V(4)) { Jmp; } Nxt;
        case OpJge:     if (V(3) >= V(4)) { Jmp; } Nxt;
        case OpJle:     if (V(3) <= V(4)) { Jmp; } Nxt;
        case OpJgt:     if (V(3) >  V(4)) { Jmp; } Nxt;
        case OpJeq:     if (V(3) == V(4)) { Jmp; } Nxt;
        case OpJne:     if (V(3) != V(4)) { Jmp; } Nxt;
        case OpTime:
            printf("time: %.3f[sec]\n", (clock() - t0) / (double) CLOCKS_PER_SEC);
            Nxt;
        case OpEnd:     return;
        case OpLoop:    i = V(3) + 1; V(3) = i; if (i < V(4)) { Jmp; } Nxt;
        case OpPrints:  printf("%s\n", (char *) V(1)); Nxt;
        case OpAryNew:
            V(1) = (intptr_t) malloc(V(2) * SzInt);
            memset((char *) V(1), 0, V(2) * SzInt);
            Nxt;
        case OpAryInit:
            memcpy((char *) V(1), (char *) ic[pc + 2], ic[pc + 3] * SzInt);
            Nxt;
        case OpOpnWin:
            if (win != 0) { AWin_dein(win); }
            V(1) = (intptr_t) (win = aOpenWin(V(2), V(3), (String) V(4)));
            Nxt;
        case OpOpWnEx:
            if (win != 0) { AWin_dein(win); }
            V(1) = (intptr_t) (win = aOpenWinEx(V(2), V(3), (String) V(4)));
            Nxt;
        case OpOpnPly:
            if (ply != 0)
                APlay_dein(ply);
            V(1) = (intptr_t) (ply = aOpenPlay16(V(2)));
            Nxt;
        case OpArySet:  a = (intptr_t *) V(1); a[V(2)] = V(3); Nxt;
        case OpAryGet:  a = (intptr_t *) V(1); V(3) = a[V(2)]; Nxt;
        case OpPrntf1:  V(1) = printf((String) V(2), V(3), V(4)); Nxt;
        case OpPrntf2:  V(1) = printf((String) V(2), V(3), V(4), V(6), V(7), V(8), V(9)); Nxt2;
        case OpSetPix:  aSetPix((AWin *) V(2), V(3), V(4), V(6)); Nxt2;
        case OpRgb8:    V(1) = aRgb8(V(2), V(3), V(4)); Nxt;
        case OpFilRct:  aFillRect((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt2;
        case OpSetMod:  aSetMode((AWin *) V(2), V(3)); Nxt;
        case OpDrwLin:  aDrawLine((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt2;
        case OpFilOvC:  aFillOvalCent((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt2;
        case OpWait:    aWait(V(2)); Nxt;
        case OpSqrt:    V(1) = aFf16Sqrt(V(2)); Nxt;
        case OpSin:     V(1) = aFf16Sin(V(2)); Nxt;
        case OpCos:     V(1) = aFf16Cos(V(2)); Nxt;
        case OpIsClos:  V(1) = AWin_isClose((AWin *) V(2)); Nxt;
        case OpMulShr:  V(1) = aMul64Shr(V(2), V(3), V(4)); Nxt;
        case OpAgMxLI:  V(1) = aArgMaxLstInt((AInt *) V(2), V(3), V(4)); Nxt;
        case OpCol16:   V(1) = AWin_col16(V(2)); Nxt;
        case OpUdMnMx:  if (V(2) > V(4)) { V(2) = V(4); } if (V(3) < V(4)) { V(3) = V(4); } Nxt;
        case OpSwpTmp:  V(4) = V(2); V(2) = V(3); V(3) = V(4); Nxt;
        case OpEchBox:  aEchBox((AWin *) V(2), V(3), V(4), V(6), V(7), V(8), V(9), V(11)); Nxt3;
        case OpEch:     aEch((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt2;
        case OpRnd:     V(1) = aRnd(V(2)); Nxt;
        case OpGetEch:  V(1) = aGetEch((AWin *) V(2), V(3), V(4)); Nxt;
        case OpAgMxRI:  V(1) = aArgMaxRndInt((AInt *) V(2), V(3), V(4)); Nxt;
        case OpPlyMml:  APlay_mml((APlay *) V(2), V(3), (String) V(4)); Nxt;
        case OpPlyRun:  APlay_run((APlay *) V(2)); Nxt;
        case OpPrsp:    printf(" "); Nxt;
        case OpPrlf:    printf("\n"); Nxt;
        case OpPrs:     printf("%s", (char *) V(1)); Nxt;
        case OpInput:   V(1) = aInput((char *) V(2)); Nxt;
        }
    }
}

int run(String src, int fre)
{
    clock_t t0 = clock();
	int i = compile(src);
    if (fre != 0 && src != 0) // \[XR[h̎J.
        free(src);
    if (i != 0) return 1;
    exec(t0);
    if (win != 0)
        AWin_flushAll(win);
    return 0;
}

void aMain(AComArg *aCA0)
{
	aCA = aCA0;
	int argc = aGetArgc();
	String *argv = aGetArgv();
    free(lexer(tknInit));
    tStr[0] = ""; // G[̂.
    run("AWinMode_Xor=3", 0);
    if (argc >= 2) // R}hC.
        exit(run(loadText(argv[1]), 1));
    for (;;) { // Read-Eval-Print Loop.
        char cmdlin[10000];
        printf("\n>"); // vvg\.
        fgets(cmdlin, sizeof cmdlin, stdin);
        if (cmdlin[strlen(cmdlin) - 1] == '\n')
            cmdlin[strlen(cmdlin) - 1] = 0; // ɉsR[hΏ.
        if (strncmp(cmdlin, "run ", 4) == 0) { // runR}h.
            run(loadText(&cmdlin[4]), 1);
        } else if (strcmp(cmdlin, "exit") == 0) { // exitR}h.
            exit(0);
        } else if (strncmp(cmdlin, "shell ", 6) == 0) { // shellR}h.
            system(&cmdlin[6]);
        } else // ȊO.
            run(cmdlin, 0);
    }
}
